#include "g_local.h"
/*
===============
Plasma Bomb
===============
*/
/*
================================================
Plasma Bomb command code
else if (Q_stricmp (cmd, "plasmabomb") == 0)
	{
		if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] < 100)
		{
 			gi.cprintf(ent, PRINT_HIGH, "Not enough cells for Plasma Bomb.\n");
			return;
		}
		else
		{
			if (ent->PlasmaDelay == 0)
			{
				ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] =ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] - 100;
				DropPlasmaBomb(ent,atoi(gi.argv(1)));
			}
			else
			{
				gi.cprintf(ent, PRINT_HIGH, "Already dropped plasmabomb.\n");
			}
		}
	}
=============================================
*/
void PlasmaBombExplode(edict_t *self)
{
	edict_t	*ent;
	float	points;
	vec3_t	v;
	float	dist;
	vec3_t Vec1, Vec2, Vec3, Vec4;
	vec3_t Vec5, Vec6;
	VectorSet(Vec1,28,28,0);
	VectorSet(Vec2,28,-28,0);
	VectorSet(Vec3,-28,-28,0);
	VectorSet(Vec4,-28,28,0);
	VectorSet(Vec5,0,0,28);
	VectorSet(Vec6,0,0,-28);
	VectorAdd(Vec1,self->s.origin,Vec1);
	VectorAdd(Vec2,self->s.origin,Vec2);
	VectorAdd(Vec3,self->s.origin,Vec3);
	VectorAdd(Vec4,self->s.origin,Vec4);
	VectorAdd(Vec5,self->s.origin,Vec5);
	VectorAdd(Vec6,self->s.origin,Vec6);
	if (self->s.frame == 0)
	{
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_RAILTRAIL);
			gi.WritePosition (self->s.origin);
			gi.WritePosition (Vec1);
			gi.multicast (self->s.origin, MULTICAST_PHS);
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_RAILTRAIL);
			gi.WritePosition (self->s.origin);
			gi.WritePosition (Vec2);
			gi.multicast (self->s.origin, MULTICAST_PHS);
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_RAILTRAIL);
			gi.WritePosition (self->s.origin);
			gi.WritePosition (Vec3);
			gi.multicast (self->s.origin, MULTICAST_PHS);
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_RAILTRAIL);
			gi.WritePosition (self->s.origin);
			gi.WritePosition (Vec4);
			gi.multicast (self->s.origin, MULTICAST_PHS);
			
	}
	if (self->s.frame == 1)
	{
		gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_RAILTRAIL);
			gi.WritePosition (Vec1);
			gi.WritePosition (Vec5);
			gi.multicast (Vec1, MULTICAST_PHS);
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_RAILTRAIL);
			gi.WritePosition (Vec2);
			gi.WritePosition (Vec5);
			gi.multicast (Vec2, MULTICAST_PHS);
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_RAILTRAIL);
			gi.WritePosition (Vec3);
			gi.WritePosition (Vec5);
			gi.multicast (Vec3, MULTICAST_PHS);
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_RAILTRAIL);
			gi.WritePosition (Vec4);
			gi.WritePosition (Vec5);
			gi.multicast (Vec4, MULTICAST_PHS);
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_RAILTRAIL);
			gi.WritePosition (Vec1);
			gi.WritePosition (Vec6);
			gi.multicast (Vec1, MULTICAST_PHS);
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_RAILTRAIL);
			gi.WritePosition (Vec2);
			gi.WritePosition (Vec6);
			gi.multicast (Vec2, MULTICAST_PHS);
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_RAILTRAIL);
			gi.WritePosition (Vec3);
			gi.WritePosition (Vec6);
			gi.multicast (Vec3, MULTICAST_PHS);
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_RAILTRAIL);
			gi.WritePosition (Vec4);
			gi.WritePosition (Vec6);
			gi.multicast (Vec4, MULTICAST_PHS);
	}
	if (self->s.frame == 2)
	{
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_RAILTRAIL);
			gi.WritePosition (Vec5);
			gi.WritePosition (self->s.origin);
			gi.multicast (Vec5, MULTICAST_PHS);
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_RAILTRAIL);
			gi.WritePosition (Vec6);
			gi.WritePosition (self->s.origin);
			gi.multicast (Vec6, MULTICAST_PHS);
			
			
	}

	if (self->s.frame == 4)
	{
		// the BFG effect
		ent = NULL;
		while ((ent = findradius(ent, self->s.origin, self->dmg_radius+500)) != NULL)
		{
			if (!ent->takedamage)
				continue;
			if (!CanDamage (ent, self))
				continue;
			if (!CanDamage (ent, self->owner))
				continue;

			VectorAdd (ent->mins, ent->maxs, v);
			VectorMA (ent->s.origin, 0.5, v, v);
			VectorSubtract (self->s.origin, v, v);
			dist = VectorLength(v);
			points = self->radius_dmg * (1.0 - sqrt(dist/self->dmg_radius));
			if (ent == self->owner)
				points = points * 0.5;

			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_BFG_EXPLOSION);
			gi.WritePosition (ent->s.origin);
			gi.multicast (ent->s.origin, MULTICAST_PVS);
			
			T_Damage (ent, self, self->owner, self->velocity, ent->s.origin, vec3_origin, (int)points, 0, DAMAGE_ENERGY,MOD_PLASMABOMB);
		}
	}

	self->nextthink = level.time + FRAMETIME;
	self->s.frame++;
	if (self->s.frame == 5)
		self->think = G_FreeEdict;
}

void plasmabomb_think(edict_t *self)
{	
	if (self->delay < level.time)
	{
		gi.sound (self, CHAN_VOICE, gi.soundindex ("weapons/bfg__x1b.wav"), 1, ATTN_NORM, 0);
		self->solid = SOLID_NOT;
		self->touch = NULL;
		VectorMA (self->s.origin, -1 * FRAMETIME, self->velocity, self->s.origin);
		VectorClear (self->velocity);
		self->s.modelindex = gi.modelindex ("sprites/s_bfg3.sp2");
		self->s.frame = 0;
		self->s.sound = 0;
		self->s.effects &= ~EF_ANIM_ALLFAST;
		self->think = PlasmaBombExplode;
		self->nextthink = level.time + FRAMETIME;
		gi.WriteByte (svc_temp_entity);
		gi.WriteByte (TE_BFG_BIGEXPLOSION);
		gi.WritePosition (self->s.origin);
		gi.multicast (self->s.origin, MULTICAST_PVS);
	}
	self->nextthink = level.time + FRAMETIME;
}

void DropPlasmaBomb (edict_t *self, int time)
{
	edict_t	*bfg;

	bfg = G_Spawn();
	bfg->wf_team = self->wf_team;
	VectorCopy (self->s.origin, bfg->s.origin);
	bfg->movetype = MOVETYPE_NONE;
	bfg->clipmask = MASK_SHOT;
	bfg->solid = SOLID_BBOX;
	bfg->s.effects |= EF_BFG | EF_ANIM_ALLFAST;
	VectorClear (bfg->mins);
	VectorClear (bfg->maxs);
	bfg->s.modelindex = gi.modelindex ("sprites/s_bfg1.sp2");
	bfg->owner = self;
	bfg->radius_dmg = 3000;
	bfg->dmg_radius = 4000;
	bfg->classname = "plasma blast";
	bfg->s.sound = gi.soundindex ("weapons/bfg__l1a.wav");
	bfg->think = plasmabomb_think;
	bfg->nextthink = level.time + FRAMETIME;
	bfg->delay = level.time + time;
	self->PlasmaDelay = 1;
	gi.linkentity (bfg);
}

void cmd_PlasmaBomb(edict_t *ent)
{
	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] <50)
	{
		gi.cprintf(ent, PRINT_HIGH, "Not enough cells (50) for Plasma Bomb.\n");
		return;
	}
	else
	{
		if (ent->PlasmaDelay < level.time)
		{
			ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] =ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] - 50;
			DropPlasmaBomb(ent,15);		// Explode in 15 seconds
		}
		else
		{
			gi.cprintf(ent, PRINT_HIGH, "Not enough time has passed since last Plasma Bomb.\n");
		}
	}
}