#include    "g_local.h"
#include	"laser2.h"

int	laser_colour[] = {
		0xf2f2f0f0,		//0 red
		0xd0d1d2d3,		//1 green
		0xf3f3f1f1,		//2 blue
		0xdcdddedf,		//3 yellow
		0xe0e1e2e3,		//4 bitty yellow strobe
		0x80818283,     //5 JR brownish purple I think
		0x70717273,		//6 JR light blue
		0x90919293,     //7 JR type of green
		0xb0b1b2b3,		//8 JR another purple
		0x40414243,		//9 JR a reddish color
		0xe2e5e3e6,		//10 JR another orange
		0xd0f1d3f3,		//11 JR mixture of color
		0xf2f3f0f1,		//12 JR red outer blue inner
		0xf3f2f1f0,		//13 JR blue outer red inner
		0xdad0dcd2,		//14 JR yellow outer green inner
		0xd0dad2dc		//15 JR green outer yellow inner
		};

//By setting the color for each, players can tell the difference
#define LASER_DEFENSE_COLOR		4
#define LASER_TRIPBOMB_COLOR	12


/*
=====================
Laser Defense
=====================
*/
void laser_cleanup(edict_t *self)
{
        //reduce # active laser defenses
	if (self->creator && self->creator->client)
		--self->creator->client->pers.active_special[ITEM_SPECIAL_LASER_DEFENSE];

	//Remove laser
	if (self->owner) 
		G_FreeEdict (self->owner);

	//Remove grenade
	G_FreeEdict (self);

}

void laser_defense_die(edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	if (self->owner) 
	{
		self->owner->delay	= level.time + 0.1;
	}

	laser_cleanup(self);

}


void	PlaceLaser (edict_t *ent)
{
	edict_t		*self,
				*grenade;
	vec3_t		forward,
				wallp;
	trace_t		tr;

	// valid ent ?
  	if ((!ent->client) || (ent->health<=0))
	   return;

	// cells for laser ?
	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] < CELLS_FOR_LASER)
	{
 		gi.cprintf(ent, PRINT_HIGH, "Not enough cells for laser.\n");
		return;
	}

	//Are there too many laser defense systems now?
	if (ent->client->pers.active_special[ITEM_SPECIAL_LASER_DEFENSE] >= MAX_SPECIAL_LASER_DEFENSE)
	{
 		gi.cprintf(ent, PRINT_HIGH, "You can only have %d active Laser Defense Systems.\n",MAX_SPECIAL_LASER_DEFENSE );
		return;
	}

	// Setup "little look" to close wall
	VectorCopy(ent->s.origin,wallp);         

	// Cast along view angle
	AngleVectors (ent->client->v_angle, forward, NULL, NULL);

	// Setup end point
	wallp[0]=ent->s.origin[0]+forward[0]*50;
	wallp[1]=ent->s.origin[1]+forward[1]*50;
	wallp[2]=ent->s.origin[2]+forward[2]*50;  

	// trace
	tr = gi.trace (ent->s.origin, NULL, NULL, wallp, ent, MASK_SOLID);

	// Line complete ? (ie. no collision)
	if (tr.fraction == 1.0)
	{
	 	gi.cprintf (ent, PRINT_HIGH, "Too far from wall.\n");
		return;
	}

	// Hit sky ?
	if (tr.surface)
		if (tr.surface->flags & SURF_SKY)
			return;

	// Ok, lets stick one on then ...
	gi.cprintf (ent, PRINT_HIGH, "Laser attached.\n");

	ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= CELLS_FOR_LASER;

	++ent->client->pers.active_special[ITEM_SPECIAL_LASER_DEFENSE];

	// -----------
	// Setup laser
	// -----------
	self = G_Spawn();
	self -> wf_team = ent->wf_team;

	self -> movetype		= MOVETYPE_NONE;
	self -> solid			= SOLID_NOT;
	self -> s.renderfx		= RF_BEAM|RF_TRANSLUCENT;
	self -> s.modelindex	= 1;			// must be non-zero
	self -> s.sound			= gi.soundindex ("world/laser.wav");
	self -> classname		= "laser_defense";
	self -> s.frame			= 2;	// beam diameter
  	self -> owner			= ent;
	self -> creator			= ent;	
//GREGG
//	self -> s.skinnum		= laser_colour[((int) (random() * 1000)) % 16];
	self -> s.skinnum		= laser_colour[LASER_DEFENSE_COLOR];
  	self -> dmg				= LASER_DAMAGE;
	self -> think			= pre_target_laser_think;
	self -> delay			= level.time + LASER_TIME;
	//add a laser to the amount
	ent->LaserOrbs++;
	// Set orgin of laser to point of contact with wall
	VectorCopy(tr.endpos,self->s.origin);

	// convert normal at point of contact to laser angles
	vectoangles(tr.plane.normal,self -> s.angles);

	// setup laser movedir (projection of laser)
	G_SetMovedir (self->s.angles, self->movedir);

	VectorSet (self->mins, -8, -8, -8);
	VectorSet (self->maxs, 8, 8, 8);

	// link to world
	gi.linkentity (self);

	// start off ...
	target_laser_off (self);

	// ... but make automatically come on
	self -> nextthink = level.time + 2;
	grenade = G_Spawn();
	grenade->wf_team = ent->wf_team;

	VectorClear (grenade->mins);
	VectorClear (grenade->maxs);
	VectorCopy (tr.endpos, grenade->s.origin);
	vectoangles(tr.plane.normal,grenade -> s.angles);
	grenade -> movetype		= MOVETYPE_NONE;
	grenade -> clipmask		= MASK_SHOT;
	//grenade -> solid		= SOLID_NOT;
	grenade->solid = SOLID_BBOX;
	VectorSet(grenade->mins, -3, -3, 0);
	VectorSet(grenade->maxs, 3, 3, 6);
	grenade->takedamage=DAMAGE_YES;
	grenade->die = laser_defense_die;
	grenade -> s.modelindex	= gi.modelindex ("models/objects/grenade2/tris.md2");
	grenade -> owner		= self;	
	grenade -> creator		= ent;	
	grenade -> nextthink	= level.time + LASER_TIME;
	grenade -> think		= laser_cleanup;
	grenade->health= 10;
	grenade->max_health =10;

	gi.linkentity (grenade);
}

void	pre_target_laser_think (edict_t *self)
{
	target_laser_on (self);
	self->think = target_laser_think;
}

void	pre_target_laserb_think (edict_t *self);

/*
===============
Laser Tripbombs
===============
*/
/*
for them to work need some code I will do later
*/

void laser_trip_cleanup(edict_t *self)
{
        //reduce # active laser trip bombs
	if (self->creator && self->creator->client)
                --self->creator->client->pers.active_special[ITEM_SPECIAL_TRIPBOMB];

	//Remove laser
	if (self->owner) 
		G_FreeEdict (self->owner);

	//Remove grenade
	G_FreeEdict (self);

}


void laser_tripbomb_die(edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	self->owner->delay	= level.time + 0.1;

        laser_trip_cleanup(self);

}

void	PlaceLaserb (edict_t *ent)
{
	edict_t		*self,
				*grenade;

	vec3_t		forward,
				wallp;

	trace_t		tr;


	// valid ent ?
  	if ((!ent->client) || (ent->health<=0))
	   return;

	// cells for laser ?
	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] < 100)
	{
 		gi.cprintf(ent, PRINT_HIGH, "Not enough cells for laser bomb.\n");
		return;
	}

	//Are there too many laser defense systems now?
	if (ent->client->pers.active_special[ITEM_SPECIAL_TRIPBOMB] >= MAX_SPECIAL_TRIPBOMB)
	{
 		gi.cprintf(ent, PRINT_HIGH, "You can only have %d active Trip Bombs.\n",MAX_SPECIAL_TRIPBOMB );
		return;
	}

	// Setup "little look" to close wall
	VectorCopy(ent->s.origin,wallp);         

	// Cast along view angle
	AngleVectors (ent->client->v_angle, forward, NULL, NULL);

	// Setup end point
	wallp[0]=ent->s.origin[0]+forward[0]*50;
	wallp[1]=ent->s.origin[1]+forward[1]*50;
	wallp[2]=ent->s.origin[2]+forward[2]*50;  

	// trace
	tr = gi.trace (ent->s.origin, NULL, NULL, wallp, ent, MASK_SOLID);

	// Line complete ? (ie. no collision)
	if (tr.fraction == 1.0)
	{
	 	gi.cprintf (ent, PRINT_HIGH, "Too far from wall.\n");
		return;
	}

	// Hit sky ?
	if (tr.surface)
		if (tr.surface->flags & SURF_SKY)
			return;

	// Ok, lets stick one on then ...
	gi.cprintf (ent, PRINT_HIGH, "Laser attached.\n");

	ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= 100;

	++ent->client->pers.active_special[ITEM_SPECIAL_TRIPBOMB];

	// -----------
	// Setup laser
	// -----------
	self = G_Spawn();
	self->wf_team = ent->wf_team;


	self -> movetype		= MOVETYPE_NONE;
	self -> solid			= SOLID_NOT;
	self -> s.renderfx		= RF_BEAM|RF_TRANSLUCENT;
	self -> s.modelindex	= 1;			// must be non-zero
	self -> s.sound			= gi.soundindex ("world/laser.wav");
	self -> classname		= "lb";
	self -> s.frame			= 2;	// beam diameter
  	self -> owner			= ent;
//GREGG
//	self -> s.skinnum		= laser_colour[((int) (random() * 1000)) % 16];
	self -> s.skinnum		= laser_colour[LASER_TRIPBOMB_COLOR];
  	self -> dmg				= LASER_DAMAGE;
	self -> think			= pre_target_laserb_think;
	self -> delay			= level.time + LASER_TIME;
	//add a laser to the amount
	ent->LaserBomb++;
	// Set orgin of laser to point of contact with wall
	VectorCopy(tr.endpos,self->s.origin);

	// convert normal at point of contact to laser angles
	vectoangles(tr.plane.normal,self -> s.angles);

	// setup laser movedir (projection of laser)
	G_SetMovedir (self->s.angles, self->movedir);

	VectorSet (self->mins, -8, -8, -8);
	VectorSet (self->maxs, 8, 8, 8);

	// link to world
	gi.linkentity (self);

	// start off ...
	target_laser_off (self);

	// ... but make automatically come on
	self -> nextthink = level.time + 2;
	grenade = G_Spawn();
	grenade->wf_team = ent->wf_team;

	VectorClear (grenade->mins);
	VectorClear (grenade->maxs);
	VectorCopy (tr.endpos, grenade->s.origin);
	vectoangles(tr.plane.normal,grenade -> s.angles);
	grenade -> movetype		= MOVETYPE_NONE;
	grenade -> clipmask		= MASK_SHOT;
	//grenade -> solid		= SOLID_NOT;
	grenade->solid = SOLID_BBOX;
	VectorSet(grenade->mins, -3, -3, 0);
	VectorSet(grenade->maxs, 3, 3, 6);
	grenade->takedamage=DAMAGE_YES;
	grenade->die = laser_tripbomb_die;
	grenade -> s.modelindex	= gi.modelindex ("models/objects/grenade2/tris.md2");
	grenade -> owner		= self;	
	grenade -> nextthink	= level.time + LASER_TIME;
        grenade -> think                = laser_trip_cleanup;
	grenade->health= 15;
	grenade->max_health =15;

	gi.linkentity (grenade);
}
void	pre_target_laserb_think (edict_t *self)
{
	target_laser_on (self);

	self->think = target_laser_think;
}

void cmd_LaserDefense(edict_t *ent)
{
	if (ent->LaserOrbs > MAX_LASERS -1)
		gi.cprintf(ent, PRINT_HIGH, "Max Lasers Already Reached.\n");
	else
		PlaceLaser (ent);
}	

void cmd_TripBomb(edict_t *ent)
{
	if (ent->LaserBomb > 4 -1)
		gi.cprintf(ent, PRINT_HIGH, "Max Laser Trip Bombs Already Reached.\n");
	else
		PlaceLaserb (ent);
}

