#include "g_local.h"

void fire_bullet (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread, int mod);
#define FRAME_FIRE_FIRST		(FRAME_ACTIVATE_LAST + 1)
#define FRAME_IDLE_FIRST		(FRAME_FIRE_LAST + 1)
#define FRAME_DEACTIVATE_FIRST	(FRAME_IDLE_LAST + 1)

int	kick = 8;
/*
========================
Laser Sniper Rifle
========================
*/
#define lss self->lasersight
void SP_LaserSight (edict_t *self)
{
	vec3_t start,forward,right,end;

	if ( lss ) 
	{  
		G_FreeEdict(lss);    
		lss = NULL;
		return; 
	}

   
   AngleVectors (self->client->v_angle, forward, right, NULL);
   VectorSet(end,100 , 0, 0);
   G_ProjectSource (self->s.origin, end, forward, right, start);
   lss = G_Spawn ();  
   lss->owner = self; 
   lss->movetype = MOVETYPE_NOCLIP;
   lss->solid = SOLID_NOT; 
   lss->classname = "lasersight";
   lss->s.modelindex = gi.modelindex ("models/sight/tris.md2");
   lss->s.skinnum = 0;  
   lss->s.renderfx |= RF_FULLBRIGHT;
   lss->think = LaserSightThink; 
   lss->nextthink = level.time + 0.1;
}
/*--------------------------------------------- 
 LaserSightThink
  Updates the sights position, angle, and shape   
  is the lasersight entity
---------------------------------------------*/
void LaserSightThink (edict_t *self)
{  
	vec3_t start,end,endp,offset;
   vec3_t forward,right,up;  
   trace_t tr;

   AngleVectors (self->owner->client->v_angle, forward, right, up);
   VectorSet(offset,24 , 6, self->owner->viewheight-7);

   G_ProjectSource (self->owner->s.origin, offset, forward, right, start);
   VectorMA(start,8192,forward,end);

   tr = gi.trace (start,NULL,NULL, end,self->owner,CONTENTS_SOLID|CONTENTS_MONSTER|CONTENTS_DEADMONSTER);
   if (tr.fraction != 1) 
   {     
	    VectorMA(tr.endpos,-4,forward,endp);
		VectorCopy(endp,tr.endpos);   
   }
      
   vectoangles(tr.plane.normal,self->s.angles);
   VectorCopy(tr.endpos,self->s.origin);  
   gi.linkentity (self);
   self->nextthink = level.time + 0.1;}


void weapon_lasersnipe_fire (edict_t *ent)
{
	vec3_t		start;
	vec3_t		forward, right;
	vec3_t		offset;
	

	if (ent->client->ps.gunframe == 12)
	{
		ent->client->ps.gunframe++;
		ent->client->ps.gunframe++;
		return;
	}
	if (ent->client->ps.gunframe == 14)
	{
		ent->client->ps.gunframe++;
		ent->client->ps.gunframe++;
		return;
	}
	
	if (ent->client->ps.gunframe == 9)
	{
		SP_LaserSight (ent);
		ent->client->ps.fov = 90; 
		ent->client->ps.gunframe++;
		ent->client->ps.gunframe++;
		return;
	}
	if (ent->SniperDamage == 0)
	{
		SP_LaserSight (ent);
		ent->client->ps.fov = 90; 
		ent->SniperDamage = 1;
		return;
	}
	if (ent->client->buttons & BUTTON_ATTACK)
	{
		ent->SniperDamage = ent->SniperDamage+35;
		if (ent->SniperDamage>200)
			ent->SniperDamage= 200;
		ent->client->ps.fov -= 7;
		kick +=3;
		if (kick>40)
			kick = 40;
		if (ent->client->ps.fov < 48)
			ent->client->ps.fov = 48; 
		return;
	}
	AngleVectors (ent->client->v_angle, forward, right, NULL);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -2;

	VectorSet(offset, 0, 8,  ent->viewheight-8);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	if (is_quad)
	{
		ent->SniperDamage *= 4;
		kick *= 4;
	}

	
	fire_bullet (ent, start, forward, ent->SniperDamage, kick, 90, 90, MOD_SNIPERRIFLE);

	// send muzzle flash
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_SHOTGUN | MZ_SILENCED);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	ent->client->ps.gunframe++;
	PlayerNoise(ent, start, PNOISE_WEAPON);

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index]--;
	ent->SniperDamage =0;
	kick = 8;
}

void Weapon_LaserSnipeChoke (edict_t *ent)
{
	static int	pause_frames[]	= {22, 28, 34, 0};
	static int	fire_frames[]	= { 8, 9,12,14, 0};

	Weapon_Generic (ent, 7, 18, 36, 39, pause_frames, fire_frames, weapon_lasersnipe_fire);
}