#include "g_local.h"
/*
================
Flare Gun
================
*/
void flare_explode(edict_t *self)
{
	vec3_t newpos, pos;
	edict_t	*ent;
	float	points;
	vec3_t	v;
	float	dist;
	trace_t tr;
	if (self->s.frame == 1)
	{
		ent = NULL;
		while ((ent = findradius(ent, self->s.origin, self->dmg_radius+20)) != NULL)
		{
			if (!ent->takedamage)
				continue;
			if (!CanDamage (ent, self))
				continue;
			if (!CanDamage (ent, self->owner))
				continue;
			if (ent->wf_team == ent->wf_team)
				continue;

			tr = gi.trace (self->s.origin, NULL, NULL, ent->s.origin, self, MASK_SOLID);
			if (tr.fraction != 1.0)
				continue;
			VectorAdd (ent->mins, ent->maxs, v);
			VectorMA (ent->s.origin, 0.5, v, v);
			VectorSubtract (self->s.origin, v, v);
			dist = VectorLength(v);
			points = self->radius_dmg * (1.0 - sqrt(dist/self->dmg_radius));
			if (ent == self->owner)
				points = points * 0.5;
			burn_person(ent, self->owner, 4);

			T_Damage (ent, self, self->owner, self->velocity, ent->s.origin, vec3_origin, 3, 25, DAMAGE_ENERGY,MOD_FLAREGUN);
		}
	}
	self->nextthink = level.time + FRAMETIME;
	
	VectorSubtract(self->s.origin, self->pos2, pos);
	/*translate current position*/
	RotatePointAroundVector(newpos, self->pos1, pos, 20 + rndnum (0,10));
	/*So we can rotate around our original line
	of sight*/
	VectorAdd(self->pos2, newpos, self->s.origin); 
	/*then translate the current position back*/

	/*The velocity vector must be rotated also*/
	RotatePointAroundVector(self->velocity, self->pos1, self->velocity, 20 + rndnum (0,10)); 
	self->s.frame++;
	if (self->s.frame == 5)
		self->think = G_FreeEdict;
}
void flaregun_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	self->s.modelindex = gi.modelindex ("sprites/s_explod.sp2");
	self->s.frame = 0;
	self->think = flare_explode;
}

static void mod_FlareThink(edict_t *ent)
{
	vec3_t newpos, pos;

	/*translate current position*/
	VectorSubtract(ent->s.origin, ent->pos2, pos); 

	/*So we can rotate around our original line of sight*/
	RotatePointAroundVector(newpos, ent->pos1, pos, 15 + rndnum (0,20)); 

	VectorAdd(ent->pos2, newpos, ent->s.origin); /*then translate the current position back*/

	/*The velocity vector must be rotated also*/
	RotatePointAroundVector(ent->velocity, ent->pos1, ent->velocity, 15 + rndnum (0,20)); 

	if(ent->delay < level.time)
	{
		ent->s.modelindex = gi.modelindex ("sprites/s_explod.sp2");
		ent->s.frame = 0;
		ent->think = flare_explode;
	}
	ent->nextthink = level.time + .1; //Need to think again in .1 seconds
}

void fire_burningflare(edict_t *self, vec3_t start, vec3_t dir, vec3_t los, int damage, int speed, 
float damage_radius, int radius_damage)
{
edict_t *rocket;

rocket = G_Spawn();

VectorCopy (los, rocket->pos1); /*Added: Save the line of sight of the center rocket. This is
the axis around which the other two rockets rotate*/
VectorCopy (start, rocket->pos2); /*Added: Save the start position of the rocket (Not sure if
this is necessary. This info might already be somewhere else)?*/

VectorCopy (start, rocket->s.origin);
VectorCopy (dir, rocket->movedir);
vectoangles (dir, rocket->s.angles);
VectorScale (dir, speed, rocket->velocity);
rocket->movetype = MOVETYPE_FLYMISSILE;
rocket->clipmask = MASK_SHOT;
rocket->solid = SOLID_BBOX;
rocket->s.effects |= EF_ROCKET;
VectorClear (rocket->mins);
VectorClear (rocket->maxs);
rocket->s.modelindex = gi.modelindex ("models/flare/tris.md2");
rocket->owner = self;
rocket->touch = flaregun_touch;
rocket->nextthink = level.time + .1;
rocket->think = mod_FlareThink;
rocket->dmg =4;
rocket->delay = level.time + .4;
rocket->radius_dmg = 128;
rocket->dmg_radius =128;
rocket->s.sound = gi.soundindex ("weapons/rockfly.wav");
rocket->wf_team = self->wf_team;
if (self->client)
check_dodge (self, rocket->s.origin, dir, speed);

gi.linkentity (rocket);
}

void Weapon_FlareGun_Fire (edict_t *ent)
{
vec3_t offset, start;
vec3_t forward, right;
vec3_t traj_angle, lineofsight; /*Added: Trajectory angle of rocket and line of sight for the center rocket*/
int startspeed; /*Added: Start speed of the rockets*/

int damage;
float damage_radius;
int radius_damage;

startspeed=550; /*Added: Set the rocket speed to taste*/

damage = 10 + (int)(random() * 2.0);
radius_damage = 120;
damage_radius = 120;
if (is_quad)
{
damage *= 4;
radius_damage *= 4;
}

AngleVectors (ent->client->v_angle, forward, right, NULL);

VectorScale (forward, -2, ent->client->kick_origin);
ent->client->kick_angles[0] = -1;

/*Added: Start of modified launcher code*/
VectorCopy(forward, lineofsight); /*our line of sight is the same as our forward view vector*/
VectorCopy(ent->client->v_angle, traj_angle); /*get the trajectory angles for later modification*/
/*This is the original launch code*/
VectorSet(offset, 8, 8, ent->viewheight-8);
P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);
/*Added: Now, modify the trajectory of the second rocket to 5 degrees off of the center axis*/
traj_angle[1] = ent->client->v_angle[1]+5;
AngleVectors (traj_angle, forward, right, NULL);

VectorSet(offset, 8, 8, ent->viewheight-8);
P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);
fire_burningflare (ent, start, forward, lineofsight, damage, startspeed, damage_radius, radius_damage);

// send muzzle flash
gi.WriteByte (svc_muzzleflash);
gi.WriteShort (ent-g_edicts);
gi.WriteByte (MZ_ROCKET | is_silenced);
gi.multicast (ent->s.origin, MULTICAST_PVS);

ent->client->ps.gunframe++;
			// ### Hentai ### BEGIN

			ent->client->anim_priority = ANIM_ATTACK;
			if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
			{
				ent->s.frame = FRAME_crattak1 - 1;
				ent->client->anim_end = FRAME_crattak9;
			}
			else
			{
				ent->s.frame = FRAME_attack1 - 1;
				ent->client->anim_end = FRAME_attack8;
			}
	
			// ### Hentai ### END

PlayerNoise(ent, start, PNOISE_WEAPON);

/*enable this if you want your rocket supply to be updated*/
ent->client->pers.inventory[ent->client->ammo_index] -= ent->client->pers.weapon->quantity;
}
void Weapon_FlareGun (edict_t *ent)
{
	static int	pause_frames[]	= {9,32, 0};
	static int	fire_frames[]	= {9, 0};

	Weapon_Generic (ent,5, 9, 31, 36, pause_frames, fire_frames, Weapon_FlareGun_Fire);
}