#include "g_local.h"
#include "stdlog.h"

FILE *logfile = NULL;

char *strip9(char *str)
{
    char *p = str;
    while(*p)
    {
        if(*p==9)
            *p = '_';
        p++;
    }   
    return str;
}
                             
void  sl_Logging( game_import_t  *gi, char *pPatchName )
{
    char path[100];
    char str[20];

	if (wfflags == NULL) return;

    if ((int)wfflags->value & WF_NO_PLAYER_CLASSES)
        return;

//    strcpy(path,gamedir);
//    strcat(path,"/std.log");
    strcpy(path,"std.log");
    if( logfile = fopen(path,"a") )
    {
        fprintf(logfile,"\x9\x9StdLog\x9 1.22\n");
        fprintf(logfile,"\x9\x9PatchName\x9%s\n",strip9(pPatchName));
        _strdate( str );
        fprintf(logfile,"\x9\x9LogDate\x9%s\n",str);
        _strtime( str );
        fprintf(logfile,"\x9\x9LogTime\x9%s\n",str);
    }
}


void sl_GameStart( game_import_t    *gi,level_locals_t    level )
{
    if( logfile )
    {
        fprintf(logfile,"\x9\x9LogDeathFlags\x9%d\n",dmflags);
        fprintf(logfile,"\x9\x9Map\x9%s\n",strip9(level.level_name));
        fprintf(logfile,"\x9\x9GameStart\x9\x9\x9%f\n",level.time);
    }
}

void sl_GameEnd( game_import_t    *gi,level_locals_t    level )
{
    if( logfile )
    {
        fprintf(logfile,"\x9\x9GameEnd\x9\x9\x9%f\n",level.time);
        fflush(logfile);
    }
}

void sl_LogPlayerConnect( game_import_t *gi,level_locals_t level, edict_t *ent )
{
    if( logfile )
    {
        fprintf(logfile,"\x9\x9PlayerConnect\x9%s\x9%s\x9%f\n",
			strip9(ent->client->pers.netname),
			CTFTeamName(ent->client->resp.ctf_team),
			level.time);
    }
}

void sl_LogPlayerDisconnect( game_import_t *gi,level_locals_t level, edict_t *ent )
{
    if( logfile )
    {
        fprintf(logfile,"\x9\x9PlayerDisonnect\x9%s\x9\x9%f\n",
			strip9(ent->client->pers.netname),
			level.time);
    }
}

void sl_LogPlayerTeamChange( game_import_t *gi, char *pPlayerName, char *pTeamName)
{
    if( logfile )
    {
        fprintf(logfile,"\x9\x9PlayerTeamChange\x9%s\x9\x9%f\n",
			strip9(pPlayerName),
			strip9(pTeamName),
			level.time);
    }
}

void sl_LogPlayerRename( game_import_t  *gi, char *pPlayerName, char *pNewName)
{
    if( logfile )
    {
        fprintf(logfile,"\x9\x9PlayerRename\x9%s\x9\x9%f\n",
			strip9(pPlayerName),
			strip9(pNewName),
			level.time);
    }
}


void sl_LogScore( game_import_t  *gi,
                         char           *pKillerName,
                         char           *pTargetName,
                         char           *pScoreType,
                         char           *pWeaponName,
                         int             iScore)
{
    if( logfile )
    {
    fprintf(logfile,"%s\x9%s\x9%s\x9%s\x9%d\x9%f\n",
                                    strip9(pKillerName),
                                    strip9(pTargetName),
                                    strip9(pScoreType),
                                    strip9(pWeaponName),
                                     iScore,
                                     level.time );
    }
}
