#include "g_local.h"
void remote_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	T_RadiusDamage (self, self->owner, 20, NULL, 10,0);
	// BANG !
	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_EXPLOSION1);
	gi.WritePosition(self->s.origin);
	gi.multicast (self->s.origin, MULTICAST_PVS);
	G_FreeEdict (self);
}
void remotecam_think(edict_t *ent)
{
	if(ent->owner->client->remotetoggle)
	{
		if (ent->owner->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] < 2)
		{
 			gi.cprintf(ent, PRINT_HIGH, "Not enough cells for the  Remote Camera to stay\n");

			G_FreeEdict (ent->owner->client->oldplayer);
			ent->owner->client->remotetoggle = 0;
			T_RadiusDamage (ent, ent->owner, 10, NULL, 10,0);
			// BANG !
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_EXPLOSION1);
			gi.WritePosition(ent->s.origin);
			gi.multicast (ent->s.origin, MULTICAST_PVS);
			G_FreeEdict (ent);
			return;
		}
	}
	if(ent->owner->client->remotetoggle)
		ent->owner->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= 2;
	ent->nextthink = level.time + 0.5;
}

void place_remotecam (edict_t *ent)
{
	
	vec3_t		forward,
				wallp, offset;

	trace_t		tr;

	// valid ent ?
  	if ((!ent->client) || (ent->health<=0))
	   return;

	if (ent->remotecam) 
		{  
			G_FreeEdict(ent->remotecam);    
			ent->remotecam = NULL;
			gi.bprintf (PRINT_HIGH, "Remote cam off.\n"); 
			if (ent->client->oldplayer)
				G_FreeEdict(ent->client->oldplayer);
			return; 
		}

	// cells for laser ?
	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] < 25)
	{
 		gi.cprintf(ent, PRINT_HIGH, "Not enough cells for a Remote Camera\n");
		return;
	}

	// Setup "little look" to close wall
	VectorCopy(ent->s.origin,wallp);         

	// Cast along view angle
	AngleVectors (ent->client->v_angle, forward, NULL, NULL);

	// Setup end point
	wallp[0]=ent->s.origin[0]+forward[0]*50;
	wallp[1]=ent->s.origin[1]+forward[1]*50;
	wallp[2]=ent->s.origin[2]+forward[2]*50;  

	// trace
	tr = gi.trace (ent->s.origin, NULL, NULL, wallp, ent, MASK_SOLID);

	// Line complete ? (ie. no collision)
	if (tr.fraction == 1.0)
	{
	 	gi.cprintf (ent, PRINT_HIGH, "Too far from wall.\n");
		return;
	}

	// Hit sky ?
	if (tr.surface)
		if (tr.surface->flags & SURF_SKY)
			return;
	ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= 25;


		if (ent->remotecam) 
		{  
			G_FreeEdict(ent->remotecam);    
			ent->remotecam = NULL;
			gi.bprintf (PRINT_HIGH, "Remote cam off.\n"); 
			return; 
		}
		gi.bprintf (PRINT_HIGH, "Remote cam on.\n");
		ent->remotecam = G_Spawn();
		VectorClear (ent->remotecam->mins);
		VectorClear (ent->remotecam->maxs);
		VectorCopy (tr.endpos, ent->remotecam->s.origin);
		vectoangles(tr.plane.normal,ent->remotecam -> s.angles);
		ent->remotecam -> movetype		= MOVETYPE_NONE;
		ent->remotecam -> clipmask		= MASK_SHOT;
		//grenade -> solid		= SOLID_NOT;
		ent->remotecam->solid = SOLID_BBOX;
		VectorSet(ent->remotecam->mins, -3, -3, 0);
		VectorSet(ent->remotecam->maxs, 3, 3, 6);
		ent->remotecam->takedamage=DAMAGE_NO;
		ent->remotecam -> s.modelindex	= gi.modelindex ("models/objects/grenade2/tris.md2");
		ent->remotecam -> owner		= ent;	
		ent->remotecam->think = remotecam_think;
		ent->remotecam->nextthink = level.time + 0.5;
		ent->remotecam->die = remote_die;
		ent->remotecam->health= 10;
		ent->remotecam->max_health =10;
		offset[0]=forward[0]*-10;
		offset[1]=forward[1]*-10;
		offset[2]=forward[2]*-10;
		VectorAdd(offset,tr.endpos,offset);
		VectorCopy(offset,ent->remotecam->camposition);
		gi.linkentity (ent->remotecam);
		if(ent->client->remotetoggle)
		{
			ent->client->oldplayer = G_Spawn(); 
			ent->client->oldplayer->s.frame = ent->s.frame;
			VectorCopy (ent->s.origin, ent->client->oldplayer->s.origin);
			VectorCopy (ent->velocity, ent->client->oldplayer->velocity);
            VectorCopy (ent->s.angles, ent->client->oldplayer->s.angles);
            ent->client->oldplayer->s.modelindex = ent->s.modelindex;
            ent->client->oldplayer->s.modelindex2 = ent->s.modelindex2;
            gi.linkentity (ent->client->oldplayer);
		}
}

//Remote Camera Commands
void cmd_CameraPlace(edict_t *ent)
{
	place_remotecam (ent);
}

void cmd_CameraToggle(edict_t *ent)
{
	if (ent->client->remotetoggle)
	{
		ent->client->remotetoggle = 0;
		G_FreeEdict(ent->client->oldplayer);
	}
	else
	{
		ent->client->remotetoggle =1;
		ent->client->oldplayer = G_Spawn(); 
		ent->client->oldplayer->s.frame = ent->s.frame;
		VectorCopy (ent->s.origin, ent->client->oldplayer->s.origin);
		VectorCopy (ent->velocity, ent->client->oldplayer->velocity);
		VectorCopy (ent->s.angles, ent->client->oldplayer->s.angles);
		ent->client->oldplayer->s.modelindex = ent->s.modelindex;
		ent->client->oldplayer->s.modelindex2 = ent->s.modelindex2;
		gi.linkentity (ent->client->oldplayer);
	}
}
