#include "g_local.h"

void Fire_Think (edict_t *self)
{
	vec3_t dir;
	int damage;
	float	points;
	vec3_t	v;

	if (level.time > self->delay)
	{
		self->owner->Flames--;
		G_FreeEdict (self);
		return;
	}
	//if (self->owner->takedamage = DAMAGE_NO)
	//{
	//	self->owner->Flames--;
	//	G_FreeEdict (self);
//		return;
//	}
	if (!self->owner)
	{
		G_FreeEdict (self);
		return;
	}
	if (self->owner->waterlevel)
	{
		self->owner->Flames--;
		G_FreeEdict (self);
		return;
	}
	damage = rndnum (1,self->SniperDamage);	
	VectorAdd (self->orb->mins, self->orb->maxs, v);
	VectorMA (self->orb->s.origin, 0.5, v, v);
	VectorSubtract (self->s.origin, v, v);
	points = damage - 0.5 * (VectorLength (v));
	VectorSubtract (self->owner->s.origin, self->s.origin, dir);

	if (self->PlasmaDelay < level.time)
	{
		T_Damage (self->owner, self, self->orb, dir, self->owner->s.origin,vec3_origin, damage, 0, DAMAGE_NO_KNOCKBACK,MOD_WF_FLAME);
		self->PlasmaDelay = level.time + 0.8;
	}
	VectorCopy(self->owner->s.origin,self->s.origin);
	self->nextthink = level.time + .2;
}

void burn_person(edict_t *target, edict_t *owner, int damage)
{
	edict_t	*flame;

	if (target->Flames > 1)//Lowered this down even more (GREGG-From 3 to 1)
		return;
	target->Flames++;
	flame = G_Spawn();
	flame->movetype = MOVETYPE_NOCLIP;
	flame->clipmask = MASK_SHOT;
	flame->solid = SOLID_NOT;
	flame->s.effects |= EF_ANIM_ALLFAST|EF_BFG|EF_HYPERBLASTER;//|EF_GRENADE|EF_BLASTER;
	flame->velocity[0] = target->velocity[0];
	flame->velocity[1] = target->velocity[1];
	flame->velocity[2] = target->velocity[2];

	VectorClear (flame->mins);
	VectorClear (flame->maxs);
	flame->s.modelindex = gi.modelindex ("sprites/fire.sp2");
	flame->owner = target;
	flame->orb = owner;
	flame->delay = level.time + 5;//8;//Jr Shorten it so it goes away faster
	flame->nextthink = level.time + .8;
	flame->PlasmaDelay = level.time + 0.8;
	flame->think = Fire_Think;
	flame->SniperDamage = damage+2;//JR increased that
	flame->classname = "fire";
	flame->s.sound = gi.soundindex ("weapons/bfg__l1a.wav");
	gi.linkentity (flame);

	VectorCopy(target->s.origin,flame->s.origin);
}

static void Napalm_Touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (other == ent->owner)
		return;

	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (ent);
		return;
	}

	if (!other->takedamage)
	{
		return;
	}
	return;
}

void Napalm_Think(edict_t *self)
{
	edict_t	*ent;
	vec3_t	v;
	float	points;
	float	dist;
	ent = NULL;
	while ((ent = findradius(ent, self->s.origin, 64)) != NULL)
	{
		if (!ent->takedamage)
			continue;
		if (!CanDamage (ent, self))
			continue;
		if (!CanDamage (ent, self->owner))
			continue;
		VectorAdd (ent->mins, ent->maxs, v);
		VectorMA (ent->s.origin, 0.5, v, v);
		VectorSubtract (self->s.origin, v, v);
		dist = VectorLength(v);
		points = self->radius_dmg * (1.0 - sqrt(dist/self->dmg_radius));
		if (ent == self->owner)
			points = points * 0.5;
		burn_person(ent, self->owner, 4);

		T_Damage (ent, self, self->owner, self->velocity, ent->s.origin, vec3_origin, 3, 25, DAMAGE_ENERGY,0);
	}
	self->nextthink = level.time + 0.8;
	if (self->delay <level.time)
		self->think = G_FreeEdict;
	if (self->waterlevel)
	{
		G_FreeEdict (self);
		return;
	}
}

//Use Gregg's function for now
void fire_napalm2 (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius)
{     
	edict_t *grenade; 
       vec3_t  dir;
        vec3_t  forward, right, up;  
		vectoangles (aimdir, dir);
        AngleVectors (dir, forward, right, up);     
		grenade = G_Spawn();
        VectorCopy (start, grenade->s.origin);
        VectorScale (aimdir, speed, grenade->velocity);
        VectorMA (grenade->velocity, 200 + crandom() * 10.0, up, grenade->velocity);
        VectorMA (grenade->velocity, crandom() * 10.0, right, grenade->velocity);
        VectorSet (grenade->avelocity, 300, 300, 300);
        grenade->movetype = MOVETYPE_BOUNCE;
        grenade->clipmask = MASK_SHOT;     
		grenade->solid = SOLID_BBOX;
        grenade->s.effects |= /*EF_GRENADE|EF_BLASTER|*/EF_ANIM_ALLFAST|EF_BFG|EF_HYPERBLASTER;;
	//	VectorClear (grenade->mins);
      //  VectorClear (grenade->maxs);
        grenade->s.modelindex = gi.modelindex ("sprites/fire.sp2");
        grenade->owner = self;   
		grenade->touch = Napalm_Touch;
        grenade->think = Napalm_Think;
		grenade->nextthink = level.time + 0.1;
		grenade->delay = level.time + timer;
		grenade->dmg = damage;
        grenade->dmg_radius = damage_radius;
        grenade->classname = "napalm";  
			// CCH: a few more attributes to let the grenade 'die'
	VectorSet(grenade->mins, -32, -32, -32);
	VectorSet(grenade->maxs, 32, 32, 32);
	grenade->mass = 5;
	grenade->monsterinfo.aiflags = AI_NOSTEP;

		gi.linkentity (grenade);
}