#include "g_local.h"
#include "m_player.h"
#define newTurret self->turret1
#define newTurret2 self->turret1->turret2
#define Level1Idle 0
#define Level1StartFirst 1
#define Level1StartEnd 2
#define Level1AttackFirst 3
#define Level1AttackEnd 6
#define Level23Idle 0
#define Level23AttackFirst 1
#define Level23AttackEnd 2
#define StatusIdle 0
#define StatusStart 1
#define StatusAttack 2

void BecomeExplosion1 (edict_t *self);
void SP_Turret (edict_t *self);
//void fire_bullet (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread);
void TurretFire1(edict_t *self);

void TurretAnimate(edict_t *ent)
{
  if(ent->count==1)
  {
	if(ent->delay==StatusIdle)
	{
		ent->s.frame = Level1Idle;
		return;
	}
	else if(ent->delay==StatusStart)
	{
		if(ent->s.frame == Level1StartEnd)
		{
		ent->delay=StatusAttack;
		ent->s.frame=Level1AttackFirst;
		return;
	}
	else if(ent->s.frame==Level1Idle)
	{
		ent->s.frame = Level1StartFirst;
		return;
	}
	else if(ent->s.frame==Level1StartFirst)
	{
		ent->s.frame++;
		return;
	}
	else
	{
		ent->s.frame = Level1Idle;
		return;
	}
}
else
{
	if(ent->delay==StatusAttack)
	{
		if(ent->s.frame==Level1AttackEnd)
		{
			ent->s.frame--;
			return;
		}
		else
		{
			ent->s.frame++;
			return;
		}
	}
}
}
else
{
	if(ent->delay ==StatusIdle)
{
ent->s.frame = Level23Idle;
return;
}
else
{
if(ent->s.frame==Level23AttackEnd)
{
ent->s.frame = Level23AttackFirst;
return;
}
ent->s.frame++;
return;
}
	}
}

void FireTurretLeft(edict_t *ent,int damage)
{
	vec3_t forward, right, start, target, dir;
	
	if(ent->light_level<1)
		return;
	ent->light_level--;

	AngleVectors (ent->s.angles, forward, right, NULL);
	
	start[0] = ent->s.origin[0] + forward[0] * 3 + right[0] * -0.5;
	start[1] = ent->s.origin[1] + forward[1] * 3 + right[1] * -0.5;
	start[2] = ent->s.origin[2] + forward[2] * 3 + right[2] * -0.5 +4;

	// calc direction to where we targetd
	VectorMA (ent->enemy->s.origin, -0.05, ent->enemy->velocity, target);

	//Adjust for height
	target[2] += ent->enemy->viewheight/1.5;
	
	VectorSubtract (target, start, dir);
	VectorNormalize (dir);
	
	//fire bullet
	fire_bullet (ent, start, dir, damage, 0, 25, 25, MOD_SENTRY);

	// send muzzle flash
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent - g_edicts);
	gi.WriteByte (MZ_SHOTGUN );
	gi.multicast (start, MULTICAST_PVS);
	gi.sound(ent, CHAN_VOICE, gi.soundindex("boss3\xfire.wav"), 1, ATTN_NORM, 0);

}


void FireTurretCenter(edict_t *ent)
{
	vec3_t forward, right, start, target, dir;
	
	if(ent->light_level<1)
		return;
	ent->light_level--;
	AngleVectors (ent->s.angles, forward, right, NULL);

	start[0] = ent->s.origin[0] + forward[0] * 3 ;
	start[1] = ent->s.origin[1] + forward[1] * 3 ;
	start[2] = ent->s.origin[2] + forward[2] * 3+4;

	// calc direction to where we targetd
	VectorMA (ent->enemy->s.origin, -0.05, ent->enemy->velocity, target);
	
	//Adjust for height
	target[2] += ent->enemy->viewheight/1.5;
	
	VectorSubtract (target, start, dir);
	VectorNormalize (dir);
	
	//fire bullet
	fire_bullet (ent, start, dir, 8, 0, 25, 25, MOD_SENTRY);

	// send muzzle flash
	
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent - g_edicts);
	gi.WriteByte (MZ_SHOTGUN );
	gi.multicast (start, MULTICAST_PVS);
	gi.sound(ent, CHAN_VOICE, gi.soundindex("boss3\xfire.wav"), 1, ATTN_NORM, 0);

}

void FireTurretRight(edict_t *ent,int damage)
{
	vec3_t forward, right, start, target, dir;
	
	if(ent->light_level<1)
		return;
	ent->light_level--;
	AngleVectors (ent->s.angles, forward, right, NULL);

	start[0] = ent->s.origin[0] + forward[0] * 3 + right[0] * 0.5;
	start[1] = ent->s.origin[1] + forward[1] * 3 + right[1] * 0.5;
	start[2] = ent->s.origin[2] + forward[2] * 3 + right[2] * 0.5+4;

	// calc direction to where we targetd
	VectorMA (ent->enemy->s.origin, -0.05, ent->enemy->velocity, target);
	
	//Adjust for height
	target[2] += ent->enemy->viewheight/1.5;
	
	VectorSubtract (target, start, dir);
	VectorNormalize (dir);
	
	//fire bullet
	fire_bullet (ent, start, dir, damage, 0, 25, 25, MOD_SENTRY);

	// send muzzle flash
	
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent - g_edicts);
	gi.WriteByte (MZ_SHOTGUN);
	gi.multicast (start, MULTICAST_PVS);
	gi.sound(ent, CHAN_VOICE, gi.soundindex("boss3\xfire.wav"), 1, ATTN_NORM, 0);

}


void Turret_Think(edict_t *self)
{
	edict_t *blip;
	float dist;
	vec3_t v;
	trace_t		tr;
//	gitem_t	*ammo;
	int max;
	float checkyaw;
	blip = NULL;
	
	//gi.error("john");

	if(self->enemy)
	{
		if(self->enemy->health<=0)
			self->enemy= NULL;
	}
	if (self->light_level!=self->gib_health)
	{
		if (self->PlasmaDelay<level.time)
		{
			max = self->gib_health;
				
			if (self->count==3)
				self->PlasmaDelay = level.time +0.1;
			else if (self->count==2)
				self->PlasmaDelay = level.time +0.2;
			else
				self->PlasmaDelay = level.time +0.4;
			self->light_level++;
			if (self->light_level > max)
				self->light_level = max;
//GREGG			gi.sound(self, CHAN_ITEM, gi.soundindex("misc/w_pkup.wav"), 1, ATTN_NORM, 0);
		}
	}

	if (self->count == 1)
	{
	
		if(!self->enemy)
		{
			self->delay=StatusIdle;
			//Reduce range 
//			while (blip = findradius (blip, self->s.origin, 1024))
			while (blip = findradius (blip, self->s.origin, 400))
			{
		
				if (!(blip->svflags & SVF_MONSTER) && !blip->client)
					continue;
				if (blip->health <= 0)
					continue;
				if (blip == self->creator)
					continue;
				if ((blip->wf_team == self->wf_team) && (((int)wfflags->value & WF_ALLOW_FRIENDLY_FIRE)==0))
					continue;
				if (blip->light_level<10)
					continue;
				tr = gi.trace (self->s.origin, NULL, NULL, blip->s.origin, self, MASK_SOLID);
				if (tr.fraction != 1.0)
					continue;
				VectorSubtract (self->s.origin, blip->s.origin, v);
			
				dist = VectorLength(v);

				if (!visible(self, blip) && dist > 300)
					continue;
			
				self->enemy = blip;
			}
		}
		else
		{
			VectorSubtract (self->enemy->s.origin, self->s.origin, v);
		
			self->ideal_yaw = vectoyaw(v);
		
		
			M_ChangeYaw(self);
			
			checkyaw = anglemod(self->s.angles[YAW])-self->ideal_yaw;

			if (checkyaw>-25 && checkyaw<25)
			{
				if (self->light_level>0)
				{
					if (visible(self, self->enemy))
					{
						if (self->s.frame != 1)
						{
							if (self->delay==StatusIdle)
								self->delay = StatusStart;
					
							if(self->s.frame == 3)
								FireTurretRight(self,5);

							if( (self->s.frame == 1) || (self->s.frame ==5) )
								FireTurretLeft(self,5);
						
						}
					}
					else
					{
						self->delay=StatusIdle;		
						self->enemy=NULL;
					}
				}
			}
			else
			{
				self->delay=StatusIdle;
				self->enemy=NULL;
			}
		}
	}

	else if (self->count == 2)
	{
	
		if(!self->enemy)
		{
			self->delay=StatusIdle;
			//Reduce range 
			while (blip = findradius (blip, self->s.origin, 700))
			{
		
				if (!(blip->svflags & SVF_MONSTER) && !blip->client)
					continue;
				if (blip->health <= 0)
					continue;
				if (blip == self->creator)
					continue;
				if ((blip->wf_team == self->wf_team) && (((int)wfflags->value & WF_ALLOW_FRIENDLY_FIRE)==0))
					continue;
				if (blip->light_level<7)
					continue;
				tr = gi.trace (self->s.origin, NULL, NULL, blip->s.origin, self, MASK_SOLID);
				if (tr.fraction != 1.0)
					continue;
				VectorSubtract (self->s.origin, blip->s.origin, v);
			
				dist = VectorLength(v);

				if (!visible(self, blip) && dist > 500)
					continue;
			
				self->enemy = blip;
			}
		}
		else
		{
			VectorSubtract (self->enemy->s.origin, self->s.origin, v);
		
			self->ideal_yaw = vectoyaw(v);
		
		
			M_ChangeYaw(self);
			checkyaw = anglemod(self->s.angles[YAW])-self->ideal_yaw;

			if (checkyaw>-25 && checkyaw<25)
			{
				if (self->light_level>0)
				{
					if (visible(self, self->enemy))
					{
						if (self->s.frame != 1)
						{
							if (self->delay==StatusIdle)
								self->delay = StatusAttack;
					
							FireTurretCenter(self);
						
						}
					}
					else
					{
						self->delay=StatusIdle;
						self->enemy=NULL;
					}
				}
			}
			else
			{
				self->delay=StatusIdle;
				self->enemy=NULL;
			}
		}
	}
	else if (self->count == 3)
	{
	
		if(!self->enemy)
		{
			self->delay=StatusIdle;
			//Reduce range 
                        while (blip = findradius (blip, self->s.origin, 700))
			{
		
				if (!(blip->svflags & SVF_MONSTER) && !blip->client)
					continue;
				if (blip->health <= 0)
					continue;
				if (blip == self->creator)
					continue;
				if ((blip->wf_team == self->wf_team) && (((int)wfflags->value & WF_ALLOW_FRIENDLY_FIRE)==0))
					continue;
				if (blip->light_level<4)
					continue;
				tr = gi.trace (self->s.origin, NULL, NULL, blip->s.origin, self, MASK_SOLID);
				if (tr.fraction != 1.0)
					continue;
				VectorSubtract (self->s.origin, blip->s.origin, v);
			
				dist = VectorLength(v);

				if (!visible(self, blip) && dist > 700)
					continue;
			
				self->enemy = blip;
			}
		}
		else
		{
			VectorSubtract (self->enemy->s.origin, self->s.origin, v);
		
			self->ideal_yaw = vectoyaw(v);
		
		
			M_ChangeYaw(self);
			checkyaw = anglemod(self->s.angles[YAW])-self->ideal_yaw;

			if (checkyaw>-25 && checkyaw<25)
			{
				if (self->light_level>0)
				{
					if (visible(self, self->enemy))
					{
						if (self->s.frame != 1)
						{
							if (self->delay==StatusIdle)
								self->delay = StatusAttack;
					
							FireTurretRight(self,15);
							FireTurretLeft(self,15);
						
						}
					}
					else
					{
						self->delay=StatusIdle;
						self->enemy=NULL;
					}
				}
			}
			else
			{
				self->delay=StatusIdle;
				self->enemy = NULL;
			}
		}
	}
	//Move the stand? (GREGG)
	if (self->sentry)
		VectorCopy(self->s.origin,self->sentry->s.origin);

	TurretAnimate(self);
	self->nextthink = level.time + 0.1;
	if(self->health<self->max_health)
		self->health++;
}	

void turret_remove(edict_t *ent)
{
	if (ent->sentry) 
	{  
		gi.cprintf(ent->creator, PRINT_HIGH, "Sentry Gun off.\n"); 

		//First free the stand
		if (ent->sentry->sentry)
		{
			G_FreeEdict(ent->sentry->sentry);
			ent->sentry->sentry = NULL;
		}


		//Then free the sentry gun
		G_FreeEdict(ent->sentry);    
		ent->sentry = NULL;
		if (ent->client->oldplayer)
			G_FreeEdict(ent->client->oldplayer);
		return; 
	}
}

void turret_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{

	vec3_t origin;	

	gi.cprintf(self->creator, PRINT_HIGH, "Sentry Gun Destroyed.\n"); 

	//Give a frag to the attacker
	if (attacker->client && attacker->wf_team != self->wf_team)
	{
		attacker->client->resp.score++;
	}

	VectorCopy (self->s.origin,origin);
	origin[2]+= 0.5;
	self->takedamage = DAMAGE_NO;

	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_EXPLOSION1);
	gi.WritePosition (origin);
	gi.multicast (origin, MULTICAST_PVS);
	//G_FreeEdict(self->turret2);

	//Remove stand (which is the sentry of the sentry gun)
	if (self->sentry)
	{
		G_FreeEdict(self->sentry);
	}
	//Gregg I noticed you put this in the wrong place
	//Clear client's pointer to sentry gun
	if (self->creator)
		self->creator->sentry = NULL;
	G_FreeEdict (self);

	//Clear client's pointer to sentry gun
	if (self->creator)
		self->creator->sentry = NULL;

}

void place_turret (edict_t *ent)
{
	
	vec3_t		forward,up,right,wallp, pos;

	trace_t		tr;
	edict_t *sentrystand;

	// valid ent ?
  	if ((!ent->client) || (ent->health<=0))
	   return;

	if (ent->sentry) 
	{  
		gi.cprintf(ent, PRINT_HIGH, "Sentry Gun off.\n"); 

		//First free the stand
		if (ent->sentry->sentry)
		{
			G_FreeEdict(ent->sentry->sentry);
			ent->sentry->sentry = NULL;
		}

		//Then free the sentry gun
		G_FreeEdict(ent->sentry);    
		ent->sentry = NULL;
		if (ent->client->oldplayer)
			G_FreeEdict(ent->client->oldplayer);
		return; 
	}

	// cells for sentry gun ?
	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] < 25)
	{
 		gi.cprintf(ent, PRINT_HIGH, "Not enough cells for a Sentry Gun\n");
		return;
	}

	// Setup "little look" to close wall
	VectorCopy(ent->s.origin,wallp);         

	// Cast along view angle
	AngleVectors (ent->client->v_angle, forward, right, up);

	// Setup end point
	pos[0]=ent->s.origin[0]+forward[0]*75;
	pos[1]=ent->s.origin[1]+forward[1]*75;
	pos[2]=ent->s.origin[2]+forward[2]*75+30;  
	wallp[0]=ent->s.origin[0]+forward[0]*150;
	wallp[1]=ent->s.origin[1]+forward[1]*150;
	wallp[2]=ent->s.origin[2]+forward[2]*150+30; 
	// trace
	tr = gi.trace (ent->s.origin, NULL, NULL, wallp, ent, MASK_SOLID);
	
		
	// Line complete ? (ie. no collision)
	if (tr.fraction != 1.0)
	{
	 	gi.cprintf (ent, PRINT_HIGH, "Not enough room.\n");
		return;
	}
	wallp[2]+=22;
	tr = gi.trace (pos, NULL, NULL, wallp, ent, MASK_SOLID);
	// Line complete ? (ie. no collision)
	if (tr.fraction != 1.0)
	{
	 	gi.cprintf (ent, PRINT_HIGH, "Not enough room. Try aiming lower\n");
		return;
	}
	wallp[2]-=40;
		tr = gi.trace (pos, NULL, NULL, wallp, ent, MASK_SOLID);
	// Line complete ? (ie. no collision)
	if (tr.fraction != 1.0)
	{
	 	gi.cprintf (ent, PRINT_HIGH, "Not enough room. Try aiming higher\n");
		return;
	}

	// Hit sky ?
	if (tr.surface)
		if (tr.surface->flags & SURF_SKY)
			return;
	ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= 25;


//		if (ent->sentry) 
//		{  
//			G_FreeEdict(ent->sentry);    
//			ent->sentry = NULL;
//			gi.bprintf (PRINT_HIGH, "Sentry Gun off.\n"); 
//			return; 
//		}
	gi.cprintf(ent, PRINT_HIGH, "Sentry Gun on.\n");
	ent->sentry = G_Spawn();
	VectorClear (ent->sentry->mins);
	VectorClear (ent->sentry->maxs);
	VectorCopy (pos, ent->sentry->s.origin);
	ent->sentry ->s.angles[0]=ent->s.angles[0];
//	ent->sentry -> movetype		= MOVETYPE_STEP;
//	ent->sentry -> clipmask		= MASK_SHOT;
	ent->sentry -> movetype		= MOVETYPE_STEP;
	ent->sentry -> clipmask		= MASK_PLAYERSOLID;
	ent->sentry->mass = 400;
	ent->s.renderfx=RF_FRAMELERP|RF_TRANSLUCENT|RF_GLOW;
	//grenade -> solid		= SOLID_NOT;
	ent->sentry->solid = SOLID_BBOX;
//GR - reduce size of bounding box since I reduced size of model
//	VectorSet(ent->sentry->mins, -95,-44,-80);
//	VectorSet(ent->sentry->maxs, 57, 41, 24);
	VectorSet(ent->sentry->mins, -50,-20,-40);
	VectorSet(ent->sentry->maxs, 30, 21, 22);
	ent->sentry->takedamage=DAMAGE_YES;
	ent->sentry -> s.modelindex	= gi.modelindex ("models/sentry/turret1/tris.md2");
	ent->sentry -> creator = ent;	
	ent->sentry->think = Turret_Think;
	ent->sentry->nextthink = level.time + 0.1;
	ent->sentry->die = turret_die;
	ent->sentry->health= 80;
	ent->sentry->max_health =80;
	ent->sentry->count = 1;
	ent->sentry->classname = "SentryGun";
	ent->sentry->wf_team = ent->wf_team;
	ent->sentry->noteamdamage = true;	//Don't let teammates damage it
	ent->sentry->yaw_speed = 35;
	ent->sentry->gib_health = 75;//Max Ammo
	ent->sentry->light_level = 75;//Ammo Total
		
	ent->sentry->delay=StatusIdle;
	gi.linkentity (ent->sentry);
	sentrystand = G_Spawn();
	VectorClear (sentrystand->mins);
	VectorClear (sentrystand->maxs);
	VectorCopy (pos,sentrystand->s.origin);
	sentrystand->s.angles[0]=ent -> s.angles[0];
	sentrystand->movetype		= MOVETYPE_NONE;
	sentrystand->mass = 400;
	//grenade -> solid		= SOLID_NOT;
	sentrystand->solid = SOLID_BBOX;
	VectorSet(sentrystand->mins, -45,-15,-35);
	VectorSet(sentrystand->maxs, 25, 18, 18);
	sentrystand->takedamage=DAMAGE_NO;
	sentrystand-> s.modelindex	= gi.modelindex ("models/stand/tris.md2");
	sentrystand-> creator = ent->sentry;
	sentrystand->wf_team = ent->wf_team;
	sentrystand->noteamdamage = true;	//Don't let teammates damage it
		
	gi.linkentity (sentrystand);
	ent->sentry->sentry = sentrystand;
}

void UpgradeSentry(edict_t *self)
{
	edict_t *blip;
	trace_t		tr;
	qboolean found;

	blip = NULL;
	found = false;
//	while (blip = findradius (blip, self->s.origin, 2048))
	while (blip = findradius (blip, self->s.origin, 128))
	{
		if (Q_stricmp("SentryGun", blip->classname))
			continue;

		if (self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] < 80)
		{
 			gi.cprintf(self, PRINT_HIGH, "Not enough cells for upgrading\n");
			return;
		}

		found = true;

		tr = gi.trace (self->s.origin, NULL, NULL, blip->s.origin, self, MASK_SOLID);
		if (tr.fraction != 1.0)
			continue;
		if (blip->creator != self)
			continue;
		if (blip->count == 3)
 			gi.cprintf(self, PRINT_HIGH, "Sentry gun already at level 3\n");

		if (blip->count < 3)
			blip->count++;
		self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= 80;
		if (blip->count == 2)
		{
			blip->health= 150;
			blip->max_health =150;
			blip -> s.modelindex	= gi.modelindex ("models/sentry/turret2/tris.md2");
			blip->delay = StatusIdle;
			blip->s.frame = 0;
			blip->yaw_speed = 40;
			blip->gib_health = 150;//Max Ammo
		}
		if (blip->count == 3)
		{
			blip->health= 215;
			blip->max_health =215;
			blip -> s.modelindex	= gi.modelindex ("models/sentry/turret3/tris.md2");
			blip->delay = StatusIdle;
			blip->s.frame = 0;			
			blip->yaw_speed = 45;
			blip->gib_health = 225;//Max Ammo
		}
	}

	if (found == false)
 		gi.cprintf(self, PRINT_HIGH, "Sorry, you aren't close enough.\n");
}
