#include "g_local.h"

#define newSupplyDepot self->supply
void SP_SupplyDepot(edict_t *self);
/*
=================
Supply Depot
=================
*/

void SupplyThink (edict_t *self)
{
	edict_t *other;
	int x;
	other = NULL;
	while ((other = findradius(other, self->s.origin, 16)) != NULL)
	{
		if (other->client)
		{
			other->DrunkTime=0;
			other->disease= 0;

			if (other->client->pers.inventory[ITEM_INDEX(FindItem("bullets"))]<other->client->pers.max_bullets)
			{
				x =1;
				other->client->pers.inventory[ITEM_INDEX(FindItem("bullets"))]+= 1;
			}
			if (other->client->pers.inventory[ITEM_INDEX(FindItem("shells"))]<other->client->pers.max_shells)
			{
				x=1;
				other->client->pers.inventory[ITEM_INDEX(FindItem("shells"))]+= 1;
			}
			if (other->client->pers.inventory[ITEM_INDEX(FindItem("grenades"))]<other->client->pers.max_grenades)
			{
				x=1;
				other->client->pers.inventory[ITEM_INDEX(FindItem("grenades"))]+= 1;
			}
			if (other->client->pers.inventory[ITEM_INDEX(FindItem("rockets"))]<other->client->pers.max_rockets)
			{
				x=1;
				other->client->pers.inventory[ITEM_INDEX(FindItem("rockets"))]+= 1;
			}
			if (other->client->pers.inventory[ITEM_INDEX(FindItem("slugs"))]<other->client->pers.max_slugs)
			{
				x=1;
				other->client->pers.inventory[ITEM_INDEX(FindItem("slugs"))]+= 1;
			}
			if (other->client->pers.inventory[ITEM_INDEX(FindItem("cells"))]<other->client->pers.max_cells)
			{
				x=1;
				other->client->pers.inventory[ITEM_INDEX(FindItem("cells"))]+= 1;
			}
		}
	}
	
	if (x ==1)
		gi.sound(self, CHAN_ITEM, gi.soundindex("misc/w_pkup.wav"), 1, ATTN_NORM, 0);

	self->nextthink = level.time +0.2;
}

void supplydepot_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	gi.WriteByte (svc_temp_entity);
	if (self->waterlevel)
		gi.WriteByte (TE_ROCKET_EXPLOSION_WATER);
	else
		gi.WriteByte (TE_ROCKET_EXPLOSION);
	gi.WritePosition (self->s.origin);
	gi.multicast (self->s.origin, MULTICAST_PVS);
	make_debris(self);

	self->takedamage = DAMAGE_NO;
	
	
	SP_SupplyDepot (self->owner);
	G_FreeEdict(self);
}

void SP_SupplyDepot(edict_t *self)
{
		// cells for laser ?
	if (self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] < 10)
	{
 		gi.cprintf(self, PRINT_HIGH, "Need 10 cells for a Supply Depot.\n");
		return;
	}
	if (self->client->pers.inventory[ITEM_INDEX(FindItem("Bullets"))] < 10)
	{
 		gi.cprintf(self, PRINT_HIGH, "Need 10 bullets for a Supply Depot.\n");
		return;
	}
	if (self->client->pers.inventory[ITEM_INDEX(FindItem("Shells"))] < 10)
	{
 		gi.cprintf(self, PRINT_HIGH, "Need 10 shells for a Supply Depot.\n");
		return;
	}
	if (self->client->pers.inventory[ITEM_INDEX(FindItem("Rockets"))] < 10)
	{
 		gi.cprintf(self, PRINT_HIGH, "Need 10 rockets for a Supply Depot.\n");
		return;
	}
	if (self->client->pers.inventory[ITEM_INDEX(FindItem("Grenades"))] < 10)
	{
 		gi.cprintf(self, PRINT_HIGH, "Need 10 grenades for a Supply Depot.\n");
		return;
	}
	if (self->client->pers.inventory[ITEM_INDEX(FindItem("Slugs"))] < 10)
	{
 		gi.cprintf(self, PRINT_HIGH, "Need 10 slugs for a Supply Depot.\n");
		return;
	}
	if ( newSupplyDepot ) 
	{  
		G_FreeEdict(newSupplyDepot);    
		newSupplyDepot = NULL;
		gi.cprintf(self, PRINT_HIGH, "Supply Depot off.\n"); 
		return; 
	}
	gi.cprintf(self, PRINT_HIGH, "Supply Depot on.\n");
	newSupplyDepot = G_Spawn ();
	VectorCopy(self->s.origin,newSupplyDepot->s.origin);
	newSupplyDepot->s.origin[2] += 40;
	newSupplyDepot->classname="depot";
	newSupplyDepot->takedamage=DAMAGE_AIM;
	newSupplyDepot->movetype= MOVETYPE_TOSS;
	newSupplyDepot->mass = 200;
	newSupplyDepot->solid = SOLID_BBOX;
	newSupplyDepot->clipmask=MASK_ALL;
	newSupplyDepot->deadflag =DEAD_NO;
	newSupplyDepot->clipmask = MASK_SHOT;
	newSupplyDepot->model = self->model;
	newSupplyDepot->s.modelindex = gi.modelindex ("models/objects/dmspot/tris.md2");
	newSupplyDepot->s.skinnum = 1;
	newSupplyDepot->solid = SOLID_BBOX;
	newSupplyDepot->noteamdamage = true;	//Don't let teammates damage it

	VectorSet (newSupplyDepot->mins, -32, -32, -24);
	VectorSet (newSupplyDepot->maxs, 32, 32, -16);
	newSupplyDepot->s.frame =0;
	newSupplyDepot->waterlevel = 0;
	newSupplyDepot->watertype=0;
	newSupplyDepot->health= 100;
	newSupplyDepot->max_health =100;
	newSupplyDepot->gib_health = -80;
	newSupplyDepot->die = supplydepot_die;
	newSupplyDepot->owner = self;
	newSupplyDepot->dmg = 100;
	newSupplyDepot->dmg_radius = 100;
//	newSupplyDepot->touch = SupplyTouch;
	newSupplyDepot->think =SupplyThink;
	newSupplyDepot->nextthink = level.time +1;
	VectorClear (newSupplyDepot->velocity);
	gi.linkentity (newSupplyDepot);

	self->client->pers.inventory[ITEM_INDEX(FindItem("bullets"))]-= 10;
			
	self->client->pers.inventory[ITEM_INDEX(FindItem("shells"))]-= 10;
			
	self->client->pers.inventory[ITEM_INDEX(FindItem("grenades"))]-= 10;
	
	self->client->pers.inventory[ITEM_INDEX(FindItem("rockets"))]-= 10;
		
	self->client->pers.inventory[ITEM_INDEX(FindItem("slugs"))]-= 10;
			
	self->client->pers.inventory[ITEM_INDEX(FindItem("cells"))]-= 10;
			
	gi.centerprintf (self,"Supply Depot set!\nNote: 10 of each ammo has been\ndrained into the Supply Depot to be\nreplicated\n");
}