#include "g_local.h"

void alarm_remove(edict_t *self)
{
	if (self->owner && self->owner->client)
		--self->owner->client->pers.active_special[ITEM_SPECIAL_ALARMS];
	G_FreeEdict (self);
}

void alarm_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	T_RadiusDamage (self, self->owner, 20, NULL, 10,0);
	// BANG !
	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_EXPLOSION1);
	gi.WritePosition(self->s.origin);
	gi.multicast (self->s.origin, MULTICAST_PVS);
	G_FreeEdict (self);
	--self->owner->client->pers.active_special[ITEM_SPECIAL_ALARMS];
}

void alarmthink(edict_t *ent)
{
	edict_t *blip;		

     if (level.time > ent->delay)	//don't exploce on contact
        {
		alarm_remove (ent);
        return;
        }

	 ent->target_ent = NULL;
	blip = NULL;
	while ((blip = findradius (blip, ent->s.origin, 256)) != NULL)
		{
			if (!(blip->svflags & SVF_MONSTER) && !blip->client)
				continue;
			
			if (blip->health <= 0)
				continue;
			if (!visible(ent, blip))
				continue;
			if (blip == ent->owner)
				continue;

			//Don't sound alarm for team mates
			if (blip->wf_team == ent->wf_team)
				continue;

			ent->target_ent = blip;
		}
		if (ent->target_ent != NULL)
			ent->s.sound = gi.soundindex ("world/klaxon2.wav");
		else
			ent->s.sound = 0;
	ent->nextthink = level.time + .2;
}

void place_alarm (int number,edict_t *ent)
{
	
	vec3_t		forward,
				wallp;

	trace_t		tr;

	// valid ent ?
  	if ((!ent->client) || (ent->health<=0))
	   return;

	// cells for laser ?
	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] < 25)
	{
 		gi.cprintf(ent, PRINT_HIGH, "Not enough cells for an Alarm.\n");
		return;
	}

	//Are there too many alarms now?
	if (ent->client->pers.active_special[ITEM_SPECIAL_ALARMS] >= MAX_SPECIAL_ALARMS)
	{
 		gi.cprintf(ent, PRINT_HIGH, "You can only have %d active Alarms.\n",MAX_SPECIAL_ALARMS );
		return;
	}

	// Setup "little look" to close wall
	VectorCopy(ent->s.origin,wallp);         

	// Cast along view angle
	AngleVectors (ent->client->v_angle, forward, NULL, NULL);

	// Setup end point
	wallp[0]=ent->s.origin[0]+forward[0]*50;
	wallp[1]=ent->s.origin[1]+forward[1]*50;
	wallp[2]=ent->s.origin[2]+forward[2]*50;  

	// trace
	tr = gi.trace (ent->s.origin, NULL, NULL, wallp, ent, MASK_SOLID);

	// Line complete ? (ie. no collision)
	if (tr.fraction == 1.0)
	{
	 	gi.cprintf (ent, PRINT_HIGH, "Too far from wall.\n");
		return;
	}

	// Hit sky ?
	if (tr.surface)
		if (tr.surface->flags & SURF_SKY)
			return;
	ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= 25;

	++ent->client->pers.active_special[ITEM_SPECIAL_ALARMS];


	if (number == 1)
	{
		if (ent->alarm1) 
		{  
			alarm_remove (ent->alarm1);
			ent->alarm1 = NULL;
			gi.cprintf(ent, PRINT_HIGH, "Alarm off.\n"); 
			return; 
		}
		gi.cprintf(ent, PRINT_HIGH, "Alarm on.\n");
		ent->alarm1 = G_Spawn();
		VectorClear (ent->alarm1->mins);
		VectorClear (ent->alarm1->maxs);
		VectorCopy (tr.endpos, ent->alarm1->s.origin);
		vectoangles(tr.plane.normal,ent->alarm1 -> s.angles);
		ent->alarm1 -> movetype		= MOVETYPE_NONE;
		ent->alarm1 -> clipmask		= MASK_SHOT;
		//grenade -> solid		= SOLID_NOT;
		ent->alarm1->solid = SOLID_BBOX;
		VectorSet(ent->alarm1->mins, -3, -3, 0);
		VectorSet(ent->alarm1->maxs, 3, 3, 6);
		ent->alarm1->takedamage=DAMAGE_NO;
		ent->alarm1 -> s.modelindex	= gi.modelindex ("models/objects/grenade2/tris.md2");
		ent->alarm1 -> owner		= ent;	
//		ent->alarm1->die = alarm_die;
		ent->alarm1 -> nextthink	= level.time + 0.2;
		ent->alarm1 -> think		= alarmthink;
		ent->alarm1->classname = "Alarm";
		ent->alarm1->health= 10;
		ent->alarm1->max_health =10;
		ent->alarm1->wf_team = ent->wf_team;
		ent->alarm1->delay = level.time + 90.0;
		gi.linkentity (ent->alarm1);
	}
	else if (number == 2)
	{
		if (ent->alarm2) 
		{  
			G_FreeEdict(ent->alarm2);    
			ent->alarm2 = NULL;
			gi.bprintf (PRINT_HIGH, "Alarm 2 off.\n"); 
			return; 
		}
		gi.bprintf (PRINT_HIGH, "Alarm 2 on.\n");
		ent->alarm2 = G_Spawn();
		VectorClear (ent->alarm2->mins);
		VectorClear (ent->alarm2->maxs);
		VectorCopy (tr.endpos, ent->alarm2->s.origin);
		vectoangles(tr.plane.normal,ent->alarm2 -> s.angles);
		ent->alarm2 -> movetype		= MOVETYPE_NONE;
		ent->alarm2 -> clipmask		= MASK_SHOT;
		//grenade -> solid		= SOLID_NOT;
		ent->alarm2->solid = SOLID_BBOX;
		VectorSet(ent->alarm2->mins, -3, -3, 0);
		VectorSet(ent->alarm2->maxs, 3, 3, 6);
		ent->alarm2->takedamage=DAMAGE_NO;
		ent->alarm2 -> s.modelindex	= gi.modelindex ("models/objects/grenade2/tris.md2");
		ent->alarm2 -> owner		= ent;	
		ent->alarm2->die = alarm_die;
		ent->alarm2 -> nextthink	= level.time + 0.1;
		ent->alarm2 -> think		= alarmthink;
		ent->alarm2->health= 10;
		ent->alarm2->max_health =10;
		ent->alarm2->classname = "Alarm";
		ent->alarm2->wf_team = ent->wf_team;
		gi.linkentity (ent->alarm2);
	}
	else if (number == 3)
	{
		if (ent->alarm3) 
		{  
			G_FreeEdict(ent->alarm3);    
			ent->alarm3 = NULL;
			gi.bprintf (PRINT_HIGH, "Alarm 3 off.\n"); 
			return; 
		}
		gi.bprintf (PRINT_HIGH, "Alarm 3 on.\n");
		ent->alarm1 = G_Spawn();
		VectorClear (ent->alarm3->mins);
		VectorClear (ent->alarm3->maxs);
		VectorCopy (tr.endpos, ent->alarm3->s.origin);
		vectoangles(tr.plane.normal,ent->alarm3 -> s.angles);
		ent->alarm3 -> movetype		= MOVETYPE_NONE;
		ent->alarm3 -> clipmask		= MASK_SHOT;
		//grenade -> solid		= SOLID_NOT;
		ent->alarm3->solid = SOLID_BBOX;
		VectorSet(ent->alarm3->mins, -3, -3, 0);
		VectorSet(ent->alarm3->maxs, 3, 3, 6);
		ent->alarm3->takedamage=DAMAGE_NO;
		ent->alarm3->die = alarm_die;
		ent->alarm3 -> s.modelindex	= gi.modelindex ("models/objects/grenade2/tris.md2");
		ent->alarm3 -> owner		= ent;	
		ent->alarm3 -> nextthink	= level.time + 0.1;
		ent->alarm3 -> think		= alarmthink;
		ent->alarm3->health= 10;
		ent->alarm3->max_health =10;
		ent->alarm3->classname = "Alarm";
		ent->alarm3->wf_team = ent->wf_team;
		gi.linkentity (ent->alarm3);
	}
}