#include "g_local.h"
#include "motd.h"
#include "teamplay.h"
#include "CtfMisc.h"
#include "fileio.h"

extern int	weapMask[] = {	W_EXP_TECH,
							W_MEDIC,
							W_SOLDIER,
							W_SPOPS};

// *************************************************************
char *getTeamName (int index)
{
	if (index < WakeMapCfg.numOfTeams)
		return WakeMapCfg.teamNames[index];
}

char *getTeamSkin (int index) 
{
	if (index < WakeMapCfg.numOfTeams)
		return WakeMapCfg.teamSkins[index];
}

int getNumOfTeams(void) 
{
	return WakeMapCfg.numOfTeams;
}

// this function was based on code from Vanilla CTF's early vers
qboolean TeamDamageControl (edict_t *targ, edict_t *attacker)
{
	// has to be two people to be meaningful
	if (!(targ->client) || !(attacker->client))
		return false;
	
	// HACK: this way ppl just joining dont get killed when selecting teams
	if (targ->client->pers.selectTeam == 1)
		return true;

	// targ and attacker are on the same team and not the same person
	if ((targ->client->pers.ctfTeam == attacker->client->pers.ctfTeam) &&
		(targ != attacker))						
		return true;
	else
		return false;
}
