// holds all of the class specific functions

#include "g_local.h"
#include "soldier.h"
#include "teamplay.h"

//drop a prox mine
void Cmd_Proxmine_f (edict_t *ent)
{
	edict_t	*proxMine;

	if (ent->client->pers.proxMineCount <= 0)
		return;

	proxMine = G_Spawn();
	VectorCopy (ent->s.origin, proxMine->s.origin);

	//move it down on the z axis a bit
	proxMine->s.origin[2] -= 20;

	proxMine->movetype = MOVETYPE_NONE;
	proxMine->clipmask = MASK_SHOT;
	proxMine->solid = SOLID_BBOX;
	proxMine->s.effects |= EF_GRENADE;
	VectorClear (proxMine->mins);
	VectorClear (proxMine->maxs);
	proxMine->s.modelindex = gi.modelindex ("models/items/adrenal/tris.md2");
	proxMine->owner = ent;
	proxMine->nextthink = level.time + 0.1;
	proxMine->think = ProximityThink;
	proxMine->delay = level.time + PROX_DELAY;
	proxMine->dmg = PROX_DAMAGE;
	proxMine->dmg_radius = PROX_DAMAGE_RADIUS;
	proxMine->classname = "Proximity Mine";

	gi.linkentity (proxMine);

	ent->client->pers.proxMineCount--;
}


void ProximityThink (edict_t *ent)
{
	edict_t *blip = NULL;

    if (level.time > ent->delay)
	{
		Grenade_Explode(ent);
        return;
    }

    ent->think = ProximityThink;

    while ((blip = findradius(blip, ent->s.origin, 100)) != NULL)
    {
		if (!blip->client)
			continue;
        else if (blip == ent->owner)
            continue;
		else if (blip->client->pers.ctfTeam == ent->owner->client->pers.ctfTeam)
			continue;
        else if (!blip->takedamage)
            continue;
        else if (blip->health <= 0)
			continue;
	    else if (!visible(ent, blip))
			continue;
		else
		{
			ent->think = Grenade_Explode;
            break;
		}
	}

    ent->nextthink = level.time + .1;
}

// a cross between a pipebomb and a detpak.
void Cmd_DetLay_f (edict_t *ent, int delay)
{
	edict_t	*detPipe;

	if (ent->client->pers.detPipeCount <= 0)
		return;

	//if time is greater than max allowed
	if (delay > MAX_PIPE_TIME)
	{
		gi.cprintf (ent, PRINT_HIGH, 
			"Detpipe time is too big!\n");
		return;
	}

	detPipe = G_Spawn();
	VectorCopy (ent->s.origin, detPipe->s.origin);

	//move it down on the z axis a bit
	detPipe->s.origin[2] -= 20;

	detPipe->movetype = MOVETYPE_NONE;
	detPipe->clipmask = MASK_SHOT;
	detPipe->solid = SOLID_BBOX;
	detPipe->s.effects |= EF_GRENADE;
	VectorClear (detPipe->mins);
	VectorClear (detPipe->maxs);
	detPipe->s.modelindex = gi.modelindex ("models/items/adrenal/tris.md2");
	detPipe->owner = ent;
	detPipe->nextthink = level.time + 0.1;
	detPipe->think = DetPipeThink;
	gi.dprintf ("delay: %d\n",delay);
	detPipe->delay = level.time + delay;
	detPipe->dmg = PIPE_DAMAGE;
	detPipe->dmg_radius = PIPE_DAMAGE_RADIUS;
	detPipe->classname = "Det Pipe";

	gi.linkentity (detPipe);

	ent->client->pers.detPipeCount--;
}

void DetPipeThink (edict_t *ent)
{
	if (level.time > ent->delay)
	{
		Grenade_Explode(ent);
        return;
    }

	ent->think = DetPipeThink;
    ent->nextthink = level.time + .1;
}

void Cmd_DetPipe_f (edict_t *ent)
{
	edict_t *blip = NULL;

    while ((blip = findradius(blip, ent->s.origin, 1000)) != NULL)
    {
		if (!strcmp(blip->classname, "Det Pipe") && blip->owner == ent)
        {
	        blip->think = Grenade_Explode;
            blip->nextthink = level.time + .1;

		}
	}
}

void Cmd_Radar_f (edict_t *ent)
{
	int		j;
	edict_t *player;
	char    stats[500];
	vec3_t  v;
	float   len;

    j = sprintf(stats, "            Name Health Range\n=============================\n");

	for (player = g_edicts; player < &g_edicts[globals.num_edicts]; player++)
    {
		if (!player->client)
			continue;
		else if (!player->inuse)
			continue;
		else if (player == ent)
			continue;

		//medic can only see ppl on his team
		if ((ent->client->pers.ctfTeam != player->client->pers.ctfTeam) &&
			(ent->client->pers.ctfClass == C_MEDIC))
			continue;
		//special ops can only see ppl on other team
		else if ((ent->client->pers.ctfTeam == player->client->pers.ctfTeam) &&
			(ent->client->pers.ctfClass == C_SPOPS))
			continue;
	

        VectorSubtract (ent->s.origin, player->s.origin, v);

        len = VectorLength (v);

        j += sprintf(stats + j, "%16s %6d %5.0f\n", player->client->pers.netname, player->health, len);

		if (j > 450)
		{
			gi.cprintf(ent, PRINT_HIGH, "%s", stats);
			j = sprintf(stats, "            Name Health Range\n=============================\n");
		}

    }

    gi.centerprintf(ent, "%s", stats);
}

void Cmd_IntAlertLay_f (edict_t *ent)
{
	edict_t	*intAlert;

	if (ent->client->pers.intAlertCount <= 0)
		return;

	intAlert = G_Spawn();
	VectorCopy (ent->s.origin, intAlert->s.origin);
	
	//move it down on the z axis a bit
	intAlert->s.origin[2] -= 20;

	intAlert->movetype = MOVETYPE_NONE;
	intAlert->clipmask = MASK_SHOT;
	intAlert->solid = SOLID_BBOX;
	intAlert->s.effects |= EF_GRENADE;
	VectorClear (intAlert->mins);
	VectorClear (intAlert->maxs);
	intAlert->s.modelindex = gi.modelindex ("models/items/adrenal/tris.md2");
	intAlert->owner = ent;
	intAlert->nextthink = level.time + 0.1;
	intAlert->think = IntAlertThink;
	intAlert->delay = level.time + INTALERT_DELAY;
	intAlert->classname = "Intruder Alert";

	gi.linkentity (intAlert);

	ent->client->pers.intAlertCount--;
}

void IntAlertThink (edict_t *ent)
{
	edict_t *blip = NULL;

    if (level.time > ent->delay)
	{
		Grenade_Explode(ent);
        return;
    }

    ent->think = IntAlertThink;
	ent->nextthink = level.time + .2;

    while ((blip = findradius(blip, ent->s.origin, INTALERT_RANGE)) != NULL)
    {
		if (!blip->client)
			continue;
		else if (blip->client->pers.ctfTeam == ent->owner->client->pers.ctfTeam)
			continue;
        else if (!blip->takedamage)
            continue;
        else if (blip->health <= 0)
			continue;
		else
		{
			gi.centerprintf (ent->owner, "INTRUDER ALERT!!!\n%s\n",blip->client->pers.netname);
			//kick the delay up a second to avoid an assult of messages
			ent->nextthink = level.time + 1;
            break;
		}
	}
    
}
