#include "g_local.h"
#include "CtfMisc.h"	
#include "motd.h"
#include "fileio.h"
#include "teamplay.h"

char joinMsg[1024];


char *classes[] = {	"Explosive Specialist",
					"Medic",
					"Soldier",		
					"Special Op"};

void ShowJoinTeamMessage(edict_t *ent)
{
	float modTime = (int)level.time % 5;

	// english translation:
	// every 5 seconds send a JoinTeamMessage
	// this wont post when u first enter... 
	// which is fine cause the MOTD will go there
	if ((modTime<1) && (ent->client->pers.lastTimeCheck==0)) 
	{
		if (ent->client->pers.selectTeam == 1)
			PostJoinTeamMessage(ent);
		else if (ent->client->pers.selectTeam ==2)
			PostClassMessage(ent);

		ent->client->pers.lastTimeCheck = 1;
	}
	else if ((modTime>1) && (ent->client->pers.lastTimeCheck==1))
		ent->client->pers.lastTimeCheck = 0;	
}

void PostClassMessage (edict_t *ent)
{
	sprintf (joinMsg, "Pick Your Class:\n");
	strcat (joinMsg, "[1] Explosive Specialist\n");
	strcat (joinMsg, "[2] Medic\n");
	strcat (joinMsg, "[3] Soldier\n");
	strcat (joinMsg, "[4] Special Op\n");
	gi.centerprintf(ent, joinMsg);
}
void PostJoinTeamMessage (edict_t *ent)
{
	gi.centerprintf(ent, joinMsg);
}

//call this to redo the msg in joinMsg...
// like when the client changes the team listing page
void UpdateJoinTeamMessage(edict_t *ent)
{
	int		x;
	int		maxTeams,numToDisp;
	char	temp[80];

	maxTeams = getNumOfTeams();

	if (maxTeams <= 9)
		numToDisp = maxTeams;
	else
	{
		if(9 * (ent->client->teamPage + 1) <= maxTeams)
			numToDisp = 9;
		if(9 * (ent->client->teamPage + 1) > maxTeams)
			numToDisp = maxTeams % 9;
	}

	sprintf(joinMsg, "Pick team to join:\n");

	for (x=0; x<numToDisp; x++)
	{
		sprintf(temp, "[%d] %s\n",x+1,getTeamName(x+(ent->client->teamPage*9)));
		strcat(joinMsg,temp);
	}

	// dont need to show a next page or return to begining
	if (maxTeams <= 9)
		return;

	//if there are more than one page of teams,and we're not at the end
	if (9 * (ent->client->teamPage + 1) <= maxTeams)
	{
		sprintf(temp, "[0] Next Page\n");
		strcat (joinMsg, temp);
	}
	//if there are more than one page of teams, but we're at the end
	else
	{
		sprintf(temp, "[0] Begining of List\n");
		strcat (joinMsg, temp);
	}
}


void SelectTeam(edict_t *ent) 
{
	FILE	*motd_file;
	char	motd[500];
	char	line[80];
		
	// set the flag saying that they're picking a team
	ent->client->pers.selectTeam = 1;
	// set godmode while picking a team
	ent->flags &= FL_GODMODE;

	//bind the keys to select the teams
	bindJoinKeys(ent);
	
	//reset the time check interval
	ent->client->pers.lastTimeCheck = 1;

	//put the page list to page 0
	ent->client->teamPage = 0;

	// make sure to clear the flag var
	ent->client->flag = NULL;

	//show the Message Of The Day 
	// (nabbed from www.planetquake.com/qdevels)

	// STEVE changed this bit : read the motd from a file
	if (motd_file = fopen(".\\wake\\motd.txt", "r"))	{
		// we successfully opened the file "motd.txt"
		if ( fgets(motd, 500, motd_file) )		
		{
			// we successfully read a line from "motd.txt" into motd
			// ... read the remaining lines now	
			while ( fgets(line, 80, motd_file) )
			{				
				// add each new line to motd, to create a BIG message string.
				// we are using strcat: STRing conCATenation function here.
				strcat(motd, line);
			}
			// print our message.
			gi.centerprintf (ent, motd);		
		}		// be good now ! ... close the file
		fclose(motd_file);	
	} 

	UpdateJoinTeamMessage(ent);
}		

void bindJoinKeys (edict_t *ent)
{
	int		x;
	int		maxTeams;
	int		numToDisp;
	char	line[80];

	maxTeams = getNumOfTeams();

	//bind the keys to choose teams
	//watch the team count... if over 9 we need multiple pages of team joins
	if (maxTeams <= 9)
		numToDisp = maxTeams;
	else
	{
		if(9 * (ent->client->teamPage + 1) <= maxTeams)
			numToDisp = 9;
		if(9 * (ent->client->teamPage + 1) > maxTeams)
			numToDisp = maxTeams % 9;
	}

	for(x=1; x<=numToDisp; x++)
	{
		sprintf(line,"bind %d cmd \"JoinTeam %d\"\n", x, x-1);
		stuffCommand (ent, line);
	}
	
	stuffCommand (ent, "bind 0 cmd NextPage");
}
void resetKeys(edict_t *ent)
{
	// reset the keys that were used to select teams
	stuffCommand (ent, "bind 1 \"use Blaster\"\n");
	stuffCommand (ent, "bind 2 \"use Shotgun\"\n");
	stuffCommand (ent, "bind 3 \"use Super Shotgun\"\n");
	stuffCommand (ent, "bind 4 \"use Machinegun\"\n");
	stuffCommand (ent, "bind 5 \"use Chaingun\"\n");
	stuffCommand (ent, "bind 6 \"use Grenade Launcher\"\n");
	stuffCommand (ent, "bind 7 \"use Rocket Launcher\"\n");
	stuffCommand (ent, "bind 8 \"use HyperBlaster\"\n");
	stuffCommand (ent, "bind 9 \"use Railgun\"\n");
	stuffCommand (ent, "bind 0 \"use BFG10K\"\n");
}

void ClientSelectedTeam(edict_t *ent, int team)
{
	int		selTeam;
	edict_t	*from;
	int		count=0;
	char	skincmd[MAX_INFO_VALUE + 7] = "skin ";
	
	// dont let clients already playing to switch
	if (ent->client->pers.selectTeam != 1)
		return;

	//check the max clients for the map
	for (from = g_edicts; from < &g_edicts[globals.num_edicts]; from++)
	{
		if (!from->inuse)
			continue;
		if (!from->client)
			continue;
		if (from->client->pers.ctfTeam == team)
			count++ ;
	}
	if (count+1 > WakeMapCfg.teamLimit[team])
	{
		gi.cprintf(ent,PRINT_MEDIUM,
			"%s's team has reached max limit for clients.\nJoin another.\n", getTeamName(team));
		return;
	}

	//the actual team number joined
	selTeam = team + 9* ent->client->teamPage;

	// protect ourselves from bad pointers
	if (selTeam >= getNumOfTeams())
		return;

	// display the join msg & set skin
	gi.cprintf (ent, PRINT_HIGH, "You joined %s's team!\n", getTeamName(selTeam));

	if (MapCfgRead)
	{
		Info_SetValueForKey (ent->client->pers.userinfo, "skin", getTeamSkin(selTeam));
		strcat(skincmd, getTeamSkin(selTeam));
		strcat(skincmd, "\n");
		stuffCommand(ent, skincmd);
	}

	// switch the binds back to normal
	resetKeys (ent);

	//bind keys again for team selection
	stuffCommand (ent, "bind 1 cmd SwitchClass 0\n");
	stuffCommand (ent, "bind 2 cmd SwitchClass 1\n");
	stuffCommand (ent, "bind 3 cmd SwitchClass 2\n");
	stuffCommand (ent, "bind 4 cmd SwitchClass 3\n");

	//put client in class selection mode
	ent->client->pers.selectTeam = 2;
	// set the clients team flag
	ent->client->pers.ctfTeam = selTeam;

}
	
void ClientSelectedClass (edict_t *ent, int classType)	
{	
	//for right now, only let ppl joining server
	//to switch classes
	if (ent->client->pers.selectTeam != 2)
		return;
	else
		ent->client->pers.selectTeam = 0;

	//switch binds back to normal
	resetKeys (ent);

	//keep the class selection
	ent->client->pers.ctfClass = classType;
	gi.cprintf (ent, PRINT_HIGH, "You became a %s\n", classes[ent->client->pers.ctfClass]);

	// reset flags set in SelectTeam() on the client
	ent->client->pers.selectTeam = 0;
	ent->flags &= ~FL_GODMODE;

	PutClientInServer (ent,"info_player_team");
}	


