#include "g_local.h"
#include "flag.h"
#include "teamplay.h"

// returns the flag to base
void flag_return(edict_t *self) 
{
	gi.unlinkentity(self);
	VectorCopy(self->flagorigin, self->s.origin);
	self->solid = SOLID_TRIGGER;
	self->movetype = MOVETYPE_TOSS;
	gi.linkentity(self);
	self->flagstat = FLAG_ABOUT;
	self->owner = NULL;
}

// tosses the flag from a player carrying it
void flag_toss(edict_t *self) 
{
	edict_t *from;

		//play sounds
	for (from = g_edicts; from < &g_edicts[globals.num_edicts]; from++)
	{
		if (!from->inuse)
			continue;
		if (!from->client)
			continue;
		if (from->client->pers.ctfTeam == self->owner->client->pers.ctfTeam)
		{
			if (from == self->owner)
				gi.sound (from, CHAN_VOICE, gi.soundindex("wake/Youlost.wav"), 1, ATTN_NORM, 0);
			else
				gi.sound (from, CHAN_VOICE, gi.soundindex("wake/Yourlost.wav"), 1, ATTN_NORM, 0);
		}
		else if (from->client->pers.ctfTeam != self->owner->client->pers.ctfTeam)
			gi.sound (from, CHAN_VOICE, gi.soundindex("wake/Othrlost.wav"), 1, ATTN_NORM, 0);
	}


	if (self->owner->client)
		self->owner->client->pers.inventory[ITEM_INDEX(self->item)]--;
	self->think = flag_return;
	self->nextthink = level.time + 120;
	gi.unlinkentity(self);
	self->solid = SOLID_TRIGGER;
	self->movetype = MOVETYPE_TOSS;
	gi.linkentity(self);
	self->flagstat = FLAG_ABOUT;
	self->owner = NULL;
}

// .think to make the flag follow flag->owner around
void flag_follow(edict_t *self) {
	// catch errors
	if (!self->owner) {
		flag_toss(self);
		return;
	}
	gi.unlinkentity(self);
	VectorCopy(self->owner->s.origin, self->s.origin);
	VectorCopy(self->owner->velocity, self->velocity);
	
	//make the flag sit a little higher
	self->s.origin[2] += 20;

	gi.linkentity(self);
	self->nextthink = level.time + 0.1;
}


// a live client has touched the flag
qboolean flag_pickup(edict_t *self, edict_t *other) 
{
	edict_t		*from;

	// if somebody is already carrying the flag, just ignore this
	// note: no longer really needed as flag is SOLID_NOT when carried
	if (self->flagstat == FLAG_CARRIED) return (false);

	// someone picked up the flag
	other->client->pers.inventory[ITEM_INDEX(self->item)]++;
	gi.sound (self, CHAN_ITEM, gi.soundindex ("world/klaxon2.wav"), 1, ATTN_NONE, 0);
	gi.bprintf(PRINT_MEDIUM, "%s got the flag!\n", other->client->pers.netname);
	self->owner = other;
	gi.unlinkentity(self);
	self->solid = SOLID_NOT;
	self->movetype = MOVETYPE_NOCLIP;
	gi.linkentity(self);
	self->flagstat = FLAG_CARRIED;
	self->think = flag_follow;
	self->nextthink = level.time + 0.1;

	gi.unlinkentity(other);
	other->client->flag = self;
	other->s.effects &= EF_COLOR_SHELL;
	other->s.renderfx &= RF_SHELL_GREEN;
	gi.linkentity(other);

	//play sounds
	for (from = g_edicts; from < &g_edicts[globals.num_edicts]; from++)
	{
		if (!from->inuse)
			continue;
		if (!from->client)
			continue;
		if (from->client->pers.ctfTeam == other->client->pers.ctfTeam)
		{
			if (from == other)
				gi.sound (from, CHAN_VOICE, gi.soundindex("wake/Youhave.wav"), 1, ATTN_NORM, 0);
			else
				gi.sound (from, CHAN_VOICE, gi.soundindex("wake/yourteam.wav"), 1, ATTN_NORM, 0);
		}
		else if (from->client->pers.ctfTeam != other->client->pers.ctfTeam)
			gi.sound (from, CHAN_VOICE, gi.soundindex("wake/Othrteam.wav"), 1, ATTN_NORM, 0);
	}

	return (true);		// we picked it up	
}

void flag_touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf) 
{

	if (!other->client)
		return;
	if (other->health < 1)
		return;		// dead people can't pickup
	if (!ent->item->pickup(ent, other))
		return;		// player can't hold it


	// flash the screen
	other->client->bonus_alpha = 0.25;	

	// show icon and name on status bar
	other->client->ps.stats[STAT_PICKUP_ICON] = gi.imageindex(ent->item->icon);
	other->client->ps.stats[STAT_PICKUP_STRING] = CS_ITEMS+ITEM_INDEX(ent->item);
	other->client->pickup_msg_time = level.time + 3.0;

}

// links the flag into the world	
void flag_place (edict_t *flag) 
{
	trace_t		tr;
	vec3_t		dest;
	float		*v;

	VectorSet(flag->mins, -16, -16, -32);
	VectorSet(flag->maxs,  16,  16,  16);

	gi.setmodel (flag, flag->item->world_model);
	flag->solid = SOLID_TRIGGER;
	flag->movetype = MOVETYPE_TOSS;  
	flag->touch = flag_touch;

	v = tv(0,0,-128);
	VectorAdd (flag->s.origin, v, dest);

	tr = gi.trace (flag->s.origin, flag->mins, flag->maxs, dest, flag, MASK_SOLID);

	VectorCopy (tr.endpos, flag->s.origin);
	VectorCopy (flag->s.origin, flag->flagorigin);

	gi.linkentity (flag);
}

void flag_spawn (edict_t *flag, int color) 
{
	gitem_t *item;
	item = FindItem("Flag");//("Blue Flag");
	flag->flagstat = FLAG_ABOUT;

	PrecacheItem (item);
	flag->item = item;
	flag->nextthink = level.time + 2 * FRAMETIME;    // items start after other solids
	flag->think = flag_place;
	flag->s.effects = item->world_model_flags;
	flag->s.renderfx = color;
	flag->takedamage = DAMAGE_NO;
	flag->noblock = true;		// haha, can't block anything!
}

void SP_ctf_flag (edict_t *ent) 
{
	flag_spawn(ent, RF_SHELL_GREEN);
}

// prints the status of the flags
void Cmd_FlagStat_f (edict_t *ent) 
{
	edict_t	*from;
	char	*state, *carrier;

	from = G_Find(NULL, FOFS(classname), "ctf_flag"); //classname[i]);
	carrier = "";
	if (!from) 
	{
		state = "missing (MOD IS SCREWED)";
	} else 
	{
		switch (from->flagstat) 
		{
			case FLAG_CARRIED:
				state = "carried by";
				if (from->owner && from->owner->client) 
				{
					if (ent == from->owner)
					{
						carrier = " you";
					}
					else
					{
						carrier = " ";
						strcat(carrier,
							from->owner->client->pers.netname);
				}	}
				break;
			case FLAG_ABOUT:
				state = "lying about";
				break;
		}
	}

	gi.cprintf(ent, PRINT_HIGH, "The flag is %s%s!\n", state, carrier);
}
