#include "g_local.h"
#include "fileio.h"

#define MKEY_MAX_CLIENT 1
#define MKEY_TEAM_NAMES 2
#define MKEY_TEAM_SKINS 3
#define MKEY_WAKE_VER 4
#define MKEY_NEXT_MAP 5

#define UNKNOWN_KEY 0

WakeMapCfg_t	WakeMapCfg;
int				MapCfgRead = 0;

// for logging enities (map converting)
char		logTypes[4][30]= {	"info_player_team",
								"ctf_flag",
								"misc_teleporter",
								"misc_teleporter_dest"
							};

void ReadWakeMapCfgFile(char *path) 
{
	FILE	*file;
	char	line[80];
	int		key = 0;
	int		count;	//reset each time a new key is found... used in storing to structs	

	//set defaults so we can check to see if mod key was present in cfg
	//and enforce some error protection
	WakeMapCfg.numOfTeams = 0;
	WakeMapCfg.teamNames[0] = NULL;
	WakeMapCfg.teamSkins[0] = NULL;
	WakeMapCfg.wakeVerRequired = 0;
	WakeMapCfg.teamLimit[0] = 0;
	WakeMapCfg.nextMap[0] = NULL;

	if (file = fopen(path, "r"))	
	{
		gi.dprintf ("opened file successfully\n");
		// we successfully opened the file "motd.txt"
			// ... read the remaining lines now	
			while ( fgets(line, 80, file) )
			{				
				// add each new line to motd, to create a BIG message string.
				// we are using strcat: STRing conCATenation function here.

				// we're effectivly not parsing comments
				if (line[0] == ';')
					continue;
				else if (line [0] == '[')
				{
					count = 0;
					// parse the file into key sections
					if (Q_stricmp(line, "[Max Client]\n")==0)
					{
						key = MKEY_MAX_CLIENT;
						continue;
					}
					else if (Q_stricmp(line, "[Team Names]\n")==0)
					{
						key = MKEY_TEAM_NAMES;
						continue;
					}
					else if (Q_stricmp(line, "[Team Skins]\n")==0)
					{
						key = MKEY_TEAM_SKINS;
						continue;
					}
					else if (Q_stricmp(line, "[Wake Ver]\n")==0)
					{
						key = MKEY_WAKE_VER;
						continue;
					}
					else if (Q_stricmp(line, "[Next Map]\n")==0)
					{
						key = MKEY_NEXT_MAP;
						continue;
					}
					else
					{
						gi.dprintf ("UNKNOWN KEY IN MAP.CFG: %s!!!!!!\n",line);
						key = UNKNOWN_KEY;
						continue;
					}
				}
				else	//load the data for each key into structures
					switch (key)
					{
						case MKEY_MAX_CLIENT:
							if (count < MAX_TEAM)
							{
								WakeMapCfg.teamLimit[count] = atoi(line);
								count++;
							}
							break;

						case MKEY_TEAM_NAMES:
							if (count < MAX_TEAM)
							{
								WakeMapCfg.teamNames[count] = gi.TagMalloc(strlen(line)+1, TAG_GAME);
								strncpy (WakeMapCfg.teamNames[count], line, strlen(line)-1);
								count++;
								WakeMapCfg.numOfTeams++;
							}
							break;

						case MKEY_TEAM_SKINS:
							if (count < MAX_TEAM)
							{
								WakeMapCfg.teamSkins[count] = gi.TagMalloc(strlen(line)+1, TAG_GAME);
								strncpy (WakeMapCfg.teamSkins[count], line, strlen(line)-1);
								count++;
							}
							break;
							
						case MKEY_NEXT_MAP:
							strcpy (WakeMapCfg.nextMap, line);
							//path can be set only once... this avoids over allocating too
							key = UNKNOWN_KEY;
							break;

						case MKEY_WAKE_VER:
							WakeMapCfg.wakeVerRequired = atoi(line);
							//path can be set only once... this avoids over allocating too
							key = UNKNOWN_KEY;
							break;
					}
			}
	MapCfgRead = 1;
	} 
	else
		gi.dprintf ("Couldn't open: %s\n",path);
}

void WriteWakeEnt(int entType, float x, float y, float z, int optParam1, char *optParam2)
{
	FILE	*file;

	//open up the file
	if ((file = fopen(".\\wake\\new.ent", "a")) == NULL)
	{
		gi.dprintf ("Ent file didn't open!");
		return;
	}

	//print out the entity info
	fprintf (file, "{\n\"classname\" \"%s\"\n", logTypes[entType]);
	fprintf (file, "\"origin\" \"%d  %d  %d\"\n",(int)x, (int)y, (int)z);
	fprintf (file, "\"spawnflags\" \"0\"\n");
	if (entType != LOG_FLAG)
		fprintf (file, "\"angle\" \"90\"\n");
	//entity specific
	if (entType == LOG_TEAMSPAWN)
		fprintf (file, "\"ctfSpawnTeam\" \"%d\"\n", optParam1);
	else if (entType==LOG_GOAL)
	{
		fprintf (file, "\"ctfGoalTeam\" \"%d\"\n", optParam1);
		fprintf (file, "\"target\" \"%s\"\n", optParam2);
	}
	else if (entType==LOG_GOALDEST)
		fprintf (file, "\"targetname\" \"%s\"\n", optParam2);

	//everyone has the close bracket
	fprintf (file, "}\n");

	//close out the file ptr
	fclose (file);
}
