#include "g_local.h"
#include "fox.h"
#include "fileio.h"

long gameStartTime;
edict_t		*foxClient;

// RETURNs true when time has exceded the set limit.
int	checkTimeLimit (void)
{
	if (FoxHoundCfg.timeLimit < level.time - gameStartTime)
		return true;
	else 
		return false;
}

// RETURNs true when there are atleast 2 people on the server
int checkMinAmountClients (void)
{
	edict_t *player;
	int count = 0;

	for (player = g_edicts; player < &g_edicts[globals.num_edicts]; player++)
    {
		if (!player->client)
			continue;
		else if (!player->inuse)
			continue;
		count++;
    }

	if (2 <= count)
		return true;
	else 
		return false;
}

// spawns the clients in server
void startNewGame (void)
{
	int count = 0;
	edict_t *player;

	//if its the first game foxClient is NULL
	if (foxClient == NULL)
	{
		//pick first client
		for (player = g_edicts; player < &g_edicts[globals.num_edicts]; player++)
		{
			if (!player->client)
				continue;
			else if (!player->inuse)
				continue;
			//we found our fox
			foxClient = player;
			foxClient->client->pers.fox = 1;
			break;
		}
	}

	//spawn clients
	spawnAllPlayers(NULL);

	//reset the timer
	gameStartTime = level.time;
}

void calculateFoxWin (void)
{
	//give the fox some points!
	foxClient->client->resp.score += FoxHoundCfg.foxWinPts;

	//spawn everyone
	spawnAllPlayers("Fox eludes the Hounds!\n");

	//reset the timer
	gameStartTime = level.time;
}

void calculateFoxLoss (edict_t *foxKiller)
{
	//give the fox some points!
	foxKiller->client->resp.score += FoxHoundCfg.foxKillPts;
	
	//change the fox
	foxClient->client->pers.fox = 0;
	foxClient = foxKiller;
	foxClient->client->pers.fox = 1;

	//spawn everyone
	spawnAllPlayers ("Hounds shot the fox!\n");
	
	//reset the timer
	gameStartTime = level.time;

}


void spawnAllPlayers (char *msg)
{
	edict_t *player;

	//send a win message out to everyone
	for (player = g_edicts; player < &g_edicts[globals.num_edicts]; player++)
    {
		if (!player->client)
			continue;
		else if (!player->inuse)
			continue;
		if (msg != NULL)
			gi.cprintf (player, PRINT_HIGH, msg);

		if (player != foxClient)
			PutClientInServer (player);
    }

	//spawn fox last
	PutClientInServer (foxClient);
}
