#include "g_local.h"
#include "fileio.h"

FoxHoundCfg_t	FoxHoundCfg;

void ReadCfgFile(char *path) 
{
	FILE	*file;
	char	line[80];
	int		key = 0;

	//set defaults so we can check to see if mod key was present in cfg
	//and enforce some error protection
	FoxHoundCfg.timeLimit = 120;
	FoxHoundCfg.foxWeapons = 0;
	FoxHoundCfg.houndWeapons = 0;
	FoxHoundCfg.foxKillPts = 20;
	FoxHoundCfg.foxWinPts = 50;
	
	if (file = fopen(path, "r"))	
	{
		gi.dprintf ("opened file successfully\n");
		// we successfully opened the file "motd.txt"
			// ... read the remaining lines now	
			while ( fgets(line, 80, file) )
			{				
				// add each new line to motd, to create a BIG message string.
				// we are using strcat: STRing conCATenation function here.

				// we're effectivly not parsing comments
				if (line[0] == ';')
					continue;
				else if (line [0] == '[')
				{
					// parse the file into key sections
					if (Q_stricmp(line, "[Time Limit]\n")==0)
					{
						key = KEY_TIME_LIMIT;
						continue;
					}
					else if (Q_stricmp(line, "[Fox Weapons]\n")==0)
					{
						key = KEY_FOX_WEAPS;
						continue;
					}
					else if (Q_stricmp(line, "[Hound Weapons]\n")==0)
					{
						key = KEY_HOUND_WEAPS;
						continue;
					}
					else if (Q_stricmp(line, "[Fox Kill Points]\n")==0)
					{
						key = KEY_FOX_KILL;
						continue;
					}
					else if (Q_stricmp(line, "[Fox Win Points]\n")==0)
					{
						key = KEY_FOX_WIN;
						continue;
					}
					else
					{
						gi.dprintf ("UNKNOWN KEY IN FOXHOUND.CFG: %s!!!!!!\n",line);
						key = UNKNOWN_KEY;
						continue;
					}
				}
				else	//load the data for each key into structures
					switch (key)
					{
						case KEY_TIME_LIMIT:
							FoxHoundCfg.timeLimit = atoi(line);
							break;

						case KEY_FOX_WEAPS:
							FoxHoundCfg.foxWeapons = atoi(line);
							break;

						case KEY_HOUND_WEAPS:
							FoxHoundCfg.houndWeapons = atoi(line);
							break;
							
						case KEY_FOX_KILL:
							FoxHoundCfg.foxKillPts = atoi(line);
							break;

						case KEY_FOX_WIN:
							FoxHoundCfg.foxWinPts = atoi(line);
							break;
					}
			}
	} 
	else
	{
		gi.dprintf ("Couldn't open %s\n",path);
		gi.dprintf ("Assuming defaults.  No config file loaded.\n");
	}
}
