.float 		player_flag;	// misc flags (skins, etc.)

.float          captures;
.float          recoveries;
.float          pickups;

float           CLAN1_RECOVERIES;
float           CLAN2_RECOVERIES;
float           CLAN3_RECOVERIES;
float           CLAN4_RECOVERIES;

float           CLAN1_CAPTURES;
float           CLAN2_CAPTURES;
float           CLAN3_CAPTURES;
float           CLAN4_CAPTURES;

float           CLAN1_DROPFLAGS;
float           CLAN2_DROPFLAGS;
float           CLAN3_DROPFLAGS;
float           CLAN4_DROPFLAGS;

.float          basespawn;         // for begin of war spawning.

.float          ctfmsgtimeout;
.string         ctfmsg;

.float 		flag_since; 		// how long a player has had the flag
.float		last_returned_flag; 	// last time player returned his own flag
.float		last_fragged_carrier; 	// last time player fragged a flag carrier
.float		last_hurt_carrier; 	// last time player hurt the flag carrier
.float          last_hurt_carrier_team; // team of the last hurt flag carrier (for 4teamctf)

.float		regen_time;		// time to next regen
.float		rune_notice_time;	// last time we notified about multi-runes
.float          haste_sound;
.float          regeneration_sound;

float		ITEM_RUNE1_FLAG		= 1;
float		ITEM_RUNE2_FLAG		= 2;
float		ITEM_RUNE3_FLAG		= 4;
float		ITEM_RUNE4_FLAG		= 8;
float		ITEM_RUNE_MASK		= 15;
float		ITEM_ENEMY_FLAG		= 16;
float           PF_GHOST                = 64;

float	IT_SIGIL1				= 268435456;
float	IT_SIGIL2				= 536870912;
float	IT_SIGIL3				= 1073741824;
float	IT_SIGIL4				= 2147483648;

.float		previous_weapon;	// one of the IT_SHOTGUN, etc flags

float last_flag_capture;	// time of last capture
float last_capture_team;	// last team that captured

entity	runespawn;
float	runespawned;

// Teamplay bitfield entries
float TEAM_CAPTURE_FLAG        = 1;     // Play capture the flag
float TEAM_ENABLE_GRAPPLE      = 2;     // Use the grappling hook
float TEAM_ENABLE_RUNES        = 4;     // Use the runes
float TEAM_ENABLE_TOSSRUNE     = 16;    // enabling tossrune
float TEAM_NO_DISCHARGE        = 32;    // guess
float TEAM_4WAYCTF             = 64;    // CTF with up to three teams.
float TEAM_ARENA               = 128;   // clan arena, 8 rounds.
float TEAM_ENABLE_WEAPONPACK_TOSSING = 256;   // tossing weapons and backpacks.

float TEAM_CAPTURE_CAPTURE_BONUS      = 15;     // what you get for capture
float TEAM_CAPTURE_TEAM_BONUS         = 10;     // what your team gets for capture
float TEAM_CAPTURE_RECOVERY_BONUS     =  1;     // what you get for recovery
float TEAM_CAPTURE_FLAG_BONUS         =  0;     // what you get for picking up enemy flag
float TEAM_CAPTURE_FRAG_CARRIER_BONUS =  2;     // what you get for fragging
float TEAM_CAPTURE_FLAG_RETURN_TIME   = 40;     // seconds until auto return

float TEAM_CAPTURE_CARRIER_DANGER_PROTECT_BONUS = 2; // bonus for fraggin someone
                                                     // who has recently hurt your flag carrier
float TEAM_CAPTURE_CARRIER_PROTECT_BONUS        = 1; // bonus for fraggin someone while
                                                     // either you or your target are near your flag carrier
float TEAM_CAPTURE_FLAG_DEFENSE_BONUS           = 1; // bonus for fraggin someone while
                                                     // either you or your target are near your flag
float TEAM_CAPTURE_RETURN_FLAG_ASSIST_BONUS     = 1; // awarded for returning a flag that causes a
                                                     // capture to happen almost immediately
float TEAM_CAPTURE_FRAG_CARRIER_ASSIST_BONUS    = 2; // award for fragging a flag carrier if a
                                                     // capture happens almost immediately

float TEAM_CAPTURE_TARGET_PROTECT_RADIUS        = 400; // the radius around an object being
                                                       // defended where a target will be worth extra frags
float TEAM_CAPTURE_ATTACKER_PROTECT_RADIUS      = 400; // the radius around an object being
                                                       // defended where an attacker will get extra frags when making kills

float TEAM_CAPTURE_CARRIER_DANGER_PROTECT_TIMEOUT = 4;
float TEAM_CAPTURE_CARRIER_FLAG_SINCE_TIMEOUT     = 2;
float TEAM_CAPTURE_FRAG_CARRIER_ASSIST_TIMEOUT    = 6;
float TEAM_CAPTURE_RETURN_FLAG_ASSIST_TIMEOUT     = 4;

float FLAG_AT_BASE = 0;
float FLAG_CARRIED = 1;
float FLAG_DROPPED = 2;
float FLAG_INRETURN = 3;

entity team1_lastspawn;
entity team2_lastspawn;
entity team3_lastspawn;
entity team4_lastspawn;

void (string sound, float notinwar) PQ_OmniSound;
void () BackpackTouch;
void () W_SetCurrentAmmo;
float () W_BestWeapon;
void () bound_other_ammo;
void(float old, float new) Deathmatch_Weapon;

void() Spawn4WAYCTFMaps;

void(entity targ, entity attacker, string what) CTFRankLOGPlayerDMDeath;
void (entity targ, string what) CTFRankLOGPlayerDeath;
void (entity who, string what) CTFRankLOGMsg;

