#include <windows.h>

// NORB - All headers from c files as well as function definitions from the c files
// as well as functions declared here that need to be called from c files
// need to be declared in this extern c header

extern "C"
{
	#include "g_local.h"
	#include "p_menu.h"
	#include "g_qfl.h"
}
#include "menu.h"

//*************************************************************************************************************
//*************************************************************************************************************
// Function: QFLJoinTeam
//*************************************************************************************************************
//*************************************************************************************************************

void QFLJoinTeam( edict_t *ent, int qflteam )
{
	PMenu_Close( ent );

	ent->svflags &= ~SVF_NOCLIENT;

	ent->client->resp.qfl_team = qflteam;

	PutClientInServer( ent );
	// add a teleportation effect
	ent->s.event = EV_PLAYER_TELEPORT;
	// hold in place briefly
	ent->client->ps.pmove.pm_flags = PMF_TIME_TELEPORT;
	ent->client->ps.pmove.pm_time = 14;
 
 	gi.bprintf( PRINT_HIGH, "%s was drafted by team %d.\n",
		          ent->client->pers.netname, qflteam );
}

//*************************************************************************************************************
//*************************************************************************************************************
// Function: QFLJoinTeam1
//*************************************************************************************************************
//*************************************************************************************************************

void QFLJoinTeam1( edict_t *ent, SMenu *p )
{
	QFLJoinTeam( ent, 1 );
}

//*************************************************************************************************************
//*************************************************************************************************************
// Function: QFLJoinTeam2
//*************************************************************************************************************
//*************************************************************************************************************

void QFLJoinTeam2( edict_t *ent, SMenu *p )
{
	QFLJoinTeam( ent, 2 );
}

//*************************************************************************************************************
//*************************************************************************************************************
// Function: QFLChaseCam
//*************************************************************************************************************
//*************************************************************************************************************

void QFLChaseCam( edict_t *ent, SMenu *p )
{
	int     i;
	edict_t *e;

	if ( ent->client->chase_target ) 
	{
		ent->client->chase_target = NULL;
		PMenu_Close( ent );
		return;
	}

	for ( i = 1; i <= maxclients->value; i++ ) 
	{
		e = g_edicts + i;
	
		if ( e->inuse && e->solid != SOLID_NOT ) 
		{
			ent->client->chase_target = e;
			PMenu_Close( ent );
			ent->client->update_chase = true;
			break;
		}
	}
}

//*************************************************************************************************************
//*************************************************************************************************************
// Array: joinmenu
//*************************************************************************************************************
//*************************************************************************************************************

SMenu joinmenu[] = 
{
	{ "*Quake II",			PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Norb's",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Quake Football League",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,					PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,					PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Try out for the Marines",		PMENU_ALIGN_LEFT, NULL, QFLJoinTeam1 },
	{ NULL,					PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Try out for the Stroggs",		PMENU_ALIGN_LEFT, NULL, QFLJoinTeam2 },
	{ NULL,					PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Chase Camera",		PMENU_ALIGN_LEFT, NULL, QFLChaseCam },
	{ NULL,					PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Use [ and ] to move cursor",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "ENTER to select",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "ESC to Exit Menu",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "(TAB to Return)",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ NULL,					PMENU_ALIGN_LEFT, NULL, NULL },
	{ "version",	PMENU_ALIGN_RIGHT, NULL, NULL },
};

//*************************************************************************************************************
//*************************************************************************************************************
// Function: QFLUpdateJoinMenu
//*************************************************************************************************************
//*************************************************************************************************************

int QFLUpdateJoinMenu( edict_t *ent )
{
	static char levelname[32];
	static char team1players[32];
	static char team2players[32];
	int num1, num2, i;

	joinmenu[5].text = "Try out for the Marines";
	joinmenu[5].SelectFunc = QFLJoinTeam1;
	joinmenu[7].text = "Try out for the Stroggs";
	joinmenu[7].SelectFunc = QFLJoinTeam2;

	if ( ent->client->chase_target )
		joinmenu[9].text = "Leave Chase Camera";
	else
		joinmenu[9].text = "Chase Camera";

	levelname[0] = '*';

	if ( g_edicts[0].message )
		strncpy( levelname+1, g_edicts[0].message, sizeof(levelname) - 2 );
	else
		strncpy( levelname+1, level.mapname, sizeof(levelname) - 2 );

	levelname[sizeof(levelname) - 1] = 0;

	num1 = num2 = 0;
	for (i = 0; i < maxclients->value; i++) 
	{
		if (!g_edicts[i+1].inuse)
			continue;
		if (game.clients[i].resp.qfl_team == 1)
			num1++;
		else if (game.clients[i].resp.qfl_team == 2)
			num2++;
	}

	wsprintf(team1players, "  (%d players)", num1);
	wsprintf(team2players, "  (%d players)", num2);

	joinmenu[3].text = levelname;
	if (joinmenu[5].text)
		joinmenu[6].text = team1players;
	else
		joinmenu[6].text = NULL;
	if (joinmenu[7].text)
		joinmenu[8].text = team2players;
	else
		joinmenu[8].text = NULL;
	
	if (num1 > num2)
		return 1;
	else if (num2 > num1)
		return 1;

	return (rand() & 1) ? 1 : 2;
}

//*************************************************************************************************************
//*************************************************************************************************************
// Function: QFLOpenJoinMenu
//*************************************************************************************************************
//*************************************************************************************************************

void QFLOpenJoinMenu( edict_t *ent )
{
	int team;

	team = QFLUpdateJoinMenu( ent );

	if (ent->client->chase_target)
		team = 9;
	else if ( team == 1 )
		team = 5;
	else
		team = 7;

	PMenu_Open( ent, joinmenu, team, sizeof( joinmenu ) / sizeof SMenu );
}

//*************************************************************************************************************
//*************************************************************************************************************
// Function: QFLStartClient
//*************************************************************************************************************
//*************************************************************************************************************

qboolean QFLStartClient( edict_t *ent )
{
	if ( ent->client->resp.qfl_team )
		return false;

	// start as 'observer'
	ent->solid                  = SOLID_NOT;
	ent->svflags               |= SVF_NOCLIENT;
	ent->movetype               = MOVETYPE_NOCLIP;
	ent->client->ps.gunindex    = 0;
	ent->client->resp.qfl_team  = 0;

	gi.linkentity  ( ent );
	QFLOpenJoinMenu( ent );

	return true;
}

//*************************************************************************************************************
//*************************************************************************************************************
//*************************************************************************************************************
//*************************************************************************************************************

