/* ini.h - header file for INI file reading library
 *
 *  ini_initialise    - initialise INI file reading library
 *  ini_list_sections - list sections of given INI file
 *  ini_list_keys     - list keys under given section of given INI file
 *  ini_free_array    - free an array of names
 *  ini_key_value     - return the value of the specified key
 *  ini_closedown     - shut down library
 *
 *  ll_add     - add a record to the end of a linked list
 *  ll_insert  - add a record to the start of a linked list
 *  ll_delete  - remove a record from a linked list
 *  ll_destroy - remove every record from a linked list
 *
 * 16 december 1997	mr. woody
 */

#ifndef __O_INI_H
#define __O_INI_H

#include "o_shared.h"

#define INI_MAXLEN_LINE		1024	/* maximum INI file line length */

#define INI_WHITESPACE		" \011"	/* whitespace: spaces and TABs */

typedef enum {			/* error codes */
  INI_ENOERR,			/* no error */
  INI_ENOMEM,			/* memory allocation failed */
  INI_ENOENT,			/* file open failed */
  INI_EFILE,			/* error while reading file */
  INI_EFAULT,			/* null pointer */
  INI_EMAXERR			/* highest allowed error message */
} ini_t;

                               /*** o_ini.c ***/

void   ini_initialise (void);
int    ini_list_sections (char ***, char *);
int    ini_list_keys (char ***, char *, char *);
void   ini_free_array (char **, int);
char * ini_key_value (char *, char *, char *, char *);
void   ini_closedown (void);

                              /*** o_list.c ***/

void * ll_add (void **, long);
void * ll_insert (void **, long);
void   ll_delete (void **, void *, void (* destructor) (void *));
void   ll_destroy (void **, void (* destructor) (void *));

#endif // __O_INI_H

/* end of file */
