/*
 * java QuakeC compiler
 *
 * 12 Sepetember 1998   jet@poboxes.com
 */

import java.io.*;
import java.util.*;

class Tokenizer {
	private BufferedReader reader = null;
	private String data = "";

	public static final int TT_EOF = -1;
	public static final int TT_EOL = '\n';
	public static final int TT_TOK = 0;
	public String sval = null;

	public Tokenizer (BufferedReader r) {
		reader = r;
	}

	public int nextToken() throws IOException {
		char c;
		int len = 0;

		sval = "";	
		if (data.equals ("")) {
			data = reader.readLine ();
			if (data == null) return TT_EOF;	
		}

		if (data.length () == 0) return TT_EOL;

// skip whitespace
skipwhite:
		while (true) {
			try {
				while ((c = data.charAt (0)) <= ' ') {
					data = data.substring (1);
					if (data == null) return TT_EOL;
				}
			} catch (Exception e) {
				return TT_EOL;
			}
	
// skip // comments
			if (c == '/' && data.charAt (1) == '/') {
				while (data != null && data.charAt (0) != '\n')
					data = data.substring (1);
				continue skipwhite;
			}
	

// handle quoted strings specially
			if (c == '\"') {
				data = data.substring (1);
				do {
					c = data.charAt (0);
					data = data.substring (1);
					if (c == '\"') return TT_TOK;
					sval += c;
				} while (true);
			}

// parse single characters
			if (c == '{' || c == '}' || 
			    c == ')' || c == '(' || c == '\'' || c == ':') {
				sval += c;
				data = data.substring (1);
				return TT_TOK;
			}

// parse a regular word
			do {
				sval += c;
				try {
					data = data.substring (1);
					c = data.charAt (0);
				} catch (Exception e) {
					break;
				}
				if (c == '{' || c == '}' || 
				    c == ')'|| c == '(' || c == '\'' || c == ':')
					break;
			} while (c > 32);
		
			return TT_TOK;
		}
	}
}	


/* end of file */
