/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.PushbackInputStream;

class Parser {
    private static final int MAX_PARMS = 8;
    private static final int MAX_ERRORS = 10;
    private static final int MAX_NAME = 64;
    private static final int MAX_REGS = 16384;
    private static final int tt_eof = 1;
    private static final int tt_name = 2;
    private static final int tt_punct = 3;
    private static final int tt_immediate = 4;
    private static final int OFS_NULL = 0;
    private static final int OFS_RETURN = 1;
    private static final int OFS_PARM0 = 4;
    private static final int OFS_PARM1 = 7;
    private static final int OFS_PARM2 = 10;
    private static final int OFS_PARM3 = 13;
    private static final int OFS_PARM4 = 16;
    private static final int OFS_PARM5 = 19;
    private static final int OFS_PARM6 = 22;
    private static final int OFS_PARM7 = 25;
    private static final int RESERVED_OFS = 28;
    private static final int MAX_STRINGS = 500000;
    private static final int MAX_GLOBALS = 16384;
    private static final int MAX_STATEMENTS = 65536;
    private static final int MAX_FUNCTIONS = 8192;
    private static final int MAX_SOUNDS = 1024;
    private static final int MAX_MODELS = 1024;
    private static final int MAX_FIELDS = 1024;
    private static final int MAX_FILES = 1024;
    private static final int MAX_DATA_PATH = 64;
    private String sourcedir;
    private String destfile;
    private Object[] pr_globals;
    private int numpr_globals;
    private String[] strings;
    private int strofs;
    private dstatement_t[] statements;
    private int numstatements;
    private int[] statement_linenums;
    private dfunction_t[] functions;
    private int numfunctions;
    private ddef_t[] globals;
    private int numglobaldefs;
    private ddef_t[] fields;
    private int numfielddefs;
    private String[] precache_sounds;
    private int[] precache_sounds_block;
    private int numsounds;
    private String[] precache_models;
    private int[] precache_models_block;
    private int nummodels;
    private String[] precache_files;
    private int[] precache_files_block;
    private int numfiles;
    private static final int ev_void = 0;
    private static final int ev_string = 1;
    private static final int ev_float = 2;
    private static final int ev_vector = 3;
    private static final int ev_entity = 4;
    private static final int ev_field = 5;
    private static final int ev_function = 6;
    private static final int ev_pointer = 7;
    private static final int OP_DONE = 0;
    private static final int OP_MUL_F = 1;
    private static final int OP_MUL_V = 2;
    private static final int OP_MUL_FV = 3;
    private static final int OP_MUL_VF = 4;
    private static final int OP_DIV_F = 5;
    private static final int OP_ADD_F = 6;
    private static final int OP_ADD_V = 7;
    private static final int OP_SUB_F = 8;
    private static final int OP_SUB_V = 9;
    private static final int OP_EQ_F = 10;
    private static final int OP_EQ_V = 11;
    private static final int OP_EQ_S = 12;
    private static final int OP_EQ_E = 13;
    private static final int OP_EQ_FNC = 14;
    private static final int OP_NE_F = 15;
    private static final int OP_NE_V = 16;
    private static final int OP_NE_S = 17;
    private static final int OP_NE_E = 18;
    private static final int OP_NE_FNC = 19;
    private static final int OP_LE = 20;
    private static final int OP_GE = 21;
    private static final int OP_LT = 22;
    private static final int OP_GT = 23;
    private static final int OP_LOAD_F = 24;
    private static final int OP_LOAD_V = 25;
    private static final int OP_LOAD_S = 26;
    private static final int OP_LOAD_ENT = 27;
    private static final int OP_LOAD_FLD = 28;
    private static final int OP_LOAD_FNC = 29;
    private static final int OP_ADDRESS = 30;
    private static final int OP_STORE_F = 31;
    private static final int OP_STORE_V = 32;
    private static final int OP_STORE_S = 33;
    private static final int OP_STORE_ENT = 34;
    private static final int OP_STORE_FLD = 35;
    private static final int OP_STORE_FNC = 36;
    private static final int OP_STOREP_F = 37;
    private static final int OP_STOREP_V = 38;
    private static final int OP_STOREP_S = 39;
    private static final int OP_STOREP_ENT = 40;
    private static final int OP_STOREP_FLD = 41;
    private static final int OP_STOREP_FNC = 42;
    private static final int OP_RETURN = 43;
    private static final int OP_NOT_F = 44;
    private static final int OP_NOT_V = 45;
    private static final int OP_NOT_S = 46;
    private static final int OP_NOT_ENT = 47;
    private static final int OP_NOT_FNC = 48;
    private static final int OP_IF = 49;
    private static final int OP_IFNOT = 50;
    private static final int OP_CALL0 = 51;
    private static final int OP_CALL1 = 52;
    private static final int OP_CALL2 = 53;
    private static final int OP_CALL3 = 54;
    private static final int OP_CALL4 = 55;
    private static final int OP_CALL5 = 56;
    private static final int OP_CALL6 = 57;
    private static final int OP_CALL7 = 58;
    private static final int OP_CALL8 = 59;
    private static final int OP_STATE = 60;
    private static final int OP_GOTO = 61;
    private static final int OP_AND = 62;
    private static final int OP_OR = 63;
    private static final int OP_BITAND = 64;
    private static final int OP_BITOR = 65;
    private static final int DEF_SAVEGLOBAL = 32768;
    private static final int PROG_VERSION = 6;
    private int pr_source_line;
    private PushbackInputStream pr_file_p;
    private String pr_line_start;
    private int pr_bracelevel;
    private String pr_token;
    private int pr_token_type;
    private type_t pr_immediate_type;
    private eval_t pr_immediate;
    private String pr_immediate_string;
    private int pr_error_count;
    private static final String[] pr_punctuation = new String[]{"&&", "||", "<=", ">=", "==", "!=", ";", ",", "!", "*", "/", "(", ")", "-", "+", "=", "[", "]", "{", "}", "...", ".", "<", ">", "#", "&", "|", null};
    private type_t type_void = new type_t();
    private type_t type_string = new type_t();
    private type_t type_float = new type_t();
    private type_t type_vector = new type_t();
    private type_t type_entity = new type_t();
    private type_t type_field = new type_t();
    private type_t type_function = new type_t();
    private type_t type_pointer = new type_t();
    private type_t type_floatfield = new type_t();
    private static final int[] type_size = new int[]{1, 1, 1, 3, 1, 1, 1, 1};
    private final def_t def_void = new def_t();
    private final def_t def_string = new def_t();
    private final def_t def_float = new def_t();
    private final def_t def_vector = new def_t();
    private final def_t def_entity = new def_t();
    private final def_t def_field = new def_t();
    private final def_t def_function = new def_t();
    private final def_t def_pointer = new def_t();
    private def_t def_ret;
    private def_t[] def_parms;
    private final def_t[] def_for_type = new def_t[]{this.def_void, this.def_string, this.def_float, this.def_vector, this.def_entity, this.def_field, this.def_function, this.def_pointer};
    private static final int MAX_FRAMES = 256;
    private String[] pr_framemacros;
    private int pr_nummacros;
    private String[] pr_parm_names;
    private pr_info_t pr;
    private def_t[] pr_global_defs;
    private int pr_edict_size;
    private def_t pr_scope;
    private boolean pr_dumpasm;
    private int s_file;
    private int locals_end;
    private final opcode_t[] pr_opcodes = new opcode_t[]{new opcode_t("<DONE>", "DONE", -1.0f, false, this.def_entity, this.def_field, this.def_void), new opcode_t("*", "MUL_F", 2.0f, false, this.def_float, this.def_float, this.def_float), new opcode_t("*", "MUL_V", 2.0f, false, this.def_vector, this.def_vector, this.def_float), new opcode_t("*", "MUL_FV", 2.0f, false, this.def_float, this.def_vector, this.def_vector), new opcode_t("*", "MUL_VF", 2.0f, false, this.def_vector, this.def_float, this.def_vector), new opcode_t("/", "DIV", 2.0f, false, this.def_float, this.def_float, this.def_float), new opcode_t("+", "ADD_F", 3.0f, false, this.def_float, this.def_float, this.def_float), new opcode_t("+", "ADD_V", 3.0f, false, this.def_vector, this.def_vector, this.def_vector), new opcode_t("-", "SUB_F", 3.0f, false, this.def_float, this.def_float, this.def_float), new opcode_t("-", "SUB_V", 3.0f, false, this.def_vector, this.def_vector, this.def_vector), new opcode_t("==", "EQ_F", 4.0f, false, this.def_float, this.def_float, this.def_float), new opcode_t("==", "EQ_V", 4.0f, false, this.def_vector, this.def_vector, this.def_float), new opcode_t("==", "EQ_S", 4.0f, false, this.def_string, this.def_string, this.def_float), new opcode_t("==", "EQ_E", 4.0f, false, this.def_entity, this.def_entity, this.def_float), new opcode_t("==", "EQ_FNC", 4.0f, false, this.def_function, this.def_function, this.def_float), new opcode_t("!=", "NE_F", 4.0f, false, this.def_float, this.def_float, this.def_float), new opcode_t("!=", "NE_V", 4.0f, false, this.def_vector, this.def_vector, this.def_float), new opcode_t("!=", "NE_S", 4.0f, false, this.def_string, this.def_string, this.def_float), new opcode_t("!=", "NE_E", 4.0f, false, this.def_entity, this.def_entity, this.def_float), new opcode_t("!=", "NE_FNC", 4.0f, false, this.def_function, this.def_function, this.def_float), new opcode_t("<=", "LE", 4.0f, false, this.def_float, this.def_float, this.def_float), new opcode_t(">=", "GE", 4.0f, false, this.def_float, this.def_float, this.def_float), new opcode_t("<", "LT", 4.0f, false, this.def_float, this.def_float, this.def_float), new opcode_t(">", "GT", 4.0f, false, this.def_float, this.def_float, this.def_float), new opcode_t(".", "INDIRECT", 1.0f, false, this.def_entity, this.def_field, this.def_float), new opcode_t(".", "INDIRECT", 1.0f, false, this.def_entity, this.def_field, this.def_vector), new opcode_t(".", "INDIRECT", 1.0f, false, this.def_entity, this.def_field, this.def_string), new opcode_t(".", "INDIRECT", 1.0f, false, this.def_entity, this.def_field, this.def_entity), new opcode_t(".", "INDIRECT", 1.0f, false, this.def_entity, this.def_field, this.def_field), new opcode_t(".", "INDIRECT", 1.0f, false, this.def_entity, this.def_field, this.def_function), new opcode_t(".", "ADDRESS", 1.0f, false, this.def_entity, this.def_field, this.def_pointer), new opcode_t("=", "STORE_F", 5.0f, true, this.def_float, this.def_float, this.def_float), new opcode_t("=", "STORE_V", 5.0f, true, this.def_vector, this.def_vector, this.def_vector), new opcode_t("=", "STORE_S", 5.0f, true, this.def_string, this.def_string, this.def_string), new opcode_t("=", "STORE_ENT", 5.0f, true, this.def_entity, this.def_entity, this.def_entity), new opcode_t("=", "STORE_FLD", 5.0f, true, this.def_field, this.def_field, this.def_field), new opcode_t("=", "STORE_FNC", 5.0f, true, this.def_function, this.def_function, this.def_function), new opcode_t("=", "STOREP_F", 5.0f, true, this.def_pointer, this.def_float, this.def_float), new opcode_t("=", "STOREP_V", 5.0f, true, this.def_pointer, this.def_vector, this.def_vector), new opcode_t("=", "STOREP_S", 5.0f, true, this.def_pointer, this.def_string, this.def_string), new opcode_t("=", "STOREP_ENT", 5.0f, true, this.def_pointer, this.def_entity, this.def_entity), new opcode_t("=", "STOREP_FLD", 5.0f, true, this.def_pointer, this.def_field, this.def_field), new opcode_t("=", "STOREP_FNC", 5.0f, true, this.def_pointer, this.def_function, this.def_function), new opcode_t("<RETURN>", "RETURN", -1.0f, false, this.def_void, this.def_void, this.def_void), new opcode_t("!", "NOT_F", -1.0f, false, this.def_float, this.def_void, this.def_float), new opcode_t("!", "NOT_V", -1.0f, false, this.def_vector, this.def_void, this.def_float), new opcode_t("!", "NOT_S", -1.0f, false, this.def_vector, this.def_void, this.def_float), new opcode_t("!", "NOT_ENT", -1.0f, false, this.def_entity, this.def_void, this.def_float), new opcode_t("!", "NOT_FNC", -1.0f, false, this.def_function, this.def_void, this.def_float), new opcode_t("<IF>", "IF", -1.0f, false, this.def_float, this.def_float, this.def_void), new opcode_t("<IFNOT>", "IFNOT", -1.0f, false, this.def_float, this.def_float, this.def_void), new opcode_t("<CALL0>", "CALL0", -1.0f, false, this.def_function, this.def_void, this.def_void), new opcode_t("<CALL1>", "CALL1", -1.0f, false, this.def_function, this.def_void, this.def_void), new opcode_t("<CALL2>", "CALL2", -1.0f, false, this.def_function, this.def_void, this.def_void), new opcode_t("<CALL3>", "CALL3", -1.0f, false, this.def_function, this.def_void, this.def_void), new opcode_t("<CALL4>", "CALL4", -1.0f, false, this.def_function, this.def_void, this.def_void), new opcode_t("<CALL5>", "CALL5", -1.0f, false, this.def_function, this.def_void, this.def_void), new opcode_t("<CALL6>", "CALL6", -1.0f, false, this.def_function, this.def_void, this.def_void), new opcode_t("<CALL7>", "CALL7", -1.0f, false, this.def_function, this.def_void, this.def_void), new opcode_t("<CALL8>", "CALL8", -1.0f, false, this.def_function, this.def_void, this.def_void), new opcode_t("<STATE>", "STATE", -1.0f, false, this.def_float, this.def_float, this.def_void), new opcode_t("<GOTO>", "GOTO", -1.0f, false, this.def_float, this.def_void, this.def_void), new opcode_t("&&", "AND", 6.0f, false, this.def_float, this.def_float, this.def_float), new opcode_t("||", "OR", 6.0f, false, this.def_float, this.def_float, this.def_float), new opcode_t("&", "BITAND", 2.0f, false, this.def_float, this.def_float, this.def_float), new opcode_t("|", "BITOR", 2.0f, false, this.def_float, this.def_float, this.def_float), null};
    private static final int TOP_PRIORITY = 6;
    private static final int NOT_PRIORITY = 4;
    private def_t junkdef;
    private static final char PATHSEPERATOR = '/';
    private int myargc;
    private String[] myargv;
    private String com_token;
    private int com_eof;
    private BufferedInputStream pr_mark_file_p;
    private String stack;

    public Parser() {
        System.out.println("Parser ()");
        this.pr_globals = new Object[16384];
        this.strings = new String[500000];
        this.statements = new dstatement_t[65536];
        this.statement_linenums = new int[65536];
        this.functions = new dfunction_t[8192];
        this.globals = new ddef_t[16384];
        this.fields = new ddef_t[1024];
        this.precache_sounds = new String[1024];
        this.precache_sounds_block = new int[1024];
        this.precache_models = new String[1024];
        this.precache_models_block = new int[1024];
        this.precache_files = new String[1024];
        this.precache_files_block = new int[1024];
        this.pr_immediate = new eval_t();
        this.def_void.set(this.type_void, "temp");
        this.def_string.set(this.type_string, "temp");
        this.def_float.set(this.type_float, "temp");
        this.def_vector.set(this.type_vector, "temp");
        this.def_entity.set(this.type_entity, "temp");
        this.def_field.set(this.type_field, "temp");
        this.def_function.set(this.type_function, "temp");
        this.def_pointer.set(this.type_pointer, "temp");
        this.type_void.set(0, this.def_void);
        this.type_string.set(1, this.def_string);
        this.type_float.set(2, this.def_float);
        this.type_vector.set(3, this.def_vector);
        this.type_entity.set(4, this.def_entity);
        this.type_field.set(5, this.def_field);
        this.type_function.set(6, this.def_function, null, this.type_void);
        this.type_pointer.set(7, this.def_pointer);
        this.type_floatfield.set(5, this.def_field, null, this.type_float);
        this.def_ret = new def_t();
        this.def_parms = new def_t[8];
        int n = 0;
        while (n < 8) {
            this.def_parms[n] = new def_t();
            ++n;
        }
        this.pr_framemacros = new String[256];
        this.pr_parm_names = new String[8];
        this.pr = new pr_info_t();
        this.pr_global_defs = new def_t[16384];
    }

    int CopyString(String string) {
        System.out.println("CopyString (" + string + ")");
        int n = this.strofs;
        this.strings[this.strofs++] = string;
        return n;
    }

    float G_FLOAT(int n) {
        System.out.println("= G_FLOAT (" + n + ")");
        return ((Float)this.pr_globals[n]).floatValue();
    }

    void G_FLOAT(int n, float f) {
        System.out.println("G_FLOAT (" + n + ") = " + f);
        this.pr_globals[n] = new Float(f);
    }

    int G_FUNCTION(int n) {
        System.out.println("= G_FUNCTION (" + n + ")");
        return (Integer)this.pr_globals[n];
    }

    void G_FUNCTION(int n, int n2) {
        System.out.println("G_FUNCTION (" + n + ") = " + n2);
        this.pr_globals[n] = new Integer(n2);
    }

    int G_INT(int n) {
        System.out.println("= G_INT (" + n + ")");
        return (Integer)this.pr_globals[n];
    }

    void G_INT(int n, int n2) {
        System.out.println("G_INT (" + n + ") = " + n2);
        this.pr_globals[n] = new Integer(n2);
    }

    String G_STRING(int n) {
        System.out.println("= G_STRING (" + n + ")");
        return this.strings[(Integer)this.pr_globals[n]];
    }

    void G_STRING(int n, String string) {
        System.out.println("G_STRING (" + n + ") = " + string);
        int n2 = (Integer)this.pr_globals[n];
        this.strings[n2] = string;
    }

    float[] G_VECTOR(int n) {
        System.out.println("= G_VECTOR (" + n + ")");
        float[] fArray = new float[]{((Float)this.pr_globals[n]).floatValue(), ((Float)this.pr_globals[n + 1]).floatValue(), ((Float)this.pr_globals[n + 2]).floatValue()};
        return fArray;
    }

    void G_VECTOR(int n, float[] fArray) {
        System.out.println("G_VECTOR (" + n + ") = " + fArray[0] + ", " + fArray[1] + ", " + fArray[2]);
        this.pr_globals[n] = new Float(fArray[0]);
        this.pr_globals[n + 1] = new Float(fArray[1]);
        this.pr_globals[n + 2] = new Float(fArray[2]);
    }

    void InitData() {
        System.out.println("InitData ()");
        this.numstatements = 1;
        this.strofs = 1;
        this.numfunctions = 1;
        this.numglobaldefs = 1;
        this.numfielddefs = 1;
        this.def_ret.ofs = 1;
        int n = 0;
        while (n < 8) {
            this.def_parms[n].ofs = 4 + 3 * n;
            ++n;
        }
    }

    void PR_BeginCompilation() {
        System.out.println("PR_BeginCompilation ()");
        this.numpr_globals = 28;
        int n = 0;
        while (n < 28) {
            this.pr_global_defs[n] = this.def_void;
            ++n;
        }
        this.pr.types = this.type_function;
        this.type_function.next = null;
        this.pr_error_count = 0;
    }

    boolean PR_Check(String string) throws IOException, ParseException {
        this.push();
        System.out.println(String.valueOf(this.stack) + "PR_Check (" + string + ") on \"" + this.pr_token + "\"");
        if (!string.equals(this.pr_token)) {
            this.pop();
            return false;
        }
        this.PR_Lex();
        this.pop();
        return true;
    }

    void PR_ClearGrabMacros() {
        System.out.println("PR_ClearGrabMacros ()");
        this.pr_nummacros = 0;
    }

    boolean PR_CompileFile(String string, PushbackInputStream pushbackInputStream, BufferedInputStream bufferedInputStream) throws Exception {
        System.out.println("PR_CompileFile (" + string + ")");
        this.stack = "";
        if (this.pr.memory != null) {
            throw new Exception("PR_CompileFile: Didn't clear");
        }
        this.PR_ClearGrabMacros();
        this.pr_mark_file_p = bufferedInputStream;
        this.pr_file_p = pushbackInputStream;
        this.s_file = this.CopyString(string);
        this.pr_source_line = 0;
        this.PR_NewLine();
        this.PR_Lex();
        while (this.pr_token_type != 1) {
            try {
                this.pr_scope = null;
                this.PR_ParseDefs();
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                if (++this.pr_error_count > 10) {
                    return false;
                }
                this.PR_SkipToSemicolon();
                if (this.pr_token_type != 1) continue;
                return false;
            }
        }
        return this.pr_error_count == 0;
    }

    def_t PR_DefForFieldOfs(int n) throws Exception {
        System.out.println("PR_DefForFieldOfs (" + n + ")");
        def_t def_t2 = this.pr.def_head.next;
        while (def_t2 != null) {
            if (def_t2.type.type == 5 && (Integer)this.pr_globals[def_t2.ofs] == n) {
                return def_t2;
            }
            def_t2 = def_t2.next;
        }
        throw new Exception("PR_DefForFieldOfs: couldn't find " + n);
    }

    void PR_Expect(String string) throws IOException, ParseException {
        this.push();
        System.out.println(String.valueOf(this.stack) + "PR_Expect (" + string + ")");
        if (!string.equals(this.pr_token)) {
            throw new ParseException("expected " + string + ", found " + this.pr_token);
        }
        this.PR_Lex();
        this.pop();
    }

    def_t PR_Expression(int n) throws ParseException, Exception {
        this.push();
        System.out.println(String.valueOf(this.stack) + "PR_Expression (" + n + ")");
        opcode_t opcode_t2 = null;
        if (n == 0) {
            def_t def_t2 = this.PR_Term();
            this.pop();
            return def_t2;
        }
        def_t def_t3 = this.PR_Expression(n - 1);
        System.out.println("at " + n + " priority");
        block0: do {
            def_t def_t4;
            if (n == 1 && this.PR_Check("(")) {
                def_t4 = this.PR_ParseFunctionCall(def_t3);
                this.pop();
                return def_t4;
            }
            int n2 = 0;
            while (this.pr_opcodes[n2] != null) {
                opcode_t2 = this.pr_opcodes[n2];
                if (opcode_t2.priority == (float)n && this.PR_Check(opcode_t2.name)) {
                    if (opcode_t2.right_associative) {
                        int n3 = this.statements[this.numstatements - 1].op - 24;
                        if (n3 >= 0 && n3 < 6) {
                            this.statements[this.numstatements - 1].op = 30;
                            this.def_pointer.type.aux_type = def_t3.type;
                            System.out.println("setting e.type from " + def_t3.type.type + " to " + this.def_pointer.type.type + " (" + n3 + ")");
                            def_t3.type = this.def_pointer.type;
                        }
                        def_t4 = this.PR_Expression(n);
                    } else {
                        def_t4 = this.PR_Expression(n - 1);
                    }
                    int n4 = def_t3.type.type;
                    int n5 = def_t4.type.type;
                    int n6 = opcode_t2.name.charAt(0) == '.' ? (def_t4.type.aux_type != null ? def_t4.type.aux_type.type : -1) : 0;
                    System.out.println("[a = " + n4 + ", b = " + n5 + ", c = " + n6 + "]");
                    System.out.println("[e = " + def_t3.name + ", e2 = " + def_t4.name + "]");
                    opcode_t opcode_t3 = opcode_t2;
                    while (n4 != opcode_t2.type_a.type.type || n5 != opcode_t2.type_b.type.type || n6 != 0 && n6 != opcode_t2.type_c.type.type) {
                        if ((opcode_t2 = this.pr_opcodes[++n2]) != null && opcode_t2.name.equals(opcode_t3.name)) continue;
                        throw new ParseException("type mismatch for " + opcode_t3.name);
                    }
                    if (n4 == 7 && n5 != def_t3.type.aux_type.type) {
                        throw new ParseException("type mismatch for " + opcode_t2.name);
                    }
                    def_t3 = opcode_t2.right_associative ? this.PR_Statement(n2, def_t4, def_t3) : this.PR_Statement(n2, def_t3, def_t4);
                    if (n6 != 0) {
                        System.out.println("setting type from " + def_t3.type.type + " to " + def_t4.type.aux_type.type);
                        def_t3.type = def_t4.type.aux_type;
                    }
                    System.out.println("breakpoint");
                    continue block0;
                }
                ++n2;
            }
        } while (opcode_t2 == null);
        this.pop();
        return def_t3;
    }

    void PR_FindMacro() throws ParseException {
        System.out.println("PR_FindMacro ()");
        int n = 0;
        while (n < this.pr_nummacros) {
            if (this.pr_token.equals(this.pr_framemacros[n])) {
                this.pr_token = String.valueOf(n);
                this.pr_token_type = 4;
                this.pr_immediate_type = this.type_float;
                this.pr_immediate._float = n;
                return;
            }
            ++n;
        }
        throw new ParseException("Unknown frame macro $" + this.pr_token);
    }

    type_t PR_FindType(type_t type_t2) {
        System.out.println("PR_FindType ()");
        type_t type_t3 = this.pr.types;
        while (type_t3 != null) {
            if (type_t3.type == type_t2.type && type_t3.aux_type == type_t2.aux_type && type_t3.num_parms == type_t2.num_parms) {
                int n = 0;
                while (n < type_t2.num_parms) {
                    if (type_t3.parm_types[n] != type_t2.parm_types[n]) break;
                    ++n;
                }
                if (n == type_t2.num_parms) {
                    return type_t3;
                }
            }
            type_t3 = type_t3.next;
        }
        type_t3 = new type_t(type_t2);
        type_t3.next = this.pr.types;
        this.pr.types = type_t3;
        def_t def_t2 = new def_t();
        def_t2.name = "COMPLEX TYPE";
        def_t2.type = type_t3;
        type_t3.def = def_t2;
        return type_t3;
    }

    boolean PR_FinishCompilation() {
        System.out.println("PR_FinishCompilation ()");
        boolean bl = false;
        def_t def_t2 = this.pr.def_head.next;
        while (def_t2 != null) {
            if (def_t2.type.type == 6 && def_t2.scope == null && !def_t2.initialized) {
                System.out.println("function " + def_t2.name + " was not defined");
                bl = true;
            }
            def_t2 = def_t2.next;
        }
        return bl ^ true;
    }

    def_t PR_GetDef(type_t type_t2, String string, def_t def_t2, boolean bl) throws ParseException {
        String string2;
        this.push();
        System.out.println(String.valueOf(this.stack) + "PR_GetDef (type_t, " + string + ", def_t, " + bl + ")");
        def_t def_t3 = null;
        def_t3 = this.pr.def_head.next;
        while (def_t3 != null) {
            if (def_t3.name.equals(string) && (def_t3.scope == null || def_t3.scope == def_t2)) {
                if (type_t2 != null && def_t3.type != type_t2) {
                    throw new ParseException("Type mismatch on redeclaration of " + string);
                }
                System.out.println("old object [name = " + def_t3.name + ", type = " + def_t3.type.type + "]");
                this.pop();
                return def_t3;
            }
            def_t3 = def_t3.next;
        }
        if (!bl) {
            this.pop();
            return null;
        }
        this.pr.def_tail = this.pr.def_tail.next = (def_t3 = new def_t());
        this.pr.def_tail.next = null;
        def_t3.name = string;
        def_t3.type = type_t2;
        def_t3.scope = def_t2;
        def_t3.ofs = this.numpr_globals;
        this.pr_global_defs[this.numpr_globals] = def_t3;
        System.out.println("new object [name = " + string + ", type = " + type_t2.type + "]");
        if (type_t2.type == 3) {
            string2 = String.valueOf(string) + "_x";
            this.PR_GetDef(this.type_float, string2, def_t2, true);
            string2 = String.valueOf(string) + "_y";
            this.PR_GetDef(this.type_float, string2, def_t2, true);
            string2 = String.valueOf(string) + "_z";
            this.PR_GetDef(this.type_float, string2, def_t2, true);
        } else {
            this.numpr_globals += type_size[type_t2.type];
        }
        if (type_t2.type == 5) {
            this.pr_globals[def_t3.ofs] = new Integer(pr_info_t.size_fields);
            if (type_t2.aux_type.type == 3) {
                string2 = String.valueOf(string) + "_x";
                this.PR_GetDef(this.type_floatfield, string2, def_t2, true);
                string2 = String.valueOf(string) + "_y";
                this.PR_GetDef(this.type_floatfield, string2, def_t2, true);
                string2 = String.valueOf(string) + "_z";
                this.PR_GetDef(this.type_floatfield, string2, def_t2, true);
            } else {
                pr_info_t.size_fields += type_size[type_t2.aux_type.type];
            }
        }
        this.pop();
        return def_t3;
    }

    String PR_GlobalString(int n) throws Exception {
        String string;
        System.out.println("PR_GlobalString (" + n + ")");
        Object object = this.pr_globals[n];
        def_t def_t2 = this.pr_global_defs[n];
        if (def_t2 == null) {
            return this.PR_GlobalStringNoContents(n);
        }
        if (def_t2.initialized && def_t2.type.type != 6) {
            String string2 = this.PR_ValueString(def_t2.type.type, this.pr_globals[n]);
            string = n + "(" + string2 + ")";
        } else {
            string = n + "(" + def_t2.name + ")";
        }
        int n2 = string.length();
        while (n2 < 16) {
            string = String.valueOf(string) + " ";
            ++n2;
        }
        string = String.valueOf(string) + " ";
        return string;
    }

    String PR_GlobalStringNoContents(int n) {
        System.out.println("PR_GlobalStringNoContents (" + n + ")");
        Object object = this.pr_globals[n];
        def_t def_t2 = this.pr_global_defs[n];
        String string = def_t2 == null ? n + "(???)" : n + "(" + def_t2.name + ")";
        int n2 = string.length();
        while (n2 < 16) {
            string = String.valueOf(string) + " ";
            ++n2;
        }
        string = String.valueOf(string) + " ";
        return string;
    }

    void PR_Lex() throws IOException, ParseException {
        this.push();
        System.out.println(String.valueOf(this.stack) + "PR_Lex ()");
        this.pr_token = "";
        this.PR_LexWhitespace();
        char c = this.pr_file_p_read();
        this.pr_file_p.unread(c);
        if (c == '\"') {
            this.PR_LexString();
            this.pop();
            return;
        }
        if (c == '\'') {
            this.PR_LexVector();
            this.pop();
            return;
        }
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') {
            this.PR_LexName();
            this.pop();
            return;
        }
        if (c == '$') {
            this.PR_LexGrab();
            this.pop();
            return;
        }
        if (c >= '0' && c <= '9') {
            this.pr_token_type = 4;
            this.pr_immediate_type = this.type_float;
            this.pr_immediate._float = this.PR_LexNumber();
            this.pop();
            return;
        }
        if (c == '-') {
            char c2 = this.pr_file_p_read();
            char c3 = this.pr_file_p_read();
            this.pr_file_p.unread(c3);
            this.pr_file_p.unread(c2);
            if (c3 >= '0' && c3 <= '9') {
                this.pr_token_type = 4;
                this.pr_immediate_type = this.type_float;
                this.pr_immediate._float = this.PR_LexNumber();
                this.pop();
                return;
            }
        }
        this.PR_LexPunctuation();
        this.pop();
    }

    void PR_LexGrab() throws IOException, ParseException {
        System.out.println("PR_LexGrab ()");
        this.pr_file_p.read();
        if (!this.PR_SimpleGetToken()) {
            throw new ParseException("hanging $");
        }
        if (this.pr_token.equals("frame")) {
            this.PR_ParseFrame();
            this.PR_Lex();
        } else if (this.pr_token.equals("cd") || this.pr_token.equals("origin") || this.pr_token.equals("base") || this.pr_token.equals("flags") || this.pr_token.equals("scale") || this.pr_token.equals("skin")) {
            while (this.PR_SimpleGetToken()) {
            }
            this.PR_Lex();
        } else {
            this.PR_FindMacro();
        }
    }

    void PR_LexName() throws IOException {
        this.push();
        System.out.print(String.valueOf(this.stack) + "PR_LexName () = ");
        char c = this.pr_file_p_read();
        this.pr_token = "";
        do {
            this.pr_token = String.valueOf(this.pr_token) + c;
        } while ((c = this.pr_file_p_read()) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9');
        this.pr_file_p.unread(c);
        this.pr_token_type = 2;
        System.out.println("\"" + this.pr_token + "\"");
        this.pop();
    }

    float PR_LexNumber() throws IOException {
        this.push();
        System.out.print(String.valueOf(this.stack) + "PR_LexNumber ()");
        char c = this.pr_file_p_read();
        if (c == '-') {
            this.pr_token = "-";
            c = this.pr_file_p_read();
        } else {
            this.pr_token = "";
        }
        while (c >= '0' && c <= '9' || c == '.') {
            this.pr_token = String.valueOf(this.pr_token) + c;
            c = this.pr_file_p_read();
        }
        this.pr_file_p.unread(c);
        float f = new Float(this.pr_token).floatValue();
        System.out.println(" = " + f);
        this.pop();
        return f;
    }

    void PR_LexPunctuation() throws IOException, ParseException {
        int n;
        String string;
        this.push();
        System.out.println(String.valueOf(this.stack) + "PR_LexPunctuation ()");
        this.pr_token_type = 3;
        int n2 = 0;
        while ((string = pr_punctuation[n2]) != null) {
            n = string.length();
            this.pr_token = "";
            while (n > 0) {
                this.pr_token = String.valueOf(this.pr_token) + this.pr_file_p_read();
                --n;
            }
            if (this.pr_token.equals(string)) {
                if (string.charAt(0) == '{') {
                    ++this.pr_bracelevel;
                } else if (string.charAt(0) == '}') {
                    --this.pr_bracelevel;
                }
                this.pop();
                return;
            }
            n = string.length() - 1;
            while (n >= 0) {
                char c = this.pr_token.charAt(n);
                this.pr_file_p.unread(c);
                --n;
            }
            ++n2;
        }
        n = 0;
        while (n < this.pr_token.length()) {
            System.out.println(n + ": " + this.pr_token.charAt(n) + " = " + this.pr_token.charAt(n));
            ++n;
        }
        throw new ParseException("Unknown punctuation \"" + this.pr_token + "\"");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void PR_LexString() throws IOException, ParseException {
        this.push();
        System.out.println(String.valueOf(this.stack) + "PR_LexString ()");
        this.pr_token = "";
        this.pr_file_p.read();
        while (true) {
            int n;
            try {
                n = this.pr_file_p_read();
            }
            catch (IOException iOException) {
                throw new ParseException("EOF inside quote");
            }
            if (n == 10) {
                throw new ParseException("newline inside quote");
            }
            if (n == 92) {
                try {
                    n = this.pr_file_p_read();
                }
                catch (IOException iOException) {
                    throw new ParseException("EOF inside quote");
                }
                if (n == 110) {
                    n = 10;
                } else {
                    if (n != 34) throw new ParseException("Unknown escape char");
                    n = 34;
                }
            } else if (n == 34) {
                this.pr_token_type = 4;
                this.pr_immediate_type = this.type_string;
                this.pr_immediate_string = this.pr_token;
                this.pop();
                return;
            }
            this.pr_token = String.valueOf(this.pr_token) + (char)n;
        }
    }

    void PR_LexVector() throws IOException, ParseException {
        this.push();
        System.out.println(String.valueOf(this.stack) + "PR_LexVector ()");
        this.pr_file_p.read();
        this.pr_token_type = 4;
        this.pr_immediate_type = this.type_vector;
        int n = 0;
        while (n < 3) {
            this.pr_immediate.vector[n] = this.PR_LexNumber();
            this.PR_LexWhitespace();
            ++n;
        }
        char c = this.pr_file_p_read();
        if (c != '\'') {
            throw new ParseException("Bad vector");
        }
        this.pop();
    }

    void PR_LexWhitespace() throws IOException {
        block6: {
            int n;
            block5: {
                this.push();
                System.out.println(String.valueOf(this.stack) + "PR_LexWhitespace ()");
                while (true) {
                    int n2;
                    if ((n = this.pr_file_p_read()) <= 32) {
                        if (n != 10) continue;
                        this.pr_file_p.unread(n);
                        this.PR_NewLine();
                        this.pr_file_p.read();
                        continue;
                    }
                    if (n != 47) break block5;
                    n = this.pr_file_p_read();
                    if (n == 47) {
                        while ((n = this.pr_file_p_read()) != 10) {
                        }
                        this.pr_file_p.unread(n);
                        this.PR_NewLine();
                        this.pr_file_p.read();
                        continue;
                    }
                    if (n != 42) break;
                    n = 32;
                    do {
                        n2 = n;
                        n = this.pr_file_p_read();
                        if (n != 10) continue;
                        this.pr_file_p.unread(n);
                        this.PR_NewLine();
                        this.pr_file_p.read();
                    } while (n2 != 42 || n != 47);
                }
                this.pr_file_p.unread(n);
                this.pr_file_p.unread(47);
                break block6;
            }
            this.pr_file_p.unread(n);
        }
        this.pop();
    }

    void PR_NewLine() throws IOException {
        boolean bl;
        this.push();
        System.out.println(String.valueOf(this.stack) + "PR_NewLine ()");
        char c = this.pr_file_p_read();
        if (c == '\n') {
            bl = true;
        } else {
            this.pr_file_p.unread(c);
            bl = false;
        }
        ++this.pr_source_line;
        this.pr_mark_file_p.mark(1024);
        if (bl) {
            this.pr_file_p.unread(c);
        }
        this.pop();
    }

    void PR_ParseDefs() throws ParseException, Exception {
        System.out.println("PR_ParseDefs ()");
        type_t type_t2 = this.PR_ParseType();
        if (this.pr_scope != null && (type_t2.type == 5 || type_t2.type == 6)) {
            throw new ParseException("Fields and functions must be global");
        }
        do {
            String string = this.PR_ParseName();
            def_t def_t2 = this.PR_GetDef(type_t2, string, this.pr_scope, true);
            if (!this.PR_Check("=")) continue;
            if (def_t2.initialized) {
                throw new ParseException(String.valueOf(string) + " redeclared");
            }
            if (type_t2.type == 6) {
                int n = this.locals_end = this.numpr_globals;
                this.pr_scope = def_t2;
                function_t function_t2 = this.PR_ParseImmediateStatements(type_t2);
                this.pr_scope = null;
                def_t2.initialized = true;
                System.out.println("fn " + def_t2.name + " inited");
                this.G_FUNCTION(def_t2.ofs, this.numfunctions);
                function_t2.def = def_t2;
                dfunction_t dfunction_t2 = this.functions[this.numfunctions] = new dfunction_t();
                ++this.numfunctions;
                dfunction_t2.first_statement = function_t2.builtin > 0 ? -function_t2.builtin : function_t2.code;
                dfunction_t2.s_name = this.CopyString(function_t2.def.name);
                dfunction_t2.s_file = this.s_file;
                dfunction_t2.numparms = function_t2.def.type.num_parms;
                dfunction_t2.locals = this.locals_end - n;
                dfunction_t2.parm_start = n;
                int n2 = 0;
                while (n2 < dfunction_t2.numparms) {
                    dfunction_t2.parm_size[n2] = type_size[function_t2.def.type.parm_types[n2].type];
                    ++n2;
                }
            } else {
                if (this.pr_immediate_type != type_t2) {
                    throw new ParseException("wrong immediate type for " + string);
                }
                def_t2.initialized = true;
                this.pr_globals[def_t2.ofs] = this.pr_immediate;
                this.PR_Lex();
            }
        } while (this.PR_Check(","));
        this.PR_Expect(";");
    }

    void PR_ParseFrame() throws IOException {
        System.out.println("PR_ParseFrame ()");
        while (this.PR_SimpleGetToken()) {
            this.pr_framemacros[this.pr_nummacros] = this.pr_token;
            ++this.pr_nummacros;
        }
    }

    def_t PR_ParseFunctionCall(def_t def_t2) throws ParseException, Exception {
        System.out.println("PR_ParseFunctionCall (def_t)");
        type_t type_t2 = def_t2.type;
        if (type_t2.type != 6) {
            throw new ParseException("not a function");
        }
        int n = 0;
        if (!this.PR_Check(")")) {
            do {
                if (type_t2.num_parms != -1 && n >= type_t2.num_parms) {
                    throw new ParseException("too many parameters");
                }
                def_t def_t3 = this.PR_Expression(6);
                if (n == 0 && def_t2.name.length() > 0) {
                    if (def_t2.name.startsWith("precache_sound")) {
                        this.PrecacheSound(def_t3, def_t2.name.charAt(14));
                    } else if (def_t2.name.startsWith("precache_model")) {
                        this.PrecacheModel(def_t3, def_t2.name.charAt(14));
                    } else if (def_t2.name.startsWith("precache_file")) {
                        this.PrecacheFile(def_t3, def_t2.name.charAt(13));
                    }
                }
                if (type_t2.num_parms != -1 && def_t3.type != type_t2.parm_types[n]) {
                    throw new ParseException("type mismatch on parm " + n);
                }
                this.def_parms[n].type = type_t2.parm_types[n];
                this.PR_Statement(32, def_t3, this.def_parms[n]);
                ++n;
            } while (this.PR_Check(","));
            if (type_t2.num_parms != -1 && n != type_t2.num_parms) {
                throw new ParseException("too few parameters");
            }
            this.PR_Expect(")");
        }
        if (n > 8) {
            throw new ParseException("More than eight parameters");
        }
        this.PR_Statement(51 + n, def_t2, null);
        this.def_ret.type = type_t2.aux_type;
        return this.def_ret;
    }

    def_t PR_ParseImmediate() throws IOException, ParseException {
        System.out.println("PR_ParseImmediate ()");
        def_t def_t2 = this.pr.def_head.next;
        while (def_t2 != null) {
            if (def_t2.initialized && def_t2.type == this.pr_immediate_type) {
                if (this.pr_immediate_type == this.type_string) {
                    if (this.pr_globals[def_t2.ofs] instanceof Integer && this.G_STRING(def_t2.ofs).equals(this.pr_immediate_string)) {
                        this.PR_Lex();
                        return def_t2;
                    }
                } else if (this.pr_immediate_type == this.type_float) {
                    if (this.pr_globals[def_t2.ofs] instanceof Float && this.G_FLOAT(def_t2.ofs) == this.pr_immediate._float) {
                        this.PR_Lex();
                        return def_t2;
                    }
                } else if (this.pr_immediate_type == this.type_vector) {
                    if (this.pr_globals[def_t2.ofs] instanceof Float && this.pr_globals[def_t2.ofs + 1] instanceof Float && this.pr_globals[def_t2.ofs + 2] instanceof Float && this.G_FLOAT(def_t2.ofs) == this.pr_immediate.vector[0] && this.G_FLOAT(def_t2.ofs + 1) == this.pr_immediate.vector[1] && this.G_FLOAT(def_t2.ofs + 2) == this.pr_immediate.vector[2]) {
                        this.PR_Lex();
                        return def_t2;
                    }
                } else {
                    throw new ParseException("weird immediate type");
                }
            }
            def_t2 = def_t2.next;
        }
        def_t2 = new def_t();
        def_t2.next = null;
        this.pr.def_tail.next = def_t2;
        this.pr.def_tail = def_t2;
        def_t2.type = this.pr_immediate_type;
        def_t2.name = "IMMEDIATE";
        def_t2.initialized = true;
        def_t2.scope = null;
        def_t2.ofs = this.numpr_globals;
        this.pr_global_defs[def_t2.ofs] = def_t2;
        this.numpr_globals += type_size[this.pr_immediate_type.type];
        if (this.pr_immediate_type == this.type_string) {
            this.pr_immediate.string = this.CopyString(this.pr_immediate_string);
        }
        if (this.pr_immediate_type == this.type_void) {
            throw new ParseException("type void");
        }
        if (this.pr_immediate_type == this.type_string) {
            this.pr_globals[def_t2.ofs] = new String(this.pr_immediate_string);
        } else if (this.pr_immediate_type == this.type_float) {
            this.pr_globals[def_t2.ofs] = new Float(this.pr_immediate._float);
        } else if (this.pr_immediate_type == this.type_vector) {
            this.pr_globals[def_t2.ofs] = new Float(this.pr_immediate.vector[0]);
            this.pr_globals[def_t2.ofs + 1] = new Float(this.pr_immediate.vector[1]);
            this.pr_globals[def_t2.ofs + 2] = new Float(this.pr_immediate.vector[2]);
        } else {
            if (this.pr_immediate_type == this.type_entity) {
                throw new ParseException("type entity");
            }
            if (this.pr_immediate_type == this.type_field) {
                throw new ParseException("type field");
            }
            if (this.pr_immediate_type == this.type_function) {
                throw new ParseException("type function");
            }
            if (this.pr_immediate_type == this.type_pointer) {
                throw new ParseException("type pointer");
            }
            if (this.pr_immediate_type == this.type_floatfield) {
                throw new ParseException("type floatfield");
            }
        }
        this.PR_Lex();
        return def_t2;
    }

    function_t PR_ParseImmediateStatements(type_t type_t2) throws ParseException, Exception {
        this.push();
        System.out.println(String.valueOf(this.stack) + "PR_ParseImmediateStatements (type_t)");
        def_t[] def_tArray = new def_t[8];
        function_t function_t2 = new function_t();
        if (this.PR_Check("#")) {
            if (this.pr_token_type != 4 || this.pr_immediate_type != this.type_float || this.pr_immediate._float != (float)((int)this.pr_immediate._float)) {
                throw new ParseException("Bad builtin immediate");
            }
            function_t2.builtin = (int)this.pr_immediate._float;
            this.PR_Lex();
            this.pop();
            return function_t2;
        }
        function_t2.builtin = 0;
        int n = 0;
        while (n < type_t2.num_parms) {
            def_tArray[n] = this.PR_GetDef(type_t2.parm_types[n], this.pr_parm_names[n], this.pr_scope, true);
            function_t2.parm_ofs[n] = def_tArray[n].ofs;
            if (n > 0 && function_t2.parm_ofs[n] < function_t2.parm_ofs[n - 1]) {
                throw new Exception("bad parm order");
            }
            ++n;
        }
        function_t2.code = this.numstatements;
        if (this.PR_Check("[")) {
            this.PR_ParseState();
        }
        this.PR_Expect("{");
        while (!this.PR_Check("}")) {
            this.PR_ParseStatement();
        }
        this.PR_Statement(0, null, null);
        this.pop();
        return function_t2;
    }

    String PR_ParseName() throws IOException, ParseException {
        this.push();
        System.out.println(String.valueOf(this.stack) + "PR_ParseName () on \"" + this.pr_token + "\"");
        if (this.pr_token_type != 2) {
            throw new ParseException("not a name");
        }
        if (this.pr_token.length() >= 63) {
            throw new ParseException("name too long");
        }
        String string = new String(this.pr_token);
        this.PR_Lex();
        this.pop();
        return string;
    }

    void PR_ParseState() throws IOException, ParseException {
        System.out.println("PR_ParseState ()");
        if (this.pr_token_type != 4 || this.pr_immediate_type != this.type_float) {
            throw new ParseException("state frame must be a number");
        }
        def_t def_t2 = this.PR_ParseImmediate();
        this.PR_Expect(",");
        String string = this.PR_ParseName();
        def_t def_t3 = this.PR_GetDef(this.type_function, string, null, true);
        this.PR_Expect("]");
        this.PR_Statement(60, def_t2, def_t3);
    }

    void PR_ParseStatement() throws ParseException, Exception {
        this.push();
        System.out.println(String.valueOf(this.stack) + "PR_ParseStatement ()");
        if (this.PR_Check("{")) {
            do {
                this.PR_ParseStatement();
            } while (!this.PR_Check("}"));
            this.pop();
            return;
        }
        if (this.PR_Check("return")) {
            if (this.PR_Check(";")) {
                this.PR_Statement(43, null, null);
                this.pop();
                return;
            }
            def_t def_t2 = this.PR_Expression(6);
            this.PR_Expect(";");
            this.PR_Statement(43, def_t2, null);
            this.pop();
            return;
        }
        if (this.PR_Check("while")) {
            this.PR_Expect("(");
            int n = this.numstatements;
            def_t def_t3 = this.PR_Expression(6);
            this.PR_Expect(")");
            int n2 = this.numstatements;
            this.PR_Statement(50, def_t3, null);
            this.PR_ParseStatement();
            this.junkdef.ofs = n - this.numstatements;
            this.PR_Statement(61, this.junkdef, null);
            this.statements[n2].b = this.numstatements - n2;
            this.pop();
            return;
        }
        if (this.PR_Check("do")) {
            int n = this.numstatements;
            this.PR_ParseStatement();
            this.PR_Expect("while");
            this.PR_Expect("(");
            def_t def_t4 = this.PR_Expression(6);
            this.PR_Expect(")");
            this.PR_Expect(";");
            this.junkdef.ofs = n - this.numstatements;
            this.PR_Statement(49, def_t4, this.junkdef);
            this.pop();
            return;
        }
        if (this.PR_Check("local")) {
            this.PR_ParseDefs();
            this.locals_end = this.numpr_globals;
            this.pop();
            return;
        }
        if (this.PR_Check("if")) {
            this.PR_Expect("(");
            def_t def_t5 = this.PR_Expression(6);
            this.PR_Expect(")");
            int n = this.numstatements;
            this.PR_Statement(50, def_t5, null);
            this.PR_ParseStatement();
            if (this.PR_Check("else")) {
                int n3 = this.numstatements;
                this.PR_Statement(61, null, null);
                this.statements[n].b = this.numstatements - n;
                this.PR_ParseStatement();
                this.statements[n3].a = this.numstatements - n3;
            } else {
                this.statements[n].b = this.numstatements - n;
            }
            this.pop();
            return;
        }
        this.PR_Expression(6);
        this.PR_Expect(";");
        this.pop();
    }

    type_t PR_ParseType() throws IOException, ParseException {
        type_t type_t2;
        System.out.println("PR_ParseType ()");
        if (this.PR_Check(".")) {
            type_t type_t3 = new type_t();
            type_t3.type = 5;
            type_t3.aux_type = this.PR_ParseType();
            return this.PR_FindType(type_t3);
        }
        if (this.pr_token.equals("float")) {
            type_t2 = this.type_float;
        } else if (this.pr_token.equals("vector")) {
            type_t2 = this.type_vector;
        } else if (this.pr_token.equals("float")) {
            type_t2 = this.type_float;
        } else if (this.pr_token.equals("entity")) {
            type_t2 = this.type_entity;
        } else if (this.pr_token.equals("string")) {
            type_t2 = this.type_string;
        } else if (this.pr_token.equals("void")) {
            type_t2 = this.type_void;
        } else {
            throw new ParseException("\"" + this.pr_token + "\" is not a type");
        }
        this.PR_Lex();
        if (!this.PR_Check("(")) {
            return type_t2;
        }
        type_t type_t4 = new type_t();
        type_t4.type = 6;
        type_t4.aux_type = type_t2;
        type_t4.num_parms = 0;
        if (!this.PR_Check(")")) {
            if (this.PR_Check("...")) {
                type_t4.num_parms = -1;
            } else {
                do {
                    String string;
                    type_t2 = this.PR_ParseType();
                    this.pr_parm_names[type_t4.num_parms] = string = this.PR_ParseName();
                    type_t4.parm_types[type_t4.num_parms] = type_t2;
                    ++type_t4.num_parms;
                } while (this.PR_Check(","));
            }
            this.PR_Expect(")");
        }
        return this.PR_FindType(type_t4);
    }

    def_t PR_ParseValue() throws IOException, ParseException {
        this.push();
        System.out.println(String.valueOf(this.stack) + "PR_ParseValue ()");
        if (this.pr_token_type == 4) {
            def_t def_t2 = this.PR_ParseImmediate();
            this.pop();
            return def_t2;
        }
        String string = this.PR_ParseName();
        def_t def_t3 = this.PR_GetDef(null, string, this.pr_scope, false);
        if (def_t3 == null) {
            throw new ParseException("Unknown value \"" + string + "\"");
        }
        this.pop();
        return def_t3;
    }

    void PR_PrintDefs() throws Exception {
        System.out.println("PR_PrintDefs ()");
        def_t def_t2 = this.pr.def_head.next;
        while (def_t2 != null) {
            this.PR_PrintOfs(def_t2.ofs);
            def_t2 = def_t2.next;
        }
    }

    void PR_PrintNextLine() throws IOException {
        System.out.println("PR_PrintNextLine ()");
        System.out.print(String.valueOf(this.pr_source_line));
        this.pr_mark_file_p.reset();
        char c = this.pr_file_p_read();
        while (c != '\n') {
            System.out.print(String.valueOf(c));
            c = this.pr_file_p_read();
        }
        this.pr_file_p.unread(c);
        System.out.println("");
    }

    void PR_PrintOfs(int n) throws Exception {
        System.out.println("PR_PrintOfs (" + n + ")");
        System.out.println(this.PR_GlobalString(n));
    }

    void PR_PrintStatement(int n) throws Exception {
        System.out.println("PR_PrintStatement (" + n + ")");
        dstatement_t dstatement_t2 = this.statements[n];
        System.out.print(n + " : " + this.statement_linenums[n] + " : " + this.pr_opcodes[dstatement_t2.op].opname + " ");
        int n2 = this.pr_opcodes[dstatement_t2.op].opname.length();
        while (n2 < 10) {
            System.out.print(" ");
            ++n2;
        }
        if (dstatement_t2.op == 49 || dstatement_t2.op == 50) {
            System.out.print(String.valueOf(this.PR_GlobalString(dstatement_t2.a)) + "branch " + dstatement_t2.b);
        } else if (dstatement_t2.op == 61) {
            System.out.print("branch " + dstatement_t2.a);
        } else if (dstatement_t2.op - 31 < 6) {
            System.out.print(this.PR_GlobalString(dstatement_t2.a));
            System.out.print(this.PR_GlobalStringNoContents(dstatement_t2.b));
        } else {
            if (dstatement_t2.a != 0) {
                System.out.print(this.PR_GlobalString(dstatement_t2.a));
            }
            if (dstatement_t2.b != 0) {
                System.out.print(this.PR_GlobalString(dstatement_t2.b));
            }
            if (dstatement_t2.c != 0) {
                System.out.print(this.PR_GlobalStringNoContents(dstatement_t2.c));
            }
        }
        System.out.println("");
    }

    boolean PR_SimpleGetToken() throws IOException {
        char c;
        System.out.println("PR_SimpleGetToken ()");
        while ((c = this.pr_file_p_read()) <= ' ') {
            if (c != '\n') continue;
            this.pr_file_p.unread(c);
            return false;
        }
        this.pr_token = "";
        while ((c = this.pr_file_p_read()) > ' ' && c != ',' && c != ';') {
            this.pr_token = String.valueOf(this.pr_token) + c;
        }
        this.pr_file_p.unread(c);
        return true;
    }

    void PR_SkipToSemicolon() throws IOException, ParseException {
        this.push();
        System.out.println(String.valueOf(this.stack) + "PR_SkipToSemicolon ()");
        do {
            if (this.pr_bracelevel != 0 && this.PR_Check(";")) {
                this.pop();
                return;
            }
            this.PR_Lex();
        } while (this.pr_token.charAt(0) != '\uffffffff');
        this.pop();
    }

    def_t PR_Statement(int n, def_t def_t2, def_t def_t3) {
        def_t def_t4;
        this.push();
        String string = def_t2 == null ? "(null)" : def_t2.name;
        String string2 = def_t3 == null ? "(null)" : def_t3.name;
        System.out.println(String.valueOf(this.stack) + "PR_Statement (" + n + ", def_t \"" + string + "\", def_t \"" + string2 + "\")");
        opcode_t opcode_t2 = this.pr_opcodes[n];
        dstatement_t dstatement_t2 = this.statements[this.numstatements] = new dstatement_t();
        this.statement_linenums[this.numstatements] = this.pr_source_line;
        dstatement_t2.op = n;
        dstatement_t2.a = def_t2 != null ? def_t2.ofs : 0;
        dstatement_t2.b = def_t3 != null ? def_t3.ofs : 0;
        ++this.numstatements;
        if (opcode_t2.type_c == this.def_void || opcode_t2.right_associative) {
            def_t4 = null;
            dstatement_t2.c = 0;
        } else {
            def_t4 = new def_t();
            def_t4.ofs = this.numpr_globals;
            def_t4.type = opcode_t2.type_c.type;
            dstatement_t2.c = this.numpr_globals;
            this.numpr_globals += type_size[opcode_t2.type_c.type.type];
        }
        if (opcode_t2.right_associative) {
            this.pop();
            return def_t2;
        }
        this.pop();
        return def_t4;
    }

    String PR_String(String string) {
        System.out.println("PR_String (" + string + ")");
        char[] cArray = new char[80];
        int n = 0;
        int n2 = string.length();
        cArray[n++] = 34;
        for (int i = 0; string != null && i < n2; ++i) {
            if (n == 78) break;
            if (string.charAt(i) == '\n') {
                cArray[n++] = 92;
                cArray[n++] = 110;
                continue;
            }
            if (string.charAt(i) == '\"') {
                cArray[n++] = 92;
                cArray[n++] = 34;
                continue;
            }
            cArray[n++] = string.charAt(i);
            if (n <= 60) continue;
            cArray[n++] = 46;
            cArray[n++] = 46;
            cArray[n++] = 46;
            break;
        }
        cArray[n++] = 34;
        cArray[n++] = '\u0000';
        return new String(cArray);
    }

    def_t PR_Term() throws ParseException, Exception {
        this.push();
        System.out.println(String.valueOf(this.stack) + "PR_Term ()");
        if (this.PR_Check("!")) {
            def_t def_t2;
            def_t def_t3 = this.PR_Expression(4);
            int n = def_t3.type.type;
            if (n == 2) {
                def_t2 = this.PR_Statement(44, def_t3, null);
            } else if (n == 1) {
                def_t2 = this.PR_Statement(46, def_t3, null);
            } else if (n == 4) {
                def_t2 = this.PR_Statement(47, def_t3, null);
            } else if (n == 3) {
                def_t2 = this.PR_Statement(45, def_t3, null);
            } else if (n == 6) {
                def_t2 = this.PR_Statement(48, def_t3, null);
            } else {
                Object var2_6 = null;
                throw new ParseException("type mismatch for !");
            }
            this.pop();
            return def_t2;
        }
        if (this.PR_Check("(")) {
            def_t def_t4 = this.PR_Expression(6);
            this.PR_Expect(")");
            this.pop();
            return def_t4;
        }
        def_t def_t5 = this.PR_ParseValue();
        this.pop();
        return def_t5;
    }

    String PR_ValueString(int n, Object object) throws Exception {
        String string;
        System.out.println("PR_ValueString (" + n + ", Object)");
        switch (n) {
            case 1: {
                string = this.PR_String(this.strings[(Integer)object]);
                break;
            }
            case 4: {
                string = "entity " + (Integer)object;
                break;
            }
            case 6: {
                dfunction_t dfunction_t2 = this.functions[(Integer)object];
                if (dfunction_t2 == null) {
                    string = "undefined function";
                    break;
                }
                string = String.valueOf(this.strings[dfunction_t2.s_name]) + "()";
                break;
            }
            case 5: {
                def_t def_t2 = this.PR_DefForFieldOfs((Integer)object);
                string = "." + def_t2.name;
                break;
            }
            case 0: {
                string = "void";
                break;
            }
            case 2: {
                string = String.valueOf(((Float)object).floatValue());
                break;
            }
            case 3: {
                string = "'" + ((Float[])object)[0].floatValue() + " " + ((Float[])object)[1].floatValue() + " " + ((Float[])object)[2].floatValue() + "'";
                break;
            }
            case 7: {
                string = "pointer";
                break;
            }
            default: {
                string = "bad type " + n;
            }
        }
        return string;
    }

    int PR_WriteProgdefs(String string) {
        System.out.println("PR_WriteProgdefs (" + string + ")");
        return 0;
    }

    void PrecacheFile(def_t def_t2, char c) throws Exception {
        System.out.println("PrecacheFile (def_t, " + c + ")");
        if (def_t2.ofs != 0) {
            return;
        }
        String string = this.G_STRING(def_t2.ofs);
        int n = 0;
        while (n < this.numfiles) {
            if (string.equals(this.precache_files[n])) {
                return;
            }
            ++n;
        }
        if (this.numfiles == 1024) {
            throw new Exception("PrecacheFile: numfiles == MAX_FILES");
        }
        this.precache_files[n] = string;
        this.precache_files_block[n] = c >= '1' && c <= '9' ? c - 48 : 1;
        ++this.numfiles;
    }

    void PrecacheModel(def_t def_t2, char c) throws Exception {
        System.out.println("PrecacheModel (def_t, " + c + ")");
        if (def_t2.ofs != 0) {
            return;
        }
        String string = this.G_STRING(def_t2.ofs);
        int n = 0;
        while (n < this.nummodels) {
            if (string.equals(this.precache_models[n])) {
                return;
            }
            ++n;
        }
        if (this.numsounds == 1024) {
            throw new Exception("PrecacheModels: numsounds == MAX_SOUNDS");
        }
        this.precache_models[n] = string;
        this.precache_models_block[n] = c >= '1' && c <= '9' ? c - 48 : 1;
        ++this.nummodels;
    }

    void PrecacheSound(def_t def_t2, char c) throws Exception {
        System.out.println("PrecacheSound (def_t, " + c + ")");
        if (def_t2.ofs != 0) {
            return;
        }
        String string = this.G_STRING(def_t2.ofs);
        int n = 0;
        while (n < this.numsounds) {
            if (string.equals(this.precache_sounds[n])) {
                return;
            }
            ++n;
        }
        if (this.numsounds == 1024) {
            throw new Exception("PrecacheSound: numsounds == MAX_SOUNDS");
        }
        this.precache_sounds[n] = string;
        this.precache_sounds_block[n] = c >= '1' && c <= '9' ? c - 48 : 1;
        ++this.numsounds;
    }

    void PrintFields() {
        System.out.println("PrintFields ()");
        int n = 0;
        while (n < this.numfielddefs) {
            ddef_t ddef_t2 = this.fields[n];
            System.out.println(ddef_t2.ofs + " : (" + ddef_t2.type + ") " + this.strings[ddef_t2.s_name]);
            ++n;
        }
    }

    void PrintFunction(String string) throws Exception {
        dstatement_t dstatement_t2;
        System.out.println("PrintFunction (" + string + ")");
        int n = 0;
        while (n < this.numfunctions) {
            if (string.equals(this.strings[this.functions[n].s_name])) break;
            ++n;
        }
        if (n == this.numfunctions) {
            throw new Exception("No function names \"" + string + "\"");
        }
        dfunction_t dfunction_t2 = this.functions[n];
        int n2 = dfunction_t2.first_statement;
        System.out.println("Statements for " + string + ":\n");
        do {
            this.PR_PrintStatement(n2);
            dstatement_t2 = this.statements[n2++];
        } while (dstatement_t2.op != 0);
    }

    void PrintFunctions() {
        System.out.println("PrintFunctions ()");
        int n = 0;
        while (n < this.numfunctions) {
            dfunction_t dfunction_t2 = this.functions[n];
            System.out.print(String.valueOf(this.strings[dfunction_t2.s_file]) + " : " + this.strings[dfunction_t2.s_name] + " : " + dfunction_t2.first_statement + dfunction_t2.parm_start);
            int n2 = 0;
            while (n2 < dfunction_t2.numparms) {
                System.out.print(dfunction_t2.parm_size[n2] + " ");
                ++n2;
            }
            System.out.println(")");
            ++n;
        }
    }

    void PrintGlobals() {
        System.out.println("PrintGlobals ()");
        int n = 0;
        while (n < this.numglobaldefs) {
            ddef_t ddef_t2 = this.globals[n];
            System.out.println(ddef_t2.ofs + " : (" + ddef_t2.type + ") " + this.strings[ddef_t2.s_name]);
            ++n;
        }
    }

    void PrintStrings() {
        System.out.println("PrintStrings ()");
        int n = 0;
        while (n < this.strofs) {
            System.out.println(n + " : " + this.strings[n]);
            ++n;
        }
        System.out.println("");
    }

    void WriteData(int n) {
        System.out.println("WriteData (" + n + ")");
        def_t def_t2 = this.pr.def_head.next;
        while (def_t2 != null) {
            ddef_t ddef_t2;
            if (def_t2.type.type != 6 && def_t2.type.type == 5) {
                ddef_t2 = this.fields[this.numfielddefs];
                ++this.numfielddefs;
                ddef_t2.type = def_t2.type.aux_type.type;
                ddef_t2.s_name = this.CopyString(def_t2.name);
                ddef_t2.ofs = this.G_INT(def_t2.ofs);
            }
            ddef_t2 = this.globals[this.numglobaldefs];
            ++this.numglobaldefs;
            ddef_t2.type = def_t2.type.type;
            if (!def_t2.initialized && def_t2.type.type != 6 && def_t2.type.type != 5 && def_t2.scope == null) {
                ddef_t2.type |= 0x8000;
            }
            ddef_t2.s_name = this.CopyString(def_t2.name);
            ddef_t2.ofs = def_t2.ofs;
            def_t2 = def_t2.next;
        }
        this.PrintStrings();
        this.PrintFunctions();
        this.PrintFields();
        this.PrintGlobals();
        System.out.println(String.valueOf(this.strofs) + " strofs");
        System.out.println(String.valueOf(this.numstatements) + " numstatements");
        System.out.println(String.valueOf(this.numfunctions) + " numfunctions");
        System.out.println(String.valueOf(this.numglobaldefs) + " numglobaldefs");
        System.out.println(String.valueOf(this.numfielddefs) + " numfielddefs");
        System.out.println(String.valueOf(this.numpr_globals) + " numpr_globals");
    }

    void pop() {
        this.stack = this.stack.substring(0, this.stack.length() - 1);
        String string = "";
        int n = this.stack.length();
        while (n >= 0) {
            string = String.valueOf(string) + '<';
            --n;
        }
        System.out.println(string);
    }

    char pr_file_p_read() throws IOException {
        char c = (char)new Integer(this.pr_file_p.read()).byteValue();
        if (c == '\uffff') {
            throw new IOException("eof");
        }
        return c;
    }

    void push() {
        this.stack = String.valueOf(this.stack) + '>';
    }

    void writeFiles() {
        System.out.println("writeFiles ()");
        PrintWriter printWriter = null;
        String string = String.valueOf(this.sourcedir) + "files.dat";
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        }
        catch (IOException iOException) {
            System.out.println("Error opening " + string);
            return;
        }
        printWriter.println(this.numsounds);
        int n = 0;
        while (n < this.numsounds) {
            printWriter.println(String.valueOf(this.precache_sounds_block[n]) + " " + this.precache_sounds[n]);
            ++n;
        }
        printWriter.println(this.nummodels);
        int n2 = 0;
        while (n2 < this.nummodels) {
            printWriter.println(String.valueOf(this.precache_models_block[n2]) + " " + this.precache_models[n2]);
            ++n2;
        }
        printWriter.println(this.numfiles);
        int n3 = 0;
        while (n3 < this.numfiles) {
            printWriter.println(String.valueOf(this.precache_files_block[n3]) + " " + this.precache_files[n3]);
            ++n3;
        }
        printWriter.close();
    }
}

