/*
 * java QuakeC compiler
 *
 * 21 Novemeber 1998   jet@poboxes.com
 */

class type_t {
	public final static int MAX_PARMS = 8;

	public int type;		// etype_t type
	public def_t def;		// struct def_s *def
	public type_t next;		// struct type_s *next
// function types are more complex
	public type_t aux_type;		// struct type_s *aux_type
	public int num_parms;		// int num_parms, -1 = variable args
	public type_t parm_types[];	// struct type_s *parm_types[MAX_PARMS]
					// only [num_parms] allocated
	public type_t () {
		parm_types = new type_t[MAX_PARMS];
	}

	public type_t (int t, def_t d) {
		type = t;
		def = d;
		parm_types = new type_t[MAX_PARMS];
	}

	public type_t (int t, def_t d, type_t n, type_t a) {
		type = t;
		def = d;
		next = n;
		aux_type = a;
		parm_types = new type_t[MAX_PARMS];
	}

	public type_t (type_t a) {
		type = a.type;
		def = a.def;
		next = a.next;
		aux_type = a.aux_type;
		num_parms = a.num_parms;
		parm_types = new type_t[MAX_PARMS];
		for (int i = 0; i < num_parms; i++) {
			parm_types[i] = a.parm_types[i];
		}
	}
}

/* end of file */
