/*
 * java QuakeC compiler
 *
 * 21 Novemeber 1998   jet@poboxes.com
 */

class def_t {
	public type_t type;		// type_t *type
	public String name;		// char *name
	public def_t next;		// struct def_s *next
	public int ofs;			// gofs_t ofs;
// function the var was defined in, or null
	public def_t scope;		// struct def_s *scope
// true when a declaration included "= immediate"
	public boolean initialized;	// int initialized

	public def_t () {
		initialized = false;
	}

	public def_t (type_t t, String n) {
		type = t;
		name = n;
		initialized = false;
	}

	public def_t (def_t other) {
		if (other == null) {
			initialized = false;
			return;
		}
		type = other.type;
		name = other.name;
		ofs = other.ofs;
		scope = other.scope;
		initialized = other.initialized;
	}
}

/* end of file */
