/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PushbackInputStream;

public class Qcc {
    private String sourcedir;
    private String progsrc = "progs.src";
    private String[] myargs;

    Qcc(String[] stringArray) {
        Tokenizer tokenizer;
        this.myargs = stringArray;
        int n = 0;
        while (n < stringArray.length) {
            System.out.println("arg" + n + ": " + stringArray[n]);
            ++n;
        }
        if (this.CheckParm("-?") >= 0 || this.CheckParm("-help") >= 0) {
            System.out.println("qcc looks for progs.src in the current directory.");
            System.out.println("to look in a different directory: qcc -src <directory>");
            System.out.println("to build a clean data tree: qcc -copy <srcdir> <destdir>");
            System.out.println("to build a clean pak file: qcc -pak <srcdir> <packfile>");
            System.out.println("to bsp all bmodels: qcc -bspmodels <gamedir>");
            return;
        }
        int n2 = this.CheckParm("-src");
        if (n2 >= 0 && n2 < stringArray.length - 1) {
            this.sourcedir = new String(String.valueOf(stringArray[n2 + 1]) + "/");
            System.out.println("Source directory: " + this.sourcedir);
        } else {
            this.sourcedir = "";
        }
        String string = String.valueOf(this.sourcedir) + this.progsrc;
        try {
            tokenizer = new Tokenizer(new BufferedReader(new FileReader(string)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening: " + string);
            return;
        }
        String string2 = this.COM_Parse(tokenizer);
        if (string2 == null) {
            System.out.println("No destination filename.  qcc -help for info.\n");
            return;
        }
        System.out.println("outputfile: " + string2);
        Parser parser = new Parser();
        parser.PR_BeginCompilation();
        while ((string2 = this.COM_Parse(tokenizer)) != null) {
            string = String.valueOf(this.sourcedir) + string2;
            System.out.println("compiling " + string);
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("error: file not found " + string);
                continue;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            PushbackInputStream pushbackInputStream = new PushbackInputStream(bufferedInputStream, 5);
            try {
                parser.PR_CompileFile(string, pushbackInputStream, bufferedInputStream);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        parser.PR_FinishCompilation();
        parser.PR_WriteProgdefs("progdefs.h");
        parser.WriteData(0);
        parser.writeFiles();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String COM_Parse(Tokenizer tokenizer) {
        try {
            block6: while (true) {
                switch (tokenizer.nextToken()) {
                    default: {
                        continue block6;
                    }
                    case 0: {
                        return tokenizer.sval;
                    }
                    case -1: 
                }
                break;
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    int CheckParm(String string) {
        int n = 0;
        while (n < this.myargs.length) {
            if (this.myargs[n].equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("JQcc developer version 8\n");
        Qcc qcc = new Qcc(stringArray);
        System.out.println("finished.");
    }
}

