/*
 * java QuakeC compiler
 *
 * 12 Sepetember 1998   jet@poboxes.com
 */

import java.io.*;
import java.util.*;

public class Qcc {
	private static String sourcedir;
	private static String progsrc = "progs.src";

	private static String myargs[];

	public static void main (String args[]) throws Exception {

		myargs = args;
		for (int i = 0; i < args.length; i++) 
			System.out.println ("arg" + i + ": " + args[i]);

		if (CheckParm ("-?") >= 0 || CheckParm ("-help") >= 0) {
			System.out.println ("qcc looks for progs.src in the current directory.");
			System.out.println ("to look in a different directory: qcc -src <directory>");
			System.out.println ("to build a clean data tree: qcc -copy <srcdir> <destdir>");
			System.out.println ("to build a clean pak file: qcc -pak <srcdir> <packfile>");
			System.out.println ("to bsp all bmodels: qcc -bspmodels <gamedir>");
			return;
		}

		int p = CheckParm ("-src");
		if (p >= 0 && p < args.length - 1 ) {
			sourcedir = args[p + 1] + "/";
			System.out.println ("Source directory: " + sourcedir);
		} else
			sourcedir = "";

		String filename = sourcedir + progsrc;

		Tokenizer tok;
		try {
			tok = new Tokenizer (new BufferedReader (new FileReader (filename)));
		} catch (FileNotFoundException e) {
			System.out.println ("Error opening: " + filename);
			return;
		}

		String src = COM_Parse (tok);
		if (src == null) {
			System.out.println ("No destination filename.  qcc -help for info.\n");
			return;
		}
		System.out.println ("outputfile: " + src);

		Parser ps = new Parser ();
		ps.PR_BeginCompilation ();

// compile all files
		do {
			src = COM_Parse (tok);
			if (src == null) break;

			filename = sourcedir + src;
			System.out.println ("compiling " + filename);

			FileInputStream is = null;
			try {
				is = new FileInputStream (filename);
			} catch (FileNotFoundException e) {
				System.out.println ("error: file not found " + filename);
				continue;
			}

			BufferedInputStream bis = new BufferedInputStream (is);
			PushbackInputStream pis = new PushbackInputStream (bis);

			try {
				ps.PR_CompileFile (filename, pis);
			} catch (IOException e) {}

		} while (false);

		ps.PR_FinishCompilation ();
		ps.PR_WriteProgdefs ("progdefs.h");
		ps.WriteData (0);
		ps.writeFiles ();
		System.out.println ("finished.");
	}

	static int CheckParm (String check) {
		for (int i = 0; i < myargs.length; i++) { 
			if (myargs[i].equalsIgnoreCase (check)) {
				return i;
			}
		}
		return -1;
	}

	static String COM_Parse (Tokenizer tok) {
		try {
scan:
			while (true) {
				switch (tok.nextToken ()) {
				case Tokenizer.TT_EOF:
//					System.out.println ("eof");
					break scan;
				case Tokenizer.TT_EOL:
//					System.out.println ("eol");
					break;
				case Tokenizer.TT_TOK:
//					System.out.println ("word: " + tok.sval);
					return tok.sval;
				}
			}
		} catch (IOException e) {}
		return null;
	}
}

/* end of file */
