/*
 * java QuakeC compiler
 *
 * 12 Sepetember 1998   jet@poboxes.com
 */

import java.io.*;
import java.util.*;

class Parser {

// -- qcc.h --
	private final static int MAX_PARMS = 8;
	private final static int MAX_ERRORS = 10;
	private final static int MAX_NAME = 64;
	private final static int MAX_REGS = 16384;

	private final static int tt_eof = 1;		// end of file reached
	private final static int tt_name = 2;		// an alphanumeric name token
	private final static int tt_punct = 3;		// code punctuation
	private final static int tt_immediate = 4;

	private final static int OFS_NULL = 0;
	private final static int OFS_RETURN = 1;
	private final static int OFS_PARM0 = 4;	// leave 3 ofs for each parm to hold vectors
	private final static int OFS_PARM1 = 7;
	private final static int OFS_PARM2 = 10;
	private final static int OFS_PARM3 = 13;
	private final static int OFS_PARM4 = 16;
	private final static int OFS_PARM5 = 19;
	private final static int OFS_PARM6 = 22;
	private final static int OFS_PARM7 = 25;
	private final static int RESERVED_OFS = 28;

	private final static int MAX_STRINGS = 500000;
	private final static int MAX_GLOBALS = 16384;
	private final static int MAX_FIELDS = 1024;
	private final static int MAX_STATEMENTS = 65536;
	private final static int MAX_FUNCTIONS = 8192;

	private final static int MAX_SOUNDS = 1024;
	private final static int MAX_MODELS = 1024;
	private final static int MAX_FIELDS = 1024;
	private final static int MAX_DATA_PATH = 64;

// -- qcc.c --
	private static String sourcedir;	// char sourcedir[1024]
	private static String destfile;		// char destfile[1024]

	private static float pr_globals[];	// float pr_globals[MAX_REGS]
	private static int numpr_globals;	// int numpr_globals

	private static String strings;		// char strings[MAX_STRINGS]
	private static int strofs;		// int strofs

	private static dstatement_t statements[];	// dstatement_t statements[MAX_STATEMENTS]
	private static int numstatements;		// int numstatements
	private static int statement_linenums[];	// int statement_linenums[MAX_STATEMENTS]

	private static dfunction_t functions[];	// dfunction_t functions[MAX_FUNCTIONS]
	private static int numfunctions;	// int numfunctions

	private static ddef_t globals[];	// ddef_t globals[MAX_GLOBALS]
	private static int numglobaldefs;	// int numglobaldefs

	private static ddef_t fields[];		// ddef_t fields[MAX_FIELDS]
	private static int numfielddefs;	// int numfielddefs;

	private static String precache_sounds[];	// char precache_sounds[MAX_SOUNDS][MAX_DATA_PATH]
	private static int precache_sounds_block[];	// int precache_sounds_block[MAX_SOUNDS]
	private static int numsounds;			// int numsounds

	private static String precache_models[];	// char precache_models[MAX_SOUNDS][MAX_DATA_PATH]
	private static int precache_models_block[];	// int precache_models_block[MAX_SOUNDS]
	private static int nummodels;			// int nummodels

	private static String precache_files[];		// char precache_files[MAX_SOUNDS][MAX_DATA_PATH]
	private static int precache_files_block[];	// int precache_files_block[MAX_SOUNDS]
	private static int numfiles;			// int numfiles

// -- pr_comp.h --
	private final static int ev_void = 1;
	private final static int ev_string = 2;
	private final static int ev_float = 3;
	private final static int ev_vector = 4;
	private final static int ev_entity = 5;
	private final static int ev_field = 6;
	private final static int ev_function = 7;
	private final static int ev_pointer = 8;

	private final static int OP_DONE = 0;
	private final static int OP_MUL_F = 1;
	private final static int OP_MUL_V = 2;
	private final static int OP_MUL_FV = 3;
	private final static int OP_MUL_VF = 4;
	private final static int OP_DIV_F = 5;
	private final static int OP_ADD_F = 6;
	private final static int OP_ADD_V = 7;
	private final static int OP_SUB_F = 8;
	private final static int OP_SUB_V = 9;
	
	private final static int OP_EQ_F = 10;
	private final static int OP_EQ_V = 11;
	private final static int OP_EQ_S = 12;
	private final static int OP_EQ_E = 13;
	private final static int OP_EQ_FNC = 14;
	
	private final static int OP_NE_F = 15;
	private final static int OP_NE_V = 16;
	private final static int OP_NE_S = 17;
	private final static int OP_NE_E = 18;
	private final static int OP_NE_FNC = 19;
	
	private final static int OP_LE = 20;
	private final static int OP_GE = 21;
	private final static int OP_LT = 22;
	private final static int OP_GT = 23;

	private final static int OP_LOAD_F = 24;	
	private final static int OP_LOAD_V = 25;
	private final static int OP_LOAD_S = 26;
	private final static int OP_LOAD_ENT = 27;
	private final static int OP_LOAD_FLD = 28;
	private final static int OP_LOAD_FNC = 29;

	private final static int OP_ADDRESS = 30;

	private final static int OP_STORE_F = 31;
	private final static int OP_STORE_V = 32;
	private final static int OP_STORE_S = 33;
	private final static int OP_STORE_ENT = 34;
	private final static int OP_STORE_FLD = 35;
	private final static int OP_STORE_FNC = 36;

	private final static int OP_STOREP_F = 37;
	private final static int OP_STOREP_V = 38;
	private final static int OP_STOREP_S = 39;
	private final static int OP_STOREP_ENT = 40;
	private final static int OP_STOREP_FLD = 41;
	private final static int OP_STOREP_FNC = 42;

	private final static int OP_RETURN = 43;
	private final static int OP_NOT_F = 44;
	private final static int OP_NOT_V = 45;
	private final static int OP_NOT_S = 46;
	private final static int OP_NOT_ENT = 47;
	private final static int OP_NOT_FNC = 48;
	private final static int OP_IF = 49; 
	private final static int OP_IFNOT = 50;
	private final static int OP_CALL0 = 51;
	private final static int OP_CALL1 = 52;
	private final static int OP_CALL2 = 53;
	private final static int OP_CALL3 = 54;
	private final static int OP_CALL4 = 55;
	private final static int OP_CALL5 = 56;
	private final static int OP_CALL6 = 57;
	private final static int OP_CALL7 = 58;
	private final static int OP_CALL8 = 59;
	private final static int OP_STATE = 60;
	private final static int OP_GOTO = 61;
	private final static int OP_AND = 62;
	private final static int OP_OR = 63;
	
	private final static int OP_BITAND = 64;
	private final static int OP_BITOR = 65;

	private final static int DEF_SAVEGLOBLAL = (1<<15);

	private final static int PROG_VERSION = 6;

// -- pr_comp.c --
	private static pr_info_t pr;		// pr_info_t pr
// to find def for a global variable
	private static def_t pr_global_defs[];	// def_t *pr_global_defs[MAX_REGS]
	private static int pr_edict_size;	// int pr_edict_size

// the function being parsed, or null
	private static def_t pr_scope;		// def_t *pr_scope
	private static boolean pr_dumpasm;	// boolean pr_dumpasm
// filename for function definition
	private static int s_file;		// string_t s_file

// for tracking local variables vs temps
	private static int locals_end;		// int locals_end

	private static opcode_t opcode[] = {
		new Opcode ("<DONE>", "DONE", -1, false, def_entity, def_field, def_void),
		new Opcode ("*", "MUL_F", 2, false, def_float, def_float, def_float),
		new Opcode ("*", "MUL_V", 2, false, def_vector, def_vector, def_float),
		new Opcode ("*", "MUL_FV", 2, false, def_float, def_vector, def_vector),
		new Opcode ("*", "MUL_VF", 2, false, def_vector, def_float, def_vector),
 
		new Opcode ("/", "DIV", 2, false, def_float, def_float, def_float),

		new Opcode ("+", "ADD_F", 3, false, def_float, def_float, def_float),
		new Opcode ("+", "ADD_V", 3, false, def_vector, def_vector, def_vector),
  
		new Opcode ("-", "SUB_F", 3, false, def_float, def_float, def_float),
		new Opcode ("-", "SUB_V", 3, false, def_vector, def_vector, def_vector),

		new Opcode ("==", "EQ_F", 4, false, def_float, def_float, def_float),
		new Opcode ("==", "EQ_V", 4, false, def_vector, def_vector, def_float),
		new Opcode ("==", "EQ_S", 4, false, def_string, def_string, def_float),
		new Opcode ("==", "EQ_E", 4, false, def_entity, def_entity, def_float),
		new Opcode ("==", "EQ_FNC", 4, false, def_function, def_function, def_float),
 
		new Opcode ("!=", "NE_F", 4, false, def_float, def_float, def_float),
		new Opcode ("!=", "NE_V", 4, false, def_vector, def_vector, def_float),
		new Opcode ("!=", "NE_S", 4, false, def_string, def_string, def_float),
		new Opcode ("!=", "NE_E", 4, false, def_entity, def_entity, def_float),
		new Opcode ("!=", "NE_FNC", 4, false, def_function, def_function, def_float),
 
		new Opcode ("<=", "LE", 4, false, def_float, def_float, def_float),
		new Opcode (">=", "GE", 4, false, def_float, def_float, def_float),
		new Opcode ("<", "LT", 4, false, def_float, def_float, def_float),
		new Opcode (">", "GT", 4, false, def_float, def_float, def_float),

		new Opcode (".", "INDIRECT", 1, false, def_entity, def_field, def_float),
		new Opcode (".", "INDIRECT", 1, false, def_entity, def_field, def_vector),
		new Opcode (".", "INDIRECT", 1, false, def_entity, def_field, def_string),
		new Opcode (".", "INDIRECT", 1, false, def_entity, def_field, def_entity),
		new Opcode (".", "INDIRECT", 1, false, def_entity, def_field, def_field),
		new Opcode (".", "INDIRECT", 1, false, def_entity, def_field, def_function),

		new Opcode (".", "ADDRESS", 1, false, def_entity, def_field, def_pointer),

		new Opcode ("=", "STORE_F", 5, true, def_float, def_float, def_float),
		new Opcode ("=", "STORE_V", 5, true, def_vector, def_vector, def_vector),
		new Opcode ("=", "STORE_S", 5, true, def_string, def_string, def_string),
		new Opcode ("=", "STORE_ENT", 5, true, def_entity, def_entity, def_entity),
		new Opcode ("=", "STORE_FLD", 5, true, def_field, def_field, def_field),
		new Opcode ("=", "STORE_FNC", 5, true, def_function, def_function, def_function),

		new Opcode ("=", "STOREP_F", 5, true, def_pointer, def_float, def_float),
		new Opcode ("=", "STOREP_V", 5, true, def_pointer, def_vector, def_vector),
		new Opcode ("=", "STOREP_S", 5, true, def_pointer, def_string, def_string),
		new Opcode ("=", "STOREP_ENT", 5, true, def_pointer, def_entity, def_entity),
		new Opcode ("=", "STOREP_FLD", 5, true, def_pointer, def_field, def_field),
		new Opcode ("=", "STOREP_FNC", 5, true, def_pointer, def_function, def_function),

		new Opcode ("<RETURN>", "RETURN", -1, false, def_void, def_void, def_void),
  
		new Opcode ("!", "NOT_F", -1, false, def_float, def_void, def_float),
		new Opcode ("!", "NOT_V", -1, false, def_vector, def_void, def_float),
		new Opcode ("!", "NOT_S", -1, false, def_vector, def_void, def_float),
		new Opcode ("!", "NOT_ENT", -1, false, def_entity, def_void, def_float),
		new Opcode ("!", "NOT_FNC", -1, false, def_function, def_void, def_float),
  
		new Opcode ("<IF>", "IF", -1, false, def_float, def_float, def_void),
		new Opcode ("<IFNOT>", "IFNOT", -1, false, def_float, def_float, def_void),
  
// calls returns REG_RETURN
		new Opcode ("<CALL0>", "CALL0", -1, false, def_function, def_void, def_void),
		new Opcode ("<CALL1>", "CALL1", -1, false, def_function, def_void, def_void),
		new Opcode ("<CALL2>", "CALL2", -1, false, def_function, def_void, def_void),
		new Opcode ("<CALL3>", "CALL3", -1, false, def_function, def_void, def_void),
		new Opcode ("<CALL4>", "CALL4", -1, false, def_function, def_void, def_void),
		new Opcode ("<CALL5>", "CALL5", -1, false, def_function, def_void, def_void),
		new Opcode ("<CALL6>", "CALL6", -1, false, def_function, def_void, def_void),
		new Opcode ("<CALL7>", "CALL7", -1, false, def_function, def_void, def_void),
		new Opcode ("<CALL8>", "CALL8", -1, false, def_function, def_void, def_void),
  
		new Opcode ("<STATE>", "STATE", -1, false, def_float, def_float, def_void),
  
		new Opcode ("<GOTO>", "GOTO", -1, false, def_float, def_void, def_void),
  
		new Opcode ("&&", "AND", 6, false, def_float, def_float, def_float),
		new Opcode ("||", "OR", 6, false, def_float, def_float, def_float),

		new Opcode ("&", "BITAND", 2, false, def_float, def_float, def_float),
		new Opcode ("|", "BITOR", 2, false, def_float, def_float, def_float),
		null
	};

	private final static TOP_PRIORITY = 6;
	private final static NOT_PRIORITY = 4;

	private static def_t junkdef;			// def_t junkdef

// -- pr_lex.c --
	private static int pr_source_line;		// int pr_source_line

	private static String pr_file_p;		// char *pr_file_p
// start of current source line
	private static String pr_line_start;		// char *pr_line_start

	private static int pr_bracelevel;		// int pr_bracelevel

	private static String pr_token;			// char pr_token[2048]
	private static int pr_token_type;		// token_type_t pr_token_type
	private static type_t pr_immediate_type;	// type_t *pr_immediate_type
	private static eval_t pr_immediate;		// eval_t pr_immediate

	private static String pr_immediate_string;	// char pr_immediate_string[2048]

	private static int pr_error_count;		// int pr_error_count

	private static String punctuation[] = 
// longer symbols must be before a shorter partial match
{"&&", "||", "<=", ">=","==", "!=", ";", ",", "!", "*", "/", "(", ")", "-", "+", "=", "[", "]", "{", "}", "...", ".", "<", ">" , "#" , "&" , "|" , null};

// simple types.  function types are dynamically allocated
	private static type_t type_void = {new type_t (ev_void, def_void)};
	private static type_t type_string = {new type_t (ev_string, def_string)};
	private static type_t type_float = {new type_t (ev_float, def_float)};
	private static type_t type_vector = {new type_t (ev_vector, def_vector)};
	private static type_t type_entity = {new type_t (ev_entity, def_entity)};
	private static type_t type_field = {new type_t (ev_field, def_field)};
	private static type_t type_function = {new type_t (ev_function, def_function, null, type_void)};
// type_function is a void() function used for state defs
	private static type_t type_pointer = {new type_t (ev_pointer, def_pointer)};
	
	private static type_t type_floatfield = {new type_t (ev_field, def_field, null, type_float)};

	private static int type_size[] = {1,1,1,3,1,1,1,1};

	private static def_t def_void = {new def_t (type_void, "temp")};
	private static def_t def_string = {new def_t (type_string, "temp")};
	private static def_t def_float = {new def_t (type_float, "temp")};
	private static def_t def_vector = {new def_t (type_vector, "temp")};
	private static def_t def_entity = {new def_t (type_entity, "temp")};
	private static def_t def_field = {new def_t (type_field, "temp")};
	private static def_t def_function = {new def_t (type_function, "temp")};
	private static def_t def_pointer = {new def_t (type_pointer, "temp")};

	private static def_t def_ret, def_parms[];	// def_t def_parms[MAX_PARMS]

	private static def_t def_for_type[] = {def_void, def_string, def_float, def_vector, def_entity, def_field, def_function, def_pointer};

	private final static int MAX_FRAMES = 256;
	private static String pr_framemacros[];		// char pr_framemacros[MAX_FRAMES][16]
	private static int pr_nummacros;		// int pr_nummacros

// -- cmdlib.c --
	private final static char PATHSEPERATOR = '/';

// set these before calling CheckParm
	private static int myargc;
	private static String myargv[];

	private static String com_token;		// char com_token[1024]
	private static int com_eof;			// int com_eof

// -- fini --
	
	private static BufferedReader br;
	private static String data;
	private static boolean eof;

	public Parser () {
// -- qcc.c --
		pr_globals = new float[MAX_REGS];
		statements = new dstatement_t[MAX_STATEMENTS];
		statement_linenums = new int[MAX_STATEMENTS];
		functions = new dfunction_t[MAX_FUNCTIONS];
		globals = new ddef_t[MAX_GLOBALS];
		fields = new ddef_t[MAX_FIELDS];
		precache_sounds = new String[MAX_SOUNDS];
		precache_sounds_block = new int[MAX_SOUNDS];
		precache_models = new String[MAX_SOUNDS];
		precache_models_block = new int[MAX_SOUNDS];
		precache_files = new String[MAX_SOUNDS];
		precache_files_block = new int[MAX_SOUNDS];

// -- pr_comp.c --
		pr_global_defs = new def_t[MAX_REGS];

// -- pr_lex.c --
		def_parms = new def_t[MAX_PARMS];
		pr_framemacros = new String[MAX_FRAMES];

// -- fini --
	}

	public boolean compileFile (String filename) throws IOException {
		try {
			br = new BufferedReader (new FileReader (filename));
		} catch (FileNotFoundException e) {
			System.out.println ("Error opening: " + filename);
			return false;
		}

		data = br.readLine ();

		clearGrabMacros ();
		lex ();

		while (token_type != tt_eof) {
			scope = null;	// outside all functions
		
			parseDefs ();
		}
	
		return true;
	}

	void clearGrabMacros () {
		nummacros = 0;
		bracelevel = 0;
		types = new Vector ();
		immediate = new Eval ();
		def = new Vector ();
	}

	void lex () throws IOException {
		System.out.println ("lex (" + data + ")");

		if (eof == true) {
			token_type = tt_eof;
			return;
		}

		lexWhitespace ();
		System.out.println ("newdata: \"" + data + "\"");

		char c = data.charAt (0);
// handle quoted strings as a unit
		if (c == '\"') {
			lexString ();
			return;
		}

// handle quoted vectors as a unit
		if (c == '\'') {
			lexVector ();
			return;
		}

// if the first character is a valid identifier, parse until a non-id
// character is reached
		if ((c >= '0' && c <= '9') || 
		    (c == '-' && data.charAt (1) >= '0' && data.charAt (1) <= '9'))
		{
			token_type = tt_immediate;
			immediate_type = type_float;
			immediate._float = lexNumber ();
			return;
		}
	
		if ((c >= 'a' && c <= 'z') || 
		    (c >= 'A' && c <= 'Z') || 
		    c == '_')
		{
			lexName ();
			return;
		}
	
		if (c == '$') {
			lexGrab ();
			return;
		}
	
// parse symbol strings until a non-symbol is found
		lexPunctuation ();
	}

	void lexWhitespace () throws IOException {
		System.out.println ("lexWhitespace ()");
	
		while (true) {
// skip whitespace
			while (true) {
				data = data.trim ();
				if (data.length () == 0) {
					data = br.readLine ();
					if (data == null) {
						eof = true; return;
					}
				} else {
					break;
				}
			}

			if (data.charAt (0) == '/') {
				char c = data.charAt (1);

System.out.println ("comment check");
// skip // comments
				if (c == '/') {
					data = br.readLine ();
					if (data == null) {
						eof = true; return;
					}
					continue;
				}
		
// skip /* */ comments
				if (c == '*') {
					data = data.substring (2);
					while (true) {
						int i = data.indexOf ("*/");
						if (i == -1) {
							data = br.readLine ();
							if (data == null) {
								eof = true; return;
							}
						} else {
							data = data.substring (i + 2);
							break;
						}
					}
					continue;
				}
			}
			break;		// a real character has been found
		}
	}

	void lexString () {
		System.out.println ("lexString ()");
	}

	void lexVector () throws IOException {
		System.out.println ("lexVector ()");

		data = data.substring (1);
		token_type = tt_immediate;
		immediate_type = type_vector;
		immediate.vector = new float[3];
		for (int i = 0; i < 3 ;i++) {
			immediate.vector[i] = lexNumber ();
			lexWhitespace ();
		}
		if (data.charAt (0) == '\'') {
			System.out.println ("error: bad vector");
		}
		data = data.substring (1);
	}

	float lexNumber () {
		System.out.println ("lexNumber ()");

		char c;
		int i = 0;

		do {
			c = data.charAt (i++);
		} while ((c >= '0' && c <= '9') ||
			 c == '.');
		token = data.substring (0, --i);
		data = data.substring (i);
	
		float f = (float)0.0;
		try {
			f = (Float.valueOf (token)).floatValue ();
		} catch (NumberFormatException e) {}

		return f;
	}

	void lexName () {
		System.out.println ("lexName ()");

		char c;
		int i = 0;
		do {
			c = data.charAt (i++);
		} while ((c >= 'a' && c <= 'z') || 
			 (c >= 'A' && c <= 'Z') || 
			 c == '_' || 
			 (c >= '0' && c <= '9'));

		token = data.substring (0, --i);
		data = data.substring (i);
		token_type = tt_name;

		System.out.println ("token: \"" + token + "\"\ndata: \"" + data + "\"");
	}

	void lexGrab () {
		System.out.println ("lexGrab ()");
	}

	void lexPunctuation () {
		System.out.println ("lexPunctuation ()");

		token_type = tt_punct;
	
		String p;
		for (int i = 0; (p = punctuation[i]) != null; i++) {
			int len = p.length ();
			if (data.startsWith (p)) {
				token = p;
				if (p.charAt (0) == '{')
					bracelevel++;
				else if (p.charAt (0) == '}')
					bracelevel--;
				data = data.substring (len);
				return;
			}
		}

		System.out.println ("error: unknown punctuation");
	}

	void parseDefs () throws IOException {
		System.out.println ("parseDefs ()");

		parseType ();

		if (scope != null &&
		    (type.type == ev_field || type.type == ev_function)) {
			System.out.println ("error: fields and functions must be global");
		}
		
		do {
			String name = parseName ();
			Def def = getDef (type, name, scope, true);
		
// check for an initialization
			if (check ("=")) {
				if (def.initialized) {
					System.out.println ("error: " + name + " redeclared");
				}
	
				if (type.type == ev_function) {
					locals_start = locals_end = numpr_globals;
					scope = def;
					int f = parseImmediateStatements (type);
					scope = null;
					def.initialized = true;
					G_FUNCTION(def->ofs) = numfunctions;
					f->def = def;

// fill in the dfunction
					df = &functions[numfunctions];
					numfunctions++;
					if (f->builtin)
						df->first_statement = -f->builtin;
					else
						df->first_statement = f->code;
					df->s_name = CopyString (f->def->name);
					df->s_file = s_file;
					df->numparms =  f->def->type->num_parms;
					df->locals = locals_end - locals_start;
					df->parm_start = locals_start;
					for (i=0 ; i<df->numparms ; i++)
						df->parm_size[i] = type_size[f->def->type->parm_types[i]->type];
				
					continue;
				}
				else if (immediate_type != type) {
					System.out.println ("error: immediate type for " + name);
				}
	
				def->initialized = true;
				memcpy (pr_globals + def->ofs, &pr_immediate, 4*type_size[pr_immediate_type->type]);
				lex ();
			}
		
		} while (check (","));

		expect (";");
	}

	int parseImmediateStatements (Type type) {

// check for builtin function definition #1, #2, etc
		if (check ("#")) {
			if (token_type != tt_immediate || 
			    immediate_type != type_float || 
			    immediate._float != (int)immediate._float)
			{
				System.out.println ("error: bad builtin immediate");
			}
			f->builtin = (int)immediate._float;
			lex ();
			return f;
		}
	
		f->builtin = 0;

// define the parms
		for (i=0 ; i<type->num_parms ; i++) {
			defs[i] = getDef (type.parm_types[i], parm_names[i], scope, true);
			f->parm_ofs[i] = defs[i]->ofs;
			if (i > 0 && f->parm_ofs[i] < f->parm_ofs[i-1]) {
				System.out.println ("error: bad parm order");
		}
	
		f->code = numstatements;

// check for a state opcode
		if (check ("[")) parseState ();
		
// parse regular statements
		expect ("{");

		while (!check ("}"))
			parseStatement ();
	
// emit an end of statements opcode
		statement (opcodes, 0,0);

		return f;
	}

	void parseState () {
		if (token_type != tt_immediate ||
		    immediate_type != type_float) {
			System.out.println ("error: state frame must be a number");
		}
		Def s1 = parseImmediate ();
	
		expect (",");

		String name = parseName ();
		Def def = getDef (type_function, name, 0, true);
		
		expect ("]");
	
		statement (opcodes[OP_STATE], s1, def);
	}

	void parseStatement () {
		if (check ("{")) {
			do {
				parseStatement ();
			} while (!check ("}"));
			return;
		}
	
		if (check ("return")) {
			if (check (";")) {
				statement (opcodes[OP_RETURN], 0, 0);
				return;
			}
			e = expression (TOP_PRIORITY);
			expect (";");
			statement (opcodes[OP_RETURN], e, 0);
			return;		
		}
	
		if (check ("while")) {
			expect ("(");
			patch2 = &statements[numstatements];
			e = expression (TOP_PRIORITY);
			expect (")");
			patch1 = &statements[numstatements];
			statement (opcodes[OP_IFNOT], e, 0);
			parseStatement ();
			junkdef.ofs = patch2 - &statements[numstatements];
			statement (opcodes[OP_GOTO], &junkdef, 0);
			patch1->b = &statements[numstatements] - patch1;
			return;
		}
	
		if (check ("do")) {
			patch1 = &statements[numstatements];
			parseStatement ();
			expect ("while");
			expect ("(");
			e = expression (TOP_PRIORITY);
			expect (")");
			expect (";");
			junkdef.ofs = patch1 - &statements[numstatements];
			statement (opcodes[OP_IF], e, &junkdef);
			return;
		}
	
		if (check ("local")) {
			parseDefs ();
			locals_end = numpr_globals;
			return;
		}
	
		if (check ("if")) {
			expect ("(");
			e = expression (TOP_PRIORITY);
			expect (")");
		
			patch1 = &statements[numstatements];
			statement (opcodes[OP_IFNOT], e, 0);
		
			parseStatement ();
		
			if (check ("else")) {
				patch2 = &statements[numstatements];
				statement (opcodes[OP_GOTO], 0, 0);
				patch1->b = &statements[numstatements] - patch1;
				parseStatement ();
				patch2->a = &statements[numstatements] - patch2;
			}
			else
				patch1->b = &statements[numstatements] - patch1;
		
			return;
		}
	
		expression (TOP_PRIORITY);
		expect (";");
	}

	Def getDef (Type type, String name, Def scope, boolean allocate) {
		Def def;
		String element;

// see if the name is already in use
		for (Enumeration e = this->def.elements (); e.hasMoreElements (); ) {
			def = e.nextElement ();
			if (name.equals (def.name)) {
				if (def.scope != null && def.scope != scope)
					continue;	// in a different function
			
			if (type != null && def.type != type) {
				System.out.println ("error: type mismatch on redeclaration of " + name);
			}
			return def;
		}
	
		if (!allocate) return null;
		
// allocate a new def
		def = new Def ();
		this->def.addElement (def);
	
		def.name = name
		def.type = type;
		def.scope = scope;

// make automatic defs for the vectors elements
// .origin can be accessed as .origin_x, .origin_y, and .origin_z

		if (type.type == ev_vector) {
			getDef (type_float, name + "_x", scope, true);
			getDef (type_float, name + "_y", scope, true);
			getDef (type_float, name + "_z", scope, true);
		}

		if (type.type == ev_field) {
			if (type.aux_type.type == ev_vector) {
				getDef (type_floatfield, name + "_x", scope, true);
				getDef (type_floatfield, name + "_y", scope, true);
				getDef (type_floatfield, name + "_z", scope, true);
			}
		}

		return def;
	}

	Type parseType () throws IOException {
		System.out.println ("parseType ()");

		Type tmp = new Type ();

		if (check (".")) {
			tmp.type = ev_field;
			tmp.aux_type = parseType ();
			return findType (tmp);
		}

		Type type = null;
		if (token.equals ("float")) {
			type = type_float;
		} else if (token.equals ("vector")) {
			type = type_vector;
		} else if (token.equals ("entity")) {
			type = type_entity;
		} else if (token.equals ("string")) {
			type = type_string;
		} else if (token.equals ("void")) {
			type = type_void;
		}

		lex ();
	
		if (!check ("("))
			return type;
	
// function type
		tmp.type = ev_function;
		tmp.aux_type = type;	// return type
		tmp.num_parms = 0;
		tmp.parm_types = new Vector ();
		parm_names = new Vector ();

		if (!check (")")) {
			if (check ("..."))
				tmp.num_parms = -1;	// variable args
			else
				do {
					type = parseType ();
					String name = parseName ();
					parm_names.addElement (name);
					tmp.parm_types.addElement (type);
					tmp.num_parms++;
				} while (check (","));
	
			expect (")");
		}
	
		return findType (tmp);

	}

	String parseName () throws IOException {
		System.out.println ("parseName ()");

		String ident;

		if (token_type != tt_name) {
			System.out.println ("error: not a name");
		}
//		if (token.length () >= MAX_NAME-1) {
//			System.out.println ("error: name too long");
//		}
		ident = token;
		lex ();

		return ident;
	}

	Type findType (Type type) {
		System.out.println ("findType ()");

		Def def;
		Type check;
		int i = 0;
	
System.out.println ("loop: start");
		for (Enumeration e = types.elements (); e.hasMoreElements() ;) {
System.out.println ("loop: ini " + i);

			check = (Type)e.nextElement ();
			if (check.type != type.type || 
			    check.aux_type != type.aux_type || 
			    check.num_parms != type.num_parms)
				continue;

System.out.println ("loop: check pt. a " + i);

			if (check.num_parms == 0) continue;

Enumeration f = parm_names.elements ();
			for (Enumeration g = type.parm_types.elements (),
		             		 h = check.parm_types.elements (); 
			     g.hasMoreElements ();) {
System.out.println ("loop: name = " + f.nextElement ());
				if (g.nextElement () != h.nextElement ())
					break;
			}

System.out.println ("loop: check pt. b " + i);
			
			if (++i == type.num_parms)
				return check;	
System.out.println ("loop: fini " + i);
		}
System.out.println ("loop: end");
	
// allocate a new one
		check = type;
		types.addElement (check);
	
// allocate a generic def for the type, so fields can reference it
		def = new Def ();
		def.name = "COMPLEX TYPE";
		def.type = check;
		check.def = def;
		return check;
	}

	boolean check (String s) throws IOException {
		System.out.println ("check (" + s +")");

		if (!token.equals (s))
			return false;
		
		lex ();
		return true;
	}

	void expect (String s) throws IOException {
		System.out.println ("expect (" + s + ")");

		if (!token.equals (s)) {
			System.out.println ("error: expected " + s + " found " + token);
		}

		lex ();
	}

	void beginCompilation () {
		System.out.println ("beginCompilation ()");
	}

	void finishCompilation () {
		System.out.println ("finishCompilation ()");
	}

	void writeProgdefs (String filename) {
		System.out.println ("writeProgdefs (" + filename + ")");
	}
	
	void writeData () {
		System.out.println ("writeData ()");
	}
	
	void writeFiles () {
		System.out.println ("writeFiles ()");
	}
}

/* end of file */
