/*
 * java QuakeC compiler
 *
 * 12 Sepetember 1998   jet@poboxes.com
 */

import java.io.*;

public class qcc {
	private static String sourcedir;
	private static String progsrc = "progs.src";

	private static String myargs[];

	public static void main (String args[]) {

		myargs = args;
		for (int i = 0; i < args.length; i++) 
			System.out.println ("arg" + i + ": " + args[i]);

		if (CheckParm ("-?") >= 0 || CheckParm ("-help") >= 0) {
			System.out.println ("qcc looks for progs.src in the current directory.");
			System.out.println ("to look in a different directory: qcc -src <directory>");
			System.out.println ("to build a clean data tree: qcc -copy <srcdir> <destdir>");
			System.out.println ("to build a clean pak file: qcc -pak <srcdir> <packfile>");
			System.out.println ("to bsp all bmodels: qcc -bspmodels <gamedir>");
			return;
		}

		int p = CheckParm ("-src");
		if (p >= 0 && p < args.length - 1 ) {
			sourcedir = args[p + 1] + "/";
			System.out.println ("Source directory: " + sourcedir);
		} else
			sourcedir = "";

		String filename = sourcedir + progsrc;

		Tokenizer tok;
		try {
			tok = new Tokenizer (new BufferedReader (new FileReader (filename)));
		} catch (FileNotFoundException e) {
			System.out.println ("Error opening: " + filename);
			return;
		}

		String src = COM_Parse (tok);
		if (src == null) {
			System.out.println ("No destination filename.  qcc -help for info.\n");
			return;
		}
		System.out.println ("outputfile: " + src);

		Parser ps = new Parser ();
		ps.beginCompilation ();

// compile all files
		do {
			src = COM_Parse (tok);
			if (src == null) break;

			filename = sourcedir + src;
			System.out.println ("compiling " + filename);

			ps.compileFile (filename);
		} while (true);

		ps.finishCompilation ();
		ps.writeProgdefs ("progdefs.h");
		ps.writeData ();
		ps.writeFiles ();
		System.out.println ("finished.");
	}

	static int CheckParm (String check) {
		for (int i = 0; i < myargs.length; i++) { 
			if (myargs[i].equalsIgnoreCase (check)) {
				return i;
			}
		}
		return -1;
	}

	static String COM_Parse (Tokenizer tok) {
		try {
scan:
			while (true) {
				switch (tok.nextToken ()) {
				case Tokenizer.TT_EOF:
//					System.out.println ("eof");
					break scan;
				case Tokenizer.TT_EOL:
//					System.out.println ("eol");
					break;
				case Tokenizer.TT_TOK:
//					System.out.println ("word: " + tok.sval);
					return tok.sval;
				}
			}
		} catch (IOException e) {}
		return null;
	}
}

class Tokenizer {
	private static BufferedReader reader = null;
	private static String data = "";

	public static final int TT_EOF = -1;
	public static final int TT_EOL = '\n';
	public static final int TT_TOK = 0;
	public static String sval = null;

	public Tokenizer (BufferedReader r) {
		reader = r;
	}

	public int nextToken() throws IOException {
		char c;
		int len = 0;

		sval = "";	
		if (data.equals ("")) {
			data = reader.readLine ();
			if (data == null) return TT_EOF;	
		}

		if (data.length () == 0) return TT_EOL;

// skip whitespace
skipwhite:
		while (true) {
			try {
				while ((c = data.charAt (0)) <= ' ') {
					data = data.substring (1);
					if (data == null) return TT_EOL;
				}
			} catch (Exception e) {
				return TT_EOL;
			}
	
// skip // comments
			if (c == '/' && data.charAt (1) == '/') {
				while (data != null && data.charAt (0) != '\n')
					data = data.substring (1);
				continue skipwhite;
			}
	

// handle quoted strings specially
			if (c == '\"') {
				data = data.substring (1);
				do {
					c = data.charAt (0);
					data = data.substring (1);
					if (c == '\"') return TT_TOK;
					sval += c;
				} while (true);
			}

// parse single characters
			if (c == '{' || c == '}' || 
			    c == ')' || c == '(' || c == '\'' || c == ':') {
				sval += c;
				data = data.substring (1);
				return TT_TOK;
			}

// parse a regular word
			do {
				sval += c;
				try {
					data = data.substring (1);
					c = data.charAt (0);
				} catch (Exception e) {
					break;
				}
				if (c == '{' || c == '}' || 
				    c == ')'|| c == '(' || c == '\'' || c == ':')
					break;
			} while (c > 32);
		
			return TT_TOK;
		}
	}
}	

class Parser {

	public boolean compileFile (String filename) {
		BufferedReader br;

		try {
			br = new BufferedReader (new FileReader (filename));
		} catch (FileNotFoundException e) {
			System.out.println ("Error opening: " + filename);
			return false;
		}

		String data = "moo";

		clearGrabMacros ();
		newLine (data);
		lex (data);

		return true;
	}

	void clearGrabMacros () {
		System.out.println ("clearGrabMacros ()");
	}

	void newLine (String data) {
		System.out.println ("newLine (" + data + ")");
	}

	void lex (String data) {
		System.out.println ("lex (" + data + ")");
	}

	void beginCompilation () {
		System.out.println ("beginCompilation ()");
	}

	void finishCompilation () {
		System.out.println ("finishCompilation ()");
	}

	void writeProgdefs (String filename) {
		System.out.println ("writeProgdefs (" + filename + ")");
	}
	
	void writeData () {
		System.out.println ("writeData ()");
	}
	
	void writeFiles () {
		System.out.println ("writeFiles ()");
	}
}

/* end of file */
