/* tab setting: 4
 *
 * holo.c
 *
 * holograph for quake 2 (basic)
 *
 * from the weapons factory/orange.  to add to a patch add
 * #include "holo.h" at the top and the following code to
 * g_cmds.c
 *
 * else if (Q_stricmp (cmd, "holo") == 0)
 *   Cmd_Holo_f (ent);
 *
 * 27 march 1998        jet@poboxes.com
 */

#include "g_local.h"
#include "m_player.h"


#define HOLO_DURATION		30
#define HOLO_COST			10

/*
 * Local functions
 */

void holo_stand (edict_t *self);
void remove_holo (edict_t *self);
void spawn_holo (edict_t *self);


/*
 * Global functions
 */

void Cmd_Holo_f (edict_t *self) 
{
	char *string = gi.args();
	int  turnon;

	if (Q_stricmp (string, "on") == 0) 
		turnon = true;
	else if (Q_stricmp (string, "off") == 0) 
		turnon = false;
	else 
		turnon = !self->holo;

	if ((turnon == true) && (self->holo)) return;
	if ((turnon == false) && !(self->holo)) return;
	if (self->holo) {
		remove_holo (self->holo);
		return;
	}

	{
		int index = ITEM_INDEX(FindItem ("cells"));
		int cells = self->client->pers.inventory[index];

		if (cells < HOLO_COST) {
			gi.cprintf (self, PRINT_HIGH, "Cells are low.\n");
			return;
		}
		cells -= HOLO_COST;
		self->client->pers.inventory[index] = cells;
	}

	spawn_holo (self);
	gi.cprintf (self, PRINT_HIGH, "Holograph activated.\n");
}

void holo_stand (edict_t *self)
{
	self->think = holo_stand;
	self->nextthink = level.time + 1;
	self->health -= 1;
	if (self->health <= 0) remove_holo (self);
}

void remove_holo (edict_t *self)
{
	// flash out
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (self-g_edicts);
	gi.WriteByte (MZ_LOGOUT);
	gi.multicast (self->s.origin, MULTICAST_PVS);

	gi.cprintf (self->owner, PRINT_HIGH, "Holograph expired.\n");
	self->owner->holo = NULL;
	G_FreeEdict (self);
}

void spawn_holo (edict_t *self)
{
    edict_t *holo;
	vec3_t forward;

	holo = G_Spawn ();

	// Place decoy 100 units forward of our position
    AngleVectors (self->client->v_angle, forward, NULL, NULL);
    VectorMA (self->s.origin, 100, forward, holo->s.origin);
	VectorCopy (self->s.angles, holo->s.angles);
 
	//Link two entities together
	self->holo  = holo;	//for the owner, this is a pointer to the decoy
	holo->owner = self;	//for the decoy, this is a pointer to the owner

	//Use same model and skin as the person creating decoy
	holo->model			= self->model;
	holo->s.skinnum		= self->s.skinnum;
	holo->s.modelindex	= self->s.modelindex;
	holo->s.modelindex2 = self->s.modelindex2;

	holo->s.effects		= 0;
	holo->s.frame		= 0;
	holo->classname		= "holo";
	holo->health		= HOLO_DURATION;
	
	VectorSet (holo->mins, -16, -16, -24);
	VectorSet (holo->maxs, 16, 16, 32);
	holo->movetype = MOVETYPE_TOSS;
	holo->solid    = SOLID_NOT;

	holo->think = holo_stand;
	holo->nextthink = level.time;

	// flash in
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (holo-g_edicts);
	gi.WriteByte (MZ_LOGIN);
	gi.multicast (holo->s.origin, MULTICAST_PVS);

	gi.linkentity (holo);
}

/* end of file */
