/* tab setting: 3
 *
 * l_gibstats.c
 *
 * file including all functions for Gibstats logging support v. 1.22
 *
 *
 */

#include "g_local.h"
#include "l_gibstats.h"

/*
 * Global variables
 */

qboolean gs_enabled = false;
cvar_t *gibstats;
FILE *gs_file;

/*
 * Local functions
 */

static char *get_weapon_name (edict_t *self, edict_t *attacker) {
	int mod = meansOfDeath & ~MOD_FRIENDLY_FIRE;

	switch (mod) {
	case MOD_FALLING:
		return "fall";
	case MOD_CRUSH:
		return "crush";
	case MOD_WATER:
		return "water";
	case MOD_SLIME:
		return "slime";
	case MOD_LAVA:
		return "lava";
	case MOD_EXPLOSIVE:
	case MOD_BARREL:
		return "explode";
	case MOD_EXIT:
		return "exit";
	case MOD_TARGET_LASER:
		return "laser";
	case MOD_TARGET_BLASTER:
		return "blaster";
	default:
		break;
	}

	if (attacker == self) {
		switch (mod) {
		case MOD_HELD_GRENADE:
		case MOD_HG_SPLASH:
			return "handgrenade";
		case MOD_G_SPLASH:
			return "grenade";
		case MOD_R_SPLASH:
			return "rocket";
		case MOD_BFG_BLAST:
			return "bfg";
		default:
			return NULL;
		}
	}

	if (attacker && attacker->client) {

		switch (mod) {
		case MOD_BLASTER:
			return "blaster";
		case MOD_SHOTGUN:
			return "shotgun";
		case MOD_SSHOTGUN:
         return "sshotgun";
      case MOD_MACHINEGUN:
         return "machinegun";
      case MOD_CHAINGUN:
         return "chaingun";
      case MOD_GRENADE:
      case MOD_G_SPLASH:
         return "grenade";
      case MOD_ROCKET:
      case MOD_R_SPLASH:
         return "rocket";
      case MOD_HYPERBLASTER:
         return "hyperblaster";
      case MOD_RAILGUN:
         return "railgun";
	   case MOD_BFG_LASER:
		case MOD_BFG_BLAST:
      case MOD_BFG_EFFECT:
         return "bfg";
      case MOD_HANDGRENADE:
      case MOD_HG_SPLASH:
      case MOD_HELD_GRENADE:
         return "handgrenade";
      case MOD_TELEFRAG:
         return "telefrag";
#if 1
      case MOD_GRAPPLE:
         return "grapple";
#endif
      default:
         return NULL;
      }
   }
   return NULL;
}


/*
 * Global functions
 */

void gs_shutdown () {
   fprintf (gs_file, "\t\tGameEnd\t\t\t%.1f\n", level.time);
   fclose (gs_file);
}

void gs_init () {
	gibstats = gi.cvar ("gibstats", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (!gibstats->value) {
		gs_enabled = false;
		return;
	}
   
	if ((gs_file = fopen ("StdLog.log", "a")) == NULL) {
      gi.dprintf ("l_gibstats.c: could not append to file StdLog.log\n");
      gs_enabled = false;
      return;
   }

   gi.dprintf ("Gibstats logging enabled\n");
   fprintf (gs_file, "\t\tStdLog\t1.22\n");
   fprintf (gs_file, "\t\tPatchName\tGSCTFLogMod 1.0\n");
   gs_enabled = true;
}

void gs_map_start (void)
{
   fprintf (gs_file, "\t\tMAP\t%s\n", level.level_name);
   fprintf (gs_file, "\t\tGameStart\t\t\t%.1f\n", level.time);
}

void gs_write_death (edict_t *self, edict_t *inflictor, edict_t *attacker)
{
   /* A Suicide occured */
   if (attacker == self) {
      char *weapon = get_weapon_name (self, attacker);

		if (weapon)
         fprintf (gs_file, "%s\t\tSuicide\t%s\t-1\t%.1f\n",self->client->pers.netname, weapon, level.time);
      else
         fprintf (gs_file, "%s\t\tSuicide\t\t-1\t%.1f\n", self->client->pers.netname, level.time);
      return;
   }

   /* A frag player killed player occured */
   if (attacker && attacker->client) {
      fprintf (gs_file, "%s\t%s\tKill\t%s\t1\t%.1f\n", attacker->client->pers.netname,self->client->pers.netname, attacker->client->pers.weapon->pickup_name, level.time);
      return;
   }
      
   /* Print other deaths - all suicides without a weapon */
   fprintf (gs_file, "%s\t\tSuicide\t\t-1\t%.1f\n", self->client->pers.netname, level.time);
}

void gs_player_entered (edict_t *ent)
{
   fprintf (gs_file, "\t\tPlayerConnect\t%s\t\t%.1f\n", ent->client->pers.netname, level.time);
}

void gs_disconnect (edict_t *ent)
{
   fprintf (gs_file, "\t\tPlayerLeft\t%s\t\t%.1f\n", ent->client->pers.netname, level.time);
}

void gs_name_change (char *oldname, char *newname)
{
   fprintf (gs_file, "\t\tPlayerRename\t%s\t%s\t%.1f\n", oldname, newname, level.time);
}


/* end of file */
