#include "g_local.h"

void AlternateMenuSelection(edict_t *ent){
	if(ent->client->pers.menuselection == TEAM_RED)
		ent->client->pers.menuselection = TEAM_BLUE;
	else
		ent->client->pers.menuselection = TEAM_RED;
	ent->client->pers.printframe = 0;
}

void JoinTeam(edict_t *ent, char *s){
	if(Q_strcasecmp(s, "blaster") == 0)
		ent->client->resp.team = TEAM_RED;
	else if(Q_strcasecmp(s, "shotgun") == 0)
		ent->client->resp.team = TEAM_BLUE;
	if(ent->client->resp.team != 0){
		gi.bprintf(PRINT_HIGH, "%s joined the %s team\n", ent->client->pers.netname, TeamName(ent->client->resp.team));
		respawn(ent);
	}
}

char *TeamName(int team){
	if(team == TEAM_RED)
		return "RED";
	else if(team == TEAM_BLUE)
		return "BLUE";
	return "SPECTATOR";
}

void MenuJoinTeam(edict_t *ent){
	ent->client->resp.team = ent->client->pers.menuselection;
	gi.bprintf(PRINT_HIGH, "%s joined the %s team\n", ent->client->pers.netname, TeamName(ent->client->resp.team));
	respawn(ent);
}

void GrappleFire(edict_t *ent){
	vec3_t start;
	vec3_t forward;
	vec3_t end;
	trace_t tr;

	if(ent->client->resp.team == 0 || ent->health <= 0)
		return;
	if(ent->client->pers.grappleout == 1){
		ent->client->pers.grappleout = 0;
	}else{
		VectorCopy(ent->s.origin, start);
		start[2] += ent->viewheight - 7;
		AngleVectors(ent->client->v_angle, forward, NULL, NULL);
		VectorMA(start, 8192, forward, end);
		tr = gi.trace(start, NULL, NULL, end, ent, MASK_SHOT);
		if(tr.surface && (tr.surface->flags & SURF_SKY))
			ent->client->pers.grappleout = 0;
		else
			ent->client->pers.grappleout = 1;
		if(tr.ent){
			ent->client->pers.grappleent = tr.ent;
			VectorSubtract(tr.ent->s.origin, tr.endpos, ent->client->pers.grapplepos);
		}else{
			ent->client->pers.grappleent = NULL;
			VectorCopy(tr.endpos, ent->client->pers.grapplepos);
		}
	}
}

void Team(edict_t *ent, char *team){
	int newteam = TeamNumber(team);

	if(newteam == 0){
		if(ent->client->resp.team != 0)
			gi.cprintf(ent, PRINT_MEDIUM, "You are on the %s team\n", TeamName(ent->client->resp.team));
		else
			gi.cprintf(ent, PRINT_MEDIUM, "You are a SPECTATOR\n");
	}else if(newteam == ent->client->resp.team)
		gi.cprintf(ent, PRINT_MEDIUM, "You are already on the %s team\n", TeamName(ent->client->resp.team));
	else if(ent->client->resp.team == 0){
		ent->client->resp.team = newteam;
		gi.bprintf(PRINT_MEDIUM, "%s joined the %s team\n", ent->client->pers.netname, TeamName(ent->client->resp.team));
		respawn(ent);
	}else{
		ent->client->resp.team = newteam;
		ent->health = 0;
		player_die(ent, ent, ent, 100000, vec3_origin);
		ent->client->resp.score = 0;
		gi.bprintf(PRINT_MEDIUM, "%s changed to the %s team\n", ent->client->pers.netname, TeamName(ent->client->resp.team));
	}
}

int TeamNumber(char *s){
	if(Q_stricmp(s, "red") == 0)
		return TEAM_RED;
	else if(Q_stricmp(s, "blue") == 0)
		return TEAM_BLUE;
	return 0;
}

void Id(edict_t *ent){
	vec3_t start;
	vec3_t forward;
	vec3_t end;
	trace_t tr;

	VectorCopy(ent->s.origin, start);
	start[2] += ent->viewheight - 7;
	AngleVectors(ent->client->v_angle, forward, NULL, NULL);
	VectorMA(start, 8192, forward, end);
	tr = gi.trace(start, NULL, NULL, end, ent, MASK_SHOT);
	if(tr.ent->client){
		gi.centerprintf(ent, "%s", tr.ent->client->pers.netname);
		ent->client->pers.printframe = level.framenum;
	}
}

void Time(edict_t *ent){
	time_t ttime;
	struct tm *ltime;

	time((unsigned long *)&ttime);
	ltime = gmtime((unsigned int *)&ttime);
	gi.cprintf(ent, PRINT_MEDIUM, "%d:%d GMT\n", ltime->tm_hour, ltime->tm_min);
}

void CheckTeamLimit(void){
	if(teamlimit->value){
		if(level.redscore >= teamlimit->value || level.bluescore >= teamlimit->value){
			gi.bprintf(PRINT_HIGH, "Teamlimit hit.\n");
			EndDMLevel();
		}
	}
}

void InitBases(FILE *file){
	char *c;

	fscanf(file, "%s", c);
	level.redcorner1[0] = atoi(c);
	fscanf(file, "%s", c);
	level.redcorner1[1] = atoi(c);
	fscanf(file, "%s", c);
	level.redcorner1[2] = atoi(c);
	fscanf(file, "%s", c);
	level.redcorner2[0] = atoi(c);
	fscanf(file, "%s", c);
	level.redcorner2[1] = atoi(c);
	fscanf(file, "%s", c);
	level.redcorner2[2] = atoi(c);
	fscanf(file, "%s", c);
	level.bluecorner1[0] = atoi(c);
	fscanf(file, "%s", c);
	level.bluecorner1[1] = atoi(c);
	fscanf(file, "%s", c);
	level.bluecorner1[2] = atoi(c);
	fscanf(file, "%s", c);
	level.bluecorner2[0] = atoi(c);
	fscanf(file, "%s", c);
	level.bluecorner2[1] = atoi(c);
	fscanf(file, "%s", c);
	level.bluecorner2[2] = atoi(c);
}

void CheckBases(void){
	int i = 0;
	edict_t *e;
	int base;
	int redinred = 0;
	int redinblue = 0;
	int blueinred = 0;
	int blueinblue = 0;

	if(level.intermissiontime)
		return;
	while(i < game.maxclients){
		e = g_edicts + 1 + i;
		if(e->inuse && !e->deadflag){
			if(game.clients[i].resp.team != 0){
				base = InBase(game.clients[i].ps.pmove.origin);
				if(game.clients[i].resp.team == TEAM_RED && base == TEAM_RED)
					redinred++;
				else if(game.clients[i].resp.team == TEAM_RED && base == TEAM_BLUE)
					redinblue++;
				else if(game.clients[i].resp.team == TEAM_BLUE && base == TEAM_RED)
					blueinred++;
				else if(game.clients[i].resp.team == TEAM_BLUE && base == TEAM_BLUE)
					blueinblue++;
			}
		}
		i++;
	}
	if(redinred == 0 && blueinred > 0 && level.framenum - level.blueframe >= 25){
		level.bluescore++;
		AddScore(TEAM_BLUE);
		level.blueframe = level.framenum;
	}
	if(blueinblue == 0 && redinblue > 0 && level.framenum - level.redframe >= 25){
		level.redscore++;
		AddScore(TEAM_RED);
		level.redframe = level.framenum;
	}
}

int InBase(short origin[3]){//returns 0 if not in base, SO_RED if in red, SO_BLUE if in blue
	if(In(origin, level.redcorner1, level.redcorner2) == 1)
		return TEAM_RED;
	else if(In(origin, level.bluecorner1, level.bluecorner2) == 1)
		return TEAM_BLUE;
	else
		return 0;
}

int In(short a[3], short b[3], short c[3]){//returns 1 if a is in b and c
	if(((a[0] >= b[0] && a[0] <= c[0]) || (a[0] <= b[0] && a[0] >= c[0])) && ((a[1] >= b[1] && a[1] <= c[1]) || (a[1] <= b[1] && a[1] >= c[1])) && ((a[2] >= b[2] && a[2] <= c[2]) || (a[2] <= b[2] && a[2] >= c[2])))
		return 1;
	else
		return 0;
}

void AddScore(int team){
	int i = 0;
	edict_t *e;

	while(i < game.maxclients){
		e = g_edicts + 1 + i;
		if(e->inuse){
			if(game.clients[i].resp.team == team)
				game.clients[i].resp.score++;
		}
		i++;
	}
}

int IgnoreSpawn(char *classname){//returns 1 if spawn should be ignored
	if(strcmp(classname, "info_player_team1") == 0)
		return 1;
	if(strcmp(classname, "info_player_team2") == 0)
		return 1;
	if(strcmp(classname, "item_flag_team1") == 0)
		return 1;
	if(strcmp(classname, "item_flag_team2") == 0)
		return 1;
	if(strcmp(classname, "misc_ctf_banner") == 0)
		return 1;
	if(strcmp(classname, "misc_ctf_small_banner") == 0)
		return 1;
	return 0;
}

void FragBonuses(edict_t *self, edict_t *attacker){
	int sbase;
	int abase;

	if(self == attacker || !self->client || !attacker->client)
		return;

	//Defending Team Base
	sbase = InBase(self->client->ps.pmove.origin);
	abase = InBase(attacker->client->ps.pmove.origin);
	if(abase == attacker->client->resp.team || sbase == attacker->client->resp.team){
		gi.bprintf(PRINT_MEDIUM, "%s defends the %s base\n", attacker->client->pers.netname, TeamName(attacker->client->resp.team));		
		attacker->client->resp.score++;
		return;
	}
}

void SetMenuSelection(gclient_t *client){
	int i;
	edict_t *e;
	int bluetotal = 0;
	int redtotal = 0;
	int selection;

	while(i < game.maxclients){
		e = g_edicts + 1 + i;
		if(e->inuse){
			if(e->client->resp.team == TEAM_RED)
				redtotal++;
			if(e->client->resp.team == TEAM_BLUE)
				bluetotal++;
		}
		i++;
	}
	if(redtotal > bluetotal)
		selection = TEAM_BLUE;
	else if(bluetotal > redtotal)
		selection = TEAM_RED;
	else if(level.redscore > level.bluescore)
		selection = TEAM_BLUE;
	else
		selection = TEAM_RED;
	client->pers.menuselection = selection;
}

void AliasGrapple(edict_t *ent){
        gi.WriteByte(11);
        gi.WriteString("alias +grapple \"cmd +grapple\"; alias -grapple \"cmd -grapple\"");
        gi.unicast(ent, true);
}

char *Skin(edict_t *ent){
	char *s;

	if(IsFemale(ent))
		strcat(s, "female/");
	else
		strcat(s, "male/");
	if(ent->client->resp.team == TEAM_RED)
		strcat(s, "ctf_r");
	else
		strcat(s, "ctf_b");
	return s;
}

void DisplayMenu(edict_t *ent){
	if(level.framenum - ent->client->pers.printframe >= 20 && ent->client->resp.team == 0){
		if(ent->client->pers.menuselection == TEAM_RED)
			gi.centerprintf(ent, "Stand Off v2.2\n\n(www.captured.com/modshop)\n\n\n-> 1. Red Team\n\n   2. Blue Team");
		else
			gi.centerprintf(ent, "Stand Off v2.2\n\n(www.captured.com/modshop)\n\n\n   1. Red Team\n\n-> 2. Blue Team");
		ent->client->pers.printframe = level.framenum;
      }
}

void GrappleMove(edict_t *ent){
	vec3_t start;
	vec3_t end;
	vec3_t dir;

	if(ent->client->pers.grappleout == 0)
		return;
	ent->client->ps.pmove.gravity = 0;
	VectorCopy(ent->s.origin, start);
	start[2] += ent->viewheight - 7;
	if(ent->client->pers.grappleent){
		VectorSubtract(ent->client->pers.grappleent->s.origin, ent->client->pers.grapplepos, end);
		if(ent->client->pers.grappleent->takedamage){
			VectorSubtract(ent->s.origin, end, dir);
			T_Damage(ent->client->pers.grappleent, ent, ent, dir, end, end, 1, 1, DAMAGE_ENERGY, MOD_GRAPPLE);
		}
	}else
		VectorCopy(ent->client->pers.grapplepos, end);
	VectorSubtract(end, start, ent->velocity);
	VectorScale(ent->velocity, 2, ent->velocity);
	VectorMax(ent->velocity, 1000);
}

void VectorMax(vec3_t vec, int max){
	vec3_t v;
	float maxvector = 1000;

	VectorCopy(vec, v);
	AbsoluteValueVector(v);
	if(v[0] > maxvector)
		maxvector = v[0];
	if(v[1] > maxvector)
		maxvector = v[1];
	if(v[2] > maxvector)
		maxvector = v[2];
	VectorScale(vec, max / maxvector, vec);
}

void AbsoluteValueVector(vec3_t v){
	if(v[0] < 0)
		v[0] *= -1;
	if(v[1] < 0)
		v[1] *= -1;
	if(v[2] < 0)
		v[2] *= -1;
}

void GrappleDraw(edict_t *ent){
	vec3_t start;
	vec3_t end;
	vec3_t distance;

	if(ent->client->pers.grappleout == 0)
		return;
	VectorCopy(ent->s.origin, start);
	start[2] += ent->viewheight - 7;
	if(ent->client->pers.grappleent)
		VectorSubtract(ent->client->pers.grappleent->s.origin, ent->client->pers.grapplepos, end);
	else
		VectorCopy(ent->client->pers.grapplepos, end);
	VectorSubtract(start, end, distance);
	AbsoluteValueVector(distance);
	if(distance[0] > 64 || distance[1] > 64 || distance[2] > 64){
		gi.WriteByte(svc_temp_entity);
		gi.WriteByte(TE_BFG_LASER);
		gi.WritePosition(start);
		gi.WritePosition(end);
		gi.multicast(start, MULTICAST_PHS);
	}
}

void StandOffScoreboard(edict_t *ent){
	int total = 0;
	int i;
	edict_t *cl_ent;
	int score;
	int j;
	int k;
	int sorted[MAX_CLIENTS];
	int sortedscores[MAX_CLIENTS];
	char string[1400];
	int stringlength;
	gclient_t *cl;
	char entry[1024];
	int x;
	int redtotal = 0;
	int bluetotal = 0;
	int y;

	for(i=0 ; i<game.maxclients ; i++){
		cl_ent = g_edicts + 1 + i;
		if(!cl_ent->inuse || game.clients[i].resp.spectator)
			continue;
		score = game.clients[i].resp.score;
		for(j=0 ; j<total ; j++){
			if(score > sortedscores[j])
				break;
		}
		for(k=total ; k>j ; k--){
			sorted[k] = sorted[k-1];
			sortedscores[k] = sortedscores[k-1];
		}
		sorted[j] = i;
		sortedscores[j] = score;
		total++;
	}

	string[0] = 0;
	stringlength = strlen(string);

	Com_sprintf(entry, sizeof(entry), "xv 8 yv 8 picn ctfsb1 xv 168 yv 8 picn ctfsb2 ");
	j = strlen(entry);
	strcpy(string + stringlength, entry);
	stringlength += j;

	for (i=0 ; i<total ; i++){
		cl = &game.clients[sorted[i]];
		if(cl->resp.team == TEAM_RED){
			x = 0;
			y = redtotal * 8 + 42;
			redtotal++;
		}else{
			x = 160;
			y = bluetotal * 8 + 42;
			bluetotal++;
		}
		if((cl->resp.team == TEAM_RED && redtotal <= 16) || (cl->resp.team == TEAM_BLUE && bluetotal <= 16)){
			Com_sprintf(entry, sizeof(entry), "xv %d yv %d string \"%3d %3d %-12.12s\" ", x, y, cl->resp.score, (cl->ping > 999) ? 999 : cl->ping, cl->pers.netname);
			j = strlen(entry);
			if(stringlength + j > 1024)
				break;
			strcpy(string + stringlength, entry);
			stringlength += j;
		}
	}

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}

void GetStandOffStats(edict_t *ent){
	int i;

	//STAT_INBASE
	i = InBase(ent->client->ps.pmove.origin);
	if(i == TEAM_RED)
		ent->client->ps.stats[STAT_INBASE] = gi.imageindex("i_ctf1");
	else if(i == TEAM_BLUE)
		ent->client->ps.stats[STAT_INBASE] = gi.imageindex("i_ctf2");
	else
		ent->client->ps.stats[STAT_INBASE] = 0;


	//STAT_REDICON
	ent->client->ps.stats[STAT_REDICON] = gi.imageindex("i_ctf1");

	//STAT_REDSCORE
	ent->client->ps.stats[STAT_REDSCORE] = level.redscore;

	//STAT_BLUEICON
	ent->client->ps.stats[STAT_BLUEICON] = gi.imageindex("i_ctf2");

	//STAT_BLUESCORE
	ent->client->ps.stats[STAT_BLUESCORE] = level.bluescore;

	//STAT_ONRED
	if(ent->client->resp.team == TEAM_RED)
		ent->client->ps.stats[STAT_ONRED] = gi.imageindex("i_ctfj");
	else
		ent->client->ps.stats[STAT_ONRED] = 0;

	//STAT_ONBLUE
	if(ent->client->resp.team == TEAM_BLUE)
		ent->client->ps.stats[STAT_ONBLUE] = gi.imageindex("i_ctfj");
	else
		ent->client->ps.stats[STAT_ONBLUE] = 0;
}
