#include "g_local.h"

int HealthCost(char *s){
	if(Q_stricmp(s, "shotgun") == 0)
		return 0;
	else if(Q_stricmp(s, "super shotgun") == 0)
		return 20;
	else if(Q_stricmp(s, "machinegun") == 0)
		return 40;
	else if(Q_stricmp(s, "chaingun") == 0)
		return 60;
	else if(Q_stricmp(s, "grenade launcher") == 0)
		return 80;
	else if(Q_stricmp(s, "rocket launcher") == 0)
		return 100;
	else if(Q_stricmp(s, "hyperblaster") == 0)
		return 120;
	else if(Q_stricmp(s, "railgun") == 0)
		return 140;
	else if(Q_stricmp(s, "bfg10k") == 0)
		return 160;
	else if(Q_stricmp(s, "grenades") == 0)
		return 0;
	return 0;
}

int ArmorCost(char *s){
	if(Q_stricmp(s, "shotgun") == 0)
		return 20;
	else if(Q_stricmp(s, "super shotgun") == 0)
		return 30;
	else if(Q_stricmp(s, "machinegun") == 0)
		return 40;
	else if(Q_stricmp(s, "chaingun") == 0)
		return 50;
	else if(Q_stricmp(s, "grenade launcher") == 0)
		return 60;
	else if(Q_stricmp(s, "rocket launcher") == 0)
		return 70;
	else if(Q_stricmp(s, "hyperblaster") == 0)
		return 80;
	else if(Q_stricmp(s, "railgun") == 0)
		return 90;
	else if(Q_stricmp(s, "bfg10k") == 0)
		return 100;
	else if(Q_stricmp(s, "grenades") == 0)
		return 20;
	return 0;
}

void BuyWeapon(edict_t *ent, gitem_t *it){
	int healthcost = HealthCost(it->pickup_name);
	int armorcost = ArmorCost(it->pickup_name);
	gitem_t *ammo;

	if(ent->health <= healthcost || ent->max_health <= healthcost){
		gi.cprintf(ent, PRINT_HIGH, "Not enough health for weapon.\n");
		return;
	}
	if(ArmorIndex(ent) == 0 || ent->client->pers.inventory[ArmorIndex(ent)] < armorcost || ent->client->pers.max_armor < armorcost){
		gi.cprintf(ent, PRINT_HIGH, "Not enough armor for weapon.\n");
		return;
	}
	ent->health -= healthcost;
	ent->max_health -= healthcost;
	ent->client->pers.inventory[ArmorIndex(ent)] -= armorcost;
	ent->client->pers.max_armor -= armorcost;
	ent->client->pers.inventory[ITEM_INDEX(it)] = 1;
	ammo = FindItem(it->ammo);
	if((int) dmflags->value & DF_INFINITE_AMMO)
		Add_Ammo(ent, ammo, 1000);
	else
		Add_Ammo(ent, ammo, ammo->quantity * ammomultiplier->value);
	it->use(ent, it);

}

void Id(edict_t *ent){
	vec3_t start;
	vec3_t forward;
	vec3_t end;
	trace_t tr;

	VectorCopy(ent->s.origin, start);
	start[2] += ent->viewheight - 7;
	AngleVectors(ent->client->v_angle, forward, NULL, NULL);
	VectorMA(start, 8192, forward, end);
	tr = gi.trace(start, NULL, NULL, end, ent, MASK_SHOT);
	if(tr.ent->client)
		gi.centerprintf(ent, "%s", tr.ent->client->pers.netname);
}

void Time(edict_t *ent){
	time_t ttime;
	struct tm *ltime;

	time((unsigned long *)&ttime);
	ltime = gmtime((unsigned int *)&ttime);
	gi.cprintf(ent, PRINT_MEDIUM, "%d:%d GMT\n", ltime->tm_hour, ltime->tm_min);
}

int OKToSpawnItem(gitem_t *item){
	if((item->flags & IT_WEAPON) && (item != FindItem("grenades")))
		return 0;
	if((noammo->value) && (item->flags & IT_AMMO))
		return 0;
	if(arenamode->value)
		return 0;
	return 1;
}

int OKToSpawnEnt(edict_t *ent){
	if((arenamode->value) && (Q_stricmp(ent->classname, "item_health") == 0 || Q_stricmp(ent->classname, "item_health_small") == 0 || Q_stricmp(ent->classname, "item_health_large") == 0 || Q_stricmp(ent->classname, "item_health_mega") == 0))
		return 0;
	return 1;
}

void BuyAmmo(edict_t *ent){
	gitem_t *weapon;
	gitem_t *ammo;

	weapon = ent->client->pers.weapon;
	if(ent->client->newweapon != ent->client->pers.weapon && ent->client->newweapon != NULL)
		weapon = ent->client->newweapon;
	if(weapon == FindItem("Blaster")){
		gi.cprintf(ent, PRINT_HIGH, "Blaster does not require ammo.\n");
		return;
	}
	if(ent->health <= 10){
		gi.cprintf(ent, PRINT_HIGH, "Not enough health for ammo.\n");
		return;
	}

	ammo = FindItem(weapon->ammo);
	if(!Add_Ammo(ent, ammo, ammo->quantity)){
		gi.cprintf(ent, PRINT_HIGH, "Already at maximum capacity.\n");
		return;
	}
	ent->health -= 10;
}
