#include "g_local.h"

void AlternateMenuSelection(edict_t *ent){
	if(ent->client->pers.menuselection == TEAM_RED)
		ent->client->pers.menuselection = TEAM_BLUE;
	else
		ent->client->pers.menuselection = TEAM_RED;
	ent->client->pers.printframe = 0;
}

void JoinTeam(edict_t *ent, char *s){
	if(Q_strcasecmp(s, "blaster") == 0)
		ent->client->resp.team = TEAM_RED;
	else if(Q_strcasecmp(s, "shotgun") == 0)
		ent->client->resp.team = TEAM_BLUE;
	if(ent->client->resp.team != 0){
		gi.bprintf(PRINT_HIGH, "%s joined the %s team\n", ent->client->pers.netname, TeamName(ent->client->resp.team));
		respawn(ent);
	}
}

char *TeamName(int team){
	if(team == TEAM_RED)
		return "RED";
	else if(team == TEAM_BLUE)
		return "BLUE";
	return "SPECTATOR";
}

void MenuJoinTeam(edict_t *ent){
	ent->client->resp.team = ent->client->pers.menuselection;
	gi.bprintf(PRINT_HIGH, "%s joined the %s team\n", ent->client->pers.netname, TeamName(ent->client->resp.team));
	respawn(ent);
}

void GrappleFire(edict_t *ent){
	vec3_t start;
	vec3_t forward;
	vec3_t end;
	trace_t tr;

	if(ent->client->resp.team == 0 || ent->health <= 0)
		return;
	if(ent->client->pers.grappleout == 1){
		ent->client->pers.grappleout = 0;
	}else{
		VectorCopy(ent->s.origin, start);
		start[2] += ent->viewheight - 7;
		AngleVectors(ent->client->v_angle, forward, NULL, NULL);
		VectorMA(start, 8192, forward, end);
		tr = gi.trace(start, NULL, NULL, end, ent, MASK_SHOT);
		if(tr.surface && (tr.surface->flags & SURF_SKY))
			ent->client->pers.grappleout = 0;
		else
			ent->client->pers.grappleout = 1;
		if(tr.ent){
			ent->client->pers.grappleent = tr.ent;
			VectorSubtract(tr.ent->s.origin, tr.endpos, ent->client->pers.grapplepos);
		}else{
			ent->client->pers.grappleent = NULL;
			VectorCopy(tr.endpos, ent->client->pers.grapplepos);
		}
	}
}

void Team(edict_t *ent, char *team){
	int newteam = TeamNumber(team);

	if(newteam == 0){
		if(ent->client->resp.team != 0)
			gi.cprintf(ent, PRINT_MEDIUM, "You are on the %s team\n", TeamName(ent->client->resp.team));
		else
			gi.cprintf(ent, PRINT_MEDIUM, "You are a SPECTATOR\n");
	}else if(newteam == ent->client->resp.team)
		gi.cprintf(ent, PRINT_MEDIUM, "You are already on the %s team\n", TeamName(ent->client->resp.team));
	else if(ent->client->resp.team == 0){
		ent->client->resp.team = newteam;
		gi.bprintf(PRINT_MEDIUM, "%s joined the %s team\n", ent->client->pers.netname, TeamName(ent->client->resp.team));
		respawn(ent);
	}else{
		ent->client->resp.team = newteam;
		ent->health = 0;
		player_die(ent, ent, ent, 100000, vec3_origin);
		ent->client->resp.score = 0;
		gi.bprintf(PRINT_MEDIUM, "%s changed to the %s team\n", ent->client->pers.netname, TeamName(ent->client->resp.team));
	}
}

int TeamNumber(char *s){
	if(Q_stricmp(s, "red") == 0)
		return TEAM_RED;
	else if(Q_stricmp(s, "blue") == 0)
		return TEAM_BLUE;
	return 0;
}

void Id(edict_t *ent){
	vec3_t start;
	vec3_t forward;
	vec3_t end;
	trace_t tr;

	VectorCopy(ent->s.origin, start);
	start[2] += ent->viewheight - 7;
	AngleVectors(ent->client->v_angle, forward, NULL, NULL);
	VectorMA(start, 8192, forward, end);
	tr = gi.trace(start, NULL, NULL, end, ent, MASK_SHOT);
	if(tr.ent->client){
		gi.centerprintf(ent, "%s", tr.ent->client->pers.netname);
		ent->client->pers.printframe = level.framenum;
	}
}

void Time(edict_t *ent){
	time_t ttime;
	struct tm *ltime;

	time((unsigned long *)&ttime);
	ltime = gmtime((unsigned int *)&ttime);
	gi.cprintf(ent, PRINT_MEDIUM, "%d:%d GMT\n", ltime->tm_hour, ltime->tm_min);
}

void DropFlags(edict_t *ent){
	gitem_t *redflag = FindItem("Red Flag");
	gitem_t *blueflag = FindItem("Blue Flag");

	if(Has(ent->client, "Red Flag")){
		redflag->drop(ent, redflag);
		gi.bprintf(PRINT_MEDIUM, "%s dropped the RED flag!\n", ent->client->pers.netname);
	}
	if(Has(ent->client, "Blue Flag")){
		blueflag->drop(ent, blueflag);
		gi.bprintf(PRINT_MEDIUM, "%s dropped the BLUE flag!\n", ent->client->pers.netname);
	}
}

int Has(gclient_t *client, char *c){
	return client->pers.inventory[ITEM_INDEX(FindItem(c))];
}

void FlagAttack(edict_t *ent){
	vec3_t start;
	vec3_t forward;
	vec3_t end;
	trace_t tr;
	vec3_t dir;

	if(!Has(ent->client, "Red Flag") && !Has(ent->client, "Blue Flag")){
		gi.cprintf(ent, PRINT_MEDIUM, "You do not have a flag\n");
		return;
	}
	VectorCopy(ent->s.origin, start);
	start[2] += ent->viewheight - 7;
	AngleVectors(ent->client->v_angle, forward, NULL, NULL);
	VectorMA(start, 50, forward, end);
	tr = gi.trace(start, NULL, NULL, end, ent, MASK_SHOT);
	if(tr.ent){
		if(tr.ent->takedamage){
			VectorSubtract(ent->s.origin, tr.endpos, dir);
			T_Damage(tr.ent, ent, ent, dir, tr.endpos, tr.endpos, 100, 100, DAMAGE_ENERGY, MOD_FLAG);
			gi.sound(ent, CHAN_WEAPON, gi.soundindex("mutant/mutatck2.wav"), 1, ATTN_NORM, 0);
			return;
		}
	}
	gi.sound(ent, CHAN_WEAPON, gi.soundindex("mutant/mutatck1.wav"), 1, ATTN_NORM, 0);
}

void ReturnFlag(edict_t *ent){
	if(!(ent->watertype & (CONTENTS_LAVA|CONTENTS_SLIME)))
		return;
	gi.bprintf(PRINT_MEDIUM, "The %s flag has returned!\n", TeamName(FlagTeam(ent)));
	SetFlagReset(ent->classname);
	G_FreeEdict(ent);
}

qboolean PickupFlag(edict_t *ent, edict_t *other){
        int redindex = ITEM_INDEX(FindItem("Red Flag"));
        int blueindex = ITEM_INDEX(FindItem("Blue Flag"));
	int flagteam = FlagTeam(ent);

        other->client->pers.inventory[ITEM_INDEX(ent->item)] = 1;
	if(other->client->pers.inventory[redindex] && other->client->pers.inventory[blueindex]){
		if(capinbase->value == 0)
			CapFlag(other);
		else{
			gi.bprintf(PRINT_MEDIUM, "%s got the %s flag!\n", other->client->pers.netname, TeamName(flagteam));
			if(flagteam == OtherTeam(other->client->resp.team))
				gi.sound(other, CHAN_VOICE, gi.soundindex("ctf/flagtk.wav"), 1, ATTN_NONE, 0);
		}
        }else{
		gi.bprintf(PRINT_MEDIUM, "%s got the %s flag!\n", other->client->pers.netname, TeamName(flagteam));
		if(flagteam == OtherTeam(other->client->resp.team))
			gi.sound(other, CHAN_VOICE, gi.soundindex("ctf/flagtk.wav"), 1, ATTN_NONE, 0);
	}
        if(!(ent->spawnflags & DROPPED_ITEM)){
		ent->flags |= FL_RESPAWN;
		ent->svflags |= SVF_NOCLIENT;
		ent->solid = SOLID_NOT;
		gi.linkentity(ent);
	}
	return true;
}

void CapFlag(edict_t *ent){
	gi.bprintf(PRINT_MEDIUM, "%s captured the %s flag!\n", ent->client->pers.netname, TeamName(OtherTeam(ent->client->resp.team)));
	AddScore(ent->client->resp.team);
	ent->client->resp.score += 5;
	gi.sound(ent, CHAN_VOICE, gi.soundindex("ctf/flagcap.wav"), 1, ATTN_NONE, 0);
	ent->client->pers.inventory[ITEM_INDEX(FindItem("Red Flag"))] = 0;
	ent->client->pers.inventory[ITEM_INDEX(FindItem("Blue Flag"))] = 0;
	SetFlagReset("item_flag_team1");
	SetFlagReset("item_flag_team2");
}

int FlagTeam(edict_t *ent){
	if(strcmp(ent->classname, "item_flag_team1") == 0)
		return TEAM_RED;
	else if(strcmp(ent->classname, "item_flag_team2") == 0)
		return TEAM_BLUE;
	return 0;
}

int OtherTeam(int team){
	if(team == TEAM_RED)
		return TEAM_BLUE;
	else if(team == TEAM_BLUE)
		return TEAM_RED;
	return 0;
}

void AddScore(int team){
	int i = 0;
	edict_t *e;

	if(team == TEAM_RED)
		level.redscore++;
	else if(team == TEAM_BLUE)
		level.bluescore++;
	while(i < game.maxclients){
		e = g_edicts + 1 + i;
		if(e->inuse){
			if(game.clients[i].resp.team == team)
				game.clients[i].resp.score += 10;
		}
		i++;
	}
}

void SetFlagReset(char *c){
	edict_t *ent = NULL;

	while((ent = G_Find(ent, FOFS(classname), c)) != NULL) {
		if(!(ent->spawnflags & DROPPED_ITEM)){
			ent->think = ResetFlag;
			ent->nextthink = level.time + 2;
		}
	}
}

void ResetFlag(edict_t *ent){
	ent->svflags &= ~SVF_NOCLIENT;
	ent->solid = SOLID_TRIGGER;
	gi.linkentity(ent);
	ent->s.event = EV_ITEM_RESPAWN;
	InitFlag(ent);
}

void CheckCapLimit(void){
	if(caplimit->value){
		if(level.redscore >= caplimit->value || level.bluescore >= caplimit->value){
			gi.bprintf(PRINT_HIGH, "Caplimit hit.\n");
			EndDMLevel();
		}
	}
}

void InitFlag(edict_t *ent){
	ent->think = FlagThink;
	ent->nextthink = level.time + FRAMETIME;
}

void FlagThink(edict_t *ent){
	if(ent->solid != SOLID_NOT)
		ent->s.frame = 173 + (((ent->s.frame - 173) + 1) % 16);
	ent->nextthink = level.time + FRAMETIME;
}

int IgnoreSpawn(char *classname){//returns 1 if spawn should be ignored
	if(strcmp(classname, "info_player_team1") == 0)
		return 1;
	if(strcmp(classname, "info_player_team2") == 0)
		return 1;
	if(strcmp(classname, "misc_ctf_banner") == 0)
		return 1;
	if(strcmp(classname, "misc_ctf_small_banner") == 0)
		return 1;
	return 0;
}

void FragBonuses(edict_t *self, edict_t *attacker){
	edict_t *ent;
	int redindex = ITEM_INDEX(FindItem("Red Flag"));
	int blueindex = ITEM_INDEX(FindItem("Blue Flag"));
	char *classname;

	if(self == attacker || !self->client || !attacker->client || self->client->resp.team == attacker->client->resp.team)
		return;

	//Killing Enemy Carrier
	if(Has(self->client, "Red Flag") || Has(self->client, "Blue Flag")){
		gi.bprintf(PRINT_MEDIUM, "%s killed the %s flag carrier!\n", attacker->client->pers.netname, TeamName(self->client->resp.team));
		attacker->client->resp.score++;
	}

	//Protecting Carrier
	ent = NULL;
	while((ent = findradius(ent, attacker->s.origin, 400)) != NULL){
		if(!ent->client || ent == attacker)
			continue;
		if(attacker->client->resp.team == ent->client->resp.team && (Has(ent->client, "Red Flag") || Has(ent->client, "Blue Flag"))){
			gi.bprintf(PRINT_MEDIUM, "%s protected the %s flag carrier!\n", attacker->client->pers.netname, TeamName(attacker->client->resp.team));
			attacker->client->resp.score++;
		}
	}

	//Protecting Flag
	if(attacker->client->resp.team == TEAM_RED)
		strcpy(classname, "item_flag_team1");
	else if(attacker->client->resp.team == TEAM_BLUE)
		strcpy(classname, "item_flag_team2");
	else
		strcpy(classname, "");
	ent = NULL;
	while((ent = findradius(ent, attacker->s.origin, 400)) != NULL){
		if(strcmp(classname, ent->classname) == 0 && ent->solid != SOLID_NOT){
			gi.bprintf(PRINT_MEDIUM, "%s protected the %s flag!\n", attacker->client->pers.netname, TeamName(attacker->client->resp.team));
			attacker->client->resp.score++;
		}
	}
}

void SetMenuSelection(gclient_t *client){
	int i;
	edict_t *e;
	int bluetotal = 0;
	int redtotal = 0;
	int selection;

	while(i < game.maxclients){
		e = g_edicts + 1 + i;
		if(e->inuse){
			if(e->client->resp.team == TEAM_RED)
				redtotal++;
			if(e->client->resp.team == TEAM_BLUE)
				bluetotal++;
		}
		i++;
	}
	if(redtotal > bluetotal)
		selection = TEAM_BLUE;
	else if(bluetotal > redtotal)
		selection = TEAM_RED;
	else if(level.redscore > level.bluescore)
		selection = TEAM_BLUE;
	else
		selection = TEAM_RED;
	client->pers.menuselection = selection;
}

void AliasGrapple(edict_t *ent){
        gi.WriteByte(11);
        gi.WriteString("alias +grapple \"cmd +grapple\"; alias -grapple \"cmd -grapple\"");
        gi.unicast(ent, true);
}

char *Skin(edict_t *ent){
	char *s;

	if(IsFemale(ent))
		strcat(s, "female/");
	else
		strcat(s, "male/");
	if(ent->client->resp.team == TEAM_RED)
		strcat(s, "ctf_r");
	else
		strcat(s, "ctf_b");
	return s;
}

void DisplayMenu(edict_t *ent){
	if(level.framenum - ent->client->pers.printframe >= 20 && ent->client->resp.team == 0){
		if(ent->client->pers.menuselection == TEAM_RED)
			gi.centerprintf(ent, "Another CTF v1.0\n\n(www.captured.com/modshop)\n\n\n-> 1. Red Team\n\n   2. Blue Team");
		else
			gi.centerprintf(ent, "Another CTF v1.0\n\n(www.captured.com/modshop)\n\n\n   1. Red Team\n\n-> 2. Blue Team");
		ent->client->pers.printframe = level.framenum;
      }
}

void GrappleMove(edict_t *ent){
	vec3_t start;
	vec3_t end;
	vec3_t dir;

	if(ent->client->pers.grappleout == 0)
		return;
	ent->client->ps.pmove.gravity = 0;
	VectorCopy(ent->s.origin, start);
	start[2] += ent->viewheight - 7;
	if(ent->client->pers.grappleent){
		VectorSubtract(ent->client->pers.grappleent->s.origin, ent->client->pers.grapplepos, end);
		if(ent->client->pers.grappleent->takedamage){
			VectorSubtract(ent->s.origin, end, dir);
			T_Damage(ent->client->pers.grappleent, ent, ent, dir, end, end, 1, 1, DAMAGE_ENERGY, MOD_GRAPPLE);
		}
	}else
		VectorCopy(ent->client->pers.grapplepos, end);
	VectorSubtract(end, start, ent->velocity);
	VectorScale(ent->velocity, 2, ent->velocity);
	VectorMax(ent->velocity, 1000);
}

void VectorMax(vec3_t vec, int max){
	vec3_t v;
	float maxvector = max;

	VectorCopy(vec, v);
	AbsoluteValueVector(v);
	if(v[0] > maxvector)
		maxvector = v[0];
	if(v[1] > maxvector)
		maxvector = v[1];
	if(v[2] > maxvector)
		maxvector = v[2];
	VectorScale(vec, max / maxvector, vec);
}

void AbsoluteValueVector(vec3_t v){
	if(v[0] < 0)
		v[0] *= -1;
	if(v[1] < 0)
		v[1] *= -1;
	if(v[2] < 0)
		v[2] *= -1;
}

void GrappleDraw(edict_t *ent){
	vec3_t start;
	vec3_t end;
	vec3_t distance;

	if(ent->client->pers.grappleout == 0)
		return;
	VectorCopy(ent->s.origin, start);
	start[2] += ent->viewheight - 7;
	if(ent->client->pers.grappleent)
		VectorSubtract(ent->client->pers.grappleent->s.origin, ent->client->pers.grapplepos, end);
	else
		VectorCopy(ent->client->pers.grapplepos, end);
	VectorSubtract(start, end, distance);
	AbsoluteValueVector(distance);
	if(distance[0] > 64 || distance[1] > 64 || distance[2] > 64){
		gi.WriteByte(svc_temp_entity);
		gi.WriteByte(TE_BFG_LASER);
		gi.WritePosition(start);
		gi.WritePosition(end);
		gi.multicast(start, MULTICAST_PHS);
	}
}

void CheckForCap(edict_t *ent){
	char *c = "";
	edict_t *spot = NULL;
	vec3_t dis;

	if(!Has(ent->client, "Red Flag") || !Has(ent->client, "Blue Flag"))
		return;
	if(ent->client->resp.team == TEAM_RED)
		strcpy(c, "item_flag_team1");
	else if(ent->client->resp.team == TEAM_BLUE)
		strcpy(c, "item_flag_team2");
	spot = G_Find(ent, FOFS(classname), c);
	if(spot == NULL)
		return;
	VectorSubtract(ent->s.origin, spot->s.origin, dis);
	AbsoluteValueVector(dis);
	if(dis[0] <= 100 && dis[1] <= 100 && dis[2] <= 100)
		CapFlag(ent);
}

void AnotherScoreboard(edict_t *ent){
	int total = 0;
	int i;
	edict_t *cl_ent;
	int score;
	int j;
	int k;
	int sorted[MAX_CLIENTS];
	int sortedscores[MAX_CLIENTS];
	char string[1400];
	int stringlength;
	gclient_t *cl;
	char entry[1024];
	int x;
	int redtotal = 0;
	int bluetotal = 0;
	int y;

	for(i=0 ; i<game.maxclients ; i++){
		cl_ent = g_edicts + 1 + i;
		if(!cl_ent->inuse || game.clients[i].resp.spectator)
			continue;
		score = game.clients[i].resp.score;
		for(j=0 ; j<total ; j++){
			if(score > sortedscores[j])
				break;
		}
		for(k=total ; k>j ; k--){
			sorted[k] = sorted[k-1];
			sortedscores[k] = sortedscores[k-1];
		}
		sorted[j] = i;
		sortedscores[j] = score;
		total++;
	}

	string[0] = 0;
	stringlength = strlen(string);

	Com_sprintf(entry, sizeof(entry), "xv 8 yv 8 picn ctfsb1 xv 168 yv 8 picn ctfsb2 ");
	j = strlen(entry);
	strcpy(string + stringlength, entry);
	stringlength += j;

	for (i=0 ; i<total ; i++){
		cl = &game.clients[sorted[i]];
		if(cl->resp.team == TEAM_RED){
			x = 0;
			y = redtotal * 8 + 42;
			redtotal++;
		}else{
			x = 160;
			y = bluetotal * 8 + 42;
			bluetotal++;
		}
		if((cl->resp.team == TEAM_RED && redtotal <= 16) || (cl->resp.team == TEAM_BLUE && bluetotal <= 16)){
			if(Has(cl, "Red Flag") && Has(cl, "Blue Flag")){
				if(CurrentFlag() == TEAM_RED)
					Com_sprintf(entry, sizeof(entry), "yv %d xv %d picn sbfctf1 xv %d string \"%3d %3d %-12.12s\" ", y, x + 56, x, cl->resp.score, (cl->ping > 999) ? 999 : cl->ping, cl->pers.netname);
				else
					Com_sprintf(entry, sizeof(entry), "yv %d xv %d picn sbfctf2 xv %d string \"%3d %3d %-12.12s\" ", y, x + 56, x, cl->resp.score, (cl->ping > 999) ? 999 : cl->ping, cl->pers.netname);
			}else if(Has(cl, "Red Flag"))
				Com_sprintf(entry, sizeof(entry), "yv %d xv %d picn sbfctf1 xv %d string \"%3d %3d %-12.12s\" ", y, x + 56, x, cl->resp.score, (cl->ping > 999) ? 999 : cl->ping, cl->pers.netname);
			else if(Has(cl, "Blue Flag"))
				Com_sprintf(entry, sizeof(entry), "yv %d xv %d picn sbfctf2 xv %d string \"%3d %3d %-12.12s\" ", y, x + 56, x, cl->resp.score, (cl->ping > 999) ? 999 : cl->ping, cl->pers.netname);
			else
				Com_sprintf(entry, sizeof(entry), "yv %d xv %d string \"%3d %3d %-12.12s\" ", y, x, cl->resp.score, (cl->ping > 999) ? 999 : cl->ping, cl->pers.netname);
			j = strlen(entry);
			if(stringlength + j > 1024)
				break;
			strcpy(string + stringlength, entry);
			stringlength += j;
		}
	}

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}

int CurrentFlag(){
	int frame = level.framenum;
	while(frame % 5 != 0)
		frame--;
	if((frame / 5) % 2 == 0)
		return TEAM_RED;
	else
		return TEAM_BLUE;
	return TEAM_RED;
}

void GetAnotherStats(edict_t *ent){
	int i = 0;
	edict_t *e;
	qboolean redflag = false;
	qboolean blueflag = false;

	while(i < game.maxclients){
		e = g_edicts + 1 + i;
		if(e->inuse){
			if(Has(e->client, "Red Flag"))
				redflag = true;
			if(Has(e->client, "Blue Flag"))
				blueflag = true;
		}
		i++;
	}

	//STAT_REDICON
	if(redflag)
		ent->client->ps.stats[STAT_REDICON] = gi.imageindex("i_ctf1t");
	else
		ent->client->ps.stats[STAT_REDICON] = gi.imageindex("i_ctf1");

	//STAT_REDSCORE
	ent->client->ps.stats[STAT_REDSCORE] = level.redscore;

	//STAT_BLUEICON
	if(blueflag)
		ent->client->ps.stats[STAT_BLUEICON] = gi.imageindex("i_ctf2t");
	else
		ent->client->ps.stats[STAT_BLUEICON] = gi.imageindex("i_ctf2");

	//STAT_BLUESCORE
	ent->client->ps.stats[STAT_BLUESCORE] = level.bluescore;

	//STAT_ONRED
	if(ent->client->resp.team == TEAM_RED)
		ent->client->ps.stats[STAT_ONRED] = gi.imageindex("i_ctfj");
	else
		ent->client->ps.stats[STAT_ONRED] = 0;

	//STAT_ONBLUE
	if(ent->client->resp.team == TEAM_BLUE)
		ent->client->ps.stats[STAT_ONBLUE] = gi.imageindex("i_ctfj");
	else
		ent->client->ps.stats[STAT_ONBLUE] = 0;

	//STAT_TEAM
	if(Has(ent->client, "Red Flag") && Has(ent->client, "Blue Flag")){
		if(CurrentFlag() == TEAM_RED)
			ent->client->ps.stats[STAT_FLAG] = gi.imageindex("i_ctf1");
		else
			ent->client->ps.stats[STAT_FLAG] = gi.imageindex("i_ctf2");
	}else if(Has(ent->client, "Red Flag"))
		ent->client->ps.stats[STAT_FLAG] = gi.imageindex("i_ctf1");
	else if(Has(ent->client, "Blue Flag"))
		ent->client->ps.stats[STAT_FLAG] = gi.imageindex("i_ctf2");
	else
		ent->client->ps.stats[STAT_FLAG] = 0;
}

void Effects(edict_t *ent){
	ent->s.effects &= (EF_FLAG1 | EF_FLAG2);
	ent->s.modelindex3 = 0;
	if(ent->health <= 0)
		return;
	if(Has(ent->client, "Red Flag") && Has(ent->client, "Blue Flag")){
		if(CurrentFlag() == TEAM_RED){
			ent->s.effects |= EF_FLAG1;
			ent->s.modelindex3 = gi.modelindex("players/male/flag1.md2");
		}else{
			ent->s.effects |= EF_FLAG2;
			ent->s.modelindex3 = gi.modelindex("players/male/flag2.md2");
		}
	}else if(Has(ent->client, "Red Flag")){
		ent->s.effects |= EF_FLAG1;
		ent->s.modelindex3 = gi.modelindex("players/male/flag1.md2");
	}else if(Has(ent->client, "Blue Flag")){
		ent->s.effects |= EF_FLAG2;
		ent->s.modelindex3 = gi.modelindex("players/male/flag2.md2");
	}
}
