import java.io.*;
import java.net.*;

class adoptamod{

	/*
	mods.txt
	--------
	0 - directory
	1 - name
	2 - url
	3 - description

	Server Lists
	------------
	http://asp.planetquake.com/q2servers/q2gamespy.txt
	http://www.gameaholic.com/servers/qspy-quake2
	*/

	public static void main(String[] args) throws Exception{
		generatePage(organizeList(checkServers(getServers(), getMods())));
	}

	static String[] getServers() throws Exception{
		System.out.print("Getting PlanetQuake list... ");
		String[] serversa = getServersFromList("asp.planetquake.com", "/q2servers/q2gamespy.txt");
		System.out.println("Done.");
		System.out.print("Getting Gameaholic list... ");
		String[] serversb = getServersFromList("www.gameaholic.com", "/servers/qspy-quake2");
		System.out.println("Done.");
		String[] servers = new String[serversa.length + serversb.length];
		int i = 0;
		while(i < serversa.length){
			servers[i] = serversa[i];
			i++;
		}
		int a = 0;
		while(a < serversb.length){
			if(notInArray(servers, serversb[a])){
				servers[i] = serversb[a];
				i++;
			}
			a++;
		}
		return cleanUpArray(servers, i);
	}

	static String[] getServersFromList(String server, String file) throws Exception{
		Socket socket = new Socket(server, 80);
		PrintWriter writer = new PrintWriter(socket.getOutputStream(), true);
		writer.println("GET " + file + " HTTP/1.1\nHost: " + InetAddress.getLocalHost() + "\n");
		InputStream in = socket.getInputStream();
		byte[] b = new byte[1];
		String data = "";
		while(true){
			b[0] = (byte) in.read();
			if(b[0] == -1)
				break;
			data = data.concat(new String(b));
			if(b[0] == 88)
				break;
		}
		data = data.concat("\n");
		in.close();
		writer.close();
		socket.close();
		BufferedReader reader = new BufferedReader(new StringReader(data));
		while(!(reader.readLine().equals("")));
		String s;
		String[] servers = new String[3000];
		int i = 0;
		while(true){
			s = reader.readLine();
			if(s.equals("X") || s.equals(""))
				break;
			servers[i] = s;
			i++;
		}
		reader.close();
		servers = cleanUpArray(servers, i);
		return fixServers(servers);
	}

	static String[] cleanUpArray(String[] array, int i){
		String[] arraya = new String[i];
		i = 0;
		while(i < arraya.length){
			arraya[i] = array[i];
			i++;
		}
		return arraya;
	}

	static String[] fixServers(String[] servers){
		int i = 0;
		while(i < servers.length){
			if(servers[i].indexOf(32) != -1)
				servers[i] = servers[i].substring(0, servers[i].indexOf(32));
			if(servers[i].indexOf(58) == -1)
				servers[i] = servers[i].concat(":27910");
			i++;
		}
		return servers;
	}

	static boolean notInArray(String[] array, String s){
		int i = 0;
		while(i < array.length){
			if(array[i] != null){
				if(array[i].equals(s))
					return false;
			}
			i++;
		}
		return true;
	}

	static String[][] getMods() throws Exception{
		String[][] mods = new String[5][2000];
		BufferedReader reader = new BufferedReader(new FileReader("mods.txt"));
		String s;
		int i = 0;
		while(true){
			s = reader.readLine();
			if(s ==  null)
				break;
			mods[0][i] = s.substring(2);
			mods[1][i] = reader.readLine();
			mods[2][i] = reader.readLine();
			mods[3][i] = reader.readLine();
			mods[4][i] = "0";
			i++;
		}			
		reader.close();
		return cleanUp2DArray(mods, i);
	}

	static String[][] cleanUp2DArray(String[][] array, int i){
		String[][] arraya = new String[5][i];
		i = 0;
		while(i < arraya[0].length){
			arraya[0][i] = array[0][i];
			arraya[1][i] = array[1][i];
			arraya[2][i] = array[2][i];
			arraya[3][i] = array[3][i];
			arraya[4][i] = array[4][i];
			i++;
		}
		return arraya;
	}

	static String[][] checkServers(String[] servers, String[][] mods) throws Exception{
		int i = 0;
		DatagramSocket dsocket = new DatagramSocket(27901);
		dsocket.setSoTimeout(999);
		int timeouts = 0;
		while(i < servers.length){
			InetAddress server;
			try{
				server = InetAddress.getByName(servers[i].substring(0, servers[i].indexOf(58)));
			}catch(Exception e){
				System.out.println("Server not found");
				i++;
				System.out.println(i + "/" + servers.length);
				continue;
			}
			int port = Integer.parseInt(servers[i].substring(servers[i].indexOf(58) + 1));
			byte[] b = {(byte) 255, (byte) 255, (byte) 255, (byte) 255, (byte) 115, (byte) 116, (byte) 97, (byte) 116, (byte) 117, (byte) 115, (byte) 10};
			DatagramPacket packet = new DatagramPacket(b, b.length, server, port);
			dsocket.send(packet);
			b = new byte[1000];
			packet = new DatagramPacket(b, b.length);
			try{
				dsocket.receive(packet);
				String data = new String(packet.getData());
				mods = updateMods(mods, parseVar(data, "game", "baseq2"), parseVar(data, "hostname", "noname"), parseVar(data, "gamename", "baseq2"));
			}catch(Exception e){
				timeouts++;
				System.out.println("Time Out: " + timeouts);
			}
			i++;
			System.out.println(i + "/" + servers.length);
		}
		dsocket.close();
		System.out.println("Time Outs: " + timeouts + "/" + servers.length);
		return mods;
	}

	static String parseVar(String data, String s, String def){
		data = data.toLowerCase();
		int i = data.indexOf("\\" + s + "\\");
		if(i == -1)
			return def;
		int ii = data.indexOf("\\", i + s.length() + 2);
		if(ii == -1)
			ii = data.indexOf(10, i + s.length() + 2);
		return data.substring(i + s.length() + 2, ii);
	}

	static String[][] updateMods(String[][] mods, String game, String hostname, String gamename){
		int i = 0;
		String[][] modsa = new String[5][100];
		int a = 0;
		while(i < mods[0].length){
			if(mods[0][i].equals(game)){
				modsa[0][a] = mods[0][i].toLowerCase();
				modsa[1][a] = mods[1][i].toLowerCase();
				modsa[2][a] = mods[2][i].toLowerCase();
				modsa[3][a] = mods[3][i].toLowerCase();
				modsa[4][a] = mods[4][i].toLowerCase();
				a++;
			}
			i++;
		}
		modsa = cleanUp2DArray(modsa, a);
		if(modsa[0].length == 0){
			System.out.println("Mod not found");
			return mods;
		}
		if(modsa[0].length == 1)
			return addToServerCount(mods, modsa[1][0]);
		i = 0;
		while(i < modsa.length){
			if(gamename.indexOf(modsa[1][i]) != -1 || hostname.indexOf(modsa[1][i]) != -1)
				return addToServerCount(mods, modsa[1][i]);
			i++;
		}
		i = 0;
		while(i < modsa.length){
			String name = mods[1][i];
			if(name.indexOf(32) != -1)
				name = name.substring(0, name.indexOf(32));
			if(gamename.indexOf(name) != -1 || hostname.indexOf(name) != -1)
				return addToServerCount(mods, modsa[1][i]);
			i++;
		}
		if(game.equals("ctf"))
			return addToServerCount(mods, "Capture the Flag");
		return addToServerCount(mods, modsa[0][i]);
	}

	static String[][] addToServerCount(String[][] mods, String name){
		int i = 0;
		while(i < mods[0].length){
			if(mods[1][i].equalsIgnoreCase(name)){
				mods[4][i] = String.valueOf(Integer.parseInt(mods[4][i]) + 1);
				System.out.println(mods[1][i] + ": " + mods[4][i]);
				return mods;
			}
			i++;
		}
		System.out.println("Mod not found");
		return mods;
	}

	static String[][] organizeList(String[][] mods){
		String[][] organizedmods = new String[5][mods[0].length];
		int i = 0;
		int total = 0;
		while(i < mods[0].length){
			int ii = 0;
			while(ii < mods[0].length){
				if(mods[4][ii].equals(String.valueOf(total))){
					organizedmods[0][i] = mods[0][ii];
					organizedmods[1][i] = mods[1][ii];
					organizedmods[2][i] = mods[2][ii];
					organizedmods[3][i] = mods[3][ii];
					organizedmods[4][i] = mods[4][ii];
					i++;
				}
				ii++;
			}
			total++;
		}
		return organizedmods;
	}

	static void generatePage(String[][] mods) throws Exception{
		BufferedReader reader = new BufferedReader(new FileReader("template.html"));
		PrintWriter writer = new PrintWriter(new FileOutputStream("adoptamod.html"));
		while(true){
			String s = reader.readLine();
			if(s == null)
				break;
			else if(s.equals("<!-- Adopt-A-Mod -->")){
				int i = 0;
				while(i < mods[0].length){
					writer.println("<tr>");
					writer.println("<td align=\"center\" valign=\"top\" nowrap><a href=" + mods[2][i] + " target=\"_top\">" + mods[1][i] + "</a></td>");
					if(mods[0][i].indexOf(32) != -1)
						mods[0][i] = mods[0][i].substring(0, mods[0][i].indexOf(32));
					writer.println("<td align=\"center\" valign=\"top\">" + mods[0][i] + "</td>");
					writer.println("<td align=\"center\" valign=\"top\">" + mods[3][i] + "</td>");
					writer.println("<td align=\"center\" valign=\"top\">" + mods[4][i] + "</td>");
					writer.println("</tr>");
					i++;
				}
			}else
				writer.println(s);
		}
		writer.close();
		reader.close();
	}
}