// x_misc.c

#include "g_local.h"
#include "x_misc.h"
#define lss self->lasersight

/*
=========================================================
Churl
=========================================================
*/

/*
This makes you throw up
*/

void ChurlNow(edict_t *self)
{
	// use some local vector variables to work with
	vec3_t	forward, right;
	vec3_t	mouth_pos, spew_vector;
	float rnum;
	int i;

if (self->client->churl_delaytime < level.time)
{
	self->client->churl_delaytime = level.time;

	// set the spew vector, based on the client's view angle
	AngleVectors (self->client->v_angle, forward, right, NULL);

	// Make the spew originate from our mouth
	VectorScale (forward, 24, mouth_pos);
	VectorAdd (mouth_pos, self->s.origin, mouth_pos);
	mouth_pos[2] += self->viewheight;

	// Make the spew come forwards out of our mouth.
	VectorScale (forward, 24, spew_vector);

	// BLOOD !
	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_BLOOD);
	gi.WritePosition (mouth_pos);
	gi.WriteDir (spew_vector);
	gi.multicast (mouth_pos, MULTICAST_PVS);
	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_BLOOD);
	gi.WritePosition (mouth_pos);
	gi.WriteDir (spew_vector);
	gi.multicast (mouth_pos, MULTICAST_PVS);
	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_BLOOD);
	gi.WritePosition (mouth_pos);
	gi.WriteDir (spew_vector);
	gi.multicast (mouth_pos, MULTICAST_PVS);

	// make a painful sound
	gi.sound (self, CHAN_VOICE, gi.soundindex("misc/udeath.wav"), 1, ATTN_NORM, 0);

	// Yummy
	for (i = 0; i<3; i++)
	{
		ThrowVomit (self, mouth_pos, forward, right, self->velocity); 
	} 
	// every now and again, cough up MEGA vomit 
	if (random() < 0.2) 
	{ 
		for (i = 0; i<10; i++) 
		{ 
			ThrowVomit (self, mouth_pos, forward, right, self->velocity); 
			ThrowVomit (self, mouth_pos, forward, right, self->velocity); 
		} 
	}

	// You lose health!
	if (self->health > 5)
		self->health -= 5;
        self->client->churl_delaytime += 5;
}
else
     	gi.cprintf(self, PRINT_HIGH, "Give your stomach a rest!\n");
}


/*
=========================================================
Laser Sight
=========================================================
*/

void SP_LaserSight(edict_t *self)
{
	vec3_t  start,forward,right,end;

	if ( lss ) 
	{
	      G_FreeEdict(lss);
      	lss = NULL;
		//gi.bprintf (PRINT_HIGH, "lasersight off.");
      return;
   	}

	//gi.bprintf (PRINT_HIGH, "lasersight on.");

   	AngleVectors (self->client->v_angle, forward, right, NULL);

   	VectorSet(end,100 , 0, 0);
   	G_ProjectSource (self->s.origin, end, forward, right, start);
	
   	lss = G_Spawn ();
   	lss->owner = self;
   	lss->movetype = MOVETYPE_NOCLIP;
   	lss->solid = SOLID_NOT;
   	lss->classname = "lasersight";
   	lss->s.modelindex = gi.modelindex ("models/objects/flash/tris.md2");
   	lss->s.skinnum = 0;

	self->s.effects |= EF_COLOR_SHELL;
      self->s.renderfx = RF_SHELL_RED | RF_FULLBRIGHT;

   	lss->think = LaserSightThink;
   	lss->nextthink = level.time + 0.1;
}

void LaserSightThink (edict_t *self)
{
	vec3_t start,end,endp,offset;
   	vec3_t forward,right,up;
   	trace_t tr;

   	AngleVectors (self->owner->client->v_angle, forward, right, up);
	
 	VectorSet(offset,24 , 6, self->owner->viewheight-7);
 	G_ProjectSource (self->owner->s.origin, offset, forward, right, start);
 	VectorMA(start,8192,forward,end);

   	tr = gi.trace (start,NULL,NULL, end,self->owner,CONTENTS_SOLID|CONTENTS_MONSTER|CONTENTS_DEADMONSTER);

   	if (tr.fraction != 1)
	{
   		VectorMA(tr.endpos,-4,forward,endp);
      	VectorCopy(endp,tr.endpos);
	}

	if ((tr.ent->svflags & SVF_MONSTER) || (tr.ent->client))
	{
      	if ((tr.ent->takedamage) && (tr.ent != self->owner))
		{
		//self->s.skinnum = 1;
	      self->s.renderfx = RF_SHELL_BLUE | RF_FULLBRIGHT;
	      }
   	}
   	else
      	self->s.renderfx = RF_SHELL_RED | RF_FULLBRIGHT;
		//self->s.skinnum = 0;

	vectoangles(tr.plane.normal,self->s.angles);
   	VectorCopy(tr.endpos,self->s.origin);
	
   	gi.linkentity (self);
   	self->nextthink = level.time + 0.1;
}

void LaserSightOn(edict_t *self)
{
	vec3_t  start,forward,right,end;

	if ( lss ) 
	{
	      return;
   	}

   	AngleVectors (self->client->v_angle, forward, right, NULL);

   	VectorSet(end,100 , 0, 0);
   	G_ProjectSource (self->s.origin, end, forward, right, start);
	
   	lss = G_Spawn ();
   	lss->owner = self;
   	lss->movetype = MOVETYPE_NOCLIP;
   	lss->solid = SOLID_NOT;
   	lss->classname = "lasersight";
   	lss->s.modelindex = gi.modelindex ("models/objects/flash/tris.md2");
   	lss->s.skinnum = 0;

	self->s.effects |= EF_COLOR_SHELL;
      self->s.renderfx = RF_SHELL_RED | RF_FULLBRIGHT;

   	lss->think = LaserSightThink;
   	lss->nextthink = level.time + 0.1;
}

void LaserSightOff(edict_t *self)
{
	if (lss)
	{
	      G_FreeEdict(lss);
      	lss = NULL;
   	}
}

