// 
// x_fileio.c -- file access routines 
// 
// 
// 1/98 - L. Allan Campbell (Geist) 
// 
// INCLUDES ///////////////////////////////////////////////// 
#include "g_local.h" 
// FUNCTIONS //////////////////////////////////////////////// 
// 
// OpenFile 
// 
// Opens a file for reading. This function will probably need 
// a major overhaul in future versions so that it will handle 
// writing, appending, etc. 
// 
// Args: 
// ent - entity (client) to print diagnostic messages to. 
// filename - name of file to open. 
// 
// Return: file handle of open file stream. 
// Returns NULL if file could not be opened. 
// 
FILE *OpenFile(edict_t *ent, char *filename) 
{ 
FILE *fp = NULL; 
if ((fp = fopen(filename, "r")) == NULL) // test to see if file opened 
{ 
// file did not load 
gi.cprintf (ent, PRINT_HIGH, "Could not open file \"%s\".\n", filename); 
return NULL; 
} 
return fp; 
} 
// 
// CloseFile 
// 
// Closes a file that was previously opened with OpenFile(). 
// 
// Args: 
// ent - entity (client) to print diagnostic messages to. 
// fp - file handle of file stream to close. 
// 
// Return: (none) 
// 
void CloseFile(edict_t *ent, FILE *fp) 
{ 
if (fp) // if the file is open 
{ 
fclose(fp); 
} 
else // no file is opened 
gi.cprintf(ent, PRINT_HIGH, "ERROR -- CloseFile() exception.\n"); 
}
