// LAST EDITED BY XIAN ON 3.11.97
// - Commands

#include        	"g_local.h"
#include        	"x_cmds.h"
#include        	"x_misc.h"
#include        	"x_weapons.h"
#include		"x_force.h"

/*
=========================================================
Sequencer Charges Detonating
=========================================================
*/

/*
Loop through all 'sequencer_grenades' and detonate each if you own them
*/

void Cmd_Detcharge_f (edict_t *ent)
{
        edict_t *seqcharge;

        seqcharge = G_Find (world, FOFS(classname), "sequencer_grenade");     
        while(seqcharge)
        {
                	if(seqcharge->owner == ent)
			{
                  	seqcharge->think = sequencer_detonate;
                        seqcharge->nextthink = level.time + .1;
			}
			seqcharge = G_Find (seqcharge, FOFS(classname), "sequencer_grenade");
        }
}

/*
=========================================================
Heat Seekers
=========================================================
*/

/*
Change rockets to heat seekers
*/

void Cmd_Homing_f (edict_t *ent)
{
	int		i;

	i = atoi (gi.argv(1));

	switch (i)
	{
	case 0:
		gi.cprintf (ent, PRINT_HIGH, "Rockets\n");
		ent->client->pers.homing_state = 0;
		break;
	case 1:
	default:
		gi.cprintf (ent, PRINT_HIGH, "Heat Seekers\n");
		ent->client->pers.homing_state = 1;
		break;
	}
}

/*
=========================================================
Machinegun / Assault Rifle
=========================================================
*/

void Cmd_MGun_f (edict_t *ent)
{
	int		i;

	i = atoi (gi.argv(1));

	switch (i)
	{
	case 0:
		gi.cprintf (ent, PRINT_HIGH, "Machine Gun\n");
		ent->client->mgType = MG_NORMAL;
		break;
	case 1:
	default:
		gi.cprintf (ent, PRINT_HIGH, "Assault Rifle\n");
		ent->client->mgType = MG_ASSAULT;
		break;
	}
}

/*
=========================================================
Autodestruct
=========================================================
*/

/*
Checks to see if you have the least amount of grenades and then start countdown
*/

void Cmd_Autodestruct_Start_f (edict_t *ent)
{
      if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Grenades"))] >= 5)
	{
		Start_Autodestruct_Mode(ent);
	}
}

/*
Checks if you have at least one grenade, and blow it up. May or may not kill you.
*/

void Cmd_Blowup_f (edict_t *ent)
{
      if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Grenades"))] >= 1)
	{
		Autodestruct_Explode2(ent);
	}
}

/*
=========================================================
Defense Laser
=========================================================
*/

/*
Runs the laser command
*/

void Cmd_Laser_f (edict_t *ent)
{
	PlaceLaser (ent);	
}

/*
=========================================================
Churl
=========================================================
*/

/*
Throw up
*/

void Cmd_Churl_f (edict_t *ent)
{
	ChurlNow (ent);
}

/*
=========================================================
Forces
=========================================================
*/

/*
Activate current force
*/

void Cmd_Force_On_f (edict_t *ent)
{
	Force_On (ent);
}

/*
Deactivate current force
*/

void Cmd_Force_Off_f (edict_t *ent)
{
	Force_Off (ent);
}

/*
Next force
*/

void Cmd_Force_Next_f (edict_t *ent)
{
	Force_Next (ent);
}

/*
Previous force
*/

void Cmd_Force_Prev_f (edict_t *ent)
{
	Force_Prev (ent);
}

/*
Mana amount
*/

void Cmd_Force_Mana_f (edict_t *ent)
{
	int	mana;

	mana = ent->client->pers.inventory[ITEM_INDEX(FindItem("Mana"))];

	gi.cprintf(ent, PRINT_HIGH, "Force Mana - %s\n",mana);
}

/*
=========================================================
Action (/ME) Command, IRC style!
=========================================================
*/

void Cmd_ActionMsg_f (edict_t *ent, qboolean team, qboolean arg0)
{
	int		j;
	edict_t	*other;
	char	*p;
	char	text[2048];

	if (gi.argc () < 2 && !arg0)
		return;

	Com_sprintf (text, sizeof(text), "%s ", ent->client->pers.netname);

	if (arg0)
	{
		strcat (text, gi.argv(0));
		strcat (text, " ");
		strcat (text, gi.args());
	}
	else
	{
		p = gi.args();

		if (*p == '"')
		{
			p++;
			p[strlen(p)-1] = 0;
		}
		strcat(text, p);
	}

	// don't let text be too long for malicious reasons
	if (strlen(text) > 150)
		text[150] = 0;

	strcat(text, "\n");

	if (dedicated->value)
		gi.cprintf(NULL, PRINT_CHAT, "%s", text);

	for (j = 1; j <= game.maxclients; j++)
	{
		other = &g_edicts[j];
		if (!other->inuse)
			continue;
		if (!other->client)
			continue;
		gi.cprintf(other, PRINT_CHAT, "%s", text);
	}
}

