// LAST EDITED BY XIAN ON: 3.15.98
// - New weapons
// - MODs

#include "g_local.h"

// XIAN START -> Undeclareds
void flaregun_touch ();
void fire_flaregun ();
void plasma_touch ();
void plasma_think ();
void plasma_explode ();
void decoy_think ();
void sequencer_touch ();
void sequencer_think ();
void sequencer_detonate ();
void sequencer_explode ();
void Railbomb_Touch ();
void Railbomb_Explode ();
void Railbomb_Rails ();
//void fire_minicluster ();
void Cluster_Touch ();
void Cluster_Explode ();
void Flash_Touch ();
void Flash_Explode ();
void Grenade_Die ();
void DeadGrenade_Explode ();
void Rocket_Die ();
void homing_think ();
void lasergun_touch ();
//void fire_rocket2 ();
// XIAN END -> Undeclareds


/*
=================
check_dodge

This is a support routine used when a client is firing
a non-instant attack weapon.  It checks to see if a
monster's dodge function should be called.
=================
*/
static void check_dodge (edict_t *self, vec3_t start, vec3_t dir, int speed)
{
	vec3_t	end;
	vec3_t	v;
	trace_t	tr;
	float	eta;

	// easy mode only ducks one quarter the time
	if (skill->value == 0)
	{
		if (random() > 0.25)
			return;
	}
	VectorMA (start, 8192, dir, end);
	tr = gi.trace (start, NULL, NULL, end, self, MASK_SHOT);
	if ((tr.ent) && (tr.ent->svflags & SVF_MONSTER) && (tr.ent->health > 0) && (tr.ent->monsterinfo.dodge) && infront(tr.ent, self))
	{
		VectorSubtract (tr.endpos, start, v);
		eta = (VectorLength(v) - tr.ent->maxs[0]) / speed;
		tr.ent->monsterinfo.dodge (tr.ent, self, eta);
	}
}


/*
=================
fire_hit

Used for all impact (hit/punch/slash) attacks
=================
*/
qboolean fire_hit (edict_t *self, vec3_t aim, int damage, int kick)
{
	trace_t		tr;
	vec3_t		forward, right, up;
	vec3_t		v;
	vec3_t		point;
	float		range;
	vec3_t		dir;

	//see if enemy is in range
	VectorSubtract (self->enemy->s.origin, self->s.origin, dir);
	range = VectorLength(dir);
	if (range > aim[0])
		return false;

	if (aim[1] > self->mins[0] && aim[1] < self->maxs[0])
	{
		// the hit is straight on so back the range up to the edge of their bbox
		range -= self->enemy->maxs[0];
	}
	else
	{
		// this is a side hit so adjust the "right" value out to the edge of their bbox
		if (aim[1] < 0)
			aim[1] = self->enemy->mins[0];
		else
			aim[1] = self->enemy->maxs[0];
	}

	VectorMA (self->s.origin, range, dir, point);

	tr = gi.trace (self->s.origin, NULL, NULL, point, self, MASK_SHOT);
	if (tr.fraction < 1)
	{
		if (!tr.ent->takedamage)
			return false;
		// if it will hit any client/monster then hit the one we wanted to hit
		if ((tr.ent->svflags & SVF_MONSTER) || (tr.ent->client))
			tr.ent = self->enemy;
	}

	AngleVectors(self->s.angles, forward, right, up);
	VectorMA (self->s.origin, range, forward, point);
	VectorMA (point, aim[1], right, point);
	VectorMA (point, aim[2], up, point);
	VectorSubtract (point, self->enemy->s.origin, dir);

	// do the damage
	T_Damage (tr.ent, self, self, dir, point, vec3_origin, damage, kick/2, DAMAGE_NO_KNOCKBACK, MOD_HIT);

	if (!(tr.ent->svflags & SVF_MONSTER) && (!tr.ent->client))
		return false;

	// do our special form of knockback here
	VectorMA (self->enemy->absmin, 0.5, self->enemy->size, v);
	VectorSubtract (v, point, v);
	VectorNormalize (v);
	VectorMA (self->enemy->velocity, kick, v, self->enemy->velocity);
	if (self->enemy->velocity[2] > 0)
		self->enemy->groundentity = NULL;
	return true;
}


/*
=================
fire_lead

This is an internal support routine used for bullet/pellet based weapons.
=================
*/
static void fire_lead (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int te_impact, int hspread, int vspread, int mod)
{
	trace_t		tr;
	vec3_t		dir;
	vec3_t		forward, right, up;
	vec3_t		end;
	float		r;
	float		u;
	vec3_t		water_start;
	qboolean	water = false;
	int			content_mask = MASK_SHOT | MASK_WATER;

	tr = gi.trace (self->s.origin, NULL, NULL, start, self, MASK_SHOT);
	if (!(tr.fraction < 1.0))
	{
		vectoangles (aimdir, dir);
		AngleVectors (dir, forward, right, up);

		r = crandom()*hspread;
		u = crandom()*vspread;
		VectorMA (start, 8192, forward, end);
		VectorMA (end, r, right, end);
		VectorMA (end, u, up, end);

		if (gi.pointcontents (start) & MASK_WATER)
		{
			water = true;
			VectorCopy (start, water_start);
			content_mask &= ~MASK_WATER;
		}

		tr = gi.trace (start, NULL, NULL, end, self, content_mask);

		// see if we hit water
		if (tr.contents & MASK_WATER)
		{
			int		color;

			water = true;
			VectorCopy (tr.endpos, water_start);

			if (!VectorCompare (start, tr.endpos))
			{
				if (tr.contents & CONTENTS_WATER)
				{
					if (strcmp(tr.surface->name, "*brwater") == 0)
						color = SPLASH_BROWN_WATER;
					else
						color = SPLASH_BLUE_WATER;
				}
				else if (tr.contents & CONTENTS_SLIME)
					color = SPLASH_SLIME;
				else if (tr.contents & CONTENTS_LAVA)
					color = SPLASH_LAVA;
				else
					color = SPLASH_UNKNOWN;

				if (color != SPLASH_UNKNOWN)
				{
					gi.WriteByte (svc_temp_entity);
					gi.WriteByte (TE_SPLASH);
					gi.WriteByte (8);
					gi.WritePosition (tr.endpos);
					gi.WriteDir (tr.plane.normal);
					gi.WriteByte (color);
					gi.multicast (tr.endpos, MULTICAST_PVS);
				}

				// change bullet's course when it enters water
				VectorSubtract (end, start, dir);
				vectoangles (dir, dir);
				AngleVectors (dir, forward, right, up);
				r = crandom()*hspread*2;
				u = crandom()*vspread*2;
				VectorMA (water_start, 8192, forward, end);
				VectorMA (end, r, right, end);
				VectorMA (end, u, up, end);
			}

			// re-trace ignoring water this time
			tr = gi.trace (water_start, NULL, NULL, end, self, MASK_SHOT);
		}
	}

	// send gun puff / flash
	if (!((tr.surface) && (tr.surface->flags & SURF_SKY)))
	{
		if (tr.fraction < 1.0)
		{
			if (tr.ent->takedamage)
			{
				T_Damage (tr.ent, self, self, aimdir, tr.endpos, tr.plane.normal, damage, kick, DAMAGE_BULLET, mod);
			}
			else
			{
				if (strncmp (tr.surface->name, "sky", 3) != 0)
				{
					gi.WriteByte (svc_temp_entity);
					gi.WriteByte (te_impact);
					gi.WritePosition (tr.endpos);
					gi.WriteDir (tr.plane.normal);
					gi.multicast (tr.endpos, MULTICAST_PVS);

					if (self->client)
						PlayerNoise(self, tr.endpos, PNOISE_IMPACT);
				}
			}
		}
	}

	// if went through water, determine where the end and make a bubble trail
	if (water)
	{
		vec3_t	pos;

		VectorSubtract (tr.endpos, water_start, dir);
		VectorNormalize (dir);
		VectorMA (tr.endpos, -2, dir, pos);
		if (gi.pointcontents (pos) & MASK_WATER)
			VectorCopy (pos, tr.endpos);
		else
			tr = gi.trace (pos, NULL, NULL, water_start, tr.ent, MASK_WATER);

		VectorAdd (water_start, tr.endpos, pos);
		VectorScale (pos, 0.5, pos);

		gi.WriteByte (svc_temp_entity);
		gi.WriteByte (TE_BUBBLETRAIL);
		gi.WritePosition (water_start);
		gi.WritePosition (tr.endpos);
		gi.multicast (pos, MULTICAST_PVS);
	}
}


/*
=================
fire_bullet

Fires a single round.  Used for machinegun and chaingun.  Would be fine for
pistols, rifles, etc....
=================
*/
void fire_bullet (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread, int mod)
{
	fire_lead (self, start, aimdir, damage, kick, TE_GUNSHOT, hspread, vspread, mod);
}


/*
=================
fire_shotgun

Shoots shotgun pellets.  Used by shotgun and super shotgun.
=================
*/
void fire_shotgun (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread, int count, int mod)
{
	int		i;

	for (i = 0; i < count; i++)
		fire_lead (self, start, aimdir, damage, kick, TE_SHOTGUN, hspread, vspread, mod);
}


/*
=================
fire_blaster

Fires a single blaster bolt.  Used by the blaster and hyper blaster.
=================
*/
void blaster_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	int		mod;

	if (other == self->owner)
		return;

	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (self);
		return;
	}

	if (self->owner->client)
		PlayerNoise(self->owner, self->s.origin, PNOISE_IMPACT);

	if (other->takedamage)
	{
		if (self->spawnflags & 1)
			mod = MOD_HYPERBLASTER;
		else
			mod = MOD_BLASTER;
		T_Damage (other, self, self->owner, self->velocity, self->s.origin, plane->normal, self->dmg, 1, DAMAGE_ENERGY, mod);
	}
	else
	{
		gi.WriteByte (svc_temp_entity);
		gi.WriteByte (TE_BLASTER);
		gi.WritePosition (self->s.origin);
		if (!plane)
			gi.WriteDir (vec3_origin);
		else
			gi.WriteDir (plane->normal);
		gi.multicast (self->s.origin, MULTICAST_PVS);
	}

	G_FreeEdict (self);
}

void fire_blaster (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, int effect, qboolean hyper)
{
	edict_t	*bolt;
	trace_t	tr;

	VectorNormalize (dir);

	bolt = G_Spawn();
	VectorCopy (start, bolt->s.origin);
	VectorCopy (start, bolt->s.old_origin);
	vectoangles (dir, bolt->s.angles);
	VectorScale (dir, speed, bolt->velocity);
	bolt->movetype = MOVETYPE_FLYMISSILE;
	bolt->clipmask = MASK_SHOT;
	bolt->solid = SOLID_BBOX;
	bolt->s.effects |= effect;
	VectorClear (bolt->mins);
	VectorClear (bolt->maxs);
	bolt->s.modelindex = gi.modelindex ("models/objects/laser/tris.md2");
	bolt->s.sound = gi.soundindex ("misc/lasfly.wav");
	bolt->owner = self;
	bolt->touch = blaster_touch;
	bolt->nextthink = level.time + 2;
	bolt->think = G_FreeEdict;
	bolt->dmg = damage;
	bolt->classname = "bolt";
	if (hyper)
		bolt->spawnflags = 1;
	gi.linkentity (bolt);

	if (self->client)
		check_dodge (self, bolt->s.origin, dir, speed);

	tr = gi.trace (self->s.origin, NULL, NULL, bolt->s.origin, bolt, MASK_SHOT);
	if (tr.fraction < 1.0)
	{
		VectorMA (bolt->s.origin, -10, dir, bolt->s.origin);
		bolt->touch (bolt, tr.ent, NULL, NULL);
	}
}	


/*
=================
fire_grenade
=================
*/
static void Grenade_Explode (edict_t *ent)
{
	vec3_t		origin;
	int			mod;

	if (ent->owner->client)
		PlayerNoise(ent->owner, ent->s.origin, PNOISE_IMPACT);

	//FIXME: if we are onground then raise our Z just a bit since we are a point?
	if (ent->enemy)
	{
		float	points;
		vec3_t	v;
		vec3_t	dir;

		VectorAdd (ent->enemy->mins, ent->enemy->maxs, v);
		VectorMA (ent->enemy->s.origin, 0.5, v, v);
		VectorSubtract (ent->s.origin, v, v);
		points = ent->dmg - 0.5 * VectorLength (v);
		VectorSubtract (ent->enemy->s.origin, ent->s.origin, dir);
		if (ent->spawnflags & 1)
			mod = MOD_HANDGRENADE;
		else
			mod = MOD_GRENADE;
		T_Damage (ent->enemy, ent, ent->owner, dir, ent->s.origin, vec3_origin, (int)points, (int)points, DAMAGE_RADIUS, mod);
	}

	if (ent->spawnflags & 2)
		mod = MOD_HELD_GRENADE;
	else if (ent->spawnflags & 1)
		mod = MOD_HG_SPLASH;
	else
		mod = MOD_G_SPLASH;
	T_RadiusDamage(ent, ent->owner, ent->dmg, ent->enemy, ent->dmg_radius, mod);

	VectorMA (ent->s.origin, -0.02, ent->velocity, origin);
	gi.WriteByte (svc_temp_entity);
	if (ent->waterlevel)
	{
		if (ent->groundentity)
			gi.WriteByte (TE_GRENADE_EXPLOSION_WATER);
		else
			gi.WriteByte (TE_ROCKET_EXPLOSION_WATER);
	}
	else
	{
		if (ent->groundentity)
			gi.WriteByte (TE_GRENADE_EXPLOSION);
		else
			gi.WriteByte (TE_ROCKET_EXPLOSION);
	}
	gi.WritePosition (origin);
	gi.multicast (ent->s.origin, MULTICAST_PHS);

	G_FreeEdict (ent);
}

static void Grenade_Touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (other == ent->owner)
		return;

	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (ent);
		return;
	}

	if (!other->takedamage)
	{
		if (ent->spawnflags & 1)
		{
			if (random() > 0.5)
				gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/hgrenb1a.wav"), 1, ATTN_NORM, 0);
			else
				gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/hgrenb2a.wav"), 1, ATTN_NORM, 0);
		}
		else
		{
			gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/grenlb1b.wav"), 1, ATTN_NORM, 0);
		}
		return;
	}

	ent->enemy = other;
	Grenade_Explode (ent);
}

void fire_grenade (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius)
{
	edict_t	*grenade;
	vec3_t	dir;
	vec3_t	forward, right, up;

      if ((self->client) && (self->client->grenadeType == GRENADE_PLASMA))
      {
		speed = 900; // Make plasmas faster
	}
	vectoangles (aimdir, dir);
	AngleVectors (dir, forward, right, up);

	grenade = G_Spawn();
	VectorCopy (start, grenade->s.origin);
	VectorScale (aimdir, speed, grenade->velocity);
	VectorMA (grenade->velocity, 200 + crandom() * 10.0, up, grenade->velocity);
	VectorMA (grenade->velocity, crandom() * 10.0, right, grenade->velocity);
	VectorSet (grenade->avelocity, 300, 300, 300);
	grenade->movetype = MOVETYPE_BOUNCE;
	grenade->clipmask = MASK_SHOT;
	grenade->solid = SOLID_BBOX;
	grenade->s.effects |= EF_GRENADE;
	VectorClear (grenade->mins);
	VectorClear (grenade->maxs);
	grenade->s.modelindex = gi.modelindex ("models/objects/grenade/tris.md2");
	grenade->owner = self;
	grenade->touch = Grenade_Touch;
	grenade->nextthink = level.time + timer;
	grenade->think = Grenade_Explode;
	grenade->dmg = damage;
	grenade->dmg_radius = damage_radius;
//	grenade->classname = "grenade"; // XIAN -> rem
        Grenade_Switch(grenade,self); // XIAN -> Change type

	gi.linkentity (grenade);
}

void fire_grenade2 (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius, qboolean held)
{
	edict_t	*grenade;
	vec3_t	dir;
	vec3_t	forward, right, up;

	vectoangles (aimdir, dir);
	AngleVectors (dir, forward, right, up);

	grenade = G_Spawn();
	VectorCopy (start, grenade->s.origin);
	VectorScale (aimdir, speed, grenade->velocity);
	VectorMA (grenade->velocity, 200 + crandom() * 10.0, up, grenade->velocity);
	VectorMA (grenade->velocity, crandom() * 10.0, right, grenade->velocity);
	VectorSet (grenade->avelocity, 300, 300, 300);
	grenade->movetype = MOVETYPE_BOUNCE;
	grenade->clipmask = MASK_SHOT;
	grenade->solid = SOLID_BBOX;
	grenade->s.effects |= EF_GRENADE;
	VectorClear (grenade->mins);
	VectorClear (grenade->maxs);
	grenade->s.modelindex = gi.modelindex ("models/objects/grenade2/tris.md2");
	grenade->owner = self;
	grenade->touch = Grenade_Touch;
	grenade->nextthink = level.time + timer;
	grenade->think = Grenade_Explode;
	grenade->dmg = damage;
	grenade->dmg_radius = damage_radius;
        grenade->classname = "hgrenade";
        Grenade_Switch(grenade,self); // XIAN -> Change type
	if (held)
		grenade->spawnflags = 3;
	else
		grenade->spawnflags = 1;
	grenade->s.sound = gi.soundindex("weapons/hgrenc1b.wav");

	if (timer <= 0.0)
		Grenade_Explode (grenade);
	else
	{
		gi.sound (self, CHAN_WEAPON, gi.soundindex ("weapons/hgrent1a.wav"), 1, ATTN_NORM, 0);
		gi.linkentity (grenade);
	}
}


/*
=================
fire_rocket
=================
*/
void rocket_touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	vec3_t		origin;
	int			n;

	if (other == ent->owner)
		return;

	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (ent);
		return;
	}

	if (ent->owner->client)
		PlayerNoise(ent->owner, ent->s.origin, PNOISE_IMPACT);

	// calculate position for the explosion entity
	VectorMA (ent->s.origin, -0.02, ent->velocity, origin);

	if (other->takedamage)
	{
		T_Damage (other, ent, ent->owner, ent->velocity, ent->s.origin, plane->normal, ent->dmg, 0, 0, MOD_ROCKET);
	}
	else
	{
		// don't throw any debris in net games
		if (!deathmatch->value && !coop->value)
		{
			if ((surf) && !(surf->flags & (SURF_WARP|SURF_TRANS33|SURF_TRANS66|SURF_FLOWING)))
			{
				n = rand() % 5;
				while(n--)
					ThrowDebris (ent, "models/objects/debris2/tris.md2", 2, ent->s.origin);
			}
		}
	}

	T_RadiusDamage(ent, ent->owner, ent->radius_dmg, other, ent->dmg_radius, MOD_R_SPLASH);

	gi.WriteByte (svc_temp_entity);
	if (ent->waterlevel)
		gi.WriteByte (TE_ROCKET_EXPLOSION_WATER);
	else
		gi.WriteByte (TE_ROCKET_EXPLOSION);
	gi.WritePosition (origin);
	gi.multicast (ent->s.origin, MULTICAST_PHS);

	G_FreeEdict (ent);
}

void fire_rocket (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, float damage_radius, int radius_damage)
{
	edict_t	*rocket;

	rocket = G_Spawn();
	VectorCopy (start, rocket->s.origin);
	VectorCopy (dir, rocket->movedir);
	vectoangles (dir, rocket->s.angles);
	VectorScale (dir, speed, rocket->velocity);
	rocket->movetype = MOVETYPE_FLYMISSILE;
	rocket->clipmask = MASK_SHOT;
	rocket->solid = SOLID_BBOX;
	rocket->s.effects |= EF_ROCKET;
	VectorClear (rocket->mins);
	VectorClear (rocket->maxs);
	rocket->s.modelindex = gi.modelindex ("models/objects/rocket/tris.md2");
	rocket->owner = self;
	rocket->touch = rocket_touch;
//	rocket->nextthink = level.time + 8000/speed; // XIAN -> Rem
//	rocket->think = G_FreeEdict; // XIAN -> Rem

	rocket->dmg = damage;
	rocket->radius_dmg = radius_damage;
	rocket->dmg_radius = damage_radius;
	rocket->s.sound = gi.soundindex ("weapons/rockfly.wav");
	rocket->classname = "rocket";
// XIAN START -> Rockets
//	rocket->homing_lock = SEEKING;
 	rocket->homing_target = NULL;
      if ((self->client) && (self->client->rocketType == ROCKET_NORMAL))
      {
                rocket->nextthink = level.time + 8000/speed;
                rocket->think = G_FreeEdict;
      }
      else if ((self->client) && (self->client->rocketType == ROCKET_SEEKER))
      {
		if (self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] >= 5)
		{
			self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= 5;
			rocket->nextthink = level.time + .1;
			rocket->think = homing_think;
                  VectorSet(rocket->mins, -10, -3, 0);
			VectorSet(rocket->maxs, 10, 3, 6);
			rocket->mass = 10;
			rocket->health = 15;
			rocket->die = Rocket_Die;
			rocket->takedamage = DAMAGE_YES;
			rocket->monsterinfo.aiflags = AI_NOSTEP;
			rocket->s.effects |= EF_COLOR_SHELL;
                  rocket->s.renderfx |= RF_SHELL_RED;
			rocket->dmg = damage*0.5;
			rocket->radius_dmg = radius_damage*0.5;
			rocket->dmg_radius = damage_radius*0.5;
		}
		else
		{
			gi.cprintf(self, PRINT_HIGH, "You need at least 5 cells for Heat Seekers!\n");
			rocket->nextthink = level.time + 8000/speed;
			rocket->think = G_FreeEdict;
            }
        }
        else
        {
                rocket->nextthink = level.time + 8000/speed;
                rocket->think = G_FreeEdict;
        }
// XIAN END -> Rockets

	if (self->client)
		check_dodge (self, rocket->s.origin, dir, speed);

	gi.linkentity (rocket);
}


/*
=================
fire_rail
=================
*/
void fire_rail (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick)
{
	vec3_t		from;
	vec3_t		end;
	trace_t		tr;
	edict_t		*ignore;
	int			mask;
	qboolean	water;

// XIAN START -> Laser Gun
	edict_t	*laserbolt;

      if ((self->client) && (self->client->slugType == SLUG_LASER))
      {
		if (self->client->pers.inventory[ITEM_INDEX(FindItem("Slugs"))] >= 2)
		{
            
		self->client->pers.inventory[ITEM_INDEX(FindItem("Slugs"))] -= 2;
 	
		VectorNormalize (aimdir);

		laserbolt = G_Spawn();
		VectorCopy (start, laserbolt->s.origin);
		vectoangles (aimdir, laserbolt->s.angles);
		VectorScale (aimdir, 2000, laserbolt->velocity);
		VectorAdd (start, laserbolt->velocity, laserbolt->s.old_origin);
		laserbolt->clipmask = MASK_SHOT;
		laserbolt->movetype = MOVETYPE_RICOCHET;
		laserbolt->solid = SOLID_BBOX;
		laserbolt->s.renderfx |= RF_BEAM | RF_FULLBRIGHT;
		laserbolt->s.modelindex = 1;			// must be non-zero
		laserbolt->owner = self;
		laserbolt->s.frame = 3;
		laserbolt->s.skinnum = 0xf2f2f0f0;		// red
		VectorSet (laserbolt->mins, -8, -8, -8);
		VectorSet (laserbolt->maxs, 8, 8, 8);
		laserbolt->touch = lasergun_touch;
		laserbolt->nextthink = level.time + 2.5;
		laserbolt->think = G_FreeEdict;
		laserbolt->dmg = 125;
		
		gi.linkentity (laserbolt);
	
		tr = gi.trace (self->s.origin, NULL, NULL, laserbolt->s.origin, laserbolt, MASK_SHOT);
		if (tr.fraction < 1.0)
		{
			VectorMA (laserbolt->s.origin, -10, aimdir, laserbolt->s.origin);
			laserbolt->touch (laserbolt, tr.ent, NULL, NULL);
		}
		return;
		}
	}
// XIAN END -> Laser Gun

	VectorMA (start, 8192, aimdir, end);
	VectorCopy (start, from);
	ignore = self;
	water = false;
	mask = MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA;
	while (ignore)
	{
		tr = gi.trace (from, NULL, NULL, end, ignore, mask);

		if (tr.contents & (CONTENTS_SLIME|CONTENTS_LAVA))
		{
			mask &= ~(CONTENTS_SLIME|CONTENTS_LAVA);
			water = true;
		}
		else
		{
			if ((tr.ent->svflags & SVF_MONSTER) || (tr.ent->client))
				ignore = tr.ent;
			else
				ignore = NULL;

			if ((tr.ent != self) && (tr.ent->takedamage))
			// XIAN START -> Less dmg if invi
      			if ((self->client) && (self->client->slugType == SLUG_NORMAL))
      			{
					T_Damage (tr.ent, self, self, aimdir, tr.endpos, tr.plane.normal, damage, kick*2, 0, MOD_RAILGUN); // XIAN -> Double kick
				}
      			else
      			{
					T_Damage (tr.ent, self, self, aimdir, tr.endpos, tr.plane.normal, damage*.75, kick, 0, MOD_RAILGUN);
				}
			// XIAN END -> Less dmg if invi
		}

		VectorCopy (tr.endpos, from);
	}

	// send gun puff / flash
// XIAN START -> No trail if invislugs
      if ((self->client) && (self->client->slugType == SLUG_NORMAL))
      {
		gi.WriteByte (svc_temp_entity);
		gi.WriteByte (TE_RAILTRAIL);
		gi.WritePosition (start);
		gi.WritePosition (tr.endpos);
		gi.multicast (self->s.origin, MULTICAST_PHS);
	//	gi.multicast (start, MULTICAST_PHS);

		if (water)
		{
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_RAILTRAIL);
			gi.WritePosition (start);
			gi.WritePosition (tr.endpos);
			gi.multicast (tr.endpos, MULTICAST_PHS);
		}
	}
// XIAN END -> No trail if invislugs
	if (self->client)
		PlayerNoise(self, tr.endpos, PNOISE_IMPACT);
}


/*
=================
fire_bfg
=================
*/
void bfg_explode (edict_t *self)
{
	edict_t	*ent;
	float	points;
	vec3_t	v;
	float	dist;

	if (self->s.frame == 0)
	{
		// the BFG effect
		ent = NULL;
		while ((ent = findradius(ent, self->s.origin, self->dmg_radius)) != NULL)
		{
			if (!ent->takedamage)
				continue;
			if (ent == self->owner)
				continue;
			if (!CanDamage (ent, self))
				continue;
			if (!CanDamage (ent, self->owner))
				continue;

			VectorAdd (ent->mins, ent->maxs, v);
			VectorMA (ent->s.origin, 0.5, v, v);
			VectorSubtract (self->s.origin, v, v);
			dist = VectorLength(v);
			points = self->radius_dmg * (1.0 - sqrt(dist/self->dmg_radius));
			if (ent == self->owner)
				points = points * 0.5;

			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_BFG_EXPLOSION);
			gi.WritePosition (ent->s.origin);
			gi.multicast (ent->s.origin, MULTICAST_PHS);
			T_Damage (ent, self, self->owner, self->velocity, ent->s.origin, vec3_origin, (int)points, 0, DAMAGE_ENERGY, MOD_BFG_EFFECT);
		}
	}

	self->nextthink = level.time + FRAMETIME;
	self->s.frame++;
	if (self->s.frame == 5)
		self->think = G_FreeEdict;
}

void bfg_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (other == self->owner)
		return;

	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (self);
		return;
	}

	if (self->owner->client)
		PlayerNoise(self->owner, self->s.origin, PNOISE_IMPACT);

	// core explosion - prevents firing it into the wall/floor
	if (other->takedamage)
		T_Damage (other, self, self->owner, self->velocity, self->s.origin, plane->normal, 200, 0, 0, MOD_BFG_BLAST);
	T_RadiusDamage(self, self->owner, 200, other, 100, MOD_BFG_BLAST);

	gi.sound (self, CHAN_VOICE, gi.soundindex ("weapons/bfg__x1b.wav"), 1, ATTN_NORM, 0);
	self->solid = SOLID_NOT;
	self->touch = NULL;
	VectorMA (self->s.origin, -1 * FRAMETIME, self->velocity, self->s.origin);
	VectorClear (self->velocity);
	self->s.modelindex = gi.modelindex ("sprites/s_bfg3.sp2");
	self->s.frame = 0;
	self->s.sound = 0;
	self->s.effects &= ~EF_ANIM_ALLFAST;
	self->think = bfg_explode;
	self->nextthink = level.time + FRAMETIME;
	self->enemy = other;

	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_BFG_BIGEXPLOSION);
	gi.WritePosition (self->s.origin);
	gi.multicast (self->s.origin, MULTICAST_PVS);
}


void bfg_think (edict_t *self)
{
	edict_t	*ent;
	edict_t	*ignore;
	vec3_t	point;
	vec3_t	dir;
	vec3_t	start;
	vec3_t	end;
	int		dmg;
	trace_t	tr;

	if (deathmatch->value)
		dmg = 5;
	else
		dmg = 10;

	ent = NULL;
	while ((ent = findradius(ent, self->s.origin, 256)) != NULL)
	{
		if (ent == self)
			continue;

		if (ent == self->owner)
			continue;

		if (!ent->takedamage)
			continue;

		if (!(ent->svflags & SVF_MONSTER) && (!ent->client) && (strcmp(ent->classname, "misc_explobox") != 0))
			continue;

//ZOID
		//don't target players in CTF
		if (ctf->value && ent->client &&
			self->owner->client &&
			ent->client->resp.ctf_team == self->owner->client->resp.ctf_team)
			continue;
//ZOID

		VectorMA (ent->absmin, 0.5, ent->size, point);

		VectorSubtract (point, self->s.origin, dir);
		VectorNormalize (dir);

		ignore = self;
		VectorCopy (self->s.origin, start);
		VectorMA (start, 2048, dir, end);
		while(1)
		{
			tr = gi.trace (start, NULL, NULL, end, ignore, CONTENTS_SOLID|CONTENTS_MONSTER|CONTENTS_DEADMONSTER);

			if (!tr.ent)
				break;

			// hurt it if we can
			if ((tr.ent->takedamage) && !(tr.ent->flags & FL_IMMUNE_LASER) && (tr.ent != self->owner))
				T_Damage (tr.ent, self, self->owner, dir, tr.endpos, vec3_origin, dmg, 1, DAMAGE_ENERGY, MOD_BFG_LASER);

			// if we hit something that's not a monster or player we're done
			if (!(tr.ent->svflags & SVF_MONSTER) && (!tr.ent->client))
			{
				gi.WriteByte (svc_temp_entity);
				gi.WriteByte (TE_LASER_SPARKS);
				gi.WriteByte (4);
				gi.WritePosition (tr.endpos);
				gi.WriteDir (tr.plane.normal);
				gi.WriteByte (self->s.skinnum);
				gi.multicast (tr.endpos, MULTICAST_PVS);
				break;
			}

			ignore = tr.ent;
			VectorCopy (tr.endpos, start);
		}

		gi.WriteByte (svc_temp_entity);
		gi.WriteByte (TE_BFG_LASER);
		gi.WritePosition (self->s.origin);
		gi.WritePosition (tr.endpos);
		gi.multicast (self->s.origin, MULTICAST_PHS);
	}

	self->nextthink = level.time + FRAMETIME;
}


void fire_bfg (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, float damage_radius)
{
	edict_t	*bfg;

	bfg = G_Spawn();
	VectorCopy (start, bfg->s.origin);
	VectorCopy (dir, bfg->movedir);
	vectoangles (dir, bfg->s.angles);
	VectorScale (dir, speed, bfg->velocity);
	bfg->movetype = MOVETYPE_FLYMISSILE;
	bfg->clipmask = MASK_SHOT;
	bfg->solid = SOLID_BBOX;
	bfg->s.effects |= EF_BFG | EF_ANIM_ALLFAST;
	VectorClear (bfg->mins);
	VectorClear (bfg->maxs);
	bfg->s.modelindex = gi.modelindex ("sprites/s_bfg1.sp2");
	bfg->owner = self;
	bfg->touch = bfg_touch;
	bfg->nextthink = level.time + 8000/speed;
	bfg->think = G_FreeEdict;
	bfg->radius_dmg = damage;
	bfg->dmg_radius = damage_radius;
	bfg->classname = "bfg blast";
	bfg->s.sound = gi.soundindex ("weapons/bfg__l1a.wav");

	bfg->think = bfg_think;
	bfg->nextthink = level.time + FRAMETIME;
	bfg->teammaster = bfg;
	bfg->teamchain = NULL;

	if (self->client)
		check_dodge (self, bfg->s.origin, dir, speed);

	gi.linkentity (bfg);
}

/*
=========================================================
New weapon commands and functions, speed mod
=========================================================
*/

/*
Grenade Type Switcher
*/

static void Grenade_Switch(edict_t *ent, edict_t *self)
{

	int	i;

      VectorSet(ent->mins, -3, -3, 0);
      VectorSet(ent->maxs, 3, 3, 6);
	ent->mass = 2;
      ent->health = 15;
	ent->die = Grenade_Die;
	ent->takedamage = DAMAGE_YES;
	ent->monsterinfo.aiflags = AI_NOSTEP;
      if ((self->client) && (self->client->grenadeType == GRENADE_FLASH))
      {
		if (self->client->pers.inventory[ITEM_INDEX(FindItem("Grenades"))] >= 1)
		{
            	self->client->pers.inventory[ITEM_INDEX(FindItem("Grenades"))] -= 1;
	            ent->s.effects |= EF_COLOR_SHELL;
      	      ent->s.renderfx |= RF_SHELL_GREEN | RF_SHELL_BLUE | RF_SHELL_RED;
            	ent->touch = Flash_Touch;
            	ent->think = Flash_Explode;
            	ent->classname = "flash_grenade";
      		ent->mass = 2;
            	ent->health = 15;
		}
      }
      else if ((self->client) && (self->client->grenadeType == GRENADE_CLUSTER))
      {
		if (self->client->pers.inventory[ITEM_INDEX(FindItem("Grenades"))] >= 4)
		{
            	self->client->pers.inventory[ITEM_INDEX(FindItem("Grenades"))] -= 4;
            	ent->touch = Cluster_Touch;
            	ent->think = Cluster_Explode;
            	ent->s.effects |= EF_COLOR_SHELL;
            	ent->s.renderfx |= RF_SHELL_BLUE;
            	ent->classname = "cluster_grenade";
            	ent->mass = 2;
            	ent->health = 20;
		}
      }
      else if ((self->client) && (self->client->grenadeType == GRENADE_SEQUENCER))
      {
		if (self->client->pers.inventory[ITEM_INDEX(FindItem("Grenades"))] >= 4) // was cells5
		{
            	self->client->pers.inventory[ITEM_INDEX(FindItem("Grenades"))] -= 4;
            	ent->s.effects |= EF_COLOR_SHELL;
            	ent->s.renderfx |= RF_SHELL_GREEN | RF_SHELL_RED; // Yellow glow
            	ent->dmg = 120;
            	ent->delay = 30;
            	ent->dmg_radius = 200;
            	ent->think = sequencer_think;
           		ent->nextthink = level.time + 2;
            	ent->classname = "sequencer_grenade";
            	ent->mass = 5;
            	ent->health = 50;
		}
		else
			gi.cprintf(self, PRINT_HIGH, "Sequencers require 5 grenades per charge\n");
      }
     else if ((self->client) && (self->client->grenadeType == GRENADE_RAILBOMB))
      {
		if (self->client->pers.inventory[ITEM_INDEX(FindItem("Slugs"))] >= 5) // was slugs5
		{
            	self->client->pers.inventory[ITEM_INDEX(FindItem("Slugs"))] -= 5;
            	ent->s.effects |= EF_COLOR_SHELL;
            	ent->s.renderfx |= RF_SHELL_BLUE | RF_SHELL_RED; // Purple glow
            	ent->movetype = MOVETYPE_BOUNCE;
            	ent->touch = Railbomb_Touch;
            	ent->think = Railbomb_Explode;
            	ent->dmg = 120;
            	ent->dmg_radius = 200;
           		ent->nextthink = level.time + 1.5;
            	ent->classname = "railbomb";
            	ent->mass = 5;
            	ent->health = 50;
		}
		else
			gi.cprintf(self, PRINT_HIGH, "Railbombs require 5 grenades per bomb\n");
      }
	else if ((self->client) && (self->client->grenadeType == GRENADE_PLASMA))
      {
		if (self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] >= 20)
		{
            	self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= 20;
			ent->s.effects |= EF_BFG | EF_COLOR_SHELL; // | EF_ANIM_ALLFAST;
			ent->s.renderfx |= RF_SHELL_GREEN;
			ent->touch = plasma_touch;
			ent->nextthink = level.time + 10;
			ent->think = G_FreeEdict;
			ent->dmg = 100;
			ent->radius_dmg = 100;
			ent->dmg_radius = 500;
			ent->classname = "bfg blast";
			ent->s.sound = gi.soundindex ("weapons/bfg__l1a.wav");
			ent->think = plasma_think;
			ent->nextthink = level.time + FRAMETIME;
			ent->teammaster = ent;
			ent->teamchain = NULL;
            }
		else
			gi.cprintf(self, PRINT_HIGH, "Plasma Bombs require 20 cells per bomb\n");
	}
	else if ((self->client) && (self->client->grenadeType == GRENADE_DECOY))
      {
		if (self->client->pers.inventory[ITEM_INDEX(FindItem("Grenades"))] >= 9)
		{
            	self->client->pers.inventory[ITEM_INDEX(FindItem("Grenades"))] -= 9;

			VectorSet (self->mins, -25, -25, -25);
			VectorSet (self->maxs, 25, 25, 25);
			//i = random();
			if (random() < .01)
			 	ent->s.modelindex = gi.modelindex ("models/weapons/g_shotg/tris.md2");
			else if (random() < .02)
			 	ent->s.modelindex = gi.modelindex ("models/weapons/g_shotg2/tris.md2");
			else if (random() < .03)
			 	ent->s.modelindex = gi.modelindex ("models/weapons/g_machn/tris.md2");
			else if (random() < .04)
			 	ent->s.modelindex = gi.modelindex ("models/weapons/g_chain/tris.md2");
			else if (random() < .05)
			 	ent->s.modelindex = gi.modelindex ("models/weapons/g_launch/tris.md2");
			else if (random() < .06)
			 	ent->s.modelindex = gi.modelindex ("models/weapons/g_rocket/tris.md2");
			else if (random() < .07)
			 	ent->s.modelindex = gi.modelindex ("models/weapons/g_hyperb/tris.md2");
			else if (random() < .08)
			 	ent->s.modelindex = gi.modelindex ("models/weapons/g_rail/tris.md2");
			else if (random() < .09)
			 	ent->s.modelindex = gi.modelindex ("models/weapons/g_bfg/tris.md2");
			else
			 	ent->s.modelindex = gi.modelindex ("models/weapons/g_bfg/tris.md2");
	           	ent->movetype = MOVETYPE_TOSS;
	           	ent->s.effects -= EF_GRENADE;
			ent->s.renderfx |=  RF_GLOW;
	           	ent->s.effects |= EF_ROTATE;
	           	ent->dmg = 120;
            	ent->delay = 30;
            	ent->dmg_radius = 100;
            	ent->think = decoy_think;
           		ent->nextthink = level.time + 1;
            	ent->classname = "sequencer_grenade";
            	ent->mass = 5;
            	ent->health = 50;
            }
		else
			gi.cprintf(self, PRINT_HIGH, "Decoy Charges require 10 grenades per charge\n");
	}
}


// XIAN -> From now on, this is new weapon code
/*
=========================================================
New weapon commands and functions
=========================================================
*/

/* 
Freeze Gun
*/

void freezegun_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	int playernum;
	char userinfo[MAX_INFO_STRING];

	// make sure the other person is a player
	if( other->client && !(other->frozen) )
	{
		// grab the user info, and save the old skin
		strcpy( userinfo, other->client->pers.userinfo );
		strcpy( other->oldskin, Info_ValueForKey( userinfo, "skin" ) );
		// make em frozen
		other->frozen = 1;
		// set which skin to use
//		Info_SetValueForKey( userinfo, "skin", "male/frozen" );
//		ClientUserinfoChanged( other, userinfo );
		// set the time till thaw
		other->frozentime = level.time + 140*FRAMETIME;
		other->client->ps.pmove.pm_type = PM_FREEZE;
	      other->s.effects |= EF_COLOR_SHELL;
      	other->s.renderfx |= RF_SHELL_BLUE | RF_SHELL_BLUE | RF_SHELL_GREEN | RF_SHELL_RED; // Bluish look
	}

	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (self);
		return;
	}

	if (self->owner->client)
		PlayerNoise(self->owner, self->s.origin, PNOISE_IMPACT);

	if (!(other->takedamage))
	{
		gi.WriteByte (svc_temp_entity);
		gi.WriteByte (TE_LASER_SPARKS);
		gi.WriteByte (32);
		gi.WritePosition (self->s.origin);
		gi.WriteDir (plane->normal);
		gi.WriteByte (0xf3f3f1f1);
		gi.multicast (self->s.origin, MULTICAST_PVS);
	}
}

void fire_freezegun (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, int effect)
{
      edict_t *bolt;
	trace_t	tr;

	VectorNormalize (dir);

	bolt = G_Spawn();
	VectorCopy (start, bolt->s.origin);
	VectorCopy (start, bolt->s.old_origin);
	vectoangles (dir, bolt->s.angles);
	VectorScale (dir, speed, bolt->velocity);
	bolt->movetype = MOVETYPE_RICOCHET;
	bolt->clipmask = MASK_SHOT;
	bolt->solid = SOLID_BBOX;
      bolt->s.effects |= EF_COLOR_SHELL;
      bolt->s.renderfx |= RF_SHELL_BLUE; // Blue look
	VectorClear (bolt->mins);
	VectorClear (bolt->maxs);
	bolt->s.modelindex = gi.modelindex ("models/objects/laser/tris.md2");
	bolt->s.sound = gi.soundindex ("weapons/rockfly.wav");
	bolt->owner = self;
	bolt->touch = freezegun_touch;
	bolt->nextthink = level.time + 5;
	bolt->think = G_FreeEdict;
	bolt->dmg = 0;
      gi.linkentity (bolt);

      tr = gi.trace (self->s.origin, NULL, NULL, bolt->s.origin, bolt, MASK_SHOT);
	if (tr.fraction < 1.0)
	{
                VectorMA (bolt->s.origin, -10, dir, bolt->s.origin);
                bolt->touch (bolt, tr.ent, NULL, NULL);
	}
}	


/*
FLAREGUN
*/
void flaregun_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (self);
		return;
	}

        if (other->takedamage)
                T_Damage (other, self, self->owner, self->velocity, self->s.origin, plane->normal, 15, 1, DAMAGE_ENERGY, MOD_FLARE);

        gi.WriteByte (svc_temp_entity);
        gi.WriteByte (TE_BLASTER);
        gi.WritePosition (self->s.origin);
        if (!plane)
                gi.WriteDir (vec3_origin);
        else
                gi.WriteDir (plane->normal);
        gi.multicast (self->s.origin, MULTICAST_PVS);

return;
}

void fire_flaregun (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, int effect)
{
      edict_t *bolt;
	trace_t	tr;

	VectorNormalize (dir);
                                        
      bolt = G_Spawn();                 
	VectorCopy (start, bolt->s.origin);
	VectorCopy (start, bolt->s.old_origin);
	vectoangles (dir, bolt->s.angles);
	VectorScale (dir, speed*2, bolt->velocity);
      bolt->movetype = MOVETYPE_TOSS;
	bolt->clipmask = MASK_SHOT;
	bolt->solid = SOLID_BBOX;
      bolt->s.effects |= EF_BLASTER | EF_COLOR_SHELL;
      bolt->s.renderfx |= RF_FULLBRIGHT | (RF_SHELL_GREEN | RF_SHELL_RED) | (RF_SHELL_GREEN | RF_SHELL_RED) | (RF_SHELL_GREEN | RF_SHELL_RED);
	VectorClear (bolt->mins);
	VectorClear (bolt->maxs);
	bolt->s.modelindex = gi.modelindex ("models/objects/laser/tris.md2");
//	bolt->s.sound = gi.soundindex ("misc/lasfly.wav");
	bolt->owner = self;
      bolt->touch = flaregun_touch;
      bolt->nextthink = level.time + 5;
	bolt->think = G_FreeEdict;
	bolt->dmg = 15;
	bolt->classname = "flare";

	gi.linkentity (bolt);

	tr = gi.trace (self->s.origin, NULL, NULL, bolt->s.origin, bolt, MASK_SHOT);
	if (tr.fraction < 1.0)
	{
		VectorMA (bolt->s.origin, -10, dir, bolt->s.origin);
		bolt->touch (bolt, tr.ent, NULL, NULL);
	}
}	

/*
Sequencer Charges
*/

static void sequencer_touch  (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (other == ent->owner)
		return;

	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (ent);
		return;
	}

        if (!other->takedamage)
	{
		VectorClear (ent->velocity) ;
		VectorClear (ent->avelocity) ;
		ent->movetype = MOVETYPE_NONE;
		return;
	}

	sequencer_detonate (ent);
}
static void sequencer_think (edict_t *ent)
{
	edict_t *blip = NULL;
	
      ent->think = sequencer_think;
	while ((blip = findradius(blip, ent->s.origin, 100)) != NULL)
	{
		if (!(blip->svflags & SVF_MONSTER) && !blip->client)
			continue;
            if (blip == ent->owner)
                  continue;
		if (blip->client->resp.ctf_team == ent->owner->client->resp.ctf_team)
			continue;
		if (!blip->takedamage)
			continue;
		if (blip->health <= 0)
			continue;
		if (!visible(ent, blip))
			continue;
		ent->think = sequencer_explode;
		break;
	}

	ent->nextthink = level.time + .1;
}

static void sequencer_detonate (edict_t *ent)
{
	ent->think = sequencer_explode;
	ent->nextthink = level.time + .1;
}
static void sequencer_explode (edict_t *ent)
{
	vec3_t		origin;
	int			mod;

	if (ent->owner->client)
		PlayerNoise(ent->owner, ent->s.origin, PNOISE_IMPACT);

	//FIXME: if we are onground then raise our Z just a bit since we are a point?
	if (ent->enemy)
	{
		float	points;
		vec3_t	v;
		vec3_t	dir;

		VectorAdd (ent->enemy->mins, ent->enemy->maxs, v);
		VectorMA (ent->enemy->s.origin, 0.5, v, v);
		VectorSubtract (ent->s.origin, v, v);
		points = ent->dmg - 0.5 * VectorLength (v);
		VectorSubtract (ent->enemy->s.origin, ent->s.origin, dir);
		T_Damage (ent->enemy, ent, ent->owner, dir, ent->s.origin, vec3_origin, (int)points, (int)points, DAMAGE_RADIUS, MOD_SEQUENCER);
	}

	T_RadiusDamage(ent, ent->owner, ent->dmg, ent->enemy, ent->dmg_radius, MOD_SEQUENCER_SPLASH);

	VectorMA (ent->s.origin, -0.02, ent->velocity, origin);
	gi.WriteByte (svc_temp_entity);
	if (ent->waterlevel)
	{
		if (ent->groundentity)
			gi.WriteByte (TE_GRENADE_EXPLOSION_WATER);
		else
			gi.WriteByte (TE_ROCKET_EXPLOSION_WATER);
	}
	else
	{
		if (ent->groundentity)
			gi.WriteByte (TE_GRENADE_EXPLOSION);
		else
			gi.WriteByte (TE_ROCKET_EXPLOSION);
	}
	gi.WritePosition (origin);
	gi.multicast (ent->s.origin, MULTICAST_PHS);

	G_FreeEdict (ent);
}

/*
Decoy
*/

static void decoy_think (edict_t *ent)
{
	vec3_t		origin;
      vec3_t  		offset, v;

	// We are going to 'levitate' it so that it looks like a normal weapon!
      VectorSet(offset, 0, 0, 20);
      VectorAdd(ent->s.origin, offset, ent->s.origin);

	// It's 'levitated', now think like a sequencer
      ent->think = sequencer_think;
	ent->nextthink = level.time + .1;
}


/*
Cluster Bombs
*/

static void Cluster_Explode (edict_t *ent)
{
	vec3_t		origin;
	vec3_t		grenade1;
	vec3_t		grenade2;
	vec3_t		grenade3;
	vec3_t		grenade4;
	vec3_t		grenade5;
	vec3_t		grenade6;
	vec3_t		grenade7;
	vec3_t		grenade8;
 
	if (ent->owner->client)
		PlayerNoise(ent->owner, ent->s.origin, PNOISE_IMPACT);

	//FIXME: if we are onground then raise our Z just a bit since we are a point?
        T_RadiusDamage(ent, ent->owner, ent->dmg, NULL, ent->dmg_radius, MOD_CLUSTER_SPLASH);

	VectorMA (ent->s.origin, -0.02, ent->velocity, origin);
	gi.WriteByte (svc_temp_entity);
	if (ent->waterlevel)
	{
		if (ent->groundentity)
			gi.WriteByte (TE_GRENADE_EXPLOSION_WATER);
		else
			gi.WriteByte (TE_ROCKET_EXPLOSION_WATER);
	}
	else
	{
		if (ent->groundentity)
			gi.WriteByte (TE_GRENADE_EXPLOSION);
		else
			gi.WriteByte (TE_ROCKET_EXPLOSION);
	}
	gi.WritePosition (origin);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

// Give each grenade a XYZ velocity...
// Imagine the directions in the comments like if viewing from above

	VectorSet(grenade1,20,20,40);		// Diagonal: 	Right-Up
	VectorSet(grenade2,20,-20,40); 	// Diagonal: 	Right-Down
	VectorSet(grenade3,-20,20,40); 	// Diagonal: 	Left-Up
	VectorSet(grenade4,-20,-20,40);	// Diagonal: 	Left-Down
      VectorSet(grenade5,30,0,40); 		// Horizontal: 	Right
      VectorSet(grenade6,0,30,40); 		// Vertical: 	Up
      VectorSet(grenade7,-30,0,40); 	// Horizontal: 	Left
      VectorSet(grenade8,0,-30,40); 	// Vertical: 	Down
 
// Well, fire them!
	fire_minicluster(ent, origin, grenade1, 120, 10, 1.25, 120);	
	fire_minicluster(ent, origin, grenade2, 120, 10, 1.25, 120);
      fire_minicluster(ent, origin, grenade3, 120, 10, 1.25, 120);
      fire_minicluster(ent, origin, grenade4, 120, 10, 1.25, 120);
      fire_minicluster(ent, origin, grenade5, 120, 10, 1.25, 120); 
      fire_minicluster(ent, origin, grenade6, 120, 10, 1.25, 120); 
      fire_minicluster(ent, origin, grenade7, 120, 10, 1.25, 120); 
	fire_minicluster(ent, origin, grenade8, 120, 10, 1.25, 120); 
 
	G_FreeEdict (ent);
}

void fire_minicluster (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius)
{
	edict_t	*grenade;
	vec3_t	dir;
	vec3_t	forward, right, up;

	vectoangles (aimdir, dir);
	AngleVectors (dir, forward, right, up);

	grenade = G_Spawn();
	VectorCopy (start, grenade->s.origin);
	VectorScale (aimdir, speed, grenade->velocity);
	VectorMA (grenade->velocity, 200 + crandom() * 10.0, up, grenade->velocity);
	VectorMA (grenade->velocity, crandom() * 10.0, right, grenade->velocity);
	VectorSet (grenade->avelocity, 300, 300, 300);
	grenade->movetype = MOVETYPE_BOUNCE;
	grenade->clipmask = MASK_SHOT;
	grenade->solid = SOLID_BBOX;
      grenade->s.effects |= EF_GRENADE | EF_COLOR_SHELL;
      grenade->s.renderfx |= RF_SHELL_BLUE;
	VectorClear (grenade->mins);
	VectorClear (grenade->maxs);
	grenade->s.modelindex = gi.modelindex ("models/objects/grenade2/tris.md2");
	grenade->owner = self;
	grenade->touch = Grenade_Touch;
      grenade->nextthink = level.time + 1.25;
	grenade->think = Grenade_Explode;
      grenade->dmg = 120;
      grenade->dmg_radius = 200;
	grenade->classname = "grenade";

	gi.linkentity (grenade);
}

static void Cluster_Touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (other == ent->owner)
		return;

	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (ent);
		return;
	}

	if (!other->takedamage)
	{
		if (ent->spawnflags & 1)
		{
			if (random() > 0.5)
				gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/hgrenb1a.wav"), 1, ATTN_NORM, 0);
			else
				gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/hgrenb2a.wav"), 1, ATTN_NORM, 0);
		}
		else
		{
			gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/grenlb1b.wav"), 1, ATTN_NORM, 0);
		}
		return;
	}

        Cluster_Explode (ent);
}

/*
Rail Grenades
*/

static void Railbomb_Explode (edict_t *ent)
{
	vec3_t		origin;
	vec3_t  		rail_aim;
      vec3_t  		offset, v;
	int			i;

      // Move it off the ground so that rails can go out
      VectorSet(offset, 0, 0, 20);
      VectorAdd(ent->s.origin, offset, ent->s.origin);

	if (ent->owner->client)
		PlayerNoise(ent->owner, ent->s.origin, PNOISE_IMPACT);

	//FIXME: if we are onground then raise our Z just a bit since we are a point?
	T_RadiusDamage(ent, ent->owner, ent->dmg, ent->enemy, ent->dmg_radius, MOD_RAILBOMB_SPLASH);

	VectorMA (ent->s.origin, -0.02, ent->velocity, origin);
	gi.WriteByte (svc_temp_entity);
	if (ent->waterlevel)
	{
		if (ent->groundentity)
			gi.WriteByte (TE_GRENADE_EXPLOSION_WATER);
		else
			gi.WriteByte (TE_ROCKET_EXPLOSION_WATER);
	}
	else
	{
		if (ent->groundentity)
			gi.WriteByte (TE_GRENADE_EXPLOSION);
		else
			gi.WriteByte (TE_ROCKET_EXPLOSION);
	}
	gi.WritePosition (origin);
	gi.multicast (ent->s.origin, MULTICAST_PHS);

	for (i = 0; i<11; i++) 
	{
		rail_aim[0] = ((rand() % 360) * (((rand() % 2) == 0) ? -1 : 1)); 
		rail_aim[1] = ((rand() % 360) * (((rand() % 2) == 0) ? -1 : 1)); 
		rail_aim[2] = 10 + ((rand() % 40));
		Railbomb_Rails (ent, origin, rail_aim, 100, 0); 
	}	

	G_FreeEdict (ent);
}

static void Railbomb_Touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (other == ent->owner)
		return;

	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (ent);
		return;
	}

	if (!other->takedamage)
	{
		if (ent->spawnflags & 1)
		{
			if (random() > 0.5)
				gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/hgrenb1a.wav"), 1, ATTN_NORM, 0);
			else
				gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/hgrenb2a.wav"), 1, ATTN_NORM, 0);
		}
		else
		{
			gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/grenlb1b.wav"), 1, ATTN_NORM, 0);
		}
		return;
	}

	ent->enemy = other;
	Railbomb_Explode (ent);
}

void Railbomb_Rails (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick) 
{ 
	vec3_t  from; 
	vec3_t  end; 
	trace_t  tr; 
	edict_t  *ignore; 
	int   mask; 
	qboolean water; 
	  
	VectorMA (start, 8192, aimdir, end); 
	VectorCopy (start, from); 
	ignore = self; 
	water = false; 
	mask = MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA; 
	while (ignore) 
	{ 
		tr = gi.trace (from, NULL, NULL, end, NULL, mask); // null is normally ignore...trying to get damage to player throwing gren 
	
		if (tr.contents & (CONTENTS_SLIME|CONTENTS_LAVA)) 
	  	{ 
	   		mask &= ~(CONTENTS_SLIME|CONTENTS_LAVA); 
	   		water = true; 
	  	}
	  	else 
	  	{ 
	   		if ((tr.ent->svflags & SVF_MONSTER) || (tr.ent->client)) 
	    		ignore = tr.ent; 
	   	else 
	    		ignore = NULL; 
	
	   	if ((tr.ent->takedamage)) 
			T_Damage (tr.ent, self, self->owner, aimdir, tr.endpos, tr.plane.normal, damage, kick, 0, MOD_RAILBOMB); 
		} 
	
		VectorCopy (tr.endpos, from); 
	} 
	
	// send gun puff / flash 
	gi.WriteByte (svc_temp_entity); 
	gi.WriteByte (TE_RAILTRAIL); 
	gi.WritePosition (start); 
	gi.WritePosition (tr.endpos); 
	gi.multicast (self->s.origin, MULTICAST_PHS); 
	// gi.multicast (start, MULTICAST_PHS); 
	if (water) 
	{ 
	gi.WriteByte (svc_temp_entity); 
	gi.WriteByte (TE_RAILTRAIL); 
	gi.WritePosition (start); 
	gi.WritePosition (tr.endpos); 
	gi.multicast (tr.endpos, MULTICAST_PHS); 
	}

	if (self->client) 
		PlayerNoise(self, tr.endpos, PNOISE_IMPACT); 
}
	
/*
Flash Bombs
*/

void Flash_Explode (edict_t *ent)
{
        vec3_t	offset, v;
        edict_t	*target;
        float Distance, BlindTimeAdd;
  
        // Move it off the ground so people are sure to see it
        VectorSet(offset, 0, 0, 30);
        VectorAdd(ent->s.origin, offset, ent->s.origin);
  
        if (ent->owner->client)
                PlayerNoise(ent->owner, ent->s.origin, PNOISE_IMPACT);

        target = NULL;
        while ((target = findradius(target, ent->s.origin, FLASH_RADIUS)) != NULL)
	  {
        	if (!target->client)
            	continue;       // It's not a player
            if (!visible(ent, target))
                  continue;       // The grenade can't see it

            // Find distance
            VectorSubtract(ent->s.origin, target->s.origin, v);
            Distance = VectorLength(v);

            // Calculate blindness factor
            if ( Distance < FLASH_RADIUS/10 )
                    BlindTimeAdd = BLIND_FLASH; // Blind completely
            else
                    BlindTimeAdd = 1.5 * BLIND_FLASH * ( 1 / ( ( Distance - FLASH_RADIUS*2 ) / (FLASH_RADIUS*2) - 2 ) + 1 ); // Blind partially
            if ( BlindTimeAdd < 0 )
                    BlindTimeAdd = 0; // Do not blind at all.
            // Not facing it, but still blinded a little
            if (infront(target, ent)) // Removed ! here...
//          if (!infront(target, ent))
                    BlindTimeAdd *= .5;
            // You know when to close your eyes, don't you? Doesn't quite do the job. :)
            if (!(target == ent->owner)) // Added ! and ( ) here
//          if (target == ent->owner)
            {
                    target->client->blindTime += BlindTimeAdd * .25;
                    target->client->blindBase = BLIND_FLASH;
			  continue;
            }
		// Is it on your team? Blind him, even if it's a little!
		if (!(target->client->resp.ctf_team == ent->owner->client->resp.ctf_team)) // Added ! and ( ) here
//		if (target->client->resp.ctf_team == ent->owner->client->resp.ctf_team)
            {
                    target->client->blindTime += BlindTimeAdd * .25;
                    target->client->blindBase = BLIND_FLASH;
			  continue;
            }

            // Increment the blindness counter
            target->client->blindTime += BlindTimeAdd * 1.5;
            target->client->blindBase = BLIND_FLASH;
            target->s.angles[YAW] = ((rand() % 360) * (((rand() % 2) == 0) ? -1 : 1)); // Whee! (XIAN: Was division)
//          target->s.angles[YAW] = (rand() % 360); // Whee!
            // Let the player know what just happened
            // (It's just as well, he won't see the message immediately!)
//            gi.cprintf(target, PRINT_HIGH, "You have been blinded by %s 's flash grenade\n", ent->owner);
            // Let the owner of the grenade know it worked
//            gi.cprintf(ent->owner, PRINT_HIGH, "%s is blinded by your flash grenade!\n", target->client->pers.netname);
        }

        // Blow up the grenade
        BecomeExplosion1(ent);
}

static void Flash_Touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (other == ent->owner)
      	return;

	// If it goes in to orbit, it's gone...
      if (surf && (surf->flags & SURF_SKY))
      {
      	G_FreeEdict (ent);
            return;
	}

                // All this does is make the bouncing noises when it hits something...
      if (!other->takedamage)
      {
      	if (ent->spawnflags & 1)
            {
            	if (random() > 0.5)
                  	gi.sound (ent, CHAN_VOICE, gi.soundindex("weapons/hgrenb1a.wav"), 1, ATTN_NORM, 0);
			else
                  	gi.sound (ent, CHAN_VOICE, gi.soundindex("weapons/hgrenb2a.wav"), 1, ATTN_NORM, 0);
            }
            else
            	gi.sound (ent, CHAN_VOICE, gi.soundindex("weapons/grenlb1b.wav"), 1, ATTN_NORM, 0);
                
       	return;
	}

      // The ONLY DIFFERENCE between this and "Grenade_Touch"!!
      Flash_Explode (ent);    
}

/*
Dead Grenades
*/

static void Grenade_Die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	self->takedamage = DAMAGE_NO;
	self->nextthink = level.time + .1;
	self->think = DeadGrenade_Explode;
}
static void DeadGrenade_Explode (edict_t *ent)
{
	vec3_t		origin;


	if (ent->owner->client)
		PlayerNoise(ent->owner, ent->s.origin, PNOISE_IMPACT);

	//FIXME: if we are onground then raise our Z just a bit since we are a point?
	if (ent->enemy)
	{
		float	points;
		vec3_t	v;
		vec3_t	dir;

		VectorAdd (ent->enemy->mins, ent->enemy->maxs, v);
		VectorMA (ent->enemy->s.origin, 0.5, v, v);
		VectorSubtract (ent->s.origin, v, v);
		points = ent->dmg - 0.5 * VectorLength (v);
		VectorSubtract (ent->enemy->s.origin, ent->s.origin, dir);
		T_Damage (ent->enemy, ent, ent->owner, dir, ent->s.origin, vec3_origin, (int)points, (int)points, DAMAGE_RADIUS, MOD_DEAD_GRENADE);
	}

	T_RadiusDamage(ent, ent->owner, ent->dmg, ent->enemy, ent->dmg_radius, MOD_DEAD_GRENADE);

	VectorMA (ent->s.origin, -0.02, ent->velocity, origin);
	gi.WriteByte (svc_temp_entity);
	if (ent->waterlevel)
	{
		if (ent->groundentity)
			gi.WriteByte (TE_GRENADE_EXPLOSION_WATER);
		else
			gi.WriteByte (TE_ROCKET_EXPLOSION_WATER);
	}
	else
	{
		if (ent->groundentity)
			gi.WriteByte (TE_GRENADE_EXPLOSION);
		else
			gi.WriteByte (TE_ROCKET_EXPLOSION);
	}
	gi.WritePosition (origin);
	gi.multicast (ent->s.origin, MULTICAST_PHS);

	G_FreeEdict (ent);
}

/*
Dead Rockets
*/

static void Rocket_Explode (edict_t *ent)
{
	vec3_t		origin;

	if (ent->owner->client)
		PlayerNoise(ent->owner, ent->s.origin, PNOISE_IMPACT);

	// calculate position for the explosion entity
	VectorMA (ent->s.origin, -0.02, ent->velocity, origin);

        T_RadiusDamage(ent, ent->owner, 100, NULL, 250,MOD_DEAD_ROCKET);

	gi.WriteByte (svc_temp_entity);
	if (ent->waterlevel)
		gi.WriteByte (TE_ROCKET_EXPLOSION_WATER);
	else
		gi.WriteByte (TE_ROCKET_EXPLOSION);
	gi.WritePosition (origin);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	G_FreeEdict (ent);
}

static void Rocket_Die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	self->takedamage = DAMAGE_NO;
	self->nextthink = level.time + .1;
	self->think = Rocket_Explode;
}

/*
Triple Rockets
*/

static void Rocket_SpiralThink(edict_t *ent)
{
	vec3_t newpos, pos;

	VectorSubtract(ent->s.origin, ent->pos2, pos);
	RotatePointAroundVector(newpos, ent->pos1, pos, 30);
	VectorAdd(ent->pos2, newpos, ent->s.origin);
	RotatePointAroundVector(ent->velocity, ent->pos1, ent->velocity, 30);

	ent->nextthink = level.time + .1;
}

/*
Triple Rockets
*/

void fire_rocket2 (edict_t *self, vec3_t start, vec3_t dir, vec3_t los, int damage, int speed, 
float damage_radius, int radius_damage)
{
	edict_t *rocket;

	rocket = G_Spawn();

	VectorCopy (los, rocket->pos1);
	VectorCopy (start, rocket->pos2);
	
	VectorCopy (start, rocket->s.origin);
	VectorCopy (dir, rocket->movedir);
	vectoangles (dir, rocket->s.angles);
	VectorScale (dir, speed, rocket->velocity);
	rocket->movetype = MOVETYPE_FLYMISSILE;
	rocket->clipmask = MASK_SHOT;
	rocket->solid = SOLID_BBOX;
	rocket->s.effects |= EF_ROCKET;
	VectorClear (rocket->mins);
	VectorClear (rocket->maxs);
	rocket->s.modelindex = gi.modelindex ("models/objects/rocket/tris.md2");
	rocket->owner = self;
	rocket->touch = rocket_touch;
	rocket->nextthink = level.time + .1;
	rocket->think = Rocket_SpiralThink;
      rocket->dmg = 120;
      rocket->radius_dmg = 50;
      rocket->dmg_radius = 100;
	rocket->s.sound = gi.soundindex ("weapons/rockfly.wav");
	
	if (self->client)
	check_dodge (self, rocket->s.origin, dir, speed);
	
	gi.linkentity (rocket);
}

/*
Heat Seekers
*/

void homing_think (edict_t *ent)
{
	edict_t	*target = NULL;
	edict_t *blip = NULL;
	vec3_t	targetdir, blipdir;
	vec_t	speed;

	while ((blip = findradius(blip, ent->s.origin, 1000)) != NULL)
	{
		if (!(blip->svflags & SVF_MONSTER) && !blip->client)
			continue;
		if (blip == ent->owner)
			continue;
		if (!blip->takedamage)
			continue;
		if (blip->health <= 0)
			continue;
		if (!visible(ent, blip))
			continue;
		if (!infront(ent, blip))
			continue;
		if (blip->client->resp.ctf_team == ent->owner->client->resp.ctf_team)
			continue;
		VectorSubtract(blip->s.origin, ent->s.origin, blipdir);
		blipdir[2] += 16;
		if ((target == NULL) || (VectorLength(blipdir) < VectorLength(targetdir)))
		{
			target = blip;
			VectorCopy(blipdir, targetdir);
		}
	}
		
	if (target != NULL)
	{
		// target acquired, nudge our direction toward it
		VectorNormalize(targetdir);
		VectorScale(targetdir, 0.6, targetdir);
//		VectorScale(targetdir, 0.2, targetdir); // XIAN
		VectorAdd(targetdir, ent->movedir, targetdir);
		VectorNormalize(targetdir);
		VectorCopy(targetdir, ent->movedir);
		vectoangles(targetdir, ent->s.angles);
		speed = VectorLength(ent->velocity);
		VectorScale(targetdir, speed, ent->velocity);
		//is this the same target as before? sound warning for new targets 
		if (target != ent->homing_target) 
		{ 
			gi.sound (target, CHAN_AUTO, gi.soundindex ("world/klaxon2.wav"), 1, ATTN_NORM, 0); 
			ent->homing_target = target; 
		}
	}

	ent->nextthink = level.time + .1;
}

/*
Disintegrator
*/

// Code not yet done

/*
Plasma Bombs
*/

void plasma_explode (edict_t *self)
{
	edict_t	*ent;
	float	points;
	vec3_t	v;
	float	dist;

	if (self->s.frame == 0)
	{
		ent = NULL;
		while ((ent = findradius(ent, self->s.origin, self->dmg_radius)) != NULL)
		{
			if (!ent->takedamage)
				continue;
			if (ent == self->owner)
				continue;
			if (!CanDamage (ent, self))
				continue;
			if (!CanDamage (ent, self->owner))
				continue;

			VectorAdd (ent->mins, ent->maxs, v);
			VectorMA (ent->s.origin, 0.5, v, v);
			VectorSubtract (self->s.origin, v, v);
			dist = VectorLength(v);
			points = self->radius_dmg * (1.0 - sqrt(dist/self->dmg_radius));
			if (ent == self->owner)
				points = points * 0.5;

			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_BFG_EXPLOSION);
			gi.WritePosition (ent->s.origin);
			gi.multicast (ent->s.origin, MULTICAST_PHS);
			T_Damage (ent, self, self->owner, self->velocity, ent->s.origin, vec3_origin, (int)points, 0, DAMAGE_ENERGY, MOD_PLASMA_EFFECT);
		}
	}

	self->nextthink = level.time + FRAMETIME;
	self->s.frame++;
	if (self->s.frame == 5)
		self->think = G_FreeEdict;
}

void plasma_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (other == self->owner)
		return;

	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (self);
		return;
	}

	if (self->owner->client)
		PlayerNoise(self->owner, self->s.origin, PNOISE_IMPACT);

	// core explosion - prevents firing it into the wall/floor
	if (other->takedamage)
		T_Damage (other, self, self->owner, self->velocity, self->s.origin, plane->normal, 200, 0, 0, MOD_PLASMA_BLAST);
	T_RadiusDamage(self, self->owner, 200, other, 100, MOD_PLASMA_BLAST);

	gi.sound (self, CHAN_VOICE, gi.soundindex ("weapons/bfg__x1b.wav"), 1, ATTN_NORM, 0);
	self->movetype = MOVETYPE_NONE;
	self->solid = SOLID_NOT;
	self->touch = NULL;
	VectorMA (self->s.origin, -1 * FRAMETIME, self->velocity, self->s.origin);
	VectorClear (self->velocity);
	self->s.modelindex = gi.modelindex ("sprites/s_bfg3.sp2");
	self->s.frame = 0;
	self->s.sound = 0;
	self->s.effects &= ~EF_ANIM_ALLFAST;
	self->think = plasma_explode;
	self->nextthink = level.time + FRAMETIME;
	self->enemy = other;

	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_BFG_BIGEXPLOSION);
	gi.WritePosition (self->s.origin);
	gi.multicast (self->s.origin, MULTICAST_PVS);
}

void plasma_think (edict_t *self)
{
	edict_t	*ent;
	edict_t	*ignore;
	vec3_t	point;
	vec3_t	dir;
	vec3_t	start;
	vec3_t	end;
	int		dmg;
	trace_t	tr;

	dmg = 1;

	ent = NULL;
	while ((ent = findradius(ent, self->s.origin, 256)) != NULL)
	{
		if (ent == self)
			continue;

		if (ent == self->owner)
			continue;

		if (!ent->takedamage)
			continue;

		if (!(ent->svflags & SVF_MONSTER) && (!ent->client) && (strcmp(ent->classname, "misc_explobox") != 0))
			continue;

		if (ctf->value && ent->client &&
			self->owner->client &&
			ent->client->resp.ctf_team == self->owner->client->resp.ctf_team)
			continue;

		VectorMA (ent->absmin, 0.5, ent->size, point);

		VectorSubtract (point, self->s.origin, dir);
		VectorNormalize (dir);

		ignore = self;
		VectorCopy (self->s.origin, start);
		VectorMA (start, 2048, dir, end);
		while(1)
		{
			tr = gi.trace (start, NULL, NULL, end, ignore, CONTENTS_SOLID|CONTENTS_MONSTER|CONTENTS_DEADMONSTER);

			if (!tr.ent)
				break;

			// hurt it if we can
			if ((tr.ent->takedamage) && !(tr.ent->flags & FL_IMMUNE_LASER) && (tr.ent != self->owner))
				T_Damage (tr.ent, self, self->owner, dir, tr.endpos, vec3_origin, dmg, 1, DAMAGE_ENERGY, MOD_PLASMA_LASER);

			// if we hit something that's not a monster or player we're done
			if (!(tr.ent->svflags & SVF_MONSTER) && (!tr.ent->client))
			{
				gi.WriteByte (svc_temp_entity);
				gi.WriteByte (TE_LASER_SPARKS);
				gi.WriteByte (4);
				gi.WritePosition (tr.endpos);
				gi.WriteDir (tr.plane.normal);
				gi.WriteByte (self->s.skinnum);
				gi.multicast (tr.endpos, MULTICAST_PVS);
				break;
			}

			ignore = tr.ent;
			VectorCopy (tr.endpos, start);
		}

		gi.WriteByte (svc_temp_entity);
		gi.WriteByte (TE_BFG_LASER);
		gi.WritePosition (self->s.origin);
		gi.WritePosition (tr.endpos);
		gi.multicast (self->s.origin, MULTICAST_PHS);
	}

	self->nextthink = level.time + FRAMETIME;
}

/*
Laser Gun
*/

void lasergun_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	int playernum;
	char userinfo[MAX_INFO_STRING];

	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (self);
		return;
	}

	if (self->owner->client)
		PlayerNoise(self->owner, self->s.origin, PNOISE_IMPACT);

      if (other->takedamage) // If other takes damage, damage it and disappear, else keep bouncing
	{
		T_Damage (other, self, self->owner, self->velocity, self->s.origin, plane->normal, 125, 1, DAMAGE_ENERGY, MOD_LASER);
		G_FreeEdict (self);
	}

	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_LASER_SPARKS);
	gi.WriteByte (32);
	gi.WritePosition (self->s.origin);
	gi.WriteDir (plane->normal);
	gi.WriteByte (0xf2f2f0f0);
	gi.multicast (self->s.origin, MULTICAST_PVS);
}

/* 
Minirocket Gun
*/

void minirocket_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (self);
		return;
	}

	if (self->owner->client)
		PlayerNoise(self->owner, self->s.origin, PNOISE_IMPACT);

      if (other->takedamage)
		T_Damage (other, self, self->owner, self->velocity, self->s.origin, plane->normal, 5, 1, DAMAGE_ENERGY, MOD_MINIROCKET);

	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_LASER_SPARKS);
	gi.WriteByte (32);
	gi.WritePosition (self->s.origin);
	gi.WriteDir (plane->normal);
	gi.WriteByte (0xdcdddedf);
	gi.multicast (self->s.origin, MULTICAST_PVS);

	G_FreeEdict (self);
}

void fire_minirocket (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed)
{
      edict_t *bolt;
	trace_t	tr;

	VectorNormalize (dir);

	bolt = G_Spawn();
	VectorCopy (start, bolt->s.origin);
	VectorCopy (start, bolt->s.old_origin);
	vectoangles (dir, bolt->s.angles);
	VectorScale (dir, speed, bolt->velocity);
	bolt->movetype = MOVETYPE_FLYMISSILE;
	bolt->clipmask = MASK_SHOT;
	bolt->solid = SOLID_BBOX;
      bolt->s.effects |= EF_COLOR_SHELL;
      bolt->s.renderfx |= RF_SHELL_RED | RF_SHELL_GREEN | RF_FULLBRIGHT; // Yellow look
	VectorClear (bolt->mins);
	VectorClear (bolt->maxs);
	bolt->s.modelindex = gi.modelindex ("models/objects/laser/tris.md2");
	bolt->s.sound = gi.soundindex ("weapons/rockfly.wav");
	bolt->owner = self;
	bolt->touch = minirocket_touch;
	bolt->nextthink = level.time + 2;
	bolt->think = G_FreeEdict;
	bolt->dmg = 25;
      gi.linkentity (bolt);

      tr = gi.trace (self->s.origin, NULL, NULL, bolt->s.origin, bolt, MASK_SHOT);
	if (tr.fraction < 1.0)
	{
                VectorMA (bolt->s.origin, -10, dir, bolt->s.origin);
                bolt->touch (bolt, tr.ent, NULL, NULL);
	}
}	


