#include	"g_local.h"
#include	"x_force.h"

/*
=========================================================
FORCE SELECTION:
Selects next, prtevious forces, activates, deactivates 
them

CREDITS:
Hector Ramos
=========================================================
*/

/*
Selects next force power
*/

void Force_Next (edict_t *ent)
{
	if (ent->client->forceType == FORCE_PULL)
     	{
           	gi.cprintf(ent, PRINT_HIGH, "Force Push\n");
            ent->client->forceType = FORCE_PUSH;
	}
	else if (ent->client->forceType == FORCE_PUSH)
      {
		gi.cprintf(ent, PRINT_HIGH, "Force Blinding\n");
      	ent->client->forceType = FORCE_BLINDING;
	}
	else if (ent->client->forceType == FORCE_BLINDING)
      {
      	gi.cprintf(ent, PRINT_HIGH, "Force Healing\n");
      	ent->client->forceType = FORCE_HEALING;
	}
	else if (ent->client->forceType == FORCE_HEALING)
     	{
           	gi.cprintf(ent, PRINT_HIGH, "Force Destruction\n");
            ent->client->forceType = FORCE_DESTRUCTION;
	}
	else if (ent->client->forceType == FORCE_DESTRUCTION)
	{
		gi.cprintf(ent, PRINT_HIGH, "Force Projection\n");
		ent->client->forceType = FORCE_PROJECTION;
	}
	else if (ent->client->forceType == FORCE_PROJECTION)
     	{
           	gi.cprintf(ent, PRINT_HIGH, "Force Tracking\n");
            ent->client->forceType = FORCE_TRACKING;
	}
	else if (ent->client->forceType == FORCE_TRACKING)
     	{
           	gi.cprintf(ent, PRINT_HIGH, "Force Pull\n");
            ent->client->forceType = FORCE_PULL;
	}
	else
     	{
           	gi.cprintf(ent, PRINT_HIGH, "Force Pull\n");
            ent->client->forceType = FORCE_PULL;
	}
}

/*
Selects previous force power
*/

void Force_Prev (edict_t *ent)
{
	if (ent->client->forceType == FORCE_PULL)
	{
		gi.cprintf(ent, PRINT_HIGH, "Force Tracking\n");
	    	ent->client->forceType = FORCE_TRACKING;
	}
	else if (ent->client->forceType == FORCE_TRACKING)
	{
	 	gi.cprintf(ent, PRINT_HIGH, "Force Projection\n");
	    	ent->client->forceType = FORCE_PROJECTION;
	}
	else if (ent->client->forceType == FORCE_PROJECTION)
     	{
           	gi.cprintf(ent, PRINT_HIGH, "Force Destruction\n");
            ent->client->forceType = FORCE_DESTRUCTION;
	}
	else if (ent->client->forceType == FORCE_DESTRUCTION)
	{
		gi.cprintf(ent, PRINT_HIGH, "Force Healing\n");
	    	ent->client->forceType = FORCE_HEALING;
	}
	else if (ent->client->forceType == FORCE_HEALING)
	{
		gi.cprintf(ent, PRINT_HIGH, "Force Blinding\n");
	    	ent->client->forceType = FORCE_BLINDING;
	}
	else if (ent->client->forceType == FORCE_BLINDING)
     	{
           	gi.cprintf(ent, PRINT_HIGH, "Force Push\n");
            ent->client->forceType = FORCE_PUSH;
	}
	else if (ent->client->forceType == FORCE_PUSH)
     	{
           	gi.cprintf(ent, PRINT_HIGH, "Force Pull\n");
            ent->client->forceType = FORCE_PULL;
	}
	else
     	{
           	gi.cprintf(ent, PRINT_HIGH, "Force Pull\n");
            ent->client->forceType = FORCE_PULL;
	}
}

/*
Activates force power
*/

void Force_On (edict_t *ent)
{
	if (ent->health <= 0)
		return;
	else if (ent->client->forceType == FORCE_PULL)
     	{
                Force_Pull (ent);
	}
	else if (ent->client->forceType == FORCE_TRACKING)
     	{
                Force_Tracking (ent);    
	}
	else if (ent->client->forceType == FORCE_HEALING)
     	{
                Force_Healing (ent);    
	}
	else if (ent->client->forceType == FORCE_PROJECTION)
     	{
                Force_Projection (ent);
	}
	else if (ent->client->forceType == FORCE_DESTRUCTION)
     	{
                Force_Destruction (ent);
	}
	else if (ent->client->forceType == FORCE_BLINDING)
     	{
                Force_Blinding (ent);
	}
        else if (ent->client->forceType == FORCE_PUSH)
     	{
                Force_Push (ent);
	}
	else
     	{
                Force_Pull (ent);
	}
}

/*
=========================================================
FORCE TRACKING:
Displays all player names, their health, and distance.

CREDITS:
Chris Hilton
=========================================================
*/

void Force_Tracking (edict_t *ent)
{
	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Mana"))] >= 20)
	{
		int i, j; 
		edict_t *player;
		char stats[500];
		vec3_t v;
		float len;

		ent->client->pers.inventory[ITEM_INDEX(FindItem("Mana"))] -= 20;
	
		j = sprintf(stats, " Name Health Range\n=============================\n");
	
		for (i= 0 ; i <= maxclients->value ; i++)
		{
			player = g_edicts + 1 + i;
			if (!player->inuse || !player->client)
				continue; 
			VectorSubtract (ent->s.origin, player->s.origin, v);
			len = VectorLength (v);
			j += sprintf(stats + j, "%16s %6d %5.0f\n", player->client->pers.netname, player->health, len);
			if (j > 450)
				break;
		}	

		gi.centerprintf(ent, "%s", stats);

	      gi.sound( ent, CHAN_AUTO, gi.soundindex("world/comp_hum1.wav"), 1, ATTN_NONE, 0 );

		return;
	}
	gi.cprintf(ent, PRINT_HIGH, "Not enough Force Mana available.\n");
	return;
}	

/*
=========================================================
FORCE PUSH:
Pushes anyone...

CREDITS:
Chris Hilton
=========================================================
*/

void Force_Push (edict_t *ent)
{
	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Mana"))] >= 10) // 10 when we implement mana
	{
		vec3_t	start;
		vec3_t	forward;
		vec3_t	end;
		trace_t	tr;
	
		ent->client->pers.inventory[ITEM_INDEX(FindItem("Mana"))] -= 10; // 10 when we implement mana

		VectorCopy(ent->s.origin, start);
		start[2] += ent->viewheight;
		AngleVectors(ent->client->v_angle, forward, NULL, NULL);
		VectorMA(start, 8192, forward, end);
		tr = gi.trace(start, NULL, NULL, end, ent, MASK_SHOT);
		if ( tr.ent && ((tr.ent->svflags & SVF_MONSTER) || (tr.ent->client)) )
		{
			VectorScale(forward, 15000, forward); // was 5000
			VectorAdd(forward, tr.ent->velocity, tr.ent->velocity);
		}
	      gi.sound( ent, CHAN_AUTO, gi.soundindex("world/airhiss1.wav"), 1, ATTN_NONE, 0 );

		return;
	}
	gi.cprintf(ent, PRINT_HIGH, "Not enough Force Mana available.\n");
	return;
}

/*
=========================================================
FORCE PULL:
Pulls anyone...

CREDITS:
Chris Hilton
=========================================================
*/

void Force_Pull (edict_t *ent)
{
	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Mana"))] >= 10) // 10 when we implement mana
	{
		vec3_t	start;
		vec3_t	forward;
		vec3_t	end;
		trace_t	tr;
	
		ent->client->pers.inventory[ITEM_INDEX(FindItem("Mana"))] -= 10; // 10 when we implement mana

		VectorCopy(ent->s.origin, start);
		start[2] += ent->viewheight;
		AngleVectors(ent->client->v_angle, forward, NULL, NULL);
		VectorMA(start, 8192, forward, end);
		tr = gi.trace(start, NULL, NULL, end, ent, MASK_SHOT);
		if ( tr.ent && ((tr.ent->svflags & SVF_MONSTER) || (tr.ent->client)) )
		{
			VectorScale(forward, -15000, forward); // was -5000
			VectorAdd(forward, tr.ent->velocity, tr.ent->velocity);
		}

	      gi.sound( ent, CHAN_AUTO, gi.soundindex("world/airhiss2.wav"), 1, ATTN_NONE, 0 );

		return;
	}
	gi.cprintf(ent, PRINT_HIGH, "Not enough Force Mana available.\n");
	return;
}

/*
=========================================================
FORCE DESTRUCTION:
Sends a ball of fire their way

CREDITS:
Hector Ramos
=========================================================
*/

void Destruction_Touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	vec3_t		origin;
	int			n;

	if (other == ent->owner)
		return;

	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (ent);
		return;
	}

	if (ent->owner->client)
		PlayerNoise(ent->owner, ent->s.origin, PNOISE_IMPACT);

	// calculate position for the explosion entity
	VectorMA (ent->s.origin, -0.02, ent->velocity, origin);

	if (other->takedamage)
	{
		T_Damage (other, ent, ent->owner, ent->velocity, ent->s.origin, plane->normal, ent->dmg, 0, 0, MOD_FDESTRUCTION);
	}

	T_RadiusDamage(ent, ent->owner, ent->radius_dmg, other, ent->dmg_radius, MOD_FDESTRUCTION);

	gi.WriteByte (svc_temp_entity);
	if (ent->waterlevel)
		gi.WriteByte (TE_ROCKET_EXPLOSION_WATER);
	else
		gi.WriteByte (TE_ROCKET_EXPLOSION);
	gi.WritePosition (origin);
	gi.multicast (ent->s.origin, MULTICAST_PHS);

	G_FreeEdict (ent);
}

void Fire_Destruction (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, float damage_radius, int radius_damage)
{
	edict_t	*dest;

	dest = G_Spawn();
	VectorCopy (start, dest->s.origin);
	VectorCopy (dir, dest->movedir);
	vectoangles (dir, dest->s.angles);
	VectorScale (dir, speed, dest->velocity);
	dest->movetype = MOVETYPE_FLYMISSILE;
	dest->clipmask = MASK_SHOT;
	dest->solid = SOLID_BBOX;
//	dest->s.effects |= EF_ROCKET;
	VectorClear (dest->mins);
	VectorClear (dest->maxs);
	dest->s.modelindex = gi.modelindex ("models/objects/r_explode/tris.md2");
	dest->s.skinnum = 3;
	dest->s.frame = 8;
	dest->owner = self;
	dest->touch = Destruction_Touch;
	dest->nextthink = level.time + 8000/speed;
	dest->think = G_FreeEdict;
	dest->dmg = 150;
	dest->radius_dmg = 100;
	dest->dmg_radius = 300;
	dest->s.sound = gi.soundindex ("weapons/rockfly.wav");
	dest->classname = "destruction";

	gi.sound(self, CHAN_AUTO, gi.soundindex("world/battle2.wav"), 1, ATTN_NONE, 0 );

}


void Force_Destruction (edict_t *ent)
{
	vec3_t	offset, start;
	vec3_t	forward, right;

	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Mana"))] >= 50)
	{
		ent->client->pers.inventory[ITEM_INDEX(FindItem("Mana"))] -= 50;
		AngleVectors (ent->client->v_angle, forward, right, NULL);
		VectorScale (forward, -2, ent->client->kick_origin);
		ent->client->kick_angles[0] = -7.5;
		VectorSet(offset, 8, 8, ent->viewheight-8);
		P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);
		Fire_Destruction (ent, start, forward, 150, 1000, 300, 100);
		return;
	}
	gi.cprintf(ent, PRINT_HIGH, "Not enough Force Mana available.\n");
	return;
}

/*
=========================================================
FORCE PROJECTION:
Creates an holographic image of yourself

CREDITS:
Hector Ramos
=========================================================
*/

void Force_Projection (edict_t *ent)
{
	edict_t *self;
      edict_t *owner;
      vec3_t forward;

	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Mana"))] >= 50)
	{
		ent->client->pers.inventory[ITEM_INDEX(FindItem("Mana"))] -= 50;
		spawn_decoy (ent);
	}
	else
		gi.cprintf(ent, PRINT_HIGH, "Not enough Force Mana available.\n");

}

/*
=========================================================
FORCE BLINDING:
Blinds your target for 10 seconds

CREDITS:
Hector Ramos
=========================================================
*/

void Force_Blinding (edict_t *ent)
{
      vec3_t	offset, v;
      edict_t	*target;
      float Distance, BlindTimeAdd;
	vec3_t	start;
	vec3_t	forward;
	vec3_t	end;
	trace_t	tr;

	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Mana"))] >= 20)
	{
		ent->client->pers.inventory[ITEM_INDEX(FindItem("Mana"))] -= 20;

	      target = NULL;

		VectorCopy(ent->s.origin, start);
		start[2] += ent->viewheight;
		AngleVectors(ent->client->v_angle, forward, NULL, NULL);
		VectorMA(start, 8192, forward, end);
		tr = gi.trace(start, NULL, NULL, end, ent, MASK_SHOT);
		if ( tr.ent && ((tr.ent->svflags & SVF_MONSTER) || (tr.ent->client)) )
		{
			target = tr.ent;
		}
		else
			return;

		if (target->client->resp.ctf_team == ent->owner->client->resp.ctf_team)
	      {
			return;
		}

	      // Increment the blindness counter
		target->client->blindTime += 100;
	      target->client->blindBase = 100;

		gi.sound(ent, CHAN_AUTO, gi.soundindex("world/x_light.wav"), 1, ATTN_NONE, 0 );
		gi.sound(target, CHAN_AUTO, gi.soundindex("world/x_light.wav"), 1, ATTN_NONE, 0 );
	}
	gi.cprintf(ent, PRINT_HIGH, "Not enough Force Mana available.\n");
}

/*
=========================================================
FORCE HEALING:
Heals you back to 100 health

CREDITS:
Hector Ramos
=========================================================
*/

void Force_Healing (edict_t *ent)
{
	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Mana"))] >= 100)
	{
		ent->client->pers.inventory[ITEM_INDEX(FindItem("Mana"))] -= 100;

		if (ent->health < 100)
			ent->health = 100;

		gi.sound(ent, CHAN_AUTO, gi.soundindex("misc/spawn1.wav"), 1, ATTN_NONE, 0 );
	}
	gi.cprintf(ent, PRINT_HIGH, "Not enough Force Mana available.\n");
}
