// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id:$
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This source is available for distribution and/or modification
// only under the terms of the DOOM Source Code License as
// published by id Software. All rights reserved.
//
// The source is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// FITNESS FOR A PARTICULAR PURPOSE. See the DOOM Source Code License
// for more details.
//
// $Log:$
//
// DESCRIPTION:  Heads-up displays
//
//-----------------------------------------------------------------------------

static const char
rcsid[] = "$Id: hu_stuff.c,v 1.4 1997/02/03 16:47:52 b1 Exp $";

#include <ctype.h>

#include "doomdef.h"

#include "z_zone.h"

#include "m_swap.h"

#include "hu_stuff.h"
#include "hu_lib.h"
#include "w_wad.h"

#include "s_sound.h"

#include "doomstat.h"

// Data.
#include "dstrings.h"
#include "sounds.h"
#include "i_system.h"
#include "m_misc.h"

#include "p_spec.h"     //Timer -jc-
#include "multires.h"   //Draw patch(flag holder) -jc-


//
// Locally used constants, shortcuts.
//
#define HU_TITLE	(mapnames[(gameepisode-1)*9+gamemap-1])
#define HU_TITLE2	(mapnames2[gamemap-1])
#define HU_TITLEP	(mapnamesp[gamemap-1])
#define HU_TITLET	(mapnamest[gamemap-1])
#define HU_TITLEHEIGHT	1
#define HU_TITLEX	0
#define HU_TITLEY	(SCREENHEIGHT-(200-(167 - SHORT(hu_font[0]->height))))

#define HU_INPUTTOGGLE	key_talk
#define HU_INPUTX	HU_MSGX
#define HU_INPUTY	(HU_MSGY + HU_MSGHEIGHT*(SHORT(hu_font[0]->height) +1))
#define HU_INPUTWIDTH	64
#define HU_INPUTHEIGHT	1

#define HU_CROSSHAIRCOLOR (256-5*16)
#define SBARHEIGHT 32

//-CTF(JC) Full screen heads up display pos-------------------------------------
#define HU_GREEN   ( 7*16)+12
#define HU_INDIGO  ( 6*16)+12
#define HU_BROWN   ( 4*16)+12
#define HU_RED     ( 2*16)+9
#define HU_GOLD    (10*16)+3
#define HU_BLUE    (12*16)+9
#define HU_DKBLUE  (15*16)
#define HU_PINK    27

int backcolour[MAXPLAYERS]={HU_GREEN,HU_INDIGO,HU_BROWN,HU_RED,HU_GOLD,HU_BLUE,HU_DKBLUE,HU_PINK};

#define HU_STATTOGGLE   '`'           // Toggle key for rankings.
#define HU_TITLEYF      (SCREENHEIGHT-(SHORT(hu_font[0]->height)))
#define ST_FX           (SCREENWIDTH-35)
#define ST_FY           0
#define ST_FY1          34
#define DF_REDGE        38            // Distance from right edge (NAMES)
#define DF_TOP1         25            // Distance from top.
#define SWINGLIMIT      60            // Limit the swingbar can travel

int ctf_team[CTF_MAXTEAMS];           // Team Scores
int ctf_frags[MAXPLAYERS];            // Individual Scores

static boolean      statview= false;  // Rankings overlay

static patch_t*     pbg[MAXPLAYERS];  // Colour Backdrops for player faces
static patch_t*     plevl;            // EVIL GRIN
static patch_t*     plsid;            // Right Side Look
static patch_t*     plsid1;           // Left Side Look

// Rankings
static hu_textline_t	sclinet;      // Title
static hu_textline_t	sclinen;      // Name
static hu_textline_t	sclines;      // Individual Score
static hu_textline_t	sclinec;      // Individual Captures
static hu_textline_t	shighlight;   // Diamond marking current player

// Names for MUGS (Flag holders)
static hu_textline_t	name1;

// Holds the player name size (in pixels), for right justification, this is
// precalculated in HU_CTFPreCalculateDefaults
int namesize[MAXPLAYERS];

// Large numbers & Minus patch for HU_CTFLaregNums
static patch_t* ctftallnum[10];
extern patch_t* sttminus;

// Determines whether the scores should be recalculated
extern boolean updateCTFscore;

int xmid,ymid;

// For extended messages
boolean incomingchatstring=false;
static char chatstring[80];

int lpos=0;                       // Last line
char lastxmsg[MAX_MESSAGES][80];  // Message text

extern ctf_struct ctf_s[MAXPLAYERS]; // Team goal scores (Pickup/Return/etc)

boolean isfullscr;

char *ctfscroff=NULL;
//------------------------------------------------------------------------------

char*	chat_macros[10];
char 	player_names[MAXPLAYERS][16];

char			chat_char; // remove later.
static player_t*	plr;
patch_t*		hu_font[HU_FONTSIZE];
static hu_textline_t	w_title;
boolean			chat_on;
static hu_itext_t	w_chat;
static boolean		always_off = false;
static char		chat_dest[MAXPLAYERS];
static hu_itext_t w_inputbuffer[MAXPLAYERS];

static boolean		message_on;

//-jc- Extended Messages
static hu_stext_t	w_message[MAX_MESSAGES];
static int		message_counter;

extern int		showMessages;
extern boolean		automapactive;

static boolean		headsupactive = false;


static hu_textline_t	textlinefps;

//
// Builtin map names.
// The actual names can be found in DStrings.h.
//

char*	mapnames[40];
char*	mapnames2[40];
char*	mapnamesp[40];
char*   mapnamest[40];

const char*	shiftxform;

const char french_shiftxform[] =
{
    0,
    1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
    11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
    21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
    31,
    ' ', '!', '"', '#', '$', '%', '&',
    '"', // shift-'
    '(', ')', '*', '+',
    '?', // shift-,
    '_', // shift--
    '>', // shift-.
    '?', // shift-/
    '0', // shift-0
    '1', // shift-1
    '2', // shift-2
    '3', // shift-3
    '4', // shift-4
    '5', // shift-5
    '6', // shift-6
    '7', // shift-7
    '8', // shift-8
    '9', // shift-9
    '/',
    '.', // shift-;
    '<',
    '+', // shift-=
    '>', '?', '@',
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N',
    'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
    '[', // shift-[
    '!', // shift-backslash - OH MY GOD DOES WATCOM SUCK
    ']', // shift-]
    '"', '_',
    '\'', // shift-`
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N',
    'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
    '{', '|', '}', '~', 127

};

const char english_shiftxform[] =
{

    0,
    1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
    11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
    21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
    31,
    ' ', '!', '"', '#', '$', '%', '&',
    '"', // shift-'
    '(', ')', '*', '+',
    '<', // shift-,
    '_', // shift--
    '>', // shift-.
    '?', // shift-/
    ')', // shift-0
    '!', // shift-1
    '@', // shift-2
    '#', // shift-3
    '$', // shift-4
    '%', // shift-5
    '^', // shift-6
    '&', // shift-7
    '*', // shift-8
    '(', // shift-9
    ':',
    ':', // shift-;
    '<',
    '+', // shift-=
    '>', '?', '@',
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N',
    'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
    '[', // shift-[
    '!', // shift-backslash - OH MY GOD DOES WATCOM SUCK
    ']', // shift-]
    '"', '_',
    '\'', // shift-`
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N',
    'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
    '{', '|', '}', '~', 127
};

char frenchKeyMap[128]=
{
    0,
    1,2,3,4,5,6,7,8,9,10,
    11,12,13,14,15,16,17,18,19,20,
    21,22,23,24,25,26,27,28,29,30,
    31,
    ' ','!','"','#','$','%','&','%','(',')','*','+',';','-',':','!',
    '0','1','2','3','4','5','6','7','8','9',':','M','<','=','>','?',
    '@','Q','B','C','D','E','F','G','H','I','J','K','L',',','N','O',
    'P','A','R','S','T','U','V','Z','X','Y','W','^','\\','$','^','_',
    '@','Q','B','C','D','E','F','G','H','I','J','K','L',',','N','O',
    'P','A','R','S','T','U','V','Z','X','Y','W','^','\\','$','^',127
};

//-CTF(JC)----------------------------------------------------------------------
// Do no matter what!
void HU_CTFPreCalculateDefaults(void)
{
    int  i,j;
    char buffer[9];

    ctfscroff=getenv("CTFSCR");

    xmid=SCREENWIDTH/2;
    ymid=SCREENHEIGHT/2;

//  if (ctf || deathmatch) {
       for (i=0;i<MAXPLAYERS;i++) {
          // Handles more than 4 players
          sprintf(buffer, "STPB%d", i);
          pbg[i] = (patch_t *) W_CacheLumpName(buffer, PU_STATIC);
       }

       // Evil grin patch, for player who has the flag.
       sprintf(buffer, "STFEVL0");
       plevl= (patch_t *) W_CacheLumpName(buffer, PU_STATIC);

       // Look left & right patches
       sprintf(buffer, "STFST00");
       plsid= (patch_t *) W_CacheLumpName(buffer, PU_STATIC);

       sprintf(buffer, "STFST02");
       plsid1=(patch_t *) W_CacheLumpName(buffer, PU_STATIC);


       // Load the tall numbers for team totals
       for (i=0;i<10;i++) {
           sprintf(buffer, "STTNUM%d", i);
           ctftallnum[i] = (patch_t *) W_CacheLumpName(buffer, PU_STATIC);
       }

       // Precalculate player name lengths so they can be right justified
       // next to mugshots.
       for (i=0;i<MAXPLAYERS;i++) {
           namesize[i]=0;            // Make sure namsize[i] defaults to 0.
           for (j=0;j<strlen(player_names[i]);j++)
               namesize[i]+=hu_font[((player_names[i][j])-HU_FONTSTART)]->width;
       }
//  } //end if(ctf)
}

// This is proportional & does no range checking
void HU_CTFLaregNums(int num, int x, int y, boolean justification)
{
   char cnum[6];
   int  i, slen;

   sprintf(cnum,"%d",num);
   slen=strlen(cnum);
   if (justification) {
      // Right Justification
      for (i=0;i<slen;i++) {
          // Better handle the minus sign or there could be trouble.
          if (cnum[i]=='-')
             V_DrawPatch(x+(14*i),y,FG,sttminus);
          else
             V_DrawPatch(x+(14*i),y,FG,ctftallnum[(cnum[i]-'0')]);
      }
   }
   else {              
      // Left Justification
      int leftjust=x-(14*slen);

      for (i=0;i<slen;i++) {
          // Better handle the minus sign or there could be trouble.
          if (cnum[i]=='-')
             V_DrawPatch(leftjust+(14*i),y,FG,sttminus);
          else
             V_DrawPatch(leftjust+(14*i),y,FG,ctftallnum[(cnum[i]-'0')]);
      }
   }
}


// No checking is done eg write off screen buffer etc., assumes uppercase!!
// Used for displaying timer, quicker than calling :
//
// HUlib_initTextLine
// HUlib_addCharToTextLine
// .
// etc.
//
// But not near as safe! Thats if you don't know what your doing :)
void HU_CTFDisplayTextProp(char *mystring, int x, int y)
{
   int i,j=0, slen=strlen(mystring);

   for (i=0;i<slen;j+=(mystring[i]==':')?4:8,i++)
       V_DrawPatch(x+j,y,FG,hu_font[(mystring[i]-HU_FONTSTART)]);
}

//------------------------------------------------------------------------------


char ForeignTranslation(unsigned char ch)
{
    return ch < 128 ? frenchKeyMap[ch] : ch;
}

void HU_Init(void)
{

    int		i;
    int		j;
    char	buffer[9];

    if (language==french)
	shiftxform = french_shiftxform;
    else
	shiftxform = english_shiftxform;

    // load the heads-up font
    j = HU_FONTSTART;
    for (i=0;i<HU_FONTSIZE;i++)
    {
	sprintf(buffer, "STCFN%.3d", j++);
	hu_font[i] = (patch_t *) W_CacheLumpName(buffer, PU_STATIC);
    }

    // -jc- Precacluate the ctf vars
    HU_CTFPreCalculateDefaults();
}

void HU_Stop(void)
{
    headsupactive = false;
}

void HU_Start(void)
{

    int		i;
    char*	s;

    if (headsupactive)
	HU_Stop();

    plr = &players[consoleplayer];
    message_on = false;
    chat_on = false;

//-CTF(JC)----------------------------------------------------------------------
    // create the message widget(S)
    for (i=0;i<MAX_MESSAGES;i++)
        HUlib_initSText(&w_message[i],
		        HU_MSGX, HU_MSGY+(i*8), HU_MSGHEIGHT,
		        hu_font,
		        HU_FONTSTART, &message_on);
//------------------------------------------------------------------------------

    // create the map title widget
    HUlib_initTextLine(&w_title,
		       HU_TITLEX, HU_TITLEY,
		       hu_font,
		       HU_FONTSTART);


   //create stuff for showstats cheat
    HUlib_initTextLine(&textlinefps,
		       SCREENWIDTH/2-12, SCREENHEIGHT/2-8, //-JC-
		       hu_font,
		       HU_FONTSTART);
    
//Raven: Another patch to work with plutonia and tnt properly
//Raven: Helps display the map names properly in map view mode...
    switch ( gamemode )
    {
      case shareware:
      case registered:
      case retail:
         s = HU_TITLE;
         break;

      case commercial:
      default:
         switch(gamemission)
         {
            case pack_plut:
               s = HU_TITLEP;
               break;
            case pack_tnt:
               s = HU_TITLET;
               break;
            case doom2:
               s = HU_TITLE2;
               break;
            case doom:  //Raven: should never happen, but I had to put it in
            case none:  //Raven: should never happen, but I had to put it in
      }
    }
//Raven: End of patch
    
    while (*s)
	HUlib_addCharToTextLine(&w_title, *(s++));

//-CTF(JC)----------------------------------------------------------------------
    // create the chat widget
    HUlib_initIText(&w_chat,
		    HU_INPUTX, HU_INPUTY+(MAX_MESSAGES*8),
		    hu_font,
		    HU_FONTSTART, &chat_on);
//------------------------------------------------------------------------------

    // create the inputbuffer widgets
    for (i=0 ; i<MAXPLAYERS ; i++)
	HUlib_initIText(&w_inputbuffer[i], 0, 0, 0, 0, &always_off);

    headsupactive = true;

}

void HU_PutPixel(int x,int y,int color)
  {
  if (BPP==1)
    screens[0][y*SCREENWIDTH+x]=color;
  else
    ((short *)(screens[0]))[y*SCREENWIDTH+x]=palette_color[color];
  }

//-CTF(JC) Heads up display for CTF game----------------------------------------

void HU_CTFCalcPercentBar (int num, float maxnum, int y, int color, boolean side)
{
     int i,j,k;

     // Make sure the number does not exceed maximum.
     if (num>maxnum) num=maxnum;

     // Now work out the percentage in pixels.
     j=(int)((num/maxnum) * 35);

     if (!side) {
        // Left
        for (i=0;i<j;i++) {    // Length
            for (k=0;k<6;k++)  // Width of bar
                HU_PutPixel(i,y-k,color);
        }
     }
     else {
        // Right
        for (i=0;i<j;i++) {    // Length
            for (k=0;k<6;k++)  // Width of bar
                HU_PutPixel((SCREENWIDTH-1)-i,y-k,color);
        }
     }
}

// Disabled in 3 team mode as it is based only on teams 0 & 1
void HU_CTFSwingBar(int y)
{
    int i,j,k, colourA, colourB;

    // Only continue if two teams are in the game
    if (!(totalteams<CTF_MAXTEAMS)) return;

    // Calculate the number of pixels needed to be drawn.
    // And sort out the sides in which Green and indigo have to be drawn.
    // 2 TEAM ONLY!!
    if (consoleplayer%2) {
       j=(int)(((ctf_team[1]-ctf_team[0])/100.0) * SWINGLIMIT);
       colourA=102; // Indigo
       colourB=118; // Green
    }
    else {
       j=(int)(((ctf_team[0]-ctf_team[1])/100.0) * SWINGLIMIT);
       colourA=118; // Green
       colourB=102; // Indigo
    }

    // Make sure we don't draw too far.
    if (j>SWINGLIMIT) j=SWINGLIMIT;
    else if (j<-SWINGLIMIT) j=-SWINGLIMIT;

    // Draw the white center line.
    for (k=7;k;--k)
        HU_PutPixel(xmid,y-k,4);

    // Don't continue if the difference is zero pixels
    if (j==0) return;

    // Draw the swing bar
    if (j>0) // Draw bar to the right
       for (i=0;i<j;i++)
           for (k=5;k;--k)
               HU_PutPixel((xmid+1)+i,(y-k)-1,colourA);
    else     // Draw bar to the left
       for (i=j;i<0;i++)
           for (k=5;k;--k)
               HU_PutPixel(xmid+i,(y-k)-1,colourB);
}


static int Sindex[MAXPLAYERS];      // Psuedo list of players in the game.
static int playersleft=MAXPLAYERS;  // Players Left in the game.

void HU_CTFBSortScores(void)
{
   int i,j=0;

   // Locate and build a list based on the players currently in the game.
   // Start off checking all 8 players, then adjust accordingly.
   for (i=0;i<playersleft+1;i++) {
       if (playeringame[i])
          Sindex[j++]=i;
   }
   playersleft=j;

   // Sort descending by score.
   for (i=0;i<playersleft-1;i++) {
       for (j=i+1;j<playersleft;j++) {
           if (ctf_frags[Sindex[i]]<ctf_frags[Sindex[j]]) {
                // Swap :)
                Sindex[i]=Sindex[i]+Sindex[j];
                Sindex[j]=Sindex[i]-Sindex[j];
                Sindex[i]=Sindex[i]-Sindex[j];
           }
       }
   }
}

void HU_CTFBoxDraw(int x, int y, int colour)
{
     int i,j;

     for (i=5;i;i--)
       for (j=5;j;j--)
           HU_PutPixel(x+j,y+i,colour);
}

// Used in CTF & Deathmatch games
void HU_CTFScores(void)
{
     int i,xpos,ypos;
     static char fragstr[5], capstr[5], titstr[10];
     char *nameptr, *fragsptr=&fragstr[0], *titleptr=&titstr[0], *capptr=&capstr[0];

     // Sort player scores for Rankings.
     HU_CTFBSortScores();

     // Calculate the center point for the totals
     xpos=(ctf && !ctfscroff) ? xmid-90 : xmid-80;
     ypos=ymid-((playersleft*9)/2);

     // Display totals base on the sorted psuedo list.
     for (i=0;i<playersleft;i++) {
            nameptr=player_names[Sindex[i]];
            sprintf(fragsptr,"%d",ctf_frags[Sindex[i]]);

            if (Sindex[i]==consoleplayer) {
               HUlib_initTextLine(&shighlight,
                     xpos-10, ypos+(i*9),
                     hu_font,
                     HU_FONTSTART);
               HUlib_addCharToTextLine(&shighlight, '*');
               HUlib_drawTextLine(&shighlight, false);
            }
            else
               HU_CTFBoxDraw(xpos-10, ypos+(i*9),
                             backcolour[players[Sindex[i]].mo->playxtra]);

            // Player Name
            HUlib_initTextLine(&sclinen,
                   xpos, ypos+(i*9),
                   hu_font,
                   HU_FONTSTART);

            // Player Score
            HUlib_initTextLine(&sclines,
                   xpos+(9*16), ypos+(i*9),
                   hu_font,
                   HU_FONTSTART);

            while (*nameptr)  HUlib_addCharToTextLine(&sclinen, *(nameptr++));
            while (*fragsptr) HUlib_addCharToTextLine(&sclines, *(fragsptr++));

            // Output to screen
            HUlib_drawTextLine(&sclinen, false);
            HUlib_drawTextLine(&sclines, false);

            // Display Additional Capture Stats in CTF Mode
            if (ctf && !ctfscroff) {
               sprintf(capptr,"%d",ctf_s[Sindex[i]].captures);

               // Player Captures
               HUlib_initTextLine(&sclinec,
                     xpos+(9*20), ypos+(i*9),
                     hu_font,
                     HU_FONTSTART);

               while (*capptr) HUlib_addCharToTextLine(&sclinec, *(capptr++));
               HUlib_drawTextLine(&sclinec, false);
            }
     }

     // Display Title
     HUlib_initTextLine(&sclinet,
               (ctf && !ctfscroff) ? xpos+68 : xpos+48, ypos-(2*8),
               hu_font,
               HU_FONTSTART);

     sprintf (titleptr,"-=TOP %d=-",playersleft);
     while (*titleptr) HUlib_addCharToTextLine(&sclinet, *(titleptr++));
     HUlib_drawTextLine(&sclinet, false);
}

void HU_CTFCalcScores(void)
{
   int i,j;

   if (!updateCTFscore) return; // If the score hasn't changed then don't
                                // recalculate it.
   // Calculate frags
   for (i=0;i<CTF_MAXTEAMS;i++) ctf_team[i]=0;

   for (i=0;i<MAXPLAYERS;i++) {
       ctf_frags[i]=0;
       for (j=0;j<MAXPLAYERS;j++) {
           if (i%totalteams==j%totalteams) {
              // Players are on the same team so subtract frags against one
              // another but add captures & recoveries
              ctf_frags[i]-=players[i].frags[j];
              ctf_frags[i]+=(ctf_s[j].captures*5) + ctf_s[j].recovery;
           }
           else
              ctf_frags[i]+=players[i].frags[j]; // Opposition
       }
       ctf_team[i%totalteams]+=ctf_frags[i];     // Add team totals
   }

   updateCTFscore=false;                         // Update done
}

extern int setblocks;
extern int playerflagtaken[MAXPLAYERS];
extern int flags[CTF_MAXTEAMS];

void HU_CTFDrawer(void)
{
    int i,j=0, yp=SCREENHEIGHT-33, yp1=SCREENHEIGHT-17, teamcolour=3;
    int flagsfound=0;
    static char msg[56];
    char *s=&msg[0], flagholder[16], *n1;

    // This does the MUGS Display
    for (i=0;i<MAXPLAYERS;i++) {
        if (playerflagtaken[i]<0) continue; // Flagholder when -1 is unused.

        sprintf(flagholder,"%s",player_names[i]);
        n1=flagholder;

        switch (playerflagtaken[i]) {
             case it_redskull    : teamcolour=3; //Red Flag Backdrop
                                   break;
             case it_blueskull   : teamcolour=5; //Blue Flag Backdrop
                                   break;
             case it_yellowskull : teamcolour=4; //Gold Flag Backdrop
                                   break;
        }

        if (playerflagtaken[i]==flags[consoleplayer%totalteams]) {
           // The flag that was taken was the console players flag so update
           // the mugs to show which opposition player has the flag in the
           // top corner of the screen.
           HUlib_initTextLine(&name1,
                 (SCREENWIDTH-DF_REDGE)-namesize[i], DF_TOP1,
                 hu_font,
                 HU_FONTSTART);

           while (*n1) HUlib_addCharToTextLine(&name1, *(n1++));
           HUlib_drawTextLine(&name1, false);

           V_DrawPatch(ST_FX,ST_FY,FG,pbg[teamcolour]);
           V_DrawPatch(ST_FX+1,ST_FY-1,FG,plevl);
        }
        else {
             if ((i%totalteams)==(consoleplayer%totalteams)) {
                // The player is on the same team as the console player so
                // display their mug below.
                ++flagsfound;
                HUlib_initTextLine(&name1,
                      (SCREENWIDTH-DF_REDGE)-namesize[i], ((DF_TOP1*(flagsfound+1))+(9*flagsfound)),
                      hu_font,
                      HU_FONTSTART);

                while (*n1) HUlib_addCharToTextLine(&name1, *(n1++));
                HUlib_drawTextLine(&name1, false);

                V_DrawPatch(ST_FX,ST_FY1*flagsfound,FG,pbg[teamcolour]);
                V_DrawPatch(ST_FX+1,(ST_FY1*flagsfound)-1,FG,(i!=consoleplayer) ? plevl : plsid);
            }
        }
    }

    // Calculate player/team scores.
    HU_CTFCalcScores();

    if (!isfullscr) {
       // Calculate the positions of the HUD when not in full screen
       // mode.
       yp-=SBARHEIGHT;
       yp1-=SBARHEIGHT;
    }
    else {
          // These are only shown when in full screen mode.
          // Display percentage bar containing health
          HU_CTFCalcPercentBar(players[consoleplayer].health,
                               100.0,
                               SCREENHEIGHT-35,
                               (players[consoleplayer].health<=100)?176:183,
                               true);

          // Display percentage bar containing armour
          HU_CTFCalcPercentBar(players[consoleplayer].armorpoints,
                               100.0,
                               SCREENHEIGHT-42,
                               (players[consoleplayer].armorpoints<=100)?202:204,
                               true);

          // Only Display the ammo only if the weapon uses ammo.
          if (players[consoleplayer].readyweapon!=wp_fist &&
              players[consoleplayer].readyweapon!=wp_chainsaw)
              HU_CTFCalcPercentBar(players[consoleplayer].ammo[weaponinfo[players[consoleplayer].readyweapon].ammo],
                                  (float)players[consoleplayer].maxammo[weaponinfo[players[consoleplayer].readyweapon].ammo],
                                  SCREENHEIGHT-49,
                                  231,
                                  true);
    }

    // These work in any screen mode.
    // Display the swing bar.
    // Only displayed when two teams are playing.
    HU_CTFSwingBar((!isfullscr)? (SCREENHEIGHT-9)-SBARHEIGHT : (SCREENHEIGHT-9));

    for (i=0;i<totalteams;i++) {
        // Place the console player on the right side
        if (consoleplayer%totalteams==i%totalteams) {
           V_DrawPatch(SCREENWIDTH-35,yp,FG,pbg[i]);
           V_DrawPatch(SCREENWIDTH-35,yp,FG,plsid1);
           HU_CTFLaregNums(ctf_team[i], SCREENWIDTH-35, yp1, false);
        }
        else {
           // Draw the opposition team(s) on the Left.
           V_DrawPatch(0,yp-j,FG,pbg[i]);
           V_DrawPatch(0,yp-j,FG,plsid);
           HU_CTFLaregNums(ctf_team[i], 36, yp1-j, true);
           j+=34;
        }
    }

    // Calculate and display the timer.
    if (!levelTimer)
       sprintf (s,"%.2d:%.2d",(leveltime / TICRATE) / 60, (leveltime / TICRATE) % 60);
    else
       sprintf (s,"%.2d:%.2d",((levelTimeCount+TICRATE) / TICRATE) / 60, ((levelTimeCount+TICRATE) / TICRATE) % 60);
 
    HU_CTFDisplayTextProp(s,(xmid-18),
                            (!isfullscr)? (HU_TITLEYF-1)-SBARHEIGHT : HU_TITLEYF-1);

    // Update the console messages.
    for (i=0;i<MAX_MESSAGES;i++)
         HUlib_drawSText(&w_message[i]);

    HUlib_drawIText(&w_chat);

    // Check for " ` " or a dead player to display the totals.
    if (statview || players[consoleplayer].playerstate==PST_DEAD)
       HU_CTFScores();
}

// These are for the pulsating crosshair in HU_Drawer
int chcount=0, chdir=1, chtimer=0; //-jc-
//------------------------------------------------------------------------------

void HU_Drawer(void)
{

//-JC---------------------------------------------------------------------------

    int i,sbarheight=SBARHEIGHT;

    // Make sure the crosshair works full screen.
    if ((setblocks==11 && (!automapactive || newhupf)))
       sbarheight=0;

    // Pulsating, this is not game timer related.
    if (chtimer++%5) {
        if (chcount==14)
           chdir=-1;
        else if (chcount==0)
                chdir=1;
        chcount+=chdir;
    }

    //do crosshairs
    if (crosshair==1)
      {
      HU_PutPixel(xmid-3,(SCREENHEIGHT-sbarheight)/2,HU_CROSSHAIRCOLOR+chcount);
      HU_PutPixel(xmid-2,(SCREENHEIGHT-sbarheight)/2,HU_CROSSHAIRCOLOR+chcount);
      HU_PutPixel(xmid+2,(SCREENHEIGHT-sbarheight)/2,HU_CROSSHAIRCOLOR+chcount);
      HU_PutPixel(xmid+3,(SCREENHEIGHT-sbarheight)/2,HU_CROSSHAIRCOLOR+chcount);
      HU_PutPixel(xmid,(SCREENHEIGHT-sbarheight)/2-3,HU_CROSSHAIRCOLOR+chcount);
      HU_PutPixel(xmid,(SCREENHEIGHT-sbarheight)/2-2,HU_CROSSHAIRCOLOR+chcount);
      HU_PutPixel(xmid,(SCREENHEIGHT-sbarheight)/2+2,HU_CROSSHAIRCOLOR+chcount);
      HU_PutPixel(xmid,(SCREENHEIGHT-sbarheight)/2+3,HU_CROSSHAIRCOLOR+chcount);
      }
    else if (crosshair==2)
      {
      HU_PutPixel(xmid,(SCREENHEIGHT-sbarheight)/2,HU_CROSSHAIRCOLOR+chcount);
      }
    else if (crosshair==3)
      {
      HU_PutPixel(xmid,(SCREENHEIGHT-sbarheight)/2,HU_CROSSHAIRCOLOR+chcount);
      HU_PutPixel(xmid+1,(SCREENHEIGHT-sbarheight)/2,HU_CROSSHAIRCOLOR+chcount);
      HU_PutPixel(xmid+2,(SCREENHEIGHT-sbarheight)/2,HU_CROSSHAIRCOLOR+chcount);
      HU_PutPixel(xmid,(SCREENHEIGHT-sbarheight)/2+1,HU_CROSSHAIRCOLOR+chcount);
      HU_PutPixel(xmid,(SCREENHEIGHT-sbarheight)/2+2,HU_CROSSHAIRCOLOR+chcount);
      }

//------------------------------------------------------------------------------

    //now, draw stats
    if (showstats)
      {
      char textbuf[100];
      char *s;      
      static int timelastframe=0,fps=0,numframes=0;
      int currtime,timediff;

      numframes++;
      currtime=I_GetMilliTime();
      timediff=currtime-timelastframe;
      if (timediff>333)  //update every third of a second
        {
        if (timediff<10000)
          fps=numframes*10000/timediff;
        else
          fps=0;
        timelastframe=currtime;      
        numframes=0;
        }

      HUlib_clearTextLine(&textlinefps);
      sprintf(textbuf,"%d.%d",fps/10,fps%10);
      s=textbuf; while (*s) HUlib_addCharToTextLine(&textlinefps,*(s++));
      HUlib_drawTextLine(&textlinefps,false);
    }

//-JC---------------------------------------------------------------------------

    // Determine screen size
    isfullscr=((setblocks==11 && (!automapactive || newhupf)));

    if (ctf) {
               HU_CTFDrawer();
               return;
             }
    else if (deathmatch) {
            // This is the Deathmatch full screen HUD, I've basically borrowed
            // the CTF Code.
            if (isfullscr) {
               int i,fragscount=0;

               V_DrawPatch(SCREENWIDTH-35,SCREENHEIGHT-33,FG,pbg[consoleplayer]);
               V_DrawPatch(SCREENWIDTH-35,SCREENHEIGHT-32,FG,plsid1);

               // These are only shown when in full screen mode.
               // Display percentage bar containing health
               HU_CTFCalcPercentBar(players[consoleplayer].health,
                                    100.0,
                                    SCREENHEIGHT-35,
                                    (players[consoleplayer].health<=100)?176:183,
                                    true);

               // Display percentage bar containing armour
               HU_CTFCalcPercentBar(players[consoleplayer].armorpoints,
                                    100.0,
                                    SCREENHEIGHT-42,
                                    (players[consoleplayer].armorpoints<=100)?202:204,
                                    true);

               // Only Display the ammo only if the weapon uses ammo.
               if (players[consoleplayer].readyweapon!=wp_fist &&
                   players[consoleplayer].readyweapon!=wp_chainsaw)
                   HU_CTFCalcPercentBar(players[consoleplayer].ammo[weaponinfo[players[consoleplayer].readyweapon].ammo],
                                       (float)players[consoleplayer].maxammo[weaponinfo[players[consoleplayer].readyweapon].ammo],
                                       SCREENHEIGHT-49,
                                       231,
                                       true);

               // Calculate ConsolePlayers frag count.
               for (i=0 ; i<MAXPLAYERS ; i++)
               {
                   if (i != consoleplayer)
                      fragscount += players[consoleplayer].frags[i];
                   else
                      fragscount -= players[consoleplayer].frags[i];
               }
               HU_CTFLaregNums(fragscount, SCREENWIDTH-36, SCREENHEIGHT-17, false);
            }

            // Displays stats(rankings?), triggered by " ` ".
            if (statview || players[consoleplayer].playerstate==PST_DEAD) {
               int a,b;

               for (a=0;a<MAXPLAYERS;a++) {
                   ctf_frags[a]=0;
                   for (b=0;b<MAXPLAYERS;b++) {
                       if (a!=b) ctf_frags[a]+=players[a].frags[b];
                       else ctf_frags[a]-=players[a].frags[b];
                   }
               }
               HU_CTFScores();
            }
         }


    for (i=0;i<MAX_MESSAGES;i++)
        HUlib_drawSText(&w_message[i]);

//------------------------------------------------------------------------------

    HUlib_drawIText(&w_chat);

    if (automapactive)
	HUlib_drawTextLine(&w_title, false);

}

void HU_Erase(void)
{
    int i;                                 //-jc-

    for (i=0;i<MAX_MESSAGES;i++)           //-jc-
        HUlib_eraseSText(&w_message[i]);   //-jc-

    HUlib_eraseIText(&w_chat);
    HUlib_eraseTextLine(&w_title);

}

void HU_Ticker(void)
{

    int i, rc;
    char c;

//-CTF(JC)----------------------------------------------------------------------
// New x lines message handler
// Will continue to add messages as they are sent even if showMessage is false
// but they won't be displayed till set to true.

   if (plr->message || incomingchatstring) {
      // Move messages up 1 line if on the limit
      if (lpos>(MAX_MESSAGES-1)) {
         lpos=MAX_MESSAGES-1;
         for (i=1;i<MAX_MESSAGES;i++)
             strcpy(lastxmsg[i-1],lastxmsg[i]);
      }

      // Check for incoming messages and add them.
      if (!incomingchatstring) {
         strcpy(lastxmsg[lpos],plr->message);
         plr->message = 0;
      }
      else {
           strcpy(lastxmsg[lpos],chatstring);
           incomingchatstring=false;
      }

      lpos++;
   }

   // Determines whether to show the messages or not.
   if (showMessages) {
      for (i=0;i<MAX_MESSAGES;i++)
      HUlib_addMessageToSText(&w_message[i],  0, lastxmsg[i]);
      message_on = true;
   }
   else {
        message_on = false;
   }

//------------------------------------------------------------------------------

    // check for incoming chat characters
    if (netgame)
    {
	for (i=0 ; i<MAXPLAYERS; i++)
	{
	    if (!playeringame[i])
		continue;
	    if (i != consoleplayer
		&& (c = players[i].cmd.chatchar))
	    {
		if (c <= HU_BROADCAST)
		    chat_dest[i] = c;
		else
		{
		    if (c >= 'a' && c <= 'z')
			c = (char) shiftxform[(unsigned char) c];
		    rc = HUlib_keyInIText(&w_inputbuffer[i], c);
		    if (rc && c == KEYD_ENTER)
		    {
			if (w_inputbuffer[i].l.len
			    && (chat_dest[i] == consoleplayer+1
				|| chat_dest[i] == HU_BROADCAST))
			{

//-CTF(JC)---------------------------------------------------------------------
                            sprintf (chatstring,"%s: %s",player_names[i],w_inputbuffer[i].l.l);
                            incomingchatstring=true;
//-----------------------------------------------------------------------------

			    if ( gamemode == commercial )
			      S_StartSound(0, sfx_radio);
			    else
			      S_StartSound(0, sfx_tink);
			}
			HUlib_resetIText(&w_inputbuffer[i]);
		    }
		}
		players[i].cmd.chatchar = 0;
	    }
	}
    }

}

#define QUEUESIZE		128

static char	chatchars[QUEUESIZE];
static int	head = 0;
static int	tail = 0;


void HU_queueChatChar(char c)
{
    if (((head + 1) & (QUEUESIZE-1)) == tail)
    {
	plr->message = HUSTR_MSGU;
    }
    else
    {
	chatchars[head] = c;
	head = (head + 1) & (QUEUESIZE-1);
    }
}

char HU_dequeueChatChar(void)
{
    char c;

    if (head != tail)
    {
	c = chatchars[tail];
	tail = (tail + 1) & (QUEUESIZE-1);
    }
    else
    {
	c = 0;
    }

    return c;
}

    char		destination_keys[MAXPLAYERS];/* =
    {
	HUSTR_KEYGREEN,
	HUSTR_KEYINDIGO,
	HUSTR_KEYBROWN,
	HUSTR_KEYRED
    };*/

boolean HU_Responder(event_t *ev)
{

    static char		lastmessage[HU_MAXLINELENGTH+1];
    char*		macromessage;
    boolean		eatkey = false;
    static boolean	shiftdown = false;
    static boolean	altdown = false;
    unsigned char 	c;
    int			i;
    int			numplayers;
    
    
    static int		num_nobrainers = 0;

    numplayers = 0;
    for (i=0 ; i<MAXPLAYERS ; i++)
	numplayers += playeringame[i];

    if (ev->data1 == KEYD_RSHIFT)
    {
	shiftdown = ev->type == ev_keydown;
	return false;
    }
    else if (ev->data1 == KEYD_RALT || ev->data1 == KEYD_LALT)
    {
	altdown = ev->type == ev_keydown;
	return false;
    }

    if (ev->type != ev_keydown)
	return false;

    if (!chat_on)
    {
	if (ev->data1 == HU_MSGREFRESH)
	{
	    message_on = true;
	    message_counter = HU_MSGTIMEOUT;
	    eatkey = true;
	}
	else if (netgame && ((ev->data1==(HU_INPUTTOGGLE>>16))||(ev->data1==(HU_INPUTTOGGLE&0xffff))))
	{
	    eatkey = chat_on = true;
	    HUlib_resetIText(&w_chat);
	    HU_queueChatChar(HU_BROADCAST);
	}
        else if ((ctf || deathmatch) && ev->data1 == HU_STATTOGGLE)  //-jc-
	{
	    eatkey = true;
            statview = !statview;
	}
	else if (netgame && numplayers > 2)
	{
	    for (i=0; i<MAXPLAYERS ; i++)
	    {
		if (ev->data1 == destination_keys[i])
		{
		    if (playeringame[i] && i!=consoleplayer)
		    {
			eatkey = chat_on = true;
			HUlib_resetIText(&w_chat);
			HU_queueChatChar(i+1);
			break;
		    }
		    else if (i == consoleplayer)
		    {
			num_nobrainers++;
			if (num_nobrainers < 3)
			    plr->message = HUSTR_TALKTOSELF1;
			else if (num_nobrainers < 6)
			    plr->message = HUSTR_TALKTOSELF2;
			else if (num_nobrainers < 9)
			    plr->message = HUSTR_TALKTOSELF3;
			else if (num_nobrainers < 32)
			    plr->message = HUSTR_TALKTOSELF4;
			else
			    plr->message = HUSTR_TALKTOSELF5;
		    }
		}
	    }
	}
    }
    else
    {
	c = ev->data1;
	// send a macro
	if (altdown)
	{
	    c = c - '0';
	    if (c > 9)
		return false;
	    // fprintf(stderr, "got here\n");
	    macromessage = chat_macros[c];
	    
	    // kill last message with a '\n'
	    HU_queueChatChar(KEYD_ENTER); // DEBUG!!!
	    
	    // send the macro message
	    while (*macromessage)
		HU_queueChatChar(*macromessage++);
	    HU_queueChatChar(KEYD_ENTER);
	    
	    // leave chat mode and notify that it was sent
	    chat_on = false;
	    strcpy(lastmessage, chat_macros[c]);
	    plr->message = lastmessage;
	    eatkey = true;
	}
	else
	{
	    if (language==french)
		c = ForeignTranslation(c);
	    if (shiftdown || (c >= 'a' && c <= 'z'))
		c = shiftxform[c];
	    eatkey = HUlib_keyInIText(&w_chat, c);
	    if (eatkey)
	    {
		// static unsigned char buf[20]; // DEBUG
		HU_queueChatChar(c);
		
		// sprintf(buf, "KEY: %d => %d", ev->data1, c);
		//      plr->message = buf;
	    }
	    if (c == KEYD_ENTER)
	    {
		chat_on = false;
		if (w_chat.l.len)
		{
		    strcpy(lastmessage, w_chat.l.l);
		    plr->message = lastmessage;
		}
	    }
	    else if (c == KEYD_ESCAPE)
		chat_on = false;
	}
    }

    return eatkey;

}
