// USED in p_inter.c

#ifndef CTFINTER
#define CTFINTER

#define REDFLAG   0
#define BLUEFLAG  1
#define GOLDFLAG  2
#define CTFGREEN  0
#define CTFINDIGO 1
#define CTFBROWN  2
#define CTFRED    3
#define CTFBLUE   5
#define CTFGOLD   4


#define FLAGTAKEN0   "%s HAS GOT THE %s FLAG"
#define FLAGTAKEN1   "YOU'VE GOT THEIR FLAG"

#define FLAGRETURN0  "%s HAS RETURNED THE %s FLAG"
#define FLAGRETURN1  "YOU'VE RETURNED YOUR FLAG"

#define FLAGCAPTURE0 "%s CAPTURED THE %s FLAG"
#define FLAGCAPTURE1 "YOU'VE CAPTURED THEIR FLAG"

#define FLAGLOSTS    "%s LOST THE %s FLAG"
#define FLAGLOST     "YOU'VE LOST YOUR OPPONENTS FLAG"

#define REDFLAGSTR      "RED"
#define BLUEFLAGSTR     "BLUE"
#define YELLOWFLAGSTR   "YELLOW"
#define OTHERFLAGSTR    "INVALID"

#define FRAGSTR0     "%s WAS KILLED BY %s"
#define FRAGSTR1     "%s WAS FRAGGED BY %s"
#define FRAGSTR2     "%s WAS TERMINATED BY %s"
#define FRAGSTR3     "%s WAS DESTROYED BY %s"

#define SELFFRAGSTR0 "%s VISITS THE HEAVENS"
#define SELFFRAGSTR1 "%s CHOSE THE WRONG STRAW"
#define SELFFRAGSTR2 "%s COMMITED SUICIDE"
#define SELFFRAGSTR3 "%s MISFIRED"

//Not used.
#define SELFFRAGSTR4 "%s DECIDES DEATH IS THE BEST METHOD"

// Differs from default as it is minus the ':'
extern char  ctfnames[MAXPLAYERS][16];
       char  *flagnames[]={OTHERFLAGSTR ,OTHERFLAGSTR,
                           OTHERFLAGSTR ,BLUEFLAGSTR ,
                           YELLOWFLAGSTR,REDFLAGSTR  };

extern boolean updateCTFscore;

//-CTF(jc)----------------------------------------------------------------------
char *FRAGSTR[]    ={FRAGSTR0,
                     FRAGSTR1,
                     FRAGSTR2,
                     FRAGSTR3};

char *FRAGSTRSELF[]={SELFFRAGSTR0,
                     SELFFRAGSTR1,
                     SELFFRAGSTR2,
                     SELFFRAGSTR3};

int quotecycle=0;

//------------------------------------------------------------------------------


//-NORMAL CTF/DOOM NAMES-
#define NAME0        "GREEN"
#define NAME1        "INDIGO"
#define NAME2        "BROWN"
#define NAME3        "RED"
#define NAME4        "GOLD"
#define NAME5        "BLUE"
#define NAME6        "DKBLUE"
#define NAME7        "PINK"

//-ALTCTF DEFAULT NAMES-
#define NAME8        "DOOMGUY"
#define NAME9        "THEGUN"
#define NAMEA        "FRAGMAN"
#define NAMEB        "CAMPER"
#define NAMEC        "IMPYBOY"
#define NAMED        "X"
#define NAMEE        "HOT"
#define NAMEF        "INTENSE"

//-jc-
// Differs from default as it is minus the ':'
char    ctfnames1[MAXPLAYERS][16] = { NAME0, NAME1, NAME2, NAME3,
                                      NAME4, NAME5, NAME6, NAME7};
char    ctfnames2[MAXPLAYERS][16] = { NAME8, NAME9, NAMEA, NAMEB,
                                      NAMEC, NAMED, NAMEE, NAMEF};
char    ctfnames[MAXPLAYERS][16];

//Flag to tell HUD that a score change has occured.
boolean updateCTFscore=false;

int playerflagtaken[MAXPLAYERS]={-1,-1,-1,-1,-1,-1,-1,-1}; // Flag Held by player

// Flags in the game, used in P_CTFUpdateTouchSpecialThing.
int flags[CTF_MAXTEAMS]={it_blueskull, it_redskull, it_yellowskull};

int     ctf;                 // Parameter Check -ctf
int     ctfsnd;              // Parameter Check -ctfs needs ctfsnd.wad
int     ctf_flagip;          // Flag in possesion.
int     newhupf;             // To fix the auto CTF hud.
int     totalteams;          // No of teams in the game

ctf_struct ctf_s[MAXPLAYERS];

#endif