#include <windows.h>
#include <commctrl.h>
#include <stdarg.h>
#include <stdio.h>
#include "resource.h"

HANDLE gmyhInstance;
HWND ghwndDlgMain;
BOOL CALLBACK MainDlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);

HANDLE mutex;
DWORD dwThreadId1;

//#define WM_QCC_DONE 6660

////////////////
//TranslateString
//from QE3 source code
//by
//John Carmack
////////////////
char	*TranslateString (char *buf)
{
	static	char	buf2[32768];
	int		i, l;
	char	*out;

	l = strlen(buf);
	out = buf2;
	for (i=0 ; i<l ; i++)
	{
		if (buf[i] == '\n')
		{
			*out++ = '\r';
			*out++ = '\n';
		}
		else
			*out++ = buf[i];
	}
	*out++ = 0;

	return buf2;
}

////////////////
//log
//from QE3 source code
//Sys_printf
//by
//John Carmack
////////////////
void log_print (char *text, ...)
{
	char* out;

	va_list argptr;
	char	buf[32768];

	va_start (argptr,text);
	vsprintf (buf, text,argptr);
	va_end (argptr);

	out = TranslateString (buf);
	SendMessage (GetDlgItem(ghwndDlgMain,ID_LOG),
		EM_REPLACESEL,0,(LPARAM)out);
}

void Error (char *text, ...)
{
	char* out;

	va_list argptr;
	char	buf[32768];

	va_start (argptr,text);
	vsprintf (buf, text,argptr);
	va_end (argptr);

	out = TranslateString (buf);
	SendMessage (GetDlgItem(ghwndDlgMain,ID_LOG),
		EM_REPLACESEL,0,(LPARAM)"\r\n******************COMPILE ERROR************\r\n");
	SendMessage (GetDlgItem(ghwndDlgMain,ID_LOG),
		EM_REPLACESEL,0,(LPARAM)out);
	SendMessage (GetDlgItem(ghwndDlgMain,ID_LOG),
		EM_REPLACESEL,0,(LPARAM)"\r\n");

	EnableWindow(GetDlgItem(ghwndDlgMain,ID_OK),TRUE);
}

extern DWORD WINAPI qcc(LPVOID lpParam);

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine, int nCmdShow)
{
	HANDLE mutex = NULL;
	
	mutex = CreateMutex(NULL,TRUE,"__WIN_QCC_");
	if (GetLastError() == ERROR_ALREADY_EXISTS)
	{
		MessageBox(NULL,"WinQCC is already running.",
			"WinQCC",MB_OK | MB_ICONINFORMATION);
		if (mutex) ReleaseMutex(mutex);
		return 1;
	}
	gmyhInstance = hInstance;
	DialogBox(hInstance,MAKEINTRESOURCE(DIALOG_MAIN), NULL, (DLGPROC)MainDlgProc);
	if (mutex) ReleaseMutex(mutex);
	return 0;
}

BOOL CALLBACK MainDlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	HANDLE hThread1;

	switch(uMsg)
	{
		case WM_INITDIALOG:
		{
			//give me some icons
			SendMessage(hwndDlg,WM_SETICON,(WPARAM)ICON_BIG,(LPARAM)LoadIcon(gmyhInstance,MAKEINTRESOURCE(IDI_ICON)));
			SendMessage(hwndDlg,WM_SETICON,(WPARAM)ICON_SMALL,(LPARAM)LoadIcon(gmyhInstance,MAKEINTRESOURCE(IDI_ICON)));
			ghwndDlgMain = hwndDlg;
			SetTimer(hwndDlg,1,500,(TIMERPROC)NULL);//let the log window get up :)
			InitCommonControls();
			return(TRUE);
		}
		case WM_CLOSE:
		{
			EndDialog(hwndDlg,1);
			return(TRUE);
		}
		case WM_TIMER:
		{
			KillTimer(hwndDlg,1);
			hThread1 = CreateThread(NULL, 0, qcc, 0, 0, &dwThreadId1);
			log_print("\nCompiling . . .\n\n");
			EnableWindow(GetDlgItem(hwndDlg,ID_OK),FALSE);
			if(!hThread1)
				log_print("There was an error creating the compile thread\n");
			return(TRUE);
		}
//		case WM_QCC_DONE:
//		{
//			EnableWindow(GetDlgItem(hwndDlg,ID_OK),TRUE);
//			EnableWindow(GetDlgItem(hwndDlg,ID_REDO),TRUE);
//			return TRUE;
//		}
		case WM_COMMAND:
		{
			switch(wParam)
			{
				case ID_OK:
				{
					log_print("Exiting\n");
					EndDialog(hwndDlg,1);
					return(TRUE);
				}
				case ID_REDO:
				{
					log_print("\nRecompiling . . .\n\n");
					EnableWindow(GetDlgItem(hwndDlg,ID_OK),FALSE);
					hThread1 = CreateThread(NULL, 0, qcc, 0, 0, &dwThreadId1);
					if(!hThread1)
						log_print("There was an error creating the compile thread\n");
					return(TRUE);
				}
			}
		}
	}
	return(FALSE);
}
