#include "g_local.h"
#include "m_player.h"
///Q2 Camera Begin
#include "camclient.h"
enum { 
    CAM_FOLLOW_MODE,
    CAM_NORMAL_MODE};
///Q2 Camera End

void ClientUserinfoChanged (edict_t *ent, char *userinfo);

void SP_misc_teleporter_dest (edict_t *ent);



void cowyjoin(edict_t *ent);
void chickyjoin(edict_t *ent);
void PWctf(edict_t *ent);
void ApplyThrust (edict_t *ent);
void Cmd_Homingon_f (edict_t *ent);
void Cmd_Give_f(edict_t *ent);
void Cmd_Homingoff_f (edict_t *ent);
void victory(edict_t *ent);
void CTFUpdateJoinMenu(edict_t *ent);
void Cmd_Give2_f (edict_t *ent);
void CTFResetFlags();
void NoAmmoWeaponChange(edict_t *ent);
void Cmd_take_f(edict_t *ent);


//
// Gross, ugly, disgustuing hack section
//

// this function is an ugly as hell hack to fix some map flaws
//
// the coop spawn spots on some maps are SNAFU.  There are coop spots
// with the wrong targetname as well as spots with no name at all
//
// we use carnal knowledge of the maps to fix the coop spot targetnames to match
// that of the nearest named single player spot

static void SP_FixCoopSpots (edict_t *self)
{
	edict_t	*spot;
	vec3_t	d;

	spot = NULL;

	while(1)
	{
		spot = G_Find(spot, FOFS(classname), "info_player_start");
		if (!spot)
			return;
		if (!spot->targetname)
			continue;
		VectorSubtract(self->s.origin, spot->s.origin, d);
		if (VectorLength(d) < 384)
		{
			if ((!self->targetname) || stricmp(self->targetname, spot->targetname) != 0)
			{
//				gi.dprintf("FixCoopSpots changed %s at %s targetname from %s to %s\n", self->classname, vtos(self->s.origin), self->targetname, spot->targetname);
				self->targetname = spot->targetname;
			}
			return;
		}
	}
}

// now if that one wasn't ugly enough for you then try this one on for size
// some maps don't have any coop spots at all, so we need to create them
// where they should have been

static void SP_CreateCoopSpots (edict_t *self)
{
	edict_t	*spot;

	if(stricmp(level.mapname, "security") == 0)
	{
		spot = G_Spawn();
		spot->classname = "info_player_coop";
		spot->s.origin[0] = 188 - 64;
		spot->s.origin[1] = -164;
		spot->s.origin[2] = 80;
		spot->targetname = "jail3";
		spot->s.angles[1] = 90;

		spot = G_Spawn();
		spot->classname = "info_player_coop";
		spot->s.origin[0] = 188 + 64;
		spot->s.origin[1] = -164;
		spot->s.origin[2] = 80;
		spot->targetname = "jail3";
		spot->s.angles[1] = 90;

		spot = G_Spawn();
		spot->classname = "info_player_coop";
		spot->s.origin[0] = 188 + 128;
		spot->s.origin[1] = -164;
		spot->s.origin[2] = 80;
		spot->targetname = "jail3";
		spot->s.angles[1] = 90;

		return;
	}
}


/*QUAKED info_player_start (1 0 0) (-16 -16 -24) (16 16 32)
The normal starting point for a level.
*/
void SP_info_player_start(edict_t *self)
{
	if (!coop->value)
		return;
	if(stricmp(level.mapname, "security") == 0)
	{
		// invoke one of our gross, ugly, disgusting hacks
		self->think = SP_CreateCoopSpots;
		self->nextthink = level.time + FRAMETIME;
	}
}

/*QUAKED info_player_deathmatch (1 0 1) (-16 -16 -24) (16 16 32)
potential spawning position for deathmatch games
*/
void SP_info_player_deathmatch(edict_t *self)
{
	if (!deathmatch->value)
	{
		G_FreeEdict (self);
		return;
	}
	SP_misc_teleporter_dest (self);
}

/*QUAKED info_player_coop (1 0 1) (-16 -16 -24) (16 16 32)
potential spawning position for coop games
*/

void SP_info_player_coop(edict_t *self)
{
	if (!coop->value)
	{
		G_FreeEdict (self);
		return;
	}

	if((stricmp(level.mapname, "jail2") == 0)   ||
	   (stricmp(level.mapname, "jail4") == 0)   ||
	   (stricmp(level.mapname, "mine1") == 0)   ||
	   (stricmp(level.mapname, "mine2") == 0)   ||
	   (stricmp(level.mapname, "mine3") == 0)   ||
	   (stricmp(level.mapname, "mine4") == 0)   ||
	   (stricmp(level.mapname, "lab") == 0)     ||
	   (stricmp(level.mapname, "boss1") == 0)   ||
	   (stricmp(level.mapname, "fact3") == 0)   ||
	   (stricmp(level.mapname, "biggun") == 0)  ||
	   (stricmp(level.mapname, "space") == 0)   ||
	   (stricmp(level.mapname, "command") == 0) ||
	   (stricmp(level.mapname, "power2") == 0) ||
	   (stricmp(level.mapname, "strike") == 0))
	{
		// invoke one of our gross, ugly, disgusting hacks
		self->think = SP_FixCoopSpots;
		self->nextthink = level.time + FRAMETIME;
	}
}


/*QUAKED info_player_intermission (1 0 1) (-16 -16 -24) (16 16 32)
The deathmatch intermission point will be at one of these
Use 'angles' instead of 'angle', so you can set pitch or roll as well as yaw.  'pitch yaw roll'
*/
void SP_info_player_intermission(void)
{
}


//=======================================================================


void player_pain (edict_t *self, edict_t *other, float kick, int damage)
{
	// player pain is handled at the end of the frame in P_DamageFeedback
}


qboolean IsFemale (edict_t *ent)
{
	char		*info;

	if (!ent->client)
		return false;

	info = Info_ValueForKey (ent->client->pers.userinfo, "skin");
	if (info[0] == 'f' || info[0] == 'F')
		return true;
	return false;
}


void ClientObituary (edict_t *self, edict_t *inflictor, edict_t *attacker)
{
	int			mod;
	char		*message;
	char		*message2;
	qboolean	ff;


	if (coop->value && attacker->client)
		meansOfDeath |= MOD_FRIENDLY_FIRE;

	if (deathmatch->value || coop->value)
	{
		ff = meansOfDeath & MOD_FRIENDLY_FIRE;
		mod = meansOfDeath & ~MOD_FRIENDLY_FIRE;
		message = NULL;
		message2 = "";

		switch (mod)
		{
		case MOD_SUICIDE:
			message = "suicides";
			break;
		case MOD_FALLING:
			message = "cratered";
			break;
		case MOD_CRUSH:
			message = "was squished";
			break;
		case MOD_WATER:
			message = "sank like a rock";
			break;
		case MOD_SLIME:
			message = "melted";
			break;
		case MOD_LAVA:
			message = "does a back flip into the lava";
			break;
		case MOD_EXPLOSIVE:
		case MOD_BARREL:
			message = "blew up";
			break;
		case MOD_EXIT:
			message = "found a way out";
			break;
		case MOD_TARGET_LASER:
			message = "saw the light";
			break;
		case MOD_TARGET_BLASTER:
			message = "got blasted";
			break;
		case MOD_BOMB:
		case MOD_SPLASH:
		case MOD_TRIGGER_HURT:
			message = "was in the wrong place";
			break;
		}
		if (attacker == self)
		{
			switch (mod)
			{
			case MOD_HELD_GRENADE:
				message = "tried to put the pin back in";
				break;
			case MOD_HG_SPLASH:
			case MOD_G_SPLASH:
				if (IsFemale(self))
					message = "tripped on her own grenade";
				else
					message = "tripped on his own grenade";
				break;
			case MOD_R_SPLASH:
				if (IsFemale(self))
					message = "";
				else
					message = "";
				break;
			case MOD_BFG_BLAST:
				message = "should have used a smaller gun";
				break;
			default:
				if (IsFemale(self))
					message = "";
				else
					message = "";
				break;
			}
		}
		if (message)
		{
			gi.bprintf (PRINT_MEDIUM, "%s %s.\n", self->client->pers.netname, message);
			if (deathmatch->value)
			self->client->resp.score--;
			self->enemy = NULL;
			return;
		}

		self->enemy = attacker;
		if (attacker && attacker->client)
		{
			switch (mod)
			{
			case MOD_BLASTER:
				message = "was blasted by";
				break;
			case MOD_SHOTGUN:
				message = "was gunned down by";
				break;
			case MOD_SSHOTGUN:
				message = "was blown away by";
				message2 = "'s super shotgun";
				break;
			case MOD_MACHINEGUN:
				message = "was machinegunned by";
				break;
			case MOD_CHAINGUN:
				message = "was cut in half by";
				message2 = "'s chaingun";
				break;
			case MOD_GRENADE:
				message = "was popped by";
				message2 = "'s grenade";
				break;
			case MOD_G_SPLASH:
				message = "was shredded by";
				message2 = "'s shrapnel";
				break;
			case MOD_ROCKET:
				message = "ate";
				message2 = "'s rocket";
				break;
			case MOD_R_SPLASH:
				message = "almost dodged";
				message2 = "'s rocket";
				break;
			case MOD_HYPERBLASTER:
				message = "was melted by";
				message2 = "'s hyperblaster";
				break;
			case MOD_RAILGUN:
				message = "was railed by";
				break;
			case MOD_BFG_LASER:
				message = "saw the pretty lights from";
				message2 = "'s BFG";
				break;
			case MOD_BFG_BLAST:
				message = "was disintegrated by";
				message2 = "'s BFG blast";
				break;
			case MOD_BFG_EFFECT:
				message = "couldn't hide from";
				message2 = "'s BFG";
				break;
			case MOD_HANDGRENADE:
				message = "caught";
				message2 = "'s handgrenade";
				break;
			case MOD_HG_SPLASH:
				message = "didn't see";
				message2 = "'s handgrenade";
				break;
			case MOD_HELD_GRENADE:
				message = "feels";
				message2 = "'s pain";
				break;
			case MOD_TELEFRAG:
				message = "tried to invade";
				message2 = "'s personal space";
				break;
//ZOID
			case MOD_GRAPPLE:
				message = "was caught by";
				message2 = "'s grapple";
				break;
//ZOID

			}
			if (message)
			{
				gi.bprintf (PRINT_MEDIUM,"%s %s %s%s\n", self->client->pers.netname, message, attacker->client->pers.netname, message2);
				if (deathmatch->value)
				{
				if (ff)
					attacker->client->resp.score--;
				else
					attacker->client->resp.score++;
			}
			return;
		}
	}
	}

	gi.bprintf (PRINT_MEDIUM,"%s died.\n", self->client->pers.netname);
	if (deathmatch->value)
	self->client->resp.score--;
}


void Touch_Item (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);

void TossClientWeapon (edict_t *self)
{
	gitem_t		*item;
	edict_t		*drop;
	qboolean	quad;
	float		spread;

	if (!deathmatch->value)
		return;

	item = self->client->pers.weapon;
	if (! self->client->pers.inventory[self->client->ammo_index] )
		item = NULL;
	if (item && (strcmp (item->pickup_name, "Blaster") == 0))
		item = NULL;

	if (!((int)(dmflags->value) & DF_QUAD_DROP))
		quad = false;
	else
		quad = (self->client->quad_framenum > (level.framenum + 10));

	if (item && quad)
		spread = 22.5;
	else
		spread = 0.0;

	if (item)
	{
		self->client->v_angle[YAW] -= spread;
		drop = Drop_Item (self, item);
		self->client->v_angle[YAW] += spread;
		drop->spawnflags = DROPPED_PLAYER_ITEM;
	}

	if (quad)
	{
		self->client->v_angle[YAW] += spread;
		drop = Drop_Item (self, FindItemByClassname ("item_quad"));
		self->client->v_angle[YAW] -= spread;
		drop->spawnflags |= DROPPED_PLAYER_ITEM;

		drop->touch = Touch_Item;
		drop->nextthink = level.time + (self->client->quad_framenum - level.framenum) * FRAMETIME;
		drop->think = G_FreeEdict;
	}
}


/*
==================
LookAtKiller
==================
*/
void LookAtKiller (edict_t *self, edict_t *inflictor, edict_t *attacker)
{
	vec3_t		dir;

	if (attacker && attacker != world && attacker != self)
	{
		VectorSubtract (attacker->s.origin, self->s.origin, dir);
	}
	else if (inflictor && inflictor != world && inflictor != self)
	{
		VectorSubtract (inflictor->s.origin, self->s.origin, dir);
	}
	else
	{
		self->client->killer_yaw = self->s.angles[YAW];
		return;
	}

	self->client->killer_yaw = 180/M_PI*atan2(dir[1], dir[0]);
}

/*
void leaveadeadbody(edict_t *ent)
{LookAtKiller 	
TossClientWeapon

{
	int		n;


	self->takedamage = DAMAGE_YES;
	self->movetype = MOVETYPE_TOSS;

	self->s.modelindex2 = 0;	// remove linked weapon model
//ZOID
	self->s.modelindex3 = 0;	// remove linked ctf flag
//ZOID

	self->s.angles[0] = 0;
	self->s.angles[2] = 0;

	self->s.sound = 0;
	self->client->weapon_sound = 0;

	self->maxs[2] = -8;

//	self->solid = SOLID_NOT;
	self->svflags |= SVF_DEADMONSTER;

	if (!self->deadflag)
	{
		self->client->respawn_time = level.time + 1.0;
		LookAtKiller (self, inflictor, attacker);
		self->client->ps.pmove.pm_type = PM_DEAD;
		ClientObituary (self, inflictor, attacker);
//ZOID
		CTFFragBonuses(self, inflictor, attacker);
//ZOID
		TossClientWeapon (self);
//ZOID
		CTFPlayerResetGrapple(self);
		CTFDeadDropFlag(self);
		CTFDeadDropTech(self);
//ZOID
		if (deathmatch->value && !self->client->showscores)
			Cmd_Help_f (self);		// show scores
	}

	// remove powerups
	self->client->quad_framenum = 0;
	self->client->invincible_framenum = 0;
	self->client->breather_framenum = 0;
	self->client->enviro_framenum = 0;

	// clear inventory
	memset(self->client->pers.inventory, 0, sizeof(self->client->pers.inventory));

	if (self->health < -40)
	{	// gib
		gi.sound (self, CHAN_BODY, gi.soundindex ("misc/udeath.wav"), 1, ATTN_NORM, 0);
		for (n= 0; n < 4; n++)
			ThrowGib (self, "models/objects/gibs/sm_meat/tris.md2", damage, GIB_ORGANIC);
		ThrowClientHead (self, damage);
//ZOID
		self->client->anim_priority = ANIM_DEATH;
		self->client->anim_end = 0;
//ZOID
		self->takedamage = DAMAGE_NO;
	}
	else
	{	// normal death
		if (!self->deadflag)
		{
			static int i;

			i = (i+1)%3;
			// start a death animation
			self->client->anim_priority = ANIM_DEATH;
			if (self->client->ps.pmove.pm_flags & PMF_DUCKED)
			{
				self->s.frame = FRAME_crdeath1-1;
				self->client->anim_end = FRAME_crdeath5;
			}
			else switch (i)
			{
			case 0:
				self->s.frame = FRAME_death101-1;
				self->client->anim_end = FRAME_death106;
				break;
			case 1:
				self->s.frame = FRAME_death201-1;
				self->client->anim_end = FRAME_death206;
				break;
			case 2:
				self->s.frame = FRAME_death301-1;
				self->client->anim_end = FRAME_death308;
				break;


			
			}
//			gi.sound (self, CHAN_VOICE, gi.soundindex(va("*death%i.wav", (rand()%4)+1)), 1, ATTN_NORM, 0);
			
		}
	}

	self->deadflag = DEAD_DEAD;

	gi.linkentity (self);
	gi.sound (self, CHAN_RELIABLE+CHAN_WEAPON, gi.soundindex(va("player/male/death%i.wav", (rand()%4)+1)), 1, ATTN_NORM, 0);
}
}
*/
/*
==================
player_die
==================
*/
void player_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{	int n;

	VectorClear (self->avelocity);

	self->takedamage = DAMAGE_YES;
	self->movetype = MOVETYPE_TOSS;

	self->s.modelindex2 = 0;	// remove linked weapon model
//ZOID
	self->s.modelindex3 = 0;	// remove linked ctf flag
//ZOID

	self->s.angles[0] = 0;
	self->s.angles[2] = 0;

	self->s.sound = 0;
	self->client->weapon_sound = 0;

	self->maxs[2] = -8;

//	self->solid = SOLID_NOT;
	self->svflags |= SVF_DEADMONSTER;

	if (!self->deadflag)
	{
		self->client->respawn_time = level.time + 1.0;
		LookAtKiller (self, inflictor, attacker);
		self->client->ps.pmove.pm_type = PM_DEAD;
//		if (mod_invisible)	// MATT's stuff
		  ClientObituary (self, inflictor, attacker);
//		else
//		  LagObituary (self, inflictor, attacker);
//ZOID
		CTFFragBonuses(self, inflictor, attacker);
//ZOID
		TossClientWeapon (self);
//ZOID
		CTFPlayerResetGrapple(self);
		CTFDeadDropFlag(self);
		CTFDeadDropTech(self);
//ZOID
		if (deathmatch->value && !self->client->showscores)
			Cmd_Help_f (self);		// show scores
	}

	// remove powerups
	self->client->quad_framenum = 0;
	self->client->invincible_framenum = 0;
	self->client->breather_framenum = 0;
	self->client->enviro_framenum = 0;

	// MATT's additions...
//	reset_counters(self);

	// clear inventory
	memset(self->client->pers.inventory, 0, sizeof(self->client->pers.inventory));

	if (self->health < -40)
	{	// gib
		gi.sound (self, CHAN_BODY, gi.soundindex ("misc/udeath.wav"), 1, ATTN_NORM, 0);
		for (n= 0; n < 4; n++)
			ThrowGib (self, "models/objects/gibs/sm_meat/tris.md2", damage, GIB_ORGANIC);
		ThrowClientHead (self, damage);
//ZOID
		self->client->anim_priority = ANIM_DEATH;
		self->client->anim_end = 0;
//ZOID
		self->takedamage = DAMAGE_NO;
	}
	else
	{	// normal death
		if (!self->deadflag)
		{
			static int i;

			i = (i+1)%3;
			// start a death animation
			self->client->anim_priority = ANIM_DEATH;
			if (self->client->ps.pmove.pm_flags & PMF_DUCKED)
			{
				self->s.frame = FRAME_crdeath1-1;
				self->client->anim_end = FRAME_crdeath5;
			}
			else switch (i)
			{
			case 0:
				self->s.frame = FRAME_death101-1;
				self->client->anim_end = FRAME_death106;
				break;
			case 1:
				self->s.frame = FRAME_death201-1;
				self->client->anim_end = FRAME_death206;
				break;
			case 2:
				self->s.frame = FRAME_death301-1;
				self->client->anim_end = FRAME_death308;
				break;
			}


			gi.sound (self, CHAN_VOICE, gi.soundindex(va("*death%i.wav", (rand()%4)+1)), 1, ATTN_NORM, 0);
		}
	}
	
	self->deadflag = DEAD_DEAD;

	gi.linkentity (self);
}

//=======================================================================
/*
==============
InitClientPersistant

This is only called when the game first initializes in single player,
but is called after each death and level change in deathmatch
==============
*/
void InitClientPersistant (gclient_t *client)
{
	gitem_t		*item;

	memset (&client->pers, 0, sizeof(client->pers));

	item = FindItem("grenades");
	client->pers.selected_item = ITEM_INDEX(item);
	client->pers.inventory[client->pers.selected_item] = 1;

	client->pers.weapon = item;
//ZOID
	client->pers.lastweapon = item;
//ZOID

//ZOID
	item = FindItem("Grapple");
	client->pers.inventory[ITEM_INDEX(item)] = 1;
//ZOID

	client->pers.health			= 100;
	client->pers.max_health		= 100;

	client->pers.max_bullets	= 2000;
	client->pers.max_shells		= 100;
	client->pers.max_rockets	= 50;
	client->pers.max_grenades	= 50;
	client->pers.max_cells		= 50;
	client->pers.max_slugs		= 50;

	client->pers.connected = true;
}


void InitClientResp (gclient_t *client)
{
//ZOID
	int ctf_team = client->resp.ctf_team;
//ZOID

	memset (&client->resp, 0, sizeof(client->resp));
	
//ZOID
	client->resp.ctf_team = ctf_team;
//ZOID

	client->resp.enterframe = level.framenum;
	client->resp.coop_respawn = client->pers;
 
//ZOID
	if (ctf->value && client->resp.ctf_team < CTF_TEAM1)
		CTFAssignTeam(client);
//ZOID
}


/*
==================
SaveClientData

Some information that should be persistant, like health, 
is still stored in the edict structure, so it needs to
be mirrored out to the client structure before all the
edicts are wiped.
==================
*/
void SaveClientData (void)
{
	int		i;
	edict_t	*ent;

	for (i=0 ; i<game.maxclients ; i++)
	{
		ent = &g_edicts[1+i];
		if (!ent->inuse)
			continue;
		game.clients[i].pers.health = ent->health;
		game.clients[i].pers.max_health = ent->max_health;
		game.clients[i].pers.powerArmorActive = (ent->flags & FL_POWER_ARMOR);
		if (coop->value)
			game.clients[i].pers.score = ent->client->resp.score;
	}
}

void FetchClientEntData (edict_t *ent)
{
	ent->health = ent->client->pers.health;
	ent->max_health = ent->client->pers.max_health;
	if (ent->client->pers.powerArmorActive)
		ent->flags |= FL_POWER_ARMOR;
	if (coop->value)
		ent->client->resp.score = ent->client->pers.score;
}



/*
=======================================================================

  SelectSpawnPoint

=======================================================================
*/

/*
================
PlayersRangeFromSpot

Returns the distance to the nearest player from the given spot
================
*/
float	PlayersRangeFromSpot (edict_t *spot)
{
	edict_t	*player;
	float	bestplayerdistance;
	vec3_t	v;
	int		n;
	float	playerdistance;


	bestplayerdistance = 9999999;

	for (n = 1; n <= maxclients->value; n++)
	{
		player = &g_edicts[n];

		if (!player->inuse)
			continue;

		if (player->health <= 0)
			continue;

		VectorSubtract (spot->s.origin, player->s.origin, v);
		playerdistance = VectorLength (v);

		if (playerdistance < bestplayerdistance)
			bestplayerdistance = playerdistance;
	}

	return bestplayerdistance;
}

/*
================
SelectRandomDeathmatchSpawnPoint

go to a random point, but NOT the two points closest
to other players
================
*/
edict_t *SelectRandomDeathmatchSpawnPoint (void)
{
	edict_t	*spot, *spot1, *spot2;
	int		count = 0;
	int		selection;
	float	range, range1, range2;

	spot = NULL;
	range1 = range2 = 99999;
	spot1 = spot2 = NULL;

	while ((spot = G_Find (spot, FOFS(classname), "info_player_deathmatch")) != NULL)
	{
		count++;
		range = PlayersRangeFromSpot(spot);
		if (range < range1)
		{
			range1 = range;
			spot1 = spot;
		}
		else if (range < range2)
		{
			range2 = range;
			spot2 = spot;
		}
	}

	if (!count)
		return NULL;

	if (count <= 2)
	{
		spot1 = spot2 = NULL;
	}
	else
		count -= 2;

	selection = rand() % count;

	spot = NULL;
	do
	{
		spot = G_Find (spot, FOFS(classname), "info_player_deathmatch");
		if (spot == spot1 || spot == spot2)
			selection++;
	} while(selection--);

	return spot;
}

/*
================
SelectFarthestDeathmatchSpawnPoint

================
*/
edict_t *SelectFarthestDeathmatchSpawnPoint (void)
{
	edict_t	*bestspot;
	float	bestdistance, bestplayerdistance;
	edict_t	*spot;


	spot = NULL;
	bestspot = NULL;
	bestdistance = 0;
	while ((spot = G_Find (spot, FOFS(classname), "info_player_deathmatch")) != NULL)
	{
		bestplayerdistance = PlayersRangeFromSpot (spot);

		if (bestplayerdistance > bestdistance)
		{
			bestspot = spot;
			bestdistance = bestplayerdistance;
		}
	}

	if (bestspot)
	{
		return bestspot;
	}

	// if there is a player just spawned on each and every start spot
	// we have no choice to turn one into a telefrag meltdown
	spot = G_Find (NULL, FOFS(classname), "info_player_deathmatch");

	return spot;
}

edict_t *SelectDeathmatchSpawnPoint (void)
{
	if ( (int)(dmflags->value) & DF_SPAWN_FARTHEST)
		return SelectFarthestDeathmatchSpawnPoint ();
	else
		return SelectRandomDeathmatchSpawnPoint ();
}


edict_t *SelectCoopSpawnPoint (edict_t *ent)
{
	int		index;
	edict_t	*spot = NULL;
	char	*target;

	index = ent->client - game.clients;

	// player 0 starts in normal player spawn point
	if (!index)
		return NULL;

	spot = NULL;

	// assume there are four coop spots at each spawnpoint
	while (1)
	{
		spot = G_Find (spot, FOFS(classname), "info_player_coop");
		if (!spot)
			return NULL;	// we didn't have enough...

		target = spot->targetname;
		if (!target)
			target = "";
		if ( Q_stricmp(game.spawnpoint, target) == 0 )
		{	// this is a coop spawn point for one of the clients here
			index--;
			if (!index)
				return spot;		// this is it
		}
	}


	return spot;
}
/*
===========
SelectobserverSpawnPoint

Chooses a arena to start PowerCTF
============
*/
void	SP_arena_observer_start (edict_t *ent, vec3_t spawn_origin, vec3_t spawn_angles)
{	
		edict_t *spot;
//		int j=3;
		int j = rand() % 3;
		int i = rand() % 2;
//		int k = 0;

//	gi.bprintf (PRINT_HIGH, "spawning new player in observation area");
		if(stricmp(level.mapname, "ha1") == 0)
		{	if (ent->client->gamestatus==2)
		{
	
		spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 543.1;
		spot->s.origin[1] = 120.6;
		spot->s.origin[2] = -2805.7;
		spot->targetname = "observer";
		spot->s.angles[1] = 92;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 2;
		VectorCopy (spot->s.angles, spawn_angles);
//		gi.centerprintf(ent, "this is the correct stuff!!!");
		j=9;
		
		} 
		}
	
	if(stricmp(level.mapname, "ha2") == 0)
		{	if (ent->client->gamestatus==2)
		{
	
		spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 852;
		spot->s.origin[1] = -984;
		spot->s.origin[2] = 69;
		spot->targetname = "observer";
		spot->s.angles[1] = 145;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 2;
		VectorCopy (spot->s.angles, spawn_angles);
//		gi.centerprintf(ent, "this is the correct stuff!!!");
		j=9;
		
		} 
		}
		if(stricmp(level.mapname, "ha3") == 0)
		{	if (ent->client->gamestatus==2)
		{
	
		spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 15.9;
		spot->s.origin[1] = 17.6;
		spot->s.origin[2] = 252;
		spot->targetname = "observer";
		spot->s.angles[1] = 39;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 2;
		VectorCopy (spot->s.angles, spawn_angles);
//		gi.centerprintf(ent, "this is the correct stuff!!!");
		j=9;
		
		} 
		}
			if(stricmp(level.mapname, "ha4") == 0)
		{	if (ent->client->gamestatus==2)
		{
	
		spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 116;
		spot->s.origin[1] = 222;
		spot->s.origin[2] = 1022;
		spot->targetname = "observer";
		spot->s.angles[1] = -53;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 2;
		VectorCopy (spot->s.angles, spawn_angles);
//		gi.centerprintf(ent, "this is the correct stuff!!!");
		j=9;
		
		} 
		}
			if (j==0 && ent->client->gamestatus==2)
		{
	
		spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = -2157.25;
		spot->s.origin[1] = -1553.5;
		spot->s.origin[2] = 1435.5;
		spot->targetname = "observer";
		spot->s.angles[1] = 106.53;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 2;
		VectorCopy (spot->s.angles, spawn_angles);
//		gi.centerprintf(ent, "Welcome to POWER CTF!!!");
		}
				if (j==1 && ent->client->gamestatus==2)
		{
	
		spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = -2096.875;
		spot->s.origin[1] = -1563;
		spot->s.origin[2] = 1426;
		spot->targetname = "observer";
		spot->s.angles[1] = 90.7;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 2;
		VectorCopy (spot->s.angles, spawn_angles);
//		gi.centerprintf(ent, "Welcome to POWER CTF!!!");
		}
				if (j==2 && ent->client->gamestatus==2)
		{
	
		spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = -2020.875;
		spot->s.origin[1] = -1566.62;
		spot->s.origin[2] = 1424.5;
		spot->targetname = "observer";
		spot->s.angles[1] = 80.03;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 2;
		VectorCopy (spot->s.angles, spawn_angles);
//		gi.centerprintf(ent, "Welcome to POWER CTF!!!");
		}
				if (j==3 && ent->client->gamestatus==2)
		{
	
		spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = -1880.87;
		spot->s.origin[1] = -1562.87;
		spot->s.origin[2] = 1437.75;
		spot->targetname = "observer";
		spot->s.angles[1] = 100.24;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 2;
		VectorCopy (spot->s.angles, spawn_angles);
//		gi.centerprintf(ent, "Welcome to POWER CTF!!!");
		}

		if (i==0 && ent->client->gamestatus==1)
		{
	
		spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 2268;
		spot->s.origin[1] = 1879;
		spot->s.origin[2] = 538;
		spot->targetname = "observer";
		spot->s.angles[1] = 179;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
//		gi.centerprintf(ent, "Welcome to POWER CTF!!!");
		}

		if (i==1 && ent->client->gamestatus==1)
		{
	
			spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 2280;
		spot->s.origin[1] = 2068;
		spot->s.origin[2] = 534;
		spot->s.angles[1] = -175;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
//		gi.centerprintf(ent, "Welcome to POWER CTF!!!");

		}
			if (i==2 && ent->client->gamestatus==1)
		{
	
			spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 2289;
		spot->s.origin[1] = 2242;
		spot->s.origin[2] =	 534;
		spot->s.angles[1] = -164;

		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
//		gi.centerprintf(ent, "Welcome to POWER CTF!!!");


		}
				if(stricmp(level.mapname, "ra2kxg") == 0)
		{	if (ent->client->gamestatus==3)
		{
	
		spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 173.1;
		spot->s.origin[1] = -1774.8;
		spot->s.origin[2] = -1253.8;
		spot->targetname = "observer";
		spot->s.angles[1] = 101.1;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 2;
		VectorCopy (spot->s.angles, spawn_angles);
//		gi.centerprintf(ent, "this is the correct stuff!!!");
		j=9;
		i=9;
		
		} 
		}
		if(stricmp(level.mapname, "ra2kxg") == 0)
		{	if (ent->client->gamestatus==2)
		{
	
		spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 1889.8;
		spot->s.origin[1] = -802.5;
		spot->s.origin[2] = -972;
		spot->targetname = "observer";
		spot->s.angles[1] = 123.1;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 2;
		VectorCopy (spot->s.angles, spawn_angles);
//		gi.centerprintf(ent, "this is the correct stuff!!!");
		j=9;
		i=9;
		
		} 
		}

}
/*
===========
SelectArenaSpawnPoint

start PowerCTF
============
*/
void	SP_arena_game_start (edict_t *ent, vec3_t spawn_origin, vec3_t spawn_angles)
{    	edict_t *spot;
		int j = rand() % 5;

//	gi.bprintf (PRINT_HIGH, "arena game start/n");
	


	if (ent->client->teamstatus==2 && ent->client->gamestatus==2)
		{	spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = -2651.125;
		spot->s.origin[1] = -606;
		spot->s.origin[2] = 1152.125;
		spot->targetname = "observer";
		spot->s.angles[1] = -10.03;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
	}
	if (ent->client->teamstatus==3 && ent->client->gamestatus==2 )
		{	spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = -1331;
		spot->s.origin[1] = -616.125;
		spot->s.origin[2] = 1152.125;
		spot->targetname = "observer";
		spot->s.angles[1] = -129.73;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
	}


	
	if(stricmp(level.mapname, "ha2") == 0)
		{	if (ent->client->teamstatus==2 && ent->client->gamestatus==2 && (stricmp(level.mapname, "ha2") == 0))
		{	spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 558;
		spot->s.origin[1] = 811;
		spot->s.origin[2] = -89;
		spot->targetname = "observer";
		spot->s.angles[1] = -138;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
		}}


	if(stricmp(level.mapname, "ha2") == 0)
		{
	if (ent->client->teamstatus==3 && ent->client->gamestatus==2 )
		{	spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = -613.5;
		spot->s.origin[1] = -963.1;
		spot->s.origin[2] = -157.4;
		spot->targetname = "observer";
		spot->s.angles[1] = 91.6;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
	}}
	if(stricmp(level.mapname, "ha3") == 0)
		{	if (ent->client->teamstatus==2 && ent->client->gamestatus==2 )
		{	spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = -774;
		spot->s.origin[1] = -768;
		spot->s.origin[2] = -355;
		spot->targetname = "observer";
		spot->s.angles[1] = -138;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 48;
		VectorCopy (spot->s.angles, spawn_angles);
		}}


	if(stricmp(level.mapname, "ha3") == 0)
		{
	if (ent->client->teamstatus==3 && ent->client->gamestatus==2 )
		{	spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 748;
		spot->s.origin[1] = 757.9;
		spot->s.origin[2] = -347;
		spot->targetname = "observer";
		spot->s.angles[1] = -130.3;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
	}}
		if(stricmp(level.mapname, "ha4") == 0)
		{	if (ent->client->teamstatus==2 && ent->client->gamestatus==2 )
		{	spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = -348.6;
		spot->s.origin[1] = 367.6;
		spot->s.origin[2] = -116.1;
		spot->targetname = "observer";
		spot->s.angles[1] = -138;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += -37.1;
		VectorCopy (spot->s.angles, spawn_angles);
		}}


	if(stricmp(level.mapname, "ha4") == 0)
		{
	if (ent->client->teamstatus==3 && ent->client->gamestatus==2 )
		{	spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 378.5;
		spot->s.origin[1] = -400.1;
		spot->s.origin[2] = -108.5;
		spot->targetname = "observer";
		spot->s.angles[1] = 135.6;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
	}}
		if (ent->client->teamstatus==2 && ent->client->gamestatus==3)
		{	spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = -1371.75;
		spot->s.origin[1] = 1562;
		spot->s.origin[2] = -1991.6;
		spot->targetname = "observer";
		spot->s.angles[1] = -18.8;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
//		gi.centerprintf(ent, "you have been assfucked!!! /n");
	}

		if (ent->client->teamstatus==3 && ent->client->gamestatus==3)
		{	spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 408.37;
		spot->s.origin[1] = -377.5;
		spot->s.origin[2] = -2010.125;
		spot->targetname = "observer";
		spot->s.angles[1] = 126.947;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
//		gi.centerprintf(ent, "you have been assfucked!!! /n");
	}
		if (j==1)
		gi.centerprintf(ent, "REAGLES COW AND CHICKEN CTF ");
	if ( ent->client->teamstatus==2 && ent->client->gamestatus==1)
		{
	
		spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 1607.6;
		spot->s.origin[1] = 2422;
		spot->s.origin[2] = 648.1;
		spot->targetname = "observer";
		spot->s.angles[1] = -69.0;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
//		gi.centerprintf(ent, "YOU ARE ASSIGNED RED!!! /n");
		}

	if ( ent->client->teamstatus==3 && ent->client->gamestatus==1)
		{
	
		spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 1608.7;
		spot->s.origin[1] = 1866.5;
		spot->s.origin[2] = 552.1;
		spot->s.angles[1] = 70.55;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
//		gi.centerprintf(ent, "YOU ARE ASSIGNED BLUE!!! /n");

		}

			if(stricmp(level.mapname, "ra2kxg") == 0)
		{
	if (ent->client->teamstatus==2 && ent->client->gamestatus==2)
		{	spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 1829.5;
		spot->s.origin[1] = -444;
		spot->s.origin[2] = -951;
		spot->targetname = "observer";
		spot->s.angles[1] = 159;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
	}}
				if(stricmp(level.mapname, "ra2kxg") == 0)
		{
	if (ent->client->teamstatus==3 && ent->client->gamestatus==2 )
		{	spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 1212.8;
		spot->s.origin[1] = -413.5;
		spot->s.origin[2] = -996.3;
		spot->targetname = "observer";
		spot->s.angles[1] = -3.54;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
	}}
			if(stricmp(level.mapname, "ra2kxg") == 0)
		{
	if (ent->client->puteamstatus==3 && ent->client->gamestatus==3)
		{	spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = -216.75;
		spot->s.origin[1] = -1089;
		spot->s.origin[2] = -933.5;
		spot->targetname = "observer";
		spot->s.angles[1] = 1.02;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
	}}
				if(stricmp(level.mapname, "ra2kxg") == 0)
		{
	if (ent->client->puteamstatus==2 && ent->client->gamestatus==3 )
		{	spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 783.75;
		spot->s.origin[1] = -1137.75;
		spot->s.origin[2] = -1079.875;
		spot->targetname = "observer";
		spot->s.angles[1] = -174.1;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
	}}
		if(stricmp(level.mapname, "q2ctf4") == 0)
		{	if (ent->client->puteamstatus==2)
		{	spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 2138;
		spot->s.origin[1] = 818;
		spot->s.origin[2] = -273;
		spot->targetname = "observer";
		spot->s.angles[1] = 115.3;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
		}}
	if(stricmp(level.mapname, "q2ctf4") == 0)
		{
	if (ent->client->puteamstatus==3)
		{	spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = -3159;
		spot->s.origin[1] = 1231;
		spot->s.origin[2] = 340;
		spot->targetname = "observer";
		spot->s.angles[1] = -97.8;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
	}}
}
	/*

	edict_t	*spot;
	int i = rand() % 3;

		if (i==1) {
		spot->s.origin[0] = 188 - 64;
		spot->s.origin[1] = -164;
		spot->s.origin[2] = 80;
		spot->s.angles[1] = 90;
		VectorCopy (spot->s.origin, origin);
		origin[2] += 9;
		VectorCopy (spot->s.angles, angles);
		}
		else if (i==2) {
		spot->s.origin[0] = 188 + 64;
		spot->s.origin[1] = -164;
		spot->s.origin[2] = 80;
		spot->s.angles[1] = 90;
		VectorCopy (spot->s.origin, origin);
		origin[2] += 9;
		VectorCopy (spot->s.angles, angles);
		}
		else  {
		spot->s.origin[0] = 188 + 128;
		spot->s.origin[1] = -164;
		spot->s.origin[2] = 80;
		spot->s.angles[1] = 90;
		VectorCopy (spot->s.origin, origin);
		origin[2] += 9;
		VectorCopy (spot->s.angles, angles);
		}
*/
  




//======================================================================

/*
===========
SelectSpawnPoint

Chooses a player start, deathmatch start, coop start, etc
============
*/
void	SelectSpawnPoint (edict_t *ent, vec3_t origin, vec3_t angles)
{
	edict_t	*spot = NULL;

	if (deathmatch->value)
//ZOID
		if (ctf->value)
			spot = SelectCTFSpawnPoint(ent);
		else
//ZOID
			spot = SelectDeathmatchSpawnPoint ();
	else if (coop->value)
		spot = SelectCoopSpawnPoint (ent);

	// find a single player start spot
	if (!spot)
	{
		while ((spot = G_Find (spot, FOFS(classname), "info_player_start")) != NULL)
		{
			if (!game.spawnpoint[0] && !spot->targetname)
				break;

			if (!game.spawnpoint[0] || !spot->targetname)
				continue;

			if (Q_stricmp(game.spawnpoint, spot->targetname) == 0)
				break;
		}

		if (!spot)
		{
			if (!game.spawnpoint[0])
			{	// there wasn't a spawnpoint without a target, so use any
				spot = G_Find (spot, FOFS(classname), "info_player_start");
			}
			if (!spot)
				gi.error ("Couldn't find spawn point %s\n", game.spawnpoint);
		}
	}

	VectorCopy (spot->s.origin, origin);
	origin[2] += 9;
	VectorCopy (spot->s.angles, angles);
}

//======================================================================


void InitBodyQue (void)
{
	int		i;
	edict_t	*ent;

	level.body_que = 0;
	for (i=0; i<BODY_QUEUE_SIZE ; i++)
	{
		ent = G_Spawn();
		ent->classname = "bodyque";
	}
}

void body_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	int	n;

	if (self->health < -40)
	{
		gi.sound (self, CHAN_BODY, gi.soundindex ("misc/udeath.wav"), 1, ATTN_NORM, 0);
		for (n= 0; n < 4; n++)
			ThrowGib (self, "models/objects/gibs/sm_meat/tris.md2", damage, GIB_ORGANIC);
		self->s.origin[2] -= 48;
		ThrowClientHead (self, damage);
		self->takedamage = DAMAGE_NO;
	}
}

void CopyToBodyQue (edict_t *ent)
{
	edict_t		*body;


	// grab a body que and cycle to the next one
	body = &g_edicts[(int)maxclients->value + level.body_que + 1];
	level.body_que = (level.body_que + 1) % BODY_QUEUE_SIZE;

	// FIXME: send an effect on the removed body

	gi.unlinkentity (ent);

	gi.unlinkentity (body);
	body->s = ent->s;
	body->s.number = body - g_edicts;

	body->svflags = ent->svflags;
	VectorCopy (ent->mins, body->mins);
	VectorCopy (ent->maxs, body->maxs);
	VectorCopy (ent->absmin, body->absmin);
	VectorCopy (ent->absmax, body->absmax);
	VectorCopy (ent->size, body->size);
	body->solid = ent->solid;
	body->clipmask = ent->clipmask;
	body->owner = ent->owner;
	body->movetype = ent->movetype;

	body->die = body_die;
	body->takedamage = DAMAGE_YES;

	gi.linkentity (body);
}



/*
===========
PutClientInArena

Called when a player connects to a server or respawns in
a deathmatch.
============
*/
void PutClientInArena (edict_t *ent, vec3_t spawn_origin, vec3_t spawn_angles)
{
	vec3_t	mins = {-16, -16, -24};
	vec3_t	maxs = {16, 16, 32};
	int		index,time1,time2,exec,kill,rails,arg,argg;
	gclient_t	*client;
	char *model;
	int		let,i,numy1,numy2,resetd,savegame,cam,vic,saveplaying,saveteam,savenum1,savenum2,timer,pownum,pass;
	int pu,only1,only2,only3,only4,only5,me1,me2;
	client_persistant_t	saved;
	client_respawn_t	resp;
	savenum1 = 0;
	savenum2= 0;
		CTFDeadDropFlag(ent);
		CTFDeadDropTech(ent);
  //	gi.bprintf(PRINT_MEDIUM, "executing putclientinarena\n");
	// find a spawn point
	// do it before setting health back up, so farthest
	// ranging doesn't count this client
//	SelectArenaSpawnPoint (ent, arena, spawn_origin, spawn_angles);
	me1=ent->client->megotnum1;
	me2=ent->client->megotnum2;
	arg=ent->client->puplayingstatus;
	argg=ent->client->pukillprot;
	numy1=ent->client->nummy1;
	numy2=ent->client->nummy2;
	resetd=ent->client->reset;
	vic=ent->client->victory;
	rails=railwars;
	kill=ent->client->killprot;
	exec=ent->client->executed;
	time1=ent->client->timer1;
	time2=ent->client->timer2;
	savegame= ent->client->gamestatus;
	saveplaying= ent->client->playingstatus;
	saveteam= ent->client->teamstatus;
	index = ent-g_edicts-1;
	client = ent->client;
	timer = ent->client->timer;
	savenum1=num1;
	savenum2=num2;
	model = ent->client->STORED;
	pownum = ent->client->powernum;
	cam=ent->client->iMode;
	pass = ent->client->freepass;
	only1=ent->client->onlyonce1;
	only2=ent->client->onlyonce2;
	only3=ent->client->onlyonce3;
	only4=ent->client->onlyonce4;
	only5=ent->client->onlyonce5;
	pu=ent->client->puteamstatus;
	let=ent->client->letguyscore;

	
	// deathmatch wipes most client data every spawn
	if (deathmatch->value)
	{
		char		userinfo[MAX_INFO_STRING];

		resp = client->resp;
		memcpy (userinfo, client->pers.userinfo, sizeof(userinfo));
		InitClientPersistant (client);
		ClientUserinfoChanged (ent, userinfo);
	

	}
	 else if (coop->value)
	{
		int			n;
		char		userinfo[MAX_INFO_STRING];

		resp = client->resp;
		memcpy (userinfo, client->pers.userinfo, sizeof(userinfo));
		// this is kind of ugly, but it's how we want to handle keys in coop
		for (n = 0; n < MAX_ITEMS; n++)
		{
			if (itemlist[n].flags & IT_KEY)
				resp.coop_respawn.inventory[n] = client->pers.inventory[n];
		}
		client->pers = resp.coop_respawn;
		ClientUserinfoChanged (ent, userinfo);
		if (resp.score > client->pers.score)
			client->pers.score = resp.score;
	}
	else
	{
		memset (&resp, 0, sizeof(resp));
	}

	// clear everything but the persistant data
	saved = client->pers;
	memset (client, 0, sizeof(*client));
	client->pers = saved;
	if (client->pers.health <= 0)
		InitClientPersistant(client);
	client->resp = resp;

	// copy some data from the client to the entity
	FetchClientEntData (ent);

	// clear entity values
	ent->groundentity = NULL;


	
	ent->client = &game.clients[index];
	ent->takedamage = DAMAGE_AIM;
	ent->movetype = MOVETYPE_WALK;
	ent->viewheight = 22;
	ent->inuse = true;
	ent->classname = "player";
	ent->mass = 200;
	ent->solid = SOLID_BBOX;
	ent->deadflag = DEAD_NO;
	ent->air_finished = level.time + 12;
	ent->clipmask = MASK_PLAYERSOLID;
	ent->model = "player/male/tris";
	ent->pain = player_pain;
	ent->die = player_die;
	ent->waterlevel = 0;
	ent->watertype = 0;
	ent->flags &= ~FL_NO_KNOCKBACK;
	ent->svflags &= ~SVF_DEADMONSTER;

	VectorCopy (mins, ent->mins);
	VectorCopy (maxs, ent->maxs);
	VectorClear (ent->velocity);

	// clear playerstate values
	memset (&ent->client->ps, 0, sizeof(client->ps));



	
//	gi.bprintf (PRINT_HIGH, "spot->s.origin[1] %f\n", spawn_origin[1]);
	client->ps.pmove.origin[0] = spawn_origin[0]*8;
	client->ps.pmove.origin[1] = spawn_origin[1]*8;
	client->ps.pmove.origin[2] = spawn_origin[2]*8;
//ZOID
	client->ps.pmove.pm_flags &= ~PMF_NO_PREDICTION;
//ZOID

	if (deathmatch->value && ((int)dmflags->value & DF_FIXED_FOV))
	{
		client->ps.fov = 90;
	}
	else
	{
		client->ps.fov = atoi(Info_ValueForKey(client->pers.userinfo, "fov"));
		if (client->ps.fov < 1)
			client->ps.fov = 90;
		else if (client->ps.fov > 160)
			client->ps.fov = 160;
	}

//	client->ps.gunindex = gi.modelindex(client->pers.weapon->view_model);
	

	// clear entity state values
	ent->s.effects = 0;
	ent->s.skinnum = ent - g_edicts - 1;
	ent->s.modelindex = 255;		// will use the skin specified model
	ent->s.modelindex2 = 255;		// custom gun model
	ent->s.frame = 0;
	VectorCopy (spawn_origin, ent->s.origin);
	ent->s.origin[2] += 10;	// make sure off ground
	VectorCopy (ent->s.origin, ent->s.old_origin);

	// set the delta angle
	for (i=0 ; i<3 ; i++)
		client->ps.pmove.delta_angles[i] = ANGLE2SHORT(spawn_angles[i] - client->resp.cmd_angles[i]);

	ent->s.angles[PITCH] = 0;
	ent->s.angles[YAW] = spawn_angles[YAW];
	ent->s.angles[ROLL] = 0;
	VectorCopy (ent->s.angles, client->ps.viewangles);
	VectorCopy (ent->s.angles, client->v_angle);
	ent->client->reset=resetd;
	ent->client->victory=vic;
	ent->client->gamestatus=savegame ;
	ent->client->timer1=time1;
	ent->client->timer2=time2;
	ent->client->playingstatus=saveplaying ;
	ent->client->teamstatus=saveteam ;
	ent->client->timer = timer;
	num1=savenum1;
	num2=savenum2;
	ent->client->puteamstatus=pu;
	ent->client->STORED=model;
	ent->client->powernum=pownum;
	ent->client->freepass=pass;
	ent->client->executed=exec;
	ent->client->killprot=kill;
	ent->client->nummy1=numy1;
	ent->client->nummy2=numy2;
	ent->client->puplayingstatus=arg;
	ent->client->pukillprot=argg;
	railwars=rails;
	ent->client->iMode=cam;
	ent->client->onlyonce1=only1;
	ent->client->onlyonce2=only2;
	ent->client->onlyonce3=only3;
	ent->client->onlyonce4=only4;
	ent->client->onlyonce5=only5;
	ent->client->megotnum1=me1;
	ent->client->megotnum2=me2;
	ent->client->letguyscore=let;

	// get rid of all weapons

	//make respawn noise
		ent->s.event = EV_PLAYER_TELEPORT;
//	respawn(ent);

	gi.linkentity (ent);
//ZOID
//	(CTFStartClient(ent));

//ZOID

//	if (!KillBox (ent))
//	{	// could't spawn in?
//	}



	// force the current weapon up
//	client->newweapon = client->pers.weapon;
//	ChangeWeapon (ent);
	
}

void respawn (edict_t *ent)
{edict_t *spot;
vec3_t spawn_origin, spawn_angles;


	{	spot = G_Spawn();
		spot->classname = "arena_observer_start";
		spot->s.origin[0] = 0;
		spot->s.origin[1] = 0;
		spot->s.origin[2] = 0;
		spot->s.angles[1] = 0;
		VectorCopy (spot->s.origin, spawn_origin);
		spawn_origin[2] += 9;
		VectorCopy (spot->s.angles, spawn_angles);
	

		if (ent->client->gamestatus == 2){

	PutClientInArena(ent, spawn_origin, spawn_angles);
		}


		return;
	}

	// restart the entire server
	gi.AddCommandString ("menu_loadgame\n");
}
/*
===========
PutClientInServer

Called when a player connects to a server or respawns in
a deathmatch.
============
*/
void PutClientInServer (edict_t *ent)
{
		vec3_t	mins = {-16, -16, -24};
	vec3_t	maxs = {16, 16, 32};
	int		index,time1,time2,exec,kill,rails,arg,argg;
	gclient_t	*client;
	char *model;
	int		let,i,numy1,numy2,resetd,savegame,cam,vic,saveplaying,saveteam,savenum1,savenum2,timer,pownum,pass;
	int pu,only1,only2,only3,only4,only5,me1,me2;
	client_persistant_t	saved;
	client_respawn_t	resp;
	vec3_t spawn_origin, spawn_angles;
	savenum1 = 0;
	savenum2= 0;
		CTFDeadDropFlag(ent);
		CTFDeadDropTech(ent);
  //	gi.bprintf(PRINT_MEDIUM, "executing putclientinarena\n");
	// find a spawn point
	// do it before setting health back up, so farthest
	// ranging doesn't count this client
//	SelectArenaSpawnPoint (ent, arena, spawn_origin, spawn_angles);
	me1=ent->client->megotnum1;
	me2=ent->client->megotnum2;
	arg=ent->client->puplayingstatus;
	argg=ent->client->pukillprot;
	numy1=ent->client->nummy1;
	numy2=ent->client->nummy2;
	resetd=ent->client->reset;
	vic=ent->client->victory;
	rails=railwars;
	kill=ent->client->killprot;
	exec=ent->client->executed;
	time1=ent->client->timer1;
	time2=ent->client->timer2;
	savegame= ent->client->gamestatus;
	saveplaying= ent->client->playingstatus;
	saveteam= ent->client->teamstatus;
	index = ent-g_edicts-1;
	client = ent->client;
	timer = ent->client->timer;
	savenum1=num1;
	savenum2=num2;
	model = ent->client->STORED;
	pownum = ent->client->powernum;
	cam=ent->client->iMode;
	pass = ent->client->freepass;
	only1=ent->client->onlyonce1;
	only2=ent->client->onlyonce2;
	only3=ent->client->onlyonce3;
	only4=ent->client->onlyonce4;
	only5=ent->client->onlyonce5;
	pu=ent->client->puteamstatus;
	let=ent->client->letguyscore;


	// find a spawn point
	// do it before setting health back up, so farthest
	// ranging doesn't count this client
	SelectSpawnPoint (ent, spawn_origin, spawn_angles);
//	gi.bprintf(PRINT_MEDIUM, "entered server\n");
	index = ent-g_edicts-1;
	client = ent->client;

	// deathmatch wipes most client data every spawn
	if (deathmatch->value)
	{
		char		userinfo[MAX_INFO_STRING];

		resp = client->resp;
		memcpy (userinfo, client->pers.userinfo, sizeof(userinfo));
		InitClientPersistant (client);
		ClientUserinfoChanged (ent, userinfo);
	

	}
	 else if (coop->value)
	{
		int			n;
		char		userinfo[MAX_INFO_STRING];

		resp = client->resp;
		memcpy (userinfo, client->pers.userinfo, sizeof(userinfo));
		// this is kind of ugly, but it's how we want to handle keys in coop
		for (n = 0; n < MAX_ITEMS; n++)
		{
			if (itemlist[n].flags & IT_KEY)
				resp.coop_respawn.inventory[n] = client->pers.inventory[n];
		}
		client->pers = resp.coop_respawn;
		ClientUserinfoChanged (ent, userinfo);
		if (resp.score > client->pers.score)
			client->pers.score = resp.score;
	}
	else
	{
		memset (&resp, 0, sizeof(resp));
	}

	// clear everything but the persistant data
	saved = client->pers;
	memset (client, 0, sizeof(*client));
	client->pers = saved;
	if (client->pers.health <= 0)
		InitClientPersistant(client);
	client->resp = resp;

	// copy some data from the client to the entity
	FetchClientEntData (ent);

	// clear entity values
	ent->groundentity = NULL;
	ent->client = &game.clients[index];
	ent->takedamage = DAMAGE_AIM;
	ent->movetype = MOVETYPE_WALK;
	ent->viewheight = 22;
	ent->inuse = true;
	ent->classname = "player";
	ent->mass = 200;
	ent->solid = SOLID_BBOX;
	ent->deadflag = DEAD_NO;
	ent->air_finished = level.time + 12;
	ent->clipmask = MASK_PLAYERSOLID;
	ent->model = "chicken/tris.md2";
	ent->pain = player_pain;
	ent->die = player_die;
	ent->waterlevel = 0;
	ent->watertype = 0;
	ent->flags &= ~FL_NO_KNOCKBACK;
	ent->svflags &= ~SVF_DEADMONSTER;

	VectorCopy (mins, ent->mins);
	VectorCopy (maxs, ent->maxs);
	VectorClear (ent->velocity);

	// clear playerstate values
	memset (&ent->client->ps, 0, sizeof(client->ps));

	client->ps.pmove.origin[0] = spawn_origin[0]*8;
	client->ps.pmove.origin[1] = spawn_origin[1]*8;
	client->ps.pmove.origin[2] = spawn_origin[2]*8;
//ZOID
	client->ps.pmove.pm_flags &= ~PMF_NO_PREDICTION;
//ZOID

	if (deathmatch->value && ((int)dmflags->value & DF_FIXED_FOV))
	{
		client->ps.fov = 90;
	}
	else
	{
		client->ps.fov = atoi(Info_ValueForKey(client->pers.userinfo, "fov"));
		if (client->ps.fov < 1)
			client->ps.fov = 90;
		else if (client->ps.fov > 160)
			client->ps.fov = 160;
	}

		
	
	client->ps.gunindex = gi.modelindex(client->pers.weapon->view_model);

	// clear entity state values
	ent->s.effects = 0;
	ent->s.skinnum = ent - g_edicts - 1;
	ent->s.modelindex = 255;		// will use the skin specified model
	ent->s.modelindex2 = 255;		// custom gun model
	ent->s.frame = 0;
	VectorCopy (spawn_origin, ent->s.origin);
	ent->s.origin[2] += 1;	// make sure off ground
	VectorCopy (ent->s.origin, ent->s.old_origin);

	// set the delta angle
	for (i=0 ; i<3 ; i++)
		client->ps.pmove.delta_angles[i] = ANGLE2SHORT(spawn_angles[i] - client->resp.cmd_angles[i]);

	ent->s.angles[PITCH] = 0;
	ent->s.angles[YAW] = spawn_angles[YAW];
	ent->s.angles[ROLL] = 0;
	VectorCopy (ent->s.angles, client->ps.viewangles);
	VectorCopy (ent->s.angles, client->v_angle);
	ent->client->reset=resetd;
	ent->client->victory=vic;
	ent->client->gamestatus=savegame ;
	ent->client->timer1=time1;
	ent->client->timer2=time2;
	ent->client->playingstatus=saveplaying ;
	ent->client->teamstatus=saveteam ;
	ent->client->timer = timer;
	num1=savenum1;
	num2=savenum2;
	ent->client->letguyscore=let;
	ent->client->puteamstatus=pu;
	ent->client->STORED=model;
	ent->client->powernum=pownum;
	ent->client->freepass=pass;
	ent->client->executed=exec;
	ent->client->killprot=kill;
	ent->client->nummy1=numy1;
	ent->client->nummy2=numy2;
	ent->client->puplayingstatus=arg;
	ent->client->pukillprot=argg;
	railwars=rails;
	ent->client->iMode=cam;
	ent->client->onlyonce1=only1;
	ent->client->onlyonce2=only2;
	ent->client->onlyonce3=only3;
	ent->client->onlyonce4=only4;
	ent->client->onlyonce5=only5;
	ent->client->megotnum1=me1;
	ent->client->megotnum2=me2;
//ZOID
//	if (CTFStartClient(ent))
//		return;
//ZOID

//	if (!KillBox (ent))
	{	// could't spawn in?
	}
  		

//	gi.linkentity (ent);

	// force the current weapon up
	client->newweapon = client->pers.weapon;
	ChangeWeapon (ent);
	
}

/*
=====================
ClientBeginDeathmatch

A client has just connected to the server in 
deathmatch mode, so clear everything out before starting them.
=====================
*/
void ClientBeginDeathmatch (edict_t *ent)
{	
	G_InitEdict (ent);

	InitClientResp (ent->client);
    ///Q2 Camera Begin
//    if (strcmp(ent->client->pers.netname, "CamClient") == 0)
 //   {	
		PutClientInServer(ent);

        MakeCamera(ent);
 //       ent->client->bIsCamera = 1;
	
		CTFOpenJoinMenu(ent);
	 
 //   }
 //   else
  //  {
	    // locate ent at a spawn point
//	    PutClientInServer (ent);
 //       ent->client->bIsCamera = 0;
 //   }

    EntityListAdd(ent);

    ///Q2 Camera End
	// locate ent at a spawn point

	
//	PutClientInServer (ent);

	// send effect
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_LOGIN);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	gi.bprintf (PRINT_HIGH, "%s entered the game\n", ent->client->pers.netname);

	// make sure all view stuff is valid
	ClientEndServerFrame (ent);
}


/*
===========
ClientBegin

called when a client has finished connecting, and is ready
to be placed into the game.  This will happen every level load.
============
*/
void ClientBegin (edict_t *ent)
{	char *userinfo;
	int		i;
	

	

	ent->client = game.clients + (ent - g_edicts - 1);

	if (deathmatch->value)
	{
		ClientBeginDeathmatch (ent);
//		KillBox(ent);
		return;
	}

	// if there is already a body waiting for us (a loadgame), just
	// take it, otherwise spawn one from scratch
	if (ent->inuse == true)
	{
		// the client has cleared the client side viewangles upon
		// connecting to the server, which is different than the
		// state when the game is saved, so we need to compensate
		// with deltaangles
		for (i=0 ; i<3 ; i++)
			ent->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(ent->client->ps.viewangles[i]);
	}
	else
	{
		// a spawn point will completely reinitialize the entity
		// except for the persistant data that was initialized at
		// ClientConnect() time
		G_InitEdict (ent);
		ent->classname = "player";
		InitClientResp (ent->client);
		PutClientInServer (ent);
	}

	if (level.intermissiontime)
	{
		MoveClientToIntermission (ent);
	}
	else
	{
		// send effect if in a multiplayer game
		if (game.maxclients > 1)
		{
			gi.WriteByte (svc_muzzleflash);
			gi.WriteShort (ent-g_edicts);
			gi.WriteByte (MZ_LOGIN);
			gi.multicast (ent->s.origin, MULTICAST_PVS);

			gi.bprintf (PRINT_HIGH, "%s entered the game\n", ent->client->pers.netname);
		}
	}
		userinfo=ent->client->pers.userinfo;
		ClientUserinfoChanged (ent, userinfo);
	// make sure all view stuff is valid
	ClientEndServerFrame (ent);
}


/*
===========
ClientUserInfoChanged

called whenever the player updates a userinfo variable.

The game can override any of the settings in place
(forcing skins or names, etc) before copying it off.
============
*/

void ClientUserinfoChanged (edict_t *ent, char *userinfo)
{
	char	*s, *n;
	int		playernum,i;
	static gitem_t *flag1_item;
	static gitem_t *flag2_item;
	gitem_t		*it;
	edict_t		*it_ent;
	static gitem_t *tech = NULL;
		gitem_t		*item;
	
	
	// check for malformed or illegal info strings
	if (!Info_Validate(userinfo))
	{
		gi.bprintf (PRINT_HIGH, "%s this inf0_validate executed\n", ent->client->pers.netname);
		strcpy (userinfo, "\\name\\badinfo\\skin\\players/male/grunt");
	}

	// set name
	n = Info_ValueForKey (userinfo, "name");
	strncpy (ent->client->pers.netname, n, sizeof(ent->client->pers.netname)-1);

	

	// set skin
	s = Info_ValueForKey (userinfo, "skin");
	playernum = ent-g_edicts-1;
//	strcpy(s, "models/chicken/");
	// combine name and skin into a configstring



	if (!flag2_item)
		flag2_item = FindItemByClassname("item_flag_team2");
	if (!flag1_item)
		flag1_item = FindItemByClassname("item_flag_team1");


	if (ent->client->pers.inventory[ITEM_INDEX(flag1_item)]  && ent->client->oncebaby==0) 
	{	
		gi.centerprintf(ent, "YOU ARE THE CHICKEN!!");
			
		
	
		for (i=6 ; i<game.num_items ; i++)
		{
			it = itemlist + i;
			if (!it->pickup)
				continue;
			if (!(it->flags & IT_AMMO))
				continue;
		
		}
	
		{
		gitem_armor_t	*info;

		it = FindItem("Jacket Armor");
		ent->client->pers.inventory[ITEM_INDEX(it)] = 0;

		it = FindItem("Combat Armor");
		ent->client->pers.inventory[ITEM_INDEX(it)] = 0;

		it = FindItem("Body Armor");
		info = (gitem_armor_t *)it->info;
		ent->client->pers.inventory[ITEM_INDEX(it)] = 0;

	}
			Cmd_take_f(ent);
			item = FindItem("railgun");
			ent->client->pers.selected_item = ITEM_INDEX(item);
			ent->client->pers.inventory[ent->client->pers.selected_item] = 1;
			item = FindItem("Slugs");
			ent->client->pers.inventory[ITEM_INDEX(item)] = 100;

			NoAmmoWeaponChange(ent);
		it = FindItem("Power Shield");
		it_ent = G_Spawn();
		it_ent->classname = it->classname;
		SpawnItem (it_ent, it);
		Touch_Item (it_ent, ent, NULL, NULL);
		if (it_ent->inuse)
			G_FreeEdict(it_ent);
			item = FindItem("cells");
			ent->client->pers.inventory[ITEM_INDEX(item)] = 100;
		it->use (ent, it);

			tech = FindItemByClassname("item_tech3");
		ent->client->pers.inventory[ITEM_INDEX(tech)]=1;

		if((num1+num2)<2 && ent->client->gamestatus<3)
		gi.centerprintf(ent, "WAITING FOR OPPONENT!!");
		s = "cyborg/oni911";
//		gi.bprintf (PRINT_HIGH, " s IS = %s /n", s);
//		s = "battroid/fokker";
		gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s", ent->client->pers.netname, s) );
		CTFEffects(ent);
		ent->client->oncebaby=1;
	}

	if (ent->client->pers.inventory[ITEM_INDEX(flag2_item)]  && ent->client->oncebaby==0 )  
	{
		
		gi.centerprintf(ent, "YOU ARE THE COW!!!");

		for (i=6 ; i<game.num_items ; i++)
		{
			it = itemlist + i;
			if (!it->pickup)
				continue;
			if (!(it->flags & IT_AMMO))
				continue;
	
		}
	
		{
		gitem_armor_t	*info;

		it = FindItem("Jacket Armor");
		ent->client->pers.inventory[ITEM_INDEX(it)] = 0;

		it = FindItem("Combat Armor");
		ent->client->pers.inventory[ITEM_INDEX(it)] = 0;

		it = FindItem("Body Armor");
		info = (gitem_armor_t *)it->info;
		ent->client->pers.inventory[ITEM_INDEX(it)] = 0;

	}
		Cmd_take_f(ent);
		item = FindItem("railgun");
			ent->client->pers.selected_item = ITEM_INDEX(item);
			ent->client->pers.inventory[ent->client->pers.selected_item] = 1;
			item = FindItem("Slugs");
			ent->client->pers.inventory[ITEM_INDEX(item)] = 100;

			NoAmmoWeaponChange(ent);
		it = FindItem("Power Shield");
		it_ent = G_Spawn();
		it_ent->classname = it->classname;
		SpawnItem (it_ent, it);
		Touch_Item (it_ent, ent, NULL, NULL);
		if (it_ent->inuse)
			G_FreeEdict(it_ent);
			item = FindItem("cells");
			ent->client->pers.inventory[ITEM_INDEX(item)] = 100;
		it->use (ent, it);

			tech = FindItemByClassname("item_tech3");
		ent->client->pers.inventory[ITEM_INDEX(tech)]=1;


		if((num1+num2)<2 && (ent->client->gamestatus<3 ))
		gi.centerprintf(ent, "WAITING FOR OPPONENT!!");
		s = "cow/blackcow";
//		gi.bprintf (PRINT_HIGH, " s IS = %s /n", s);
		gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s", ent->client->pers.netname, s) );
		CTFEffects(ent);
		ent->client->oncebaby=1;
	}		
		if (! ent->client->pers.inventory[ITEM_INDEX(flag2_item)] && !ent->client->pers.inventory[ITEM_INDEX(flag1_item)] )
	{	//	gi.centerprintf(ent, "TRANSFORMATION!!");
			s=ent->client->STORED;
//			gi.bprintf (PRINT_HIGH, " s IS = %s /n", s);
			gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s", ent->client->pers.netname, s) );
			CTFEffects(ent);
	}	
	// fov
	if (deathmatch->value && ((int)dmflags->value & DF_FIXED_FOV))
	{
		ent->client->ps.fov = 90;
	}
	else
	{
		ent->client->ps.fov = atoi(Info_ValueForKey(userinfo, "fov"));
		if (ent->client->ps.fov < 1)
			ent->client->ps.fov = 90;
		else if (ent->client->ps.fov > 160)
			ent->client->ps.fov = 160;
	}

	// handedness
	s = Info_ValueForKey (userinfo, "hand");
	if (strlen(s))
	{
		ent->client->pers.hand = atoi(s);
	}

	// save off the userinfo in case we want to check something later
	strncpy (ent->client->pers.userinfo, userinfo, sizeof(ent->client->pers.userinfo)-1);

}



/*
===========
ClientConnect

Called when a player begins connecting to the server.
The game can refuse entrance to a client by returning false.
If the client is allowed, the connection process will continue
and eventually get to ClientBegin()
Changing levels will NOT cause this to be called again, but
loadgames will.
============
*/
qboolean ClientConnect (edict_t *ent, char *userinfo)
{
	char	*value;

	// check to see if they are on the banned IP list
	value = Info_ValueForKey (userinfo, "ip");

	// check for a password
	value = Info_ValueForKey (userinfo, "password");
	if (strcmp(password->string, value) != 0)
		return false;

	// they can connect
	ent->client = game.clients + (ent - g_edicts - 1);

	// if there is already a body waiting for us (a loadgame), just
	// take it, otherwise spawn one from scratch
	if (ent->inuse == false)
	{
		// clear the respawning variables
//ZOID -- force team join
		ent->client->resp.ctf_team = -1;
//ZOID
		InitClientResp (ent->client);
		if (!game.autosaved || !ent->client->pers.weapon)
			InitClientPersistant (ent->client);
	}

	ClientUserinfoChanged (ent, userinfo);
	
	if (game.maxclients > 1)
		gi.dprintf ("%s connected\n", ent->client->pers.netname);

	ent->client->pers.connected = true;
	return true;

}

/*
===========
ClientDisconnect

Called when a player drops from the server.
Will not be called between levels.
============
*/
void ClientDisconnect (edict_t *ent)
{
	int		playernum;

	if (!ent->client)
		return;
   ///Q2 Camera Begin
    EntityListRemove(ent);
    ///Q2 Camera End
	gi.bprintf (PRINT_HIGH, "%s disconnected\n", ent->client->pers.netname);

	if(ent->client->teamstatus==2 && ent->client->playingstatus==4){
	num1=0; gi.bprintf (PRINT_HIGH, " PLAYER REMOVED FROM POWERCTF GAME \n");
	}
	if(ent->client->teamstatus==3 && ent->client->playingstatus==4){
	num2=0; gi.bprintf (PRINT_HIGH, " PLAYER REMOVE FROM POWERCTF GAME  \n");
	}


//ZOID

	CTFDeadDropFlag(ent);
	CTFDeadDropTech(ent);
	MAKENOTEAM=0;
	CTFResetFlags();
	gi.centerprintf(ent, "PLAYER DISCONNECTED POWERCTF GAME ABORTED!!");

//ZOID

	// send effect
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_LOGOUT);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	gi.unlinkentity (ent);
	ent->s.modelindex = 0;
	ent->solid = SOLID_NOT;
	ent->inuse = false;
	ent->classname = "disconnected";
	ent->client->pers.connected = false;

	playernum = ent-g_edicts-1;
	gi.configstring (CS_PLAYERSKINS+playernum, "");
}


//==============================================================


edict_t	*pm_passent;

// pmove doesn't need to know about passent and contentmask
trace_t	PM_trace (vec3_t start, vec3_t mins, vec3_t maxs, vec3_t end)
{
	if (pm_passent->health > 0)
		return gi.trace (start, mins, maxs, end, pm_passent, MASK_PLAYERSOLID);
	else
		return gi.trace (start, mins, maxs, end, pm_passent, MASK_DEADSOLID);
}

unsigned CheckBlock (void *b, int c)
{
	int	v,i;
	v = 0;
	for (i=0 ; i<c ; i++)
		v+= ((byte *)b)[i];
	return v;
}
void PrintPmove (pmove_t *pm)
{
	unsigned	c1, c2;

	c1 = CheckBlock (&pm->s, sizeof(pm->s));
	c2 = CheckBlock (&pm->cmd, sizeof(pm->cmd));
	Com_Printf ("sv %3i:%i %i\n", pm->cmd.impulse, c1, c2);
}
void arenyone(edict_t *ent)
{
	if(ent->client->teamstatus==2 && ent->client->playingstatus==4){
	num1=0; //gi.bprintf (PRINT_HIGH, " whoopie! num1 made 0.... num1 = %i  \n", num1);
	ent->client->megotnum1=0;
	}
	if(ent->client->teamstatus==3 && ent->client->playingstatus==4){
	num2=0; //gi.bprintf (PRINT_HIGH, " whoopie! num2 made 0.... num1 = %i  \n", num2);
	ent->client->megotnum2=0;
	}
		CTFDeadDropFlag(ent);
		CTFDeadDropTech(ent);
}


void entergame(edict_t *ent){

	 vec3_t spawn_origin, spawn_angles;

	if ( punumbys<500 && stopforasec==0 && ent->client->gamestatus==3){
	punumbys = punumbys + 1;
	}

	if (punumbys > 90.0 && punumbys < 120.0 )
	{	
		if (ent->client->dogcounter==0){
	gi.centerprintf(ent, "PICKUP GAME STARTING");
	gi.sound (ent, CHAN_RELIABLE+CHAN_VOICE, gi.soundindex("player/male/4.wav"), 1, ATTN_NORM, 0);
	ent->client->dogcounter =1;}
	}
	if (punumbys > 120.0 && punumbys <180 )
	{	if (ent->client->dogcounter==1){
		gi.centerprintf(ent, "GET READY!!");
		gi.sound (ent, CHAN_RELIABLE+CHAN_VOICE, gi.soundindex("player/male/3.wav"), 1, ATTN_NORM, 0);	
		ent->client->dogcounter =2;}
	}
	if (punumbys > 180.0 && punumbys < 230.0 )
	{	if (ent->client->dogcounter==2){
		gi.centerprintf(ent, "TWO !!");
		gi.sound (ent, CHAN_RELIABLE+CHAN_VOICE, gi.soundindex("player/male/2.wav"), 1, ATTN_NORM, 0);		
		ent->client->dogcounter =3;}
	}
	if (punumbys > 230.0 && punumbys < 250.0 )
	{	if (ent->client->dogcounter==3){
		gi.centerprintf(ent, "ONE !!");
		piggy=0;
		gi.sound (ent, CHAN_RELIABLE+CHAN_VOICE, gi.soundindex("player/male/1.wav"), 1, ATTN_NORM, 0);		
		ent->client->dogcounter =4;}
		ent->client->spawnd=1;
	}
	if (punumbys > 350.0 )
	{	if (ent->client->dogcounter==4){
		gi.centerprintf(ent, " GO!!");
		
		CTFResetFlags();
		SP_arena_game_start(ent, spawn_origin, spawn_angles);
		PutClientInArena(ent, spawn_origin, spawn_angles);
		Cmd_take_f(ent);
		Cmd_Give2_f (ent);
		railwars=1;
		ent->client->dogcounter =0;
		ent->client->pukillprot=0;
		pukillall=0;
		PUPICKUPSTART=0;
		ent->client->onlyonce3=0;
		ent->client->onlyonce1=0;
		ent->client->onlyonce2=0;
		ent->client->onlyonce4=0;
		ent->client->onlyonce5=0;
		ent->client->letguyscore=1;
		pickupweps=1;
		
	}

}
}
void pickupgame(edict_t *ent){ 
	int ctf_team;
	char *killer;

	if ( (ent->deadflag) && ent->client->onlyonce1 ==0){

	MakeCamera(ent);
	ent->client->onlyonce1=1;
//	ent->deadflag=DEAD_DEAD;
	}		

	ctf_team=ent->client->resp.ctf_team;
	killer=CTFOtherTeamName(ctf_team);


	if (pukillall==1 && !(killer==puteam) && ent->client->onlyonce3 ==0){
	KillBox (ent);
	ent->client->onlyonce3=1;
	gi.centerprintf(ent, "%s TEAM WINS, YOUR TEAM IS EXECUTED!!",killer);
	Cmd_take_f(ent);
	ent->client->victory=0;
	ent->client->letguyscore=0;
	}
	if (pukillall==1 && (killer==puteam) && ent->client->onlyonce4 ==0){
	gi.centerprintf(ent, "YOUR TEAM WINS !!!");
//	Cmd_take_f(ent);
	ent->client->victory = ent->client->victory+1;
	ent->client->onlyonce4 =1;
	ent->client->letguyscore=0;
	}

	tiecount=tiecount+1;
	if(tiecount>52){
		tiecount=0;
	tiecounter=0;}
	if (ent->client->gamestatus==3 && (ent->health>0)&& tiecount>2){
		tiecounter=tiecounter+1;
	}	
	if(tiecount==52 && tiecounter==0 && ent->client->onlyonce5==0){
	gi.bprintf(PRINT_HIGH,"GAME IS A TIE !!!");
	Cmd_take_f(ent);
	punumbys=0;
	ent->client->onlyonce5=1;}

	entergame(ent);
}


/*
==============
ClientThink

This will be called once for each client frame, which will
usually be a couple times for each server frame.
==============
*/

void ClientThink (edict_t *ent, usercmd_t *ucmd, edict_t *player, edict_t *self, char userinfo[MAX_INFO_STRING])
{	
	gclient_t	*client;
	edict_t	*other;
	gitem_t		*item;
	int	 i, j ,totald;
	int doggydoo;
	pmove_t	pm;
	 vec3_t spawn_origin, spawn_angles;
	static gitem_t *flag1_item;
	static gitem_t *flag2_item;
	gitem_t		*it;
	static gitem_t *tech = NULL;
	pm_passent = ent;



	level.current_entity = ent;
	client = ent->client;
	if (ent->client->gamestatus == 3)
	pickupgame(ent);
   


    if (ent->client->bIsCamera)
    {
        CameraThink(ent,ucmd);
        return;
    }



	{
		

	{	timey= timey +1;
//	gi.cprintf (ent,PRINT_HIGH, "timey+1");
	}
	if( timey==100 ){
//		start railwar
			startrail=1;
	}
	if( timey==200 ){
//		start grenage launcher war
			startgrenade=1;		
	}
		if( timey==700 ){
//		start hyperblaster war
			starthyper=1;		
	}
			if( timey==800 ){
//		start machinegun war
			startmachine=1;		
	}

	if( timey==1000 ){
//		reset railwars counter
			ent->client->endwars=1;
			timey=0;}}




	if (killall==1){
		railwars=0;	
	}

		if (!flag2_item)
		flag2_item = FindItemByClassname("item_flag_team2");
	if (!flag1_item)
		flag1_item = FindItemByClassname("item_flag_team1");
	//railwars!
//	gi.bprintf (PRINT_HIGH, " freepass=%i \n railwars=%i \n timey %i\n",ent->client->freepass, railwars, timey);
	if ((ent->client->pers.inventory[ITEM_INDEX(flag2_item)]  || ent->client->pers.inventory[ITEM_INDEX(flag1_item)])  && startrail==1 && ent->client->startonce2==0 ) 
	{		
			Cmd_take_f(ent);
		
			item = FindItem("railgun");
			client->pers.selected_item = ITEM_INDEX(item);
			client->pers.inventory[client->pers.selected_item] = 1;
			item = FindItem("Slugs");
			ent->client->pers.inventory[ITEM_INDEX(item)] = 100;

			NoAmmoWeaponChange(ent);
//			gi.centerprintf(ent, "RAILWARS !!");
			ent->client->startonce2=1;
	}
	//railwars over
	if ((ent->client->pers.inventory[ITEM_INDEX(flag2_item)]  || ent->client->pers.inventory[ITEM_INDEX(flag1_item)])  && startgrenade==1 && ent->client->startonce3==0 ) 

	{		
		
			Cmd_take_f(ent);
//			gi.centerprintf(ent, "ALL WEAPONS!!");
			item = FindItem("grenade launcher");
			client->pers.selected_item = ITEM_INDEX(item);
			client->pers.inventory[client->pers.selected_item] = 1;
			item = FindItem("Grenades");
			ent->client->pers.inventory[ITEM_INDEX(item)] = 100;

			ent->client->newweapon = FindItem ("grenade launcher");
//			gi.centerprintf(ent, "GRENADE LAUNCHER WARS !!");
			ent->client->startonce3=1;
	}
		if ((ent->client->pers.inventory[ITEM_INDEX(flag2_item)]  || ent->client->pers.inventory[ITEM_INDEX(flag1_item)])  && starthyper==1 && ent->client->startonce4==0 ) 
	{		
		
			Cmd_take_f(ent);
		
			item = FindItem("hyperblaster");
			client->pers.selected_item = ITEM_INDEX(item);
			client->pers.inventory[client->pers.selected_item] = 1;
			item = FindItem("cells");
			ent->client->pers.inventory[ITEM_INDEX(item)] = 300;

			ent->client->newweapon = FindItem ("hyperblaster");
//			gi.centerprintf(ent, "HYPERBLASTER WARS !!");
			ent->client->startonce4=1;
	}
				if ((ent->client->pers.inventory[ITEM_INDEX(flag2_item)]  || ent->client->pers.inventory[ITEM_INDEX(flag1_item)])  && startmachine==1 && ent->client->startonce5==0 ) 
	{		
		
			Cmd_take_f(ent);
	
			item = FindItem("machinegun");
			client->pers.selected_item = ITEM_INDEX(item);
			client->pers.inventory[client->pers.selected_item] = 1;
			item = FindItem("bullets");
			ent->client->pers.inventory[ITEM_INDEX(item)] = 1000;

			ent->client->newweapon = FindItem ("machinegun");
//			gi.centerprintf(ent, "MACHNINEGUN WARS !!");
			ent->client->startonce5=1;
	}
	if ((ent->client->pers.inventory[ITEM_INDEX(flag2_item)]  || ent->client->pers.inventory[ITEM_INDEX(flag1_item)]) && ent->client->endwars==1  )
	{		
		
			Cmd_Give2_f (ent);
//			gi.centerprintf(ent, "ALL WEAPONS!!");
			NoAmmoWeaponChange(ent);
		
			ent->client->startonce2=0;
			ent->client->startonce3=0;
			ent->client->startonce4=0;
			ent->client->startonce5=0;
			startrail=0;
			startgrenade=0;
			starthyper=0;
			startmachine=0;
			ent->client->endwars=0;
	}
	
	

	if (county ==1000)
				county=0;
	if (countyy ==1000)
				countyy=0;

			if (ent->client->teamstatus==2 && MAKENOTEAM==1){
				ent->client->resp.ctf_team = CTF_TEAM1;}
				if (ent->client->teamstatus==3 && MAKENOTEAM==1){
					ent->client->resp.ctf_team = CTF_TEAM2;}
				if (ent->client->teamstatus==1 && MAKENOTEAM==1){
				ent->client->resp.ctf_team = CTF_NOTEAM;}
				if (ent->client->gamestatus==1 && MAKENOTEAM==0){
				ent->client->resp.ctf_team = CTF_NOTEAM;}

//check to see if powerctf is behaving properly
	if ((num1+num2)==2 && MAKENOTEAM==1 && ent->client->playingstatus==4){
	piggy=piggy+1;
	if (piggy>2500){
	triggy=155;
	gi.centerprintf(ent, "GAME OVER ON TIME!!");
	piggy=0;
	ent->client->reset=0;
	}
	}
	if ((num1+num2)==2 && MAKENOTEAM==0 && ent->client->playingstatus==4){
	piggy=piggy+1;
	if (piggy>500){
	triggy=155;
	gi.centerprintf(ent, "POWERCTF ERROR -- RESETTING!!");
	piggy=0;
	ent->client->reset=0;
	}
	}
	if ((num1+num2)==1 && MAKENOTEAM==1 && ent->client->playingstatus==4){
	piggy=piggy+1;
	if (piggy>500){
	triggy=155;
	gi.centerprintf(ent, "POWERCTF ERROR -- RESTARTING!!");
	piggy=0;
	ent->client->reset=0;
	}

	}
	

    if (triggy>120 && ent->client->gamestatus==2 && ent->client->reset==0){
		triggy=triggy-1;
		KillBox (ent);
		ent->client->gamestatus=2;
		
		ent->client->playingstatus=2;
		numbys=0;
		num1=0;
		ent->client->megotnum1=0;
		num2=0;
		ent->client->megotnum2=0;
	ent->client->victory=0;
	ent->client->timer1=1;
	ent->client->timer2=0;
	ent->client->timer = 0;
	ent->client->powernum=0;
	ent->client->freepass=0;
	ent->client->executed=0;
	ent->client->killprot=0;
	ent->client->nummy1=0;
	ent->client->nummy2=0;
	numbys=0;
	MAKENOTEAM=0;
	CTFDeadDropFlag(ent);
	CTFDeadDropTech(ent);
	SP_arena_observer_start (ent, spawn_origin, spawn_angles);
	PutClientInArena(ent, spawn_origin, spawn_angles);
	ent->client->reset=1;
	}


	if (stopforasec==1){
		stopcounter=stopcounter+1;
	gi.centerprintf(ent, "%s WON 3 IN A ROW!!",name);
	if(stopcounter>70){
		stopforasec=0;}
	}
	
	if (killall==1){
		triggernewgame=1;
		doggydoo=1;	
	}
	if (triggernewgame==1 && (num1+num2)==2 && doggydoo ==1){
		numbys=0;
		doggydoo=0;
		triggernewgame=0;
	}
	if(ent->client->victory >=3){
	victory(ent);
	ent->client->victory=-1;
	stopforasec=1;
	 name = ent->client->pers.netname;

	}
	if (electrocute==1 && !(ent->client->victory==-1)){
	gi.sound (ent, CHAN_AUTO, gi.soundindex("player/fry.wav"), 1, ATTN_NORM, 0);
		
		CTFDeadDropFlag(ent);
		CTFDeadDropTech(ent);
		KillBox (ent);
		ent->client->victory =0;
		gi.centerprintf(ent, "YOU HAVE BEEN ELECTROCUTED BY %s !!",name);
		electrocute=0;
		piggy=0;
		gi.sound (ent, CHAN_AUTO, gi.soundindex("player/fry.wav"), 1, ATTN_NORM, 0);
		stopforasec=0;
	}
	if (blowup==1 && !(ent->client->victory==-1)){		
		CTFDeadDropFlag(ent);
		CTFDeadDropTech(ent);
		KillBox (ent);
		ent->client->victory =0;
		piggy=0;
		gi.centerprintf(ent, "YOU HAVE BEEN BLOWED UP BY %s !!",name);
		blowup=0;
		stopforasec=0;
	}
	if (kiss==1&& !(ent->client->victory==-1)){
	gi.centerprintf(ent, "YOU HAVE BEEN KISSED BY %s !!",name);
	ent->client->victory =0;
	kiss=0;
	}
//	gi.bprintf (PRINT_HIGH, " num1...= %i num2...=%i \n teamstatus...=%i \n playingstatus...=%i \n", num1, num2, ent->client->teamstatus, ent->client->playingstatus);
	if (spawnoutside==1 && !(ent->client->victory==-1)){
		gi.sound (ent, CHAN_AUTO, gi.soundindex("player/fry.wav"), 1, ATTN_NORM, 0);
		CTFDeadDropFlag(ent);
		CTFDeadDropTech(ent);
		ent->client->victory =0;
		respawn(ent);
		gi.centerprintf(ent, "YOU HAVE BEEN SPAWNED HERE BY %s !!",name);
		piggy=0;
		spawnoutside=0;
		stopforasec=0;
	}
	if (map1==1){
		gi.sound (ent, CHAN_AUTO, gi.soundindex("player/fry.wav"), 1, ATTN_NORM, 0);
	
            ent->classname = "target_changelevel";
            ent->map = "ra2map1";
			BeginIntermission (ent);
		gi.bprintf(PRINT_HIGH,"%s CHANGES MAP TO RA2MAP1 !!",name);
		map1=0;
		ent->client->victory =0;
	}
		if (map2==1){
		gi.sound (ent, CHAN_AUTO, gi.soundindex("player/fry.wav"), 1, ATTN_NORM, 0);
		
            ent->classname = "target_changelevel";
            ent->map = "ra2kxg";
			BeginIntermission (ent);
		gi.bprintf(PRINT_HIGH,"%s CHANGES MAP TO RA2KXG !!",name);
		map2=0;	
		ent->client->victory =0;
		stopforasec=0;
	}
			if (map3==1){
		gi.sound (ent, CHAN_AUTO, gi.soundindex("player/fry.wav"), 1, ATTN_NORM, 0);
		
            ent->classname = "target_changelevel";
            ent->map = "q2ctf4";
			BeginIntermission (ent);
		gi.bprintf(PRINT_HIGH, "%s CHANGES MAP TO Q2CTF4 !!",name);
		map3=0;	
		ent->client->victory =0;
		stopforasec=0;
	}
	if (killall==1 && ent->client->startonce==1 && ent->client->killprot==1) 
	{//drop all weapons
			SP_arena_game_start(ent, spawn_origin, spawn_angles);
			PutClientInArena(ent, spawn_origin, spawn_angles);
			gi.centerprintf(ent, "YOU HAVE WON !!");
			ent->client->letguyscore=0;
			ent->client->reset=0;
			triggy=0;
			Cmd_Give2_f(ent);
			railwars=0;
		
			ent->client->startonce=0;
			ent->client->victory = ent->client->victory+1;
	
	}
	if (killall==1 && ent->client->killprot==0 && (ent->client->playingstatus==4 || ent->client->freepass==1)) 
	{
//		gi.cprintf (ent, PRINT_HIGH, "KILLBOX EXECUTED");
		gi.centerprintf(ent, "YOU ARE EXECUTED!!");
		CTFDeadDropFlag(ent);
		CTFDeadDropTech(ent);
		KillBox (ent);
		killall=0;
		MAKENOTEAM=0;
		Cmd_take_f(ent);
		ent->client->startonce=0;
		ent->client->executed=1;
		gi.sound (ent, CHAN_AUTO, gi.soundindex("items/captureflag.wav"), 1, ATTN_NORM, 0);
		railwars=0;
		ent->client->resp.ctf_team = CTF_NOTEAM;
		ent->client->timer2=300;
		ent->client->victory =0;
		piggy=0;
		ent->client->reset=0;
		triggy=0;
		ent->client->freepass=0;
		ent->client->letguyscore=0;
	}
	
	if ( ent->client->executed==1  && ent->client->teamstatus==2)
	{	
//		ent->client->freepass=1;
		
		ent->client->executed=0;
		ent->client->playingstatus = 1; //gi.bprintf (PRINT_HIGH, " ent->client->playingstatus made 1....= %i  \n", ent->client->playingstatus);
		num1= 0;
		ent->client->megotnum1=0;
		piggy=0;
		ent->client->timer1 = 1;
//		CopyToBodyQue(ent);
		CTFDeadDropFlag(ent);
		CTFDeadDropTech(ent);
		ent->client->timer1 = 1;
		MAKENOTEAM=0;
		
	}
//	gi.bprintf (PRINT_HIGH, " num1= %i\n num2=%i \n exec=%i\n", num1,num2,ent->client->executed);
	if (  ent->client->executed==1 && ent->client->teamstatus==3)
	{	
//		ent->client->freepass=1;
//		gi.bprintf (PRINT_HIGH, " num1= %i\n num2=%i \n exec=%i\n", num1,num2,ent->client->executed);
		ent->client->executed=0;
		ent->client->playingstatus = 1; //gi.bprintf (PRINT_HIGH, " ent->client->playingstatus made 1....= %i  \n", ent->client->playingstatus);
		num2= 0; 
		ent->client->megotnum2=0;
		piggy=0;
		ent->client->timer1 = 1;
//		CopyToBodyQue(ent);
		CTFDeadDropFlag(ent);
		CTFDeadDropTech(ent);
		ent->client->timer1 = 1;
		MAKENOTEAM=0;
	}
	if (MAKENOTEAM==0 && ent->client->playingstatus==4){
		pigger=pigger+1;
//		CTFResetFlags();
		if (pigger ==25){
		CTFDeadDropFlag(ent);
	
		pigger=0;
		}
	}
     
		totald=0;
		totald = (num1 + num2);	

	timeyd= timeyd +1;
	if(timeyd ==5){
//	gi.cprintf (ent,PRINT_HIGH, "%f \n %f \n %f \n and %f \n", ent->s.origin[0], ent->s.origin[1],ent->s.origin[2],ent->s.angles[1]);
//	gi.cprintf (ent,PRINT_HIGH, "stopforasec= %i \n totald= %i \n game= %i \n playing= %i \n numbys= %i \n",stopforasec, totald, ent->client->gamestatus,ent->client->playingstatus,numbys);
	CTFUpdateJoinMenu(ent);
	timeyd=0;}

	if ( totald==2 && numbys<500 && ent->client->playingstatus==4 && stopforasec==0){

	numbys = numbys + 1;
//	gi.centerprintf(ent, "inside the fucking numby loop");
//	
	}
	//Time to play wav 4
	if (numbys > 10.0 && numbys < 120.0 && ent->client->playingstatus==4)
	{	
		if (ent->client->dogcounter==0){
//	gi.bprintf (PRINT_HIGH, " num1...= %i num2...=%i \n", num1, num2);
	gi.centerprintf(ent, "POWERCTF GAME STARTING");
	gi.sound (ent, CHAN_RELIABLE+CHAN_VOICE, gi.soundindex("player/male/4.wav"), 1, ATTN_NORM, 0);
	ent->client->dogcounter =1;}

	}

	//Time to play wav 3
	if (numbys > 120.0 && numbys <180 && ent->client->playingstatus==4)
	{	if (ent->client->dogcounter==1){
//		gi.bprintf (PRINT_HIGH, " num1...= %i num2...=%i \n", num1, num2);
		gi.centerprintf(ent, "GET READY!!");
		gi.sound (ent, CHAN_RELIABLE+CHAN_VOICE, gi.soundindex("player/male/3.wav"), 1, ATTN_NORM, 0);	
		ent->client->dogcounter =2;}

	}
	//Time to play wav 2
	if (numbys > 180.0 && numbys < 230.0 && ent->client->playingstatus==4)
	{	if (ent->client->dogcounter==2){
//		gi.bprintf (PRINT_HIGH, " num1...= %i num2...=%i \n", num1, num2);
		gi.centerprintf(ent, "TWO !!");
		gi.sound (ent, CHAN_RELIABLE+CHAN_VOICE, gi.soundindex("player/male/2.wav"), 1, ATTN_NORM, 0);		
		ent->client->dogcounter =3;}

	}
	//Time to play wav 1
	if (numbys > 230.0 && numbys < 250.0 && ent->client->playingstatus==4)
	{	if (ent->client->dogcounter==3){
//		gi.bprintf (PRINT_HIGH, " num1...= %i num2...=%i \n", num1, num2);
		gi.centerprintf(ent, "ONE !!");
		Cmd_take_f(ent);
		piggy=0;
		gi.sound (ent, CHAN_RELIABLE+CHAN_VOICE, gi.soundindex("player/male/1.wav"), 1, ATTN_NORM, 0);		
		ent->client->dogcounter =4;}
		ent->client->spawnd=1;

	}
		//Time to play wav 1
	if (numbys > 350.0 && ent->client->playingstatus==4 )
	{	if (ent->client->dogcounter==4){
		ent->client->reset=0;
		triggy=0;
		gi.centerprintf(ent, " GO!!");

				if (MAKENOTEAM==1 && pigdog2==0)
				{ent->client->teamstatus=2;
				ent->client->resp.ctf_team = CTF_TEAM1;
				pigdog2=1;}
				else 
				{ent->client->teamstatus=3;
				ent->client->resp.ctf_team = CTF_TEAM2;
				pigdog2=0;}

		if (ent->client->playingstatus ==4){
		gamestartcounter=gamestartcounter+1;}

		if (gamestartcounter==2){
		gamestartcounter=0;
		stopmultiplestarts==1;
		numbys==0;
		}	

		CTFDeadDropFlag(ent);
		CTFDeadDropTech(ent);
		CTFResetFlags();
		SP_arena_game_start(ent, spawn_origin, spawn_angles);
		PutClientInArena(ent, spawn_origin, spawn_angles);
		Cmd_take_f(ent);
		Cmd_Give2_f (ent);
		MAKENOTEAM=1;
		railwars=1;
		ent->client->startonce=1;
		ent->client->dogcounter =0;
		ent->client->killprot=0;
		ent->client->letguyscore=1;
	
	
	}
//		numbys==0;
	}
	


	if( ent->client->gamestatus == 0)
	{	 ent->client->teamstatus = 0;//gi.bprintf (PRINT_HIGH, " 1 ent->client->teamstatus made 0....= %i  \n", ent->client->teamstatus);

		 ent->client->playingstatus = 0;//gi.bprintf (PRINT_HIGH, " 1 ent->client->playingstatus made 0....= %i  \n", ent->client->playingstatus);
	}	
	if ( ent->client->playingstatus ==2 ){
		ent->client->playingstatus = 3;} 

	
	

	

//	gi.bprintf (PRINT_HIGH, "playing = %i, timer2= %i, timer1 = %i",ent->client->playingstatus, ent->client->timer2, ent->client->timer1);
		if ( (num2==0 && ent->client->playingstatus == 3 && ent->client->gamestatus==2)||(ent->client->freepass==1 && ent->client->teamstatus==3 && ent->client->timer2>300)){
		
				if (topplayer==0)
				topplayer=10001;
			if (ent->client->powernum <= topplayer){
			topplayer = ent->client->powernum;
			playercounter = playercounter+1;
//gi.cprintf (ent, PRINT_HIGH, "topplayer is %i \n playercounter is %i \npowernum is %i \n",topplayer,playercounter,ent->client->powernum);
		}

	if ((playercounter > 30 && ent->client->powernum == topplayer && ent->client->gamestatus==2)||(ent->client->freepass==1  && ent->client->timer2>300)){
	
	if (ent->client->freepass==1){
		CTFDeadDropFlag(ent);
		CTFDeadDropTech(ent);}
	if (ent->client->freepass==1)		
	SP_arena_game_start(ent, spawn_origin, spawn_angles);
	if (ent->client->freepass==0){
		num2=1;
	ent->client->megotnum2=1;}
	ent->client->playingstatus =4;
	
	ent->client->spawnd =0;
	if (ent->client->freepass==1){
	PutClientInArena(ent, spawn_origin, spawn_angles);
		Cmd_take_f(ent);
		Cmd_Give2_f (ent);}
	topplayer=0;
	playercounter=0;
	ent->client->freepass=0;
//	gi.cprintf (ent, PRINT_HIGH, "EXUCTED THE ARENA 2 SHIT");
	ent->client->timer1 = 0;
	ent->client->timer2 = 0;
	ent->client->nummy1=0;
		}
		 }	
		 if ( (num1==0 && ent->client->playingstatus == 3 && ent->client->gamestatus==2)||(ent->client->freepass==1&& ent->client->teamstatus==2 && ent->client->timer2>300)){
	
				if (topplayer==0)
				topplayer=10001;
			if (ent->client->powernum <= topplayer){
			topplayer = ent->client->powernum;
			playercounter = playercounter+1;
//gi.cprintf (ent, PRINT_HIGH, "topplayer is %i \n playercounter is %i \npowernum is %i \n",topplayer,playercounter,ent->client->powernum);
		}

			if ((playercounter > 30 && ent->client->powernum == topplayer && ent->client->gamestatus==2)||(ent->client->freepass==1 && ent->client->timer2>300)){
		
	if (ent->client->freepass==1){
		CTFDeadDropFlag(ent);
		CTFDeadDropTech(ent);}
	if (ent->client->freepass==1)		
	SP_arena_game_start(ent, spawn_origin, spawn_angles);
	if (ent->client->freepass==0){
		num1=1;
	ent->client->megotnum1=1;}
	ent->client->playingstatus =4;
	
	ent->client->spawnd =0;
	if (ent->client->freepass==1){
	PutClientInArena(ent, spawn_origin, spawn_angles);
		Cmd_take_f(ent);
		Cmd_Give2_f (ent);}
	topplayer=0;
	playercounter=0;
	ent->client->freepass=0;
//	gi.cprintf (ent, PRINT_HIGH, "EXUCTED THE 3 ARENA SHIT");
	ent->client->timer1 = 0;
	ent->client->timer2 = 0;
	ent->client->nummy2=0;
			}
		 }

		if ( (ent->client->puplayingstatus == 0 && ent->client->playingstatus == 1)|| (ent->client->freepass==1 && ent->client->timer2 < 10))
		{	 ent->client->playingstatus = 2; 

		if (ent->client->freepass==1){
		CTFDeadDropFlag(ent);
		CTFDeadDropTech(ent);
		}
	
		if (ent->client->freepass==0){
		powernumber=powernumber+1;
		ent->client->powernum = powernumber;
//		gi.cprintf (ent, PRINT_HIGH, "powernum is %i \n",ent->client->powernum);
		}
//		if (ent->client->freepass==0)
		SP_arena_observer_start (ent, spawn_origin, spawn_angles);
	
		PutClientInArena(ent, spawn_origin, spawn_angles);
	
			Cmd_take_f(ent);
		ent->client->timer1 = 1;
		ent->client->timer2 =21;
		
//		gi.cprintf (ent, PRINT_HIGH, "TIMER ACTIVATED");
//		gi.bprintf (PRINT_HIGH, " num1...= %i num2...=%i \n", num1, num2);
		}

		if(ent->client->timer1 == 1)
		{ 

		ent->client->timer2 = ent->client->timer2 +1;
		}




	if ( ent->client->executed==0 && ent->client->playingstatus == 4 && (ent->deadflag))
	{	
		ent->client->freepass=1;
		
			ent->client->startonce2=0;
			ent->client->startonce3=0;
			railwars=1;
		
//		ent->client->playingstatus = 1; //gi.bprintf (`PRINT_HIGH, " ent->client->playingstatus made 1....= %i  \n", ent->client->playingstatus);
//		num1= 0;
		piggy=0;
		ent->client->timer1 = 1;
//		CopyToBodyQue(ent);
		CTFDeadDropFlag(ent);
		CTFDeadDropTech(ent);
		ent->client->timer1 = 1;
		
	}
	if (  ent->client->executed==0 && ent->client->playingstatus == 4 && (ent->deadflag))
	{	
		ent->client->freepass=1;
		
			ent->client->startonce2=0;
			ent->client->startonce3=0;
		
		
//		ent->client->playingstatus = 1; //gi.bprintf (PRINT_HIGH, " ent->client->playingstatus made 1....= %i  \n", ent->client->playingstatus);
//		num2= 0; 
		piggy=0;
		ent->client->timer1 = 1;
//		CopyToBodyQue(ent);
		CTFDeadDropFlag(ent);
		CTFDeadDropTech(ent);
		ent->client->timer1 = 1;	
	}
	if (level.intermissiontime)
	{
		client->ps.pmove.pm_type = PM_FREEZE;
		// can exit intermission after five seconds
		if (level.time > level.intermissiontime + 5.0 
			&& (ucmd->buttons & BUTTON_ANY) )
			level.exitintermission = true;
		return;
	}



//ZOID
	if (ent->client->chase_target) {
		client->resp.cmd_angles[0] = SHORT2ANGLE(ucmd->angles[0]);
		client->resp.cmd_angles[1] = SHORT2ANGLE(ucmd->angles[1]);
		client->resp.cmd_angles[2] = SHORT2ANGLE(ucmd->angles[2]);
		return;
	}
//ZOID

	// set up for pmove
	memset (&pm, 0, sizeof(pm));

	if (ent->movetype == MOVETYPE_NOCLIP)
		client->ps.pmove.pm_type = PM_SPECTATOR;
	else if (ent->s.modelindex != 255)
		client->ps.pmove.pm_type = PM_GIB;
	else if (ent->deadflag)
		client->ps.pmove.pm_type = PM_DEAD;
	else
		client->ps.pmove.pm_type = PM_NORMAL;


	if (!flag2_item)
		flag2_item = FindItemByClassname("item_flag_team2");
	if (!flag1_item)
		flag1_item = FindItemByClassname("item_flag_team1");

   client->ps.pmove.gravity = sv_gravity->value;
			
	if (ent->client->pers.inventory[ITEM_INDEX(flag2_item)]  || ent->client->pers.inventory[ITEM_INDEX(flag1_item)]) 
	{ 
		client->ps.pmove.gravity = sv_gravity->value*0.1;

	ent->client->number=(ent->client->number + 1);

	if (ent->client->number ==2){

			ent->client->quad_framenum = 0;
			ent->client->invincible_framenum = 0;
			ent->client->breather_framenum = 0;
			ent->client->enviro_framenum = 0;
			ent->client->grenade_blew_up = false;
			ent->client->grenade_time = 0;

	
//		{gi.sound (self, CHAN_RELIABLE, gi.soundindex(va("player/male/gotchicken%i.wav", (rand()%4)+1)), 1, ATTN_NORM, 0);
//		{gi.sound (self, CHAN_RELIABLE+CHAN_WEAPON, gi.soundindex(va("player/male/death%i.wav", (rand()%4)+1)), 1, ATTN_NORM, 0);
		gi.configstring(CS_LIGHTS, "m");

		userinfo=ent->client->pers.userinfo;
		ClientUserinfoChanged (ent, userinfo);
		Cmd_Homingoff_f (ent);
		Cmd_Give_f(ent);
	}
						
	} else {
		

	ent->client->number=0;
	}


if (!ent->client->pers.inventory[ITEM_INDEX(flag2_item)]  && !ent->client->pers.inventory[ITEM_INDEX(flag1_item)])

		{
	
	ent->client->number2=(ent->client->number2 + 1);
	if (ent->client->number2 == 2)
	{
		
//	gi.bprintf (PRINT_HIGH, "EXECUTING PLAYER HAS NO FLAG \n");	
//		memcpy (userinfo, client->pers.userinfo, sizeof(userinfo));
//		InitClientPersistant (client);

		userinfo=ent->client->pers.userinfo;
		ClientUserinfoChanged (ent, userinfo);	
		Cmd_Homingon_f (ent);	
//			Cmd_Give2_f (ent);
		
		gi.configstring(CS_LIGHTS,"jklmnopqrstuvwxyzyxwvutsrqponmlkj");
		
	}
	
	
	
	} else {
	ent->client->number2=0;
	}

//*****************************************************************************
	
	if(stricmp(level.mapname, "ra2map1") == 0 || stricmp(level.mapname, "ra2kxg") == 0)
	{

	if (ent->client->pers.inventory[ITEM_INDEX(flag2_item)]  || ent->client->pers.inventory[ITEM_INDEX(flag1_item)]) 
//if (!ent->client->pers.inventory[ITEM_INDEX(flag2_item)]  && !ent->client->pers.inventory[ITEM_INDEX(flag1_item)])
	{

	ent->client->numbers=ent->client->numbers + 1.0;
//	gi.bprintf (PRINT_HIGH, "numbers are = %f\n", ent->client->numbers);


	tech = FindItemByClassname("item_tech4");

if (ent->client->pers.inventory[ITEM_INDEX(tech)])
	{	
	if (ent->client->numbers > 600.0)
	{	

	gi.centerprintf(ent, "DESTRUCT SEQUENCE DE-ACTIVATED");

	if ((it = CTFWhat_Tech(ent)) != NULL) 
	it->drop (ent, it);

	ent->client->numbers = 0.0;
}
}	

	//Time to play wav 4
	if (ent->client->numbers == 500.0)
	{	
	if (ent->client->pers.inventory[ITEM_INDEX(flag2_item)])  
	gi.centerprintf(ent, "COW TRANSPLANT REVERSING");
	if (ent->client->pers.inventory[ITEM_INDEX(flag1_item)])
	gi.centerprintf(ent, "CHICKEN TRANSPLANT REVERSING");
	gi.sound (ent, CHAN_RELIABLE+CHAN_VOICE, gi.soundindex("player/male/4.wav"), 1, ATTN_NORM, 0);
	}
	//Time to play wav 3
	if (ent->client->numbers == 600.0)
	{
	if (ent->client->pers.inventory[ITEM_INDEX(flag2_item)])  
	gi.centerprintf(ent, "WARNING !! COW REJECTION ");
	
	if (ent->client->pers.inventory[ITEM_INDEX(flag1_item)])
	gi.centerprintf(ent, "WARNING !! CHICKEN REJECTION ");
		
gi.sound (ent, CHAN_RELIABLE+CHAN_VOICE, gi.soundindex("player/male/3.wav"), 1, ATTN_NORM, 0);		

	}
	//Time to play wav 2
	if (ent->client->numbers == 700.0)
	{
	if (ent->client->pers.inventory[ITEM_INDEX(flag2_item)])  
	gi.centerprintf(ent, "COW REJECTION PROCESS BEGINING");
		gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_LOGOUT);
	gi.multicast (ent->s.origin, MULTICAST_PVS);
	if (ent->client->pers.inventory[ITEM_INDEX(flag1_item)])
	gi.centerprintf(ent, "CHICKEN REJECTION PROCESS BEGINING");
		gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_LOGOUT);
	gi.multicast (ent->s.origin, MULTICAST_PVS);
gi.sound (ent, CHAN_RELIABLE+CHAN_VOICE, gi.soundindex("player/male/2.wav"), 1, ATTN_NORM, 0);		

	}
	//Time to play wav 1
	if (ent->client->numbers > 850.0 && ent->client->numbers < 890.0)
	{
	if (ent->client->pers.inventory[ITEM_INDEX(flag2_item)])  
	gi.centerprintf(ent, "COW REJECTION COMPLETE!!");
		gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_LOGOUT);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	if (ent->client->pers.inventory[ITEM_INDEX(flag1_item)])
	gi.centerprintf(ent, "CHICKEN REJECTION COMPLETE!!");
		gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_LOGOUT);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

gi.sound (ent, CHAN_RELIABLE+CHAN_VOICE, gi.soundindex("player/male/1.wav"), 1, ATTN_NORM, 0);		

	}
		//Time to play wav 1
	if (ent->client->numbers == 990.0)
	{
		gi.centerprintf(ent, "                                       ");
			if(ent->client->pers.inventory[ITEM_INDEX(flag1_item)]){
			CTFDeadDropFlag(ent);
				gi.centerprintf(ent, "YOU'VE LOST THE CHICKEN!!");
					gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_LOGOUT);
	gi.multicast (ent->s.origin, MULTICAST_PVS);
			CTFResetFlag(CTF_TEAM1);}
		if(ent->client->pers.inventory[ITEM_INDEX(flag2_item)]){
			CTFDeadDropFlag(ent);
				gi.centerprintf(ent, "YOU'VE LOST THE COW!!");
					gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_LOGOUT);
	gi.multicast (ent->s.origin, MULTICAST_PVS);
			CTFResetFlag(CTF_TEAM2);}
	gi.sound (ent, CHAN_RELIABLE+CHAN_VOICE, gi.soundindex("player/male/homelock.wav"), 1, ATTN_NORM, 0);

		client->ps.pmove.gravity = sv_gravity->value;
		ent->client->number2 = 2;
		userinfo=ent->client->pers.userinfo;
		ClientUserinfoChanged (ent, userinfo);
		ent->client->oncebaby=0;
		Cmd_Homingon_f (ent);
		Cmd_take_f(ent);
		Cmd_Give2_f(ent);
		tech = FindItemByClassname("item_tech3");
		ent->client->pers.inventory[ITEM_INDEX(tech)]=0;}

	
	
	} else {
	
	ent->client->numbers=0;
	}

}	

//*****************************************************************************
	if(stricmp(level.mapname, "q2ctf4") == 0)
{

if (ent->client->pers.inventory[ITEM_INDEX(flag2_item)]  || ent->client->pers.inventory[ITEM_INDEX(flag1_item)]) 
//if (!ent->client->pers.inventory[ITEM_INDEX(flag2_item)]  && !ent->client->pers.inventory[ITEM_INDEX(flag1_item)])
	{

	ent->client->numbers=ent->client->numbers + 1.0;
//	gi.bprintf (PRINT_HIGH, "numbers are = %f\n", ent->client->numbers);


	tech = FindItemByClassname("item_tech4");

if (ent->client->pers.inventory[ITEM_INDEX(tech)])
	{	
	if (ent->client->numbers > 1200.0)
	{	

	gi.centerprintf(ent, "DESTRUCT SEQUENCE DE-ACTIVATED");

	if ((it = CTFWhat_Tech(ent)) != NULL) 
	it->drop (ent, it);

	ent->client->numbers = 0.0;
}
}	

	//Time to play wav 4
	if (ent->client->numbers == 900.0)
	{	
	if (ent->client->pers.inventory[ITEM_INDEX(flag2_item)])  
	gi.centerprintf(ent, "COW TRANSPLANT REVERSING");
	if (ent->client->pers.inventory[ITEM_INDEX(flag1_item)])
	gi.centerprintf(ent, "CHICKEN TRANSPLANT REVERSING");
	gi.sound (ent, CHAN_RELIABLE+CHAN_VOICE, gi.soundindex("player/male/4.wav"), 1, ATTN_NORM, 0);
	}
	//Time to play wav 3
	if (ent->client->numbers == 1000.0)
	{
	if (ent->client->pers.inventory[ITEM_INDEX(flag2_item)])  
	gi.centerprintf(ent, "WARNING !! COW REJECTION ");
	
	if (ent->client->pers.inventory[ITEM_INDEX(flag1_item)])
	gi.centerprintf(ent, "WARNING !! CHICKEN REJECTION ");
		
gi.sound (ent, CHAN_RELIABLE+CHAN_VOICE, gi.soundindex("player/male/3.wav"), 1, ATTN_NORM, 0);		

	}
	//Time to play wav 2
	if (ent->client->numbers == 1300.0)
	{
	if (ent->client->pers.inventory[ITEM_INDEX(flag2_item)])  
	gi.centerprintf(ent, "COW REJECTION PROCESS BEGINING");
		gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_LOGOUT);
	gi.multicast (ent->s.origin, MULTICAST_PVS);
	if (ent->client->pers.inventory[ITEM_INDEX(flag1_item)])
	gi.centerprintf(ent, "CHICKEN REJECTION PROCESS BEGINING");
		gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_LOGOUT);
	gi.multicast (ent->s.origin, MULTICAST_PVS);
gi.sound (ent, CHAN_RELIABLE+CHAN_VOICE, gi.soundindex("player/male/2.wav"), 1, ATTN_NORM, 0);		

	}
	//Time to play wav 1
	if (ent->client->numbers > 1450.0 && ent->client->numbers < 1470.0)
	{
	if (ent->client->pers.inventory[ITEM_INDEX(flag2_item)])  
	gi.centerprintf(ent, "COW REJECTION COMPLETE!!");
		gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_LOGOUT);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	if (ent->client->pers.inventory[ITEM_INDEX(flag1_item)])
	gi.centerprintf(ent, "CHICKEN REJECTION COMPLETE!!");
		gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_LOGOUT);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

gi.sound (ent, CHAN_RELIABLE+CHAN_VOICE, gi.soundindex("player/male/1.wav"), 1, ATTN_NORM, 0);		

	}
		//Time to play wav 1
	if (ent->client->numbers == 1600.0)
	{
		gi.centerprintf(ent, "                                       ");
			if(ent->client->pers.inventory[ITEM_INDEX(flag1_item)]){
			CTFDeadDropFlag(ent);
				gi.centerprintf(ent, "YOU'VE LOST THE CHICKEN!!");
					gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_LOGOUT);
	gi.multicast (ent->s.origin, MULTICAST_PVS);
			CTFResetFlag(CTF_TEAM1);}
		if(ent->client->pers.inventory[ITEM_INDEX(flag2_item)]){
			CTFDeadDropFlag(ent);
				gi.centerprintf(ent, "YOU'VE LOST THE COW!!");
					gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_LOGOUT);
	gi.multicast (ent->s.origin, MULTICAST_PVS);
			CTFResetFlag(CTF_TEAM2);}
	gi.sound (ent, CHAN_RELIABLE+CHAN_VOICE, gi.soundindex("player/male/homelock.wav"), 1, ATTN_NORM, 0);

		client->ps.pmove.gravity = sv_gravity->value;
		ent->client->number2 = 2;
		userinfo=ent->client->pers.userinfo;
		ClientUserinfoChanged (ent, userinfo);
		ent->client->oncebaby=0;
		Cmd_Homingon_f (ent);
		Cmd_take_f(ent);
		Cmd_Give2_f(ent);
		tech = FindItemByClassname("item_tech3");
		ent->client->pers.inventory[ITEM_INDEX(tech)]=0;}

	
	
	} else {
	
	ent->client->numbers=0;
	}

}

//	ent->viewheight = 22;
//	ent->mass = 200;

	  
	
	pm.s = client->ps.pmove;

	for (i=0 ; i<3 ; i++)
	{
		pm.s.origin[i] = ent->s.origin[i]*8;
		pm.s.velocity[i] = ent->velocity[i]*8;
	}

	if (memcmp(&client->old_pmove, &pm.s, sizeof(pm.s)))
	{
		pm.snapinitial = true;
//		gi.dprintf ("pmove changed!\n");
	}

	pm.cmd = *ucmd;

	pm.trace = PM_trace;	// adds default parms
	pm.pointcontents = gi.pointcontents;

	// perform a pmove
	gi.Pmove (&pm);

	// save results of pmove
	client->ps.pmove = pm.s;
	client->old_pmove = pm.s;

	for (i=0 ; i<3 ; i++)
	{
		ent->s.origin[i] = pm.s.origin[i]*0.125;
		ent->velocity[i] = pm.s.velocity[i]*0.125;
	}

	VectorCopy (pm.mins, ent->mins);
	VectorCopy (pm.maxs, ent->maxs);

	client->resp.cmd_angles[0] = SHORT2ANGLE(ucmd->angles[0]);
	client->resp.cmd_angles[1] = SHORT2ANGLE(ucmd->angles[1]);
	client->resp.cmd_angles[2] = SHORT2ANGLE(ucmd->angles[2]);
	
	   if ((pm.cmd.upmove >= 10) && (pm.waterlevel == 0) &&( (ent->client->pers.inventory[ITEM_INDEX(flag2_item)]||ent->client->pers.inventory[ITEM_INDEX(flag1_item)])))
	{
//		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/grapple/grreset.wav"), 1, ATTN_NORM, 0);
//	gi.sound (self->owner, CHAN_RELIABLE+CHAN_WEAPON, gi.soundindex("weapons/grapple/grpull.wav"),1,  ATTN_NORM, 0);
//		PlayerNoise(ent, ent->s.origin, PNOISE_SELF);
	
		ApplyThrust (ent);
			if (ent->client->pers.inventory[ITEM_INDEX(flag1_item)]) 
				
		it = FindItem("Power Shield");
		if(chooser<10){
			
		chooser=1+chooser;}
		else{
	
			
			chooser=0;}
	   }
//		client->ps.pmove.gravity = sv_gravity->value*0.03;
	
  
	  else if (ent->groundentity && !pm.groundentity && (pm.cmd.upmove >= 10) && (pm.waterlevel == 0))
	{
		gi.sound(ent, CHAN_VOICE, gi.soundindex("*jump1.wav"), 1, ATTN_NORM, 0);
		PlayerNoise(ent, ent->s.origin, PNOISE_SELF);

//
	}


	ent->viewheight = pm.viewheight;
	ent->waterlevel = pm.waterlevel;
	ent->watertype = pm.watertype;
	ent->groundentity = pm.groundentity;
	if (pm.groundentity)
		ent->groundentity_linkcount = pm.groundentity->linkcount;

	if (ent->deadflag)
	{
		client->ps.viewangles[ROLL] = 40;
		client->ps.viewangles[PITCH] = -15;
		client->ps.viewangles[YAW] = client->killer_yaw;
	}
	else
	{
		VectorCopy (pm.viewangles, client->v_angle);
		VectorCopy (pm.viewangles, client->ps.viewangles);
	}

//ZOID
	if (client->ctf_grapple)
		CTFGrapplePull(client->ctf_grapple);
//ZOID

	gi.linkentity (ent);

	if (ent->movetype != MOVETYPE_NOCLIP)
		G_TouchTriggers (ent);

	// touch other objects
	for (i=0 ; i<pm.numtouch ; i++)
	{
		other = pm.touchents[i];
		for (j=0 ; j<i ; j++)
			if (pm.touchents[j] == other)
				break;
		if (j != i)
			continue;	// duplicated
		if (!other->touch)
			continue;
		other->touch (other, ent, NULL, NULL);
	}


	client->oldbuttons = client->buttons;
	client->buttons = ucmd->buttons;
	client->latched_buttons |= client->buttons & ~client->oldbuttons;

	// save light level the player is standing on for
	// monster sighting AI
	ent->light_level = ucmd->lightlevel;

	// fire weapon from final position if needed
	if (client->latched_buttons & BUTTON_ATTACK
//ZOID
		&& ent->movetype != MOVETYPE_NOCLIP
//ZOID
		)
	{
		if (!client->weapon_thunk)
		{
			client->weapon_thunk = true;
			Think_Weapon (ent);
		}
	}

//ZOID
//regen tech
	CTFApplyRegeneration(ent);
//ZOID

//ZOID
	for (i = 1; i <= maxclients->value; i++) {
		other = g_edicts + i;
		if (other->inuse && other->client->chase_target == ent)
			UpdateChaseCam(other);


	}
//ZOID
}


/*
==============
ClientBeginServerFrame

This will be called once for each server frame, before running
any other entities in the world.
==============
*/
void ClientBeginServerFrame (edict_t *ent)
{
	gclient_t	*client;
	int			buttonMask;

	if (level.intermissiontime)
		return;

	client = ent->client;

	// run weapon animations if it hasn't been done by a ucmd_t
	if (!client->weapon_thunk
//ZOID
		&& ent->movetype != MOVETYPE_NOCLIP
//ZOID
		)
		Think_Weapon (ent);
	else
		client->weapon_thunk = false;

	if (ent->deadflag)
	{
		// wait for any button just going down
		if ( level.time > client->respawn_time)
		{
			// in deathmatch, only wait for attack button
			if (deathmatch->value)
				buttonMask = BUTTON_ATTACK;
			else
				buttonMask = -1;

			if ( ( client->latched_buttons & buttonMask ) ||
				(deathmatch->value && ((int)dmflags->value & DF_FORCE_RESPAWN) ) )
			{	
			
				respawn(ent);
				client->latched_buttons = 0;
			
			}
		}
		return;
	}

	// add player trail so monsters can follow
	if (!deathmatch->value)
		if (!visible (ent, PlayerTrail_LastSpot() ) )
			PlayerTrail_Add (ent->s.old_origin);

	client->latched_buttons = 0;
}


/*
void PWteam1(edict_t *ent, pmenu_t *p)
{		if((stricmp(level.mapname, "ra2map1") == 0)||(stricmp(level.mapname, "ra2kxg") == 0))
	{
	
		PWctf(ent);
ent->client->gamestatus=2;
ent->client->puplayingstatus =0;
ent->client->puteamstatus =0;
gi.sound (ent, CHAN_AUTO, gi.soundindex("items/ohboy.wav"), 1, ATTN_NORM, 0);

	}else{
		gi.cprintf(ent, PRINT_HIGH, "NOT AVAILABLE ON THIS MAP!!");
		gi.sound (ent, CHAN_AUTO, gi.soundindex("player/fry.wav"), 1, ATTN_NORM, 0);
	
	}
	if(!(ent->deadflag))
	tiecounter=tiecounter-1;
}*/
void PWteam2(edict_t *ent, pmenu_t *p)
{		if(((stricmp(level.mapname, "ra2map1") == 0)||(stricmp(level.mapname, "ra2kxg") == 0)))
	{

	PWctf(ent);
ent->client->gamestatus=2;
ent->client->puplayingstatus =0;
ent->client->puteamstatus =0;
	gi.sound (ent, CHAN_AUTO, gi.soundindex("items/killcow.wav"), 1, ATTN_NORM, 0);
	
		}else{
		gi.cprintf(ent, PRINT_HIGH, "NOT AVAILABLE ON THIS MAP!!");
		gi.sound (ent, CHAN_AUTO, gi.soundindex("player/fry.wav"), 1, ATTN_NORM, 0);
	
	}
	
}

void killother(edict_t *other)
{		
	other->client->killprot=1;
	killall=1;
	stopmultiplestarts=0;
	gamestart=1;
	numbys==0;
			
}

void CTFAssignSkin1a(edict_t *ent)
{
	int playernum = ent-g_edicts-1;
	char *s;

	s = "battroid/fokker";
	ent->client->STORED=s;
	gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s", ent->client->pers.netname, s) );

	

}
void CTFAssignSkin1b(edict_t *ent)
{
	int playernum = ent-g_edicts-1;
	char *s;

	s = "grimlock/grimlock";
	ent->client->STORED=s;
	gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s", ent->client->pers.netname, s) );

	

}

void CTFAssignSkin1c(edict_t *ent)
{
	int playernum = ent-g_edicts-1;
	char *s;

	s = "tank/jeep1";
	ent->client->STORED=s;
	gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s", ent->client->pers.netname, s) );

	

}

void CTFAssignSkin1d(edict_t *ent)
{
	int playernum = ent-g_edicts-1;
	char *s;

	s = "optimus/optimus";
	ent->client->STORED=s;
	gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s", ent->client->pers.netname, s) );

	

}

void CTFAssignSkin1e(edict_t *ent)
{
	int playernum = ent-g_edicts-1;
	char *s;

	s = "rhino/rhino";
	ent->client->STORED=s;
	gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s", ent->client->pers.netname, s) );

	

}

void CTFAssignSkin1f(edict_t *ent)
{
	int playernum = ent-g_edicts-1;
	char *s;

	s = "valkyrie/vf1s_max";
	ent->client->STORED=s;
	gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s", ent->client->pers.netname, s) );

	

}
void CTFAssignSkin2a(edict_t *ent)
{
	int playernum = ent-g_edicts-1;
	char *s;

	s = "astro/astro";
	ent->client->STORED=s;
	gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s", ent->client->pers.netname, s) );

	

}
void CTFAssignSkin2b(edict_t *ent)
{
	int playernum = ent-g_edicts-1;
	char *s;

	s = "dire/avenger";
	ent->client->STORED=s;
	gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s", ent->client->pers.netname, s) );

	

}
void CTFAssignSkin2c(edict_t *ent)
{
	int playernum = ent-g_edicts-1;
	char *s;

	s = "ichabod/ichabod";
	ent->client->STORED=s;
	gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s", ent->client->pers.netname, s) );

	

}
void CTFAssignSkin2d(edict_t *ent)
{
	int playernum = ent-g_edicts-1;
	char *s;

	s = "omithomimus/frigid";
	ent->client->STORED=s;
	gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s", ent->client->pers.netname, s) );

	

}
void CTFAssignSkin2e(edict_t *ent)
{
	int playernum = ent-g_edicts-1;
	char *s;

	s = "frei/rei";
	ent->client->STORED=s;
	gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s", ent->client->pers.netname, s) );



}
void CTFAssignSkin2f(edict_t *ent)
{
	int playernum = ent-g_edicts-1;
	char *s;

	s = "yohko/yohko";
	ent->client->STORED=s;
	gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s", ent->client->pers.netname, s) );



}
void GETGAMESTATUS(edict_t *other, int MAKENO)
{
//	gi.bprintf(PRINT_MEDIUM, "MAKENOTEAM is damnwell  %i\n", MAKENOTEAM);
	MAKENO=MAKENOTEAM;

}
void electrocuted(edict_t *ent)
{electrocute=1;
PMenu_Close(ent);}
void spawnoutsided(edict_t *ent)
{spawnoutside=1;
PMenu_Close(ent);}
void blowupd(edict_t *ent)
{blowup=1;
PMenu_Close(ent);}
void kissd(edict_t *ent)
{kiss=1;
PMenu_Close(ent);}

void map1d(edict_t *ent)
{map1=1;
PMenu_Close(ent);}
void map2d(edict_t *ent)
{map2=1;
PMenu_Close(ent);}
void map3d(edict_t *ent)
{map3=1;
PMenu_Close(ent);}


void chickenteam(edict_t *ent, pmenu_t *p)
{
if((ent->client->puplayingstatus ==0 || ent->client->puteamstatus==3)){ 
	if(ent->client->megotnum1==1){
	num1=0;
	ent->client->megotnum1=0;
//	gi.bprintf(PRINT_HIGH, "num1 made 0");
	}
		if(ent->client->megotnum2==1){
	num2=0; 
	ent->client->megotnum2=0;
//	gi.bprintf(PRINT_HIGH, "num2 made 0");
		}
		if (ent->client->playingstatus==4)
			triggy=155;
		PUPICKUPSTART=1;
	
		CTFDeadDropFlag(ent);
		CTFDeadDropTech(ent);

	
	ent->client->teamstatus = 0;
	ent->client->playingstatus =0;
	ent->client->puteamstatus=2;
	chickyjoin(ent);
}else{	
//	gi.cprintf(ent, PRINT_HIGH, "GAME IN PROGRESS!!");
	gi.sound (ent, CHAN_AUTO, gi.soundindex("items/idiot.wav"), 1, ATTN_NORM, 0);
}}

void cowteam(edict_t *ent, pmenu_t *p)
{	
	
if((ent->client->puplayingstatus ==0 || ent->client->puteamstatus==2)){ 
		if(ent->client->megotnum1==1){
	num1=0; 
	ent->client->megotnum1=0;
//		gi.bprintf( PRINT_HIGH,"num1 made 0");
	}
		if(ent->client->megotnum2==1){
	num2=0;
	ent->client->megotnum2=0;
//		gi.bprintf(PRINT_HIGH, "num2 made 0");
		}	
		if (ent->client->playingstatus==4)
		triggy=155;	
		PUPICKUPSTART=1;
		CTFDeadDropFlag(ent);
		CTFDeadDropTech(ent);
	ent->client->teamstatus = 0;
	ent->client->playingstatus =0;
	cowyjoin(ent);
	ent->client->puteamstatus=3;





	}else{		
//	gi.cprintf(ent, PRINT_HIGH, "GAME IN PROGRESS!!");
	gi.sound (ent, CHAN_AUTO, gi.soundindex("items/idiot.wav"), 1, ATTN_NORM, 0);	
}}


void pukillteam(edict_t *ent)
{		
	ent->client->pukillprot=1;
	pukillall=1;
	PUPICKUPSTART=1;
	if (ent->client->letguyscore==1){
		punumbys=0;}
		
}
