#include "g_local.h"
#include "m_player.h"
#include "s_team.h"

void Touch_Item (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
void TossClientWeapon (edict_t *self);
void Use_Weapon (edict_t *ent, gitem_t *item);
void drop_temp_touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
void drop_make_touchable (edict_t *ent);

void spawn_tossed_weapon(edict_t *ent, gitem_t *item)
{
	vec3_t	forward, right, offset;
	edict_t *dropped;

	dropped = G_Spawn();

	dropped->classname = item->classname;
	dropped->item = item;
	dropped->spawnflags = DROPPED_ITEM;
	dropped->s.effects = item->world_model_flags;
	dropped->s.renderfx = RF_GLOW;
	VectorSet (dropped->mins, -15, -15, -15);
	VectorSet (dropped->maxs, 15, 15, 15);
	gi.setmodel (dropped, dropped->item->world_model);
	dropped->solid = SOLID_TRIGGER;
	dropped->movetype = MOVETYPE_BOUNCE;  
	dropped->touch = drop_temp_touch;
	dropped->owner = ent;

	if (ent->client)
	{
		trace_t	trace;

		AngleVectors (ent->client->v_angle, forward, right, NULL);
		VectorSet(offset, 24, 0, -16);
		G_ProjectSource (ent->s.origin, offset, forward, right, dropped->s.origin);
		trace = gi.trace (ent->s.origin, dropped->mins, dropped->maxs,
			dropped->s.origin, ent, CONTENTS_SOLID);
		VectorCopy (trace.endpos, dropped->s.origin);
	}
	else
	{
		AngleVectors (ent->s.angles, forward, right, NULL);
		VectorCopy (ent->s.origin, dropped->s.origin);
	}

	VectorScale (forward, 100, dropped->velocity);
	dropped->velocity[2] = 300;

	dropped->think = drop_make_touchable;
	dropped->nextthink = level.time + 1;

	gi.linkentity (dropped);

};

void spawn_tossed_pack(edict_t *ent, gitem_t *item, int quantity)
{
	vec3_t	forward, right, offset;
	edict_t *dropped;
	gitem_t *pack;

	pack = FindItem("Ammo Pack");

	dropped = G_Spawn();

	dropped->classname = item->classname;
	dropped->item = item;
	// Count is used in the Pickup_Ammo routine
	// if count > 0 then use that
	// otherwise, use the default quantity
	dropped->count = quantity;
	dropped->spawnflags = DROPPED_ITEM;
	dropped->s.effects = pack->world_model_flags;
	dropped->s.renderfx = RF_GLOW;
	VectorSet (dropped->mins, -15, -15, -15);
	VectorSet (dropped->maxs, 15, 15, 15);
	gi.setmodel (dropped, pack->world_model);
	dropped->solid = SOLID_TRIGGER;
	dropped->movetype = MOVETYPE_BOUNCE;  
	dropped->touch = drop_temp_touch;
	dropped->owner = ent;

	if (ent->client)
	{
		trace_t	trace;

		AngleVectors (ent->client->v_angle, forward, right, NULL);
		VectorSet(offset, 24, 0, -16);
		G_ProjectSource (ent->s.origin, offset, forward, right, dropped->s.origin);
		trace = gi.trace (ent->s.origin, dropped->mins, dropped->maxs,
			dropped->s.origin, ent, CONTENTS_SOLID);
		VectorCopy (trace.endpos, dropped->s.origin);
	}
	else
	{
		AngleVectors (ent->s.angles, forward, right, NULL);
		VectorCopy (ent->s.origin, dropped->s.origin);
	}

	VectorScale (forward, 100, dropped->velocity);
	dropped->velocity[2] = 300;

	dropped->think = drop_make_touchable;
	dropped->nextthink = level.time + 1;

	gi.linkentity (dropped);

};

void Toss_Weapon(edict_t *self)
{
	int			current_index;
	gitem_t		*current_weapon;

	if ((int)(dmflags->value) & DF_WEAPONS_STAY)
		return;

	if (!((int)teamplay->value & TEAM_DROP_ITEMS))
	{
		gi.cprintf(self, PRINT_HIGH, "Server doesn't permit dropping items\n");
		return;
	};

	current_weapon = self->client->pers.weapon;
	current_index = ITEM_INDEX(current_weapon);

	if (current_index == ITEM_INDEX(FindItem("Blaster")) ||
		current_index == ITEM_INDEX(FindItem("Hook")))
		return;

	spawn_tossed_weapon(self, current_weapon);
	self->client->pers.inventory[current_index]--;

	Team_ChangeToBestWeapon(self);
};

void Toss_Pack (edict_t *ent)
{
	int		quantity;
	gitem_t	*it;

	if (!((int)teamplay->value & TEAM_DROP_ITEMS))
	{
		gi.cprintf(ent, PRINT_HIGH, "Server doesn't permit dropping items\n");
		return;
	};

	if (!ent->client->ammo_index)
		return;

	it = FindItem(ent->client->pers.weapon->ammo);
	if (!it)
		return;

	if (ent->client->pers.inventory[ent->client->ammo_index] < it->quantity)
		quantity = ent->client->pers.inventory[ent->client->ammo_index];
	else
		quantity = it->quantity;

	spawn_tossed_pack(ent, FindItem(ent->client->pers.weapon->ammo), quantity);

	ent->client->pers.inventory[ent->client->ammo_index] -= quantity;
};
