#include "g_local.h"
#include "s_flag.h"
#include "s_misc.h"
#include "s_rune.h"

int	NUM_TEAMS = 2;

void Killed (edict_t *targ, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
edict_t *SelectFarthestDeathmatchSpawnPoint (void);
edict_t *SelectRandomDeathmatchSpawnPoint (void);
float	PlayersRangeFromSpot (edict_t *spot);

typedef enum {
	CTF_STATE_START,
	CTF_STATE_PLAYING
} ctfstate_t;

team_t	*teams;
char	*default_names[MAX_TEAMS] = {TEAM1_DEFAULT_NAME,
									 TEAM2_DEFAULT_NAME,
									 TEAM3_DEFAULT_NAME,
									 TEAM4_DEFAULT_NAME};
validskin_t teamskins[] = 
	{0,		"player/male",		"male/ctf0",
	 0,		"player/female",	"female/ctf0",
	 1,		"player/male",		"male/ctf1",
	 1,		"player/female",	"female/ctf1",
	 -1,	NULL,				NULL};

/*
void	Team_AssessTeamDeathPenalty(edict_t *targ, edict_t *inflictor, edict_t *attacker, vec3_t point)
{
	if(!((int)teamplay->value & TEAM_DEATH_PENALTY))
		return;
	
	if ((!targ->client) || (!attacker->client))
		return;

	if (targ != attacker)
	{
		// Die if player killed teammate
		player_die (attacker, targ, attacker, 100000, vec3_origin);
		// Add 1 to offset frag penalty
		attacker->client->resp.score += 1;
		Team_AddScoreToTeam(attacker, 1);
	};
};

void	Team_CheckFragPenalty(edict_t *targ, edict_t *attacker)
{
	if (!((int)teamplay->value & TEAM_FRAG_PENALTY))
		return;

	if ((!targ->client) || (!attacker->client))
		return;

	if (targ != attacker)
	{
		// Penalty 1 frag for killing teammate
		attacker->client->resp.score -= 2;
		Team_AddScoreToTeam(attacker, -2);
	};
};

qboolean Team_CanDamageArmor(edict_t *targ, edict_t *attacker)
{
	if ((attacker->client->resp.ctf_team == targ->client->resp.ctf_team) && 
		(attacker != targ) && 
		((int)teamplay->value & TEAM_ARMOR_PROTECT))
		{
			// Armor is protected
			return false;
		}

	return true;
};

qboolean Team_CanDamageHealth(edict_t *targ, edict_t *inflictor, edict_t *attacker, vec3_t dir, vec3_t point, vec3_t normal, int damage, int knockback, int dflags)
{
	if ((attacker->client->resp.ctf_team == targ->client->resp.ctf_team) && 
		(attacker != targ))
	{
		// Attacker and target are on the same team.
		if ((int)teamplay->value & TEAM_ATTACKER_DAMAGE)
		{
			// Damage applied to self.
			T_Damage(attacker, inflictor, attacker, dir, point, normal, damage, knockback, dflags);
		}
		if ((int)teamplay->value & TEAM_HEALTH_PROTECT)
		{
			// Health is protected
			return false;
		}
	}

	return true;
};

int Team_ValidSkinForTeam(char *skin)
{
	int i;

	i = 0;
	while (1)
	{
		if (!teamskins[i].sounddir) break;
		if (!strcmp(skin, teamskins[i].skin))
			return teamskins[i].ctf_team;
		i++;
	};

	return -1;
};

char *Team_NextValidSkin(edict_t *ent)
{
	int i;

	i = 0;
	while (1)
	{
		if (!teamskins[i].sounddir) break;
		if (teamskins[i].ctf_team == ent->client->resp.ctf_team)
			if (!strcmp(ent->client->pers.sounddir, teamskins[i].sounddir))
				return teamskins[i].skin;
		i++;
	};
	return NULL;
};

void Team_AddToTeam(edict_t *ent, int team)
{
	ent->client->resp.ctf_team = team;
	strcpy(ent->client->pers.oldskin, Team_NextValidSkin(ent));
	Info_SetValueForKey(ent->client->pers.userinfo, "skin", ent->client->pers.oldskin);
	teams[team].num_players++;
	// TODO:  Add a player chain function here so we can keep
	// a linked list of players on this team
};

void Team_RemoveFromTeam(edict_t *ent)
{
	Team_AddScoreToTeam(ent, (-1 * ent->client->resp.score));
	ent->client->resp.score = 0;
	teams[ent->client->resp.ctf_team].num_players--;
	// TODO: remove from player chain link
};

qboolean Team_ChangeTeams(edict_t *ent, int newteamnum)
{
	int oldteamcount, newteamcount;

	// This code will check to see if the change will
	// upset game balance.  If, after the move, the new
	// team has 2 more people than the other team then the
	// move is prohibited
	oldteamcount = (teams[ent->client->resp.ctf_team].num_players - 1);
	newteamcount = (teams[newteamnum].num_players + 1);
	if (newteamcount > (oldteamcount + 1))
		return false;

	Team_RemoveFromTeam(ent);

	player_die (ent, NULL, ent, 100000, vec3_origin);

	Team_AddToTeam(ent, newteamnum);

	respawn(ent);

	gi.bprintf(PRINT_HIGH, "%s has joined the %s team\n",
		ent->client->pers.netname,
		Team_TeamName(newteamnum));

	return true;
};

char *Team_ValidateChangedSkin(edict_t *ent, char *newskin)
{
	int team;

	team = Team_ValidSkinForTeam(newskin);

	if (team == TEAM_NO_TEAM_SELECTED)
	{
		gi.cprintf(ent, PRINT_HIGH, "Invalid CTF skin\n");
		return ent->client->pers.oldskin;
	};

	if (team == ent->client->resp.ctf_team)
		// Same team -- different skin
		return newskin;

	if (!((int)teamplay->value & TEAM_STATIC_TEAMS))
	{
		// Not static teams so see if the change will
		// not upset the balance
		if (Team_ChangeTeams(ent, team))
			return newskin;
	};

	// Player tried to switch teams but couldn't.  This is
	// either because static teams is set or because
	// it would upset the balance
	gi.cprintf(ent, PRINT_HIGH, "Cannot switch teams\n");
	return ent->client->pers.oldskin;
};

// This function will check to see which team has more members.
// If both teams have same number of members then it's a 50/50
// shot at which team.
void Team_CheckTeamBalance(edict_t *ent)
{
	int		thisteam;
	float	rnd;

	if (teams[RED_TEAM].num_players < teams[BLUE_TEAM].num_players)
		thisteam = RED_TEAM;
	else if (teams[RED_TEAM].num_players > teams[BLUE_TEAM].num_players)
		thisteam = BLUE_TEAM;
	else {
		rnd = crandom()*4;
		// TODO: For some reason, the rand function isn't
		// returning a random number;
		if (rnd > 2)
			thisteam = RED_TEAM;
		else
			thisteam = BLUE_TEAM;
	};

	Team_AddToTeam(ent, thisteam);
	
	return;
};

*/

static void loc_buildboxpoints(vec3_t p[8], vec3_t org, vec3_t mins, vec3_t maxs)
{
	VectorAdd(org, mins, p[0]);
	VectorCopy(p[0], p[1]);
	p[1][0] -= mins[0];
	VectorCopy(p[0], p[2]);
	p[2][1] -= mins[1];
	VectorCopy(p[0], p[3]);
	p[3][0] -= mins[0];
	p[3][1] -= mins[1];
	VectorAdd(org, maxs, p[4]);
	VectorCopy(p[4], p[5]);
	p[5][0] -= maxs[0];
	VectorCopy(p[0], p[6]);
	p[6][1] -= maxs[1];
	VectorCopy(p[0], p[7]);
	p[7][0] -= maxs[0];
	p[7][1] -= maxs[1];
}

static qboolean loc_CanSee (edict_t *targ, edict_t *inflictor)
{
	trace_t	trace;
	vec3_t	targpoints[8];
	int i;
	vec3_t viewpoint;

// bmodels need special checking because their origin is 0,0,0
	if (targ->movetype == MOVETYPE_PUSH)
		return false; // bmodels not supported

	loc_buildboxpoints(targpoints, targ->s.origin, targ->mins, targ->maxs);
	
	VectorCopy(inflictor->s.origin, viewpoint);
	viewpoint[2] += inflictor->viewheight;

	for (i = 0; i < 8; i++) {
		trace = gi.trace (viewpoint, vec3_origin, vec3_origin, targpoints[i], inflictor, MASK_SOLID);
		if (trace.fraction == 1.0)
			return true;
	}

	return false;
}

/*
================
Team_SelectCTFSpawnPoint

go to a ctf point, but NOT the two points closest
to other players
================
*/
edict_t *Team_SelectCTFSpawnPoint (edict_t *ent)
{
	edict_t	*spot, *spot1, *spot2;
	int		count = 0;
	int		selection;
	float	range, range1, range2;
	char	*cname;

	if (ent->client->resp.ctf_state != CTF_STATE_START)
		if ( (int)(dmflags->value) & DF_SPAWN_FARTHEST)
			return SelectFarthestDeathmatchSpawnPoint ();
		else
			return SelectRandomDeathmatchSpawnPoint ();

	ent->client->resp.ctf_state = CTF_STATE_PLAYING;

	switch (ent->client->resp.ctf_team) {
	case CTF_TEAM1:
		cname = "info_player_team1";
		break;
	case CTF_TEAM2:
		cname = "info_player_team2";
		break;
	default:
		return SelectRandomDeathmatchSpawnPoint();
	}

	spot = NULL;
	range1 = range2 = 99999;
	spot1 = spot2 = NULL;

	while ((spot = G_Find (spot, FOFS(classname), cname)) != NULL)
	{
		count++;
		range = PlayersRangeFromSpot(spot);
		if (range < range1)
		{
			range1 = range;
			spot1 = spot;
		}
		else if (range < range2)
		{
			range2 = range;
			spot2 = spot;
		}
	}

	if (!count)
		return SelectRandomDeathmatchSpawnPoint();

	if (count <= 2)
	{
		spot1 = spot2 = NULL;
	}
	else
		count -= 2;

	selection = rand() % count;

	spot = NULL;
	do
	{
		spot = G_Find (spot, FOFS(classname), cname);
		if (spot == spot1 || spot == spot2)
			selection++;
	} while(selection--);

	return spot;
}

void Team_ChangeToBestWeapon (edict_t *ent)
{
	gitem_t	*weapon;

	weapon = FindItem("railgun");
	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("slugs"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(weapon)] )
	{
		ent->client->newweapon = weapon;
		return;
	};

	weapon = FindItem("hyperblaster");
	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("cells"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(weapon)] )
	{
		ent->client->newweapon = weapon;
		return;
	};

	weapon = FindItem("rocket launcher");
	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("rockets"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(weapon)] )
	{
		ent->client->newweapon = weapon;
		return;
	};

	weapon = FindItem("grenade launcher");
	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("grenades"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(weapon)] )
	{
		ent->client->newweapon = weapon;
		return;
	};

	weapon = FindItem("chaingun");
	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("bullets"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(weapon)] )
	{
		ent->client->newweapon = weapon;
		return;
	};

	weapon = FindItem("machinegun");
	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("bullets"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(weapon)] )
	{
		ent->client->newweapon = weapon;
		return;
	};

	weapon = FindItem("super shotgun");
	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("shells"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(weapon)] )
	{
 		ent->client->newweapon = weapon;
		return;
	};

	weapon = FindItem("shotgun");
	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("shells"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(weapon)] )
	{
		ent->client->newweapon = weapon;
		return;
	};

	ent->client->newweapon = FindItem("Blaster");
	return;
};

void Team_AssignTeam(gclient_t *who)
{
	edict_t		*player;
	int i;
	int team1count = 0, team2count = 0;

	who->resp.ctf_state = CTF_STATE_START;

	// TODO: Uncomment this code when you add spectator support
	//if (!((int)dmflags->value & DF_CTF_FORCEJOIN)) {
	//	who->resp.ctf_team = CTF_NOTEAM;
	//	return;
	//}

	for (i = 1; i <= maxclients->value; i++) {
		player = &g_edicts[i];

		if (!player->inuse || player->client == who)
			continue;

		switch (player->client->resp.ctf_team) {
		case CTF_TEAM1:
			team1count++;
			break;
		case CTF_TEAM2:
			team2count++;
		}
	}
	if (team1count < team2count)
		who->resp.ctf_team = CTF_TEAM1;
	else if (team2count < team1count)
		who->resp.ctf_team = CTF_TEAM2;
	else if (rand() & 1)
		who->resp.ctf_team = CTF_TEAM1;
	else
		who->resp.ctf_team = CTF_TEAM2;
}

void Team_AssignSkin(edict_t *ent, char *s)
{
	int playernum = ent-g_edicts-1;
	char *p;
	char t[64];

	Com_sprintf(t, sizeof(t), "%s", s);

	if ((p = strrchr(t, '/')) != NULL)
		p[1] = 0;
	else
		strcpy(t, "male/");

	switch (ent->client->resp.ctf_team) {
	case CTF_TEAM1:
		gi.configstring (CS_PLAYERSKINS+playernum, 
			va("%s\\%s%s", ent->client->pers.netname, t, CTF_TEAM1_SKIN) );
		break;
	case CTF_TEAM2:
		gi.configstring (CS_PLAYERSKINS+playernum,
			va("%s\\%s%s", ent->client->pers.netname, t, CTF_TEAM2_SKIN) );
		break;
	default:
		gi.configstring (CS_PLAYERSKINS+playernum, 
			va("%s\\%s", ent->client->pers.netname, s) );
		break;
	}
//	gi.cprintf(ent, PRINT_HIGH, "You have been assigned to %s team.\n", ent->client->pers.netname);
}

char	*Team_TeamName(int num)
{
	return teams[num].name;
};

int		Team_TeamScore(int num)
{
	int i;
	edict_t *player;
	int team_score = 0;

	for (i = 1; i <= maxclients->value; i++) {
		player = &g_edicts[i];

		if (!player->inuse || player->client->resp.ctf_team != num)
			continue;

		team_score += player->client->resp.score;
	}
	return team_score;
};

int		Team_NumPlayers(int num)
{
	int i;
	edict_t *player;
	int num_players = 0;

	for (i = 1; i <= maxclients->value; i++) {
		player = &g_edicts[i];

		if (!player->inuse || player->client->resp.ctf_team != num)
			continue;

		num_players++;
	}
	return num_players;
};

void	Team_InitTeams()
{
	int i;

	teams = gi.TagMalloc(NUM_TEAMS * sizeof(teams[0]), TAG_GAME);

	for (i=0; i < NUM_TEAMS; i++)
	{
		strcpy(teams[i].name, default_names[i]);
		teams[i].num_players = 0;
		teams[i].player = NULL;
		teams[i].score = 0;
	};
};

void Team_CmdChangeTeam (edict_t *ent)
{
	char *t, *s;
	int desired_team;

	t = gi.args();
	if (!*t) {
		gi.cprintf(ent, PRINT_HIGH, "You are on the %s team.\n",
			Team_TeamName(ent->client->resp.ctf_team));
		return;
	}
	if (Q_stricmp(t, "red") == 0)
		desired_team = CTF_TEAM1;
	else if (Q_stricmp(t, "blue") == 0)
		desired_team = CTF_TEAM2;
	else {
		gi.cprintf(ent, PRINT_HIGH, "Unknown team %s.\n", t);
		return;
	}

	if (ent->client->resp.ctf_team == desired_team) {
		gi.cprintf(ent, PRINT_HIGH, "You are already on the %s team.\n",
			Team_TeamName(ent->client->resp.ctf_team));
		return;
	}
////
	// This will let 5 on 4 become 4 on 5 but not vice versa
	if ((Team_NumPlayers(desired_team) + 1) > Team_NumPlayers(ent->client->resp.ctf_team))
	{
		gi.cprintf(ent, PRINT_HIGH, "You cannot switch teams\n");
		return;
	}
////
	ent->svflags = 0;
	ent->flags &= ~FL_GODMODE;
	ent->client->resp.ctf_team = desired_team;
	ent->client->resp.ctf_state = CTF_STATE_START;
	s = Info_ValueForKey (ent->client->pers.userinfo, "skin");
	Team_AssignSkin(ent, s);

	if (ent->solid == SOLID_NOT) { // spectator
		PutClientInServer (ent);
		// add a teleportation effect
		ent->s.event = EV_PLAYER_TELEPORT;
		// hold in place briefly
		ent->client->ps.pmove.pm_flags = PMF_TIME_TELEPORT;
		ent->client->ps.pmove.pm_time = 14;
		gi.bprintf(PRINT_HIGH, "%s joined the %s team.\n",
			ent->client->pers.netname, Team_TeamName(desired_team));
		return;
	}

	ent->health = 0;
	player_die (ent, ent, ent, 100000, vec3_origin);
	// don't even bother waiting for death frames
	ent->deadflag = DEAD_DEAD;
	respawn (ent);

	ent->client->resp.score = 0;

	gi.bprintf(PRINT_HIGH, "%s changed to the %s team.\n",
		ent->client->pers.netname, Team_TeamName(desired_team));
}

void Team_FragBonuses(edict_t *targ, edict_t *inflictor, edict_t *attacker)
{
	int i;
	edict_t *ent;
	int team;
	gitem_t *targ_flag,			*attacker_flag;
	int		 targ_flag_index,	 attacker_flag_index;
	edict_t *flag, *carrier;
	char *c;
	vec3_t v1, v2;

	// no bonus for fragging yourself
	if (!targ->client || !attacker->client || targ == attacker)
		return;

	team = targ->client->resp.ctf_team;
	if (team < 0)
		return; // whoever died isn't on a team

	if (team == CTF_TEAM1)
	{
		targ_flag = item_flag1;
		targ_flag_index = ITEM_INDEX(item_flag1);
		attacker_flag = item_flag2;
		attacker_flag_index = ITEM_INDEX(item_flag2);
	}
	else if (team == CTF_TEAM2)
	{
		targ_flag = item_flag2;
		targ_flag_index = ITEM_INDEX(item_flag2);
		attacker_flag = item_flag1;
		attacker_flag_index = ITEM_INDEX(item_flag1);
	}
	else
		gi.dprintf("Assigning frag bonus, error determining team\n");

	// did the attacker frag the flag carrier?
	if (targ->client->pers.inventory[attacker_flag_index]) {
		attacker->client->resp.ctf_lastfraggedcarrier = level.time;
		attacker->client->resp.score += TEAM_FRAG_CARRIER_BONUS;
		gi.cprintf(attacker, PRINT_MEDIUM, "BONUS: %d points for fragging enemy flag carrier.\n",
			TEAM_FRAG_CARRIER_BONUS);

		// the the target had the flag, clear the hurt carrier
		// field on the other team
		for (i = 1; i <= maxclients->value; i++) {
			ent = g_edicts + i;
			if (ent->inuse && ent->client->resp.ctf_team == team)
				ent->client->resp.ctf_lasthurtcarrier = 0;
		}
		return;
	}

	if (targ->client->resp.ctf_lasthurtcarrier &&
		level.time - targ->client->resp.ctf_lasthurtcarrier < TEAM_CARRIER_DANGER_PROTECT_TIMEOUT &&
		!attacker->client->pers.inventory[targ_flag_index]) {
		// attacker is on the same team as the flag carrier and
		// fragged a guy who hurt our flag carrier
		attacker->client->resp.score += TEAM_CARRIER_DANGER_PROTECT_BONUS;
		gi.bprintf(PRINT_MEDIUM, "%s defends %s's flag carrier against an agressive enemy\n",
			attacker->client->pers.netname, 
			Team_TeamName(attacker->client->resp.ctf_team));
		return;
	}

	// flag and flag carrier area defense bonuses

	// we have to find the flag and carrier entities

	// find the flag
	switch (attacker->client->resp.ctf_team) {
	case CTF_TEAM1:
		c = "item_flag_team1";
		break;
	case CTF_TEAM2:
		c = "item_flag_team2";
		break;
	default:
		return;
	}

	flag = NULL;
	while ((flag = G_Find (flag, FOFS(classname), c)) != NULL) {
		if (!(flag->spawnflags & DROPPED_ITEM))
			break;
	}

	if (!flag)
		return; // can't find attacker's flag

	// find attacker's team's flag carrier
	for (i = 1; i <= maxclients->value; i++) {
		carrier = g_edicts + i;
		if (carrier->inuse && 
			carrier->client->pers.inventory[attacker_flag_index])
			break;
		carrier = NULL;
	}

	// ok we have the attackers flag and a pointer to the carrier

	// check to see if we are defending the base's flag
	VectorSubtract(targ->s.origin, flag->s.origin, v1);
	VectorSubtract(attacker->s.origin, flag->s.origin, v2);

	if (VectorLength(v1) < TEAM_TARGET_PROTECT_RADIUS ||
		VectorLength(v2) < TEAM_TARGET_PROTECT_RADIUS ||
		loc_CanSee(flag, targ) || loc_CanSee(flag, attacker)) {
		// we defended the base flag
		attacker->client->resp.score += TEAM_FLAG_DEFENSE_BONUS;
		if (flag->solid == SOLID_NOT)
			gi.bprintf(PRINT_MEDIUM, "%s defends the %s base.\n",
				attacker->client->pers.netname, 
				Team_TeamName(attacker->client->resp.ctf_team));
		else
			gi.bprintf(PRINT_MEDIUM, "%s defends the %s flag.\n",
				attacker->client->pers.netname, 
				Team_TeamName(attacker->client->resp.ctf_team));
		return;
	}

	if (carrier && carrier != attacker) {
		VectorSubtract(targ->s.origin, carrier->s.origin, v1);
		VectorSubtract(attacker->s.origin, carrier->s.origin, v1);

		if (VectorLength(v1) < TEAM_ATTACKER_PROTECT_RADIUS ||
			VectorLength(v2) < TEAM_ATTACKER_PROTECT_RADIUS ||
			loc_CanSee(carrier, targ) || loc_CanSee(carrier, attacker)) {
			attacker->client->resp.score += TEAM_CARRIER_PROTECT_BONUS;
			gi.bprintf(PRINT_MEDIUM, "%s defends the %s team's flag carrier.\n",
				attacker->client->pers.netname, 
				Team_TeamName(attacker->client->resp.ctf_team));
			return;
		}
	}
}

qboolean Team_StartClient(edict_t *ent)
{
	if (ent->client->resp.ctf_team != CTF_NOTEAM)
		return false;

	// TODO:
	/*
	if (!((int)dmflags->value & DF_CTF_FORCEJOIN)) {
		// start as 'observer'
		ent->movetype = MOVETYPE_NOCLIP;
		ent->solid = SOLID_NOT;
		ent->svflags |= SVF_NOCLIENT;
		ent->client->resp.ctf_team = CTF_NOTEAM;
		ent->client->ps.gunindex = 0;
		gi.linkentity (ent);

		CTFOpenJoinMenu(ent);
		return true;
	}
	*/
	return false;
}
