#include "g_local.h"
#include "s_team.h"
#include "s_rune.h"
#include "s_flag.h"

#define STAT_TOP_TEAM_ICON		22
#define STAT_TOP_TEAM_SCORE		23
#define STAT_TOP_TEAM_JOINED	24
#define STAT_BOTTOM_TEAM_ICON	25
#define STAT_BOTTOM_TEAM_SCORE	26
#define STAT_BOTTOM_TEAM_JOINED	27
#define STAT_RUNE_CARRIED		28
#define STAT_FLAG_CARRIED		29

char *ctf_statusbar =
"yb	-24 "

// health
"xv	0 "
"hnum "
"xv	50 "
"pic 0 "

// ammo
"if 2 "
"	xv	100 "
"	anum "
"	xv	150 "
"	pic 2 "
"endif "

// armor
"if 4 "
"	xv	200 "
"	rnum "
"	xv	250 "
"	pic 4 "
"endif "

// selected item
"if 6 "
"	xv	296 "
"	pic 6 "
"endif "

"yb	-50 "

// picked up item
"if 7 "
"	xv	0 "
"	pic 7 "
"	xv	26 "
"	yb	-42 "
"	stat_string 8 "
"	yb	-50 "
"endif "

// timer
"if 9 "
"	xv	246 "
"	num	2	10 "
"	xv	296 "
"	pic	9 "
"endif "

//  help / weapon icon 
"if 11 "
"	xv	148 "
"	pic	11 "
"endif "

// Show Team Scores

// Top Team Score
"yb -144 "
"xr -78 "
"num 3 23 "

// Top Team Joined underlay
"if 24 "
  "yb -145 "
  "xr -26 "
  "pic 24 "
"endif "

// Top Team Icon
"yb -144 "
"xr -25 "
"pic 22 "

// Bottom Team Score
"yb -119 "
"xr -78 "
"num 3 26 "

// Bottom Team Joined underlay
"if 27 "
  "yb -120 "
  "xr -26 "
  "pic 27 "
"endif "

// Bottom Team Icon
"yb -119 "
"xr -25 "
"pic 25 "

// rune
"if 28 "
"	yb	-24 "
"	xv	274 "
"	pic 28 "
"endif "

//  frags
"xr	-50 "
"yt 2 "
"num 3 14 "

// have flag graph
"if 29 "
  "yt 26 "
  "xr -24 "
  "pic 29 "
"endif "

;

void StatusBar_CTF (edict_t *ent)
{
	int	top_team, bottom_team;
	int	top_team_icon, bottom_team_icon;
	int top_team_score, bottom_team_score;
	int	team1_score, team2_score;

	team1_score = Team_TeamScore(CTF_TEAM1);
	team2_score = Team_TeamScore(CTF_TEAM2);

	if (team2_score < team1_score)
	{
		top_team = CTF_TEAM1;
		top_team_icon = Flag_WhichIcon(CTF_TEAM1);
		top_team_score = team1_score;
		bottom_team = CTF_TEAM2;
		bottom_team_icon = Flag_WhichIcon(CTF_TEAM2);
		bottom_team_score = team2_score;
	}
	else
	{
		top_team = CTF_TEAM2;
		top_team_icon = Flag_WhichIcon(CTF_TEAM2);
		top_team_score = team2_score;
		bottom_team = CTF_TEAM1;
		bottom_team_icon = Flag_WhichIcon(CTF_TEAM1);
		bottom_team_score = team1_score;
	};

	ent->client->ps.stats[STAT_FLAG_CARRIED] = 0;
	if (ent->client->resp.ctf_team == CTF_TEAM1 &&
		ent->client->pers.inventory[ITEM_INDEX(item_flag2)] &&
		(level.framenum & 8))
		ent->client->ps.stats[STAT_FLAG_CARRIED] = gi.imageindex ("i_ctf1");

	else if (ent->client->resp.ctf_team == CTF_TEAM2 &&
		ent->client->pers.inventory[ITEM_INDEX(item_flag1)] &&
		(level.framenum & 8))
		ent->client->ps.stats[STAT_FLAG_CARRIED] = gi.imageindex ("i_ctf0");

	//
	// Team Scores
	//
	ent->client->ps.stats[STAT_TOP_TEAM_ICON] = top_team_icon;
	ent->client->ps.stats[STAT_TOP_TEAM_SCORE] = top_team_score;
	ent->client->ps.stats[STAT_TOP_TEAM_JOINED] = ((ent->client->resp.ctf_team == top_team) ? gi.imageindex("i_teamj") : 0);
	ent->client->ps.stats[STAT_BOTTOM_TEAM_ICON] = bottom_team_icon;
	ent->client->ps.stats[STAT_BOTTOM_TEAM_SCORE] = bottom_team_score;
	ent->client->ps.stats[STAT_BOTTOM_TEAM_JOINED] = ((ent->client->resp.ctf_team == bottom_team) ? gi.imageindex("i_teamj") : 0);
	//
	// Indicate carried rune
	//
	if (ent->flags & FL_PLAYER_RUNE_MASK)
	{
		gitem_t *rune;
		rune = Rune_WhichCarried(ent);
		ent->client->ps.stats[STAT_RUNE_CARRIED] = gi.imageindex(rune->icon);
	}
	else
		ent->client->ps.stats[STAT_RUNE_CARRIED] = 0;
};

/*
==================
CTFScoreboardMessage
==================
*/
void CTFScoreboardMessage (edict_t *ent, edict_t *killer)
{
	char	entry[1024];
	char	string[1400];
	int		len;
	int		i, j, k, n;
	int		sorted[MAX_CLIENTS];
	int		sortedscores[MAX_CLIENTS];
	int		score, total;
	int		totalping[2], bestping[2], worstping[2], thisping;
	int		team1plcount, team2plcount;
	int		last;
	gclient_t	*cl;
	edict_t		*cl_ent;
	int team;
	int maxsize = 1000;

	// sort the clients by team and score
	total = 0;
	last = 0;
	totalping[CTF_TEAM1] = totalping[CTF_TEAM2] = 0;
	bestping[CTF_TEAM1] = bestping[CTF_TEAM2] = 999;
	worstping[CTF_TEAM1] = worstping[CTF_TEAM2] = 0;
	team1plcount = Team_NumPlayers(CTF_TEAM1);
	team2plcount = Team_NumPlayers(CTF_TEAM2);
	
	for (i=0 ; i<game.maxclients ; i++)
	{
		cl_ent = g_edicts + 1 + i;
		if (!cl_ent->inuse)
			continue;
		
		cl = &game.clients[i];
		team = game.clients[i].resp.ctf_team;
		score = game.clients[i].resp.score;
		thisping = (cl->ping > 999 ? 999 : cl->ping);

		// This finds out where the player falls in
		// the list
		for (j=0 ; j<i ; j++)
		{
			if (score > sortedscores[j])
				break;
		}
		// This moves all scores from that point
		// down a level
		for (k=total ; k>j ; k--)
		{
			sortedscores[k] = sortedscores[k-1];
			sorted[k] = sorted[k-1];
		}
		sorted[j] = i;
		sortedscores[j] = score;
		total++;
		totalping[team] += thisping;
		if (thisping < bestping[team]) bestping[team] = thisping;
		if (thisping > worstping[team]) worstping[team] = thisping;
	}

	// print level name and exit rules
	// add the clients in sorted order
	*string = 0;
	len = 0;

	// team one
	sprintf(string, "xv 35 yv 0 picn ranking "
		"xv 35 yv 41 string \"%3d/%3d/%3d\" "
		"xv 151 yv 40 picn i_ctf0sm "
		"xv 190 yv 41 string \"%3d\" "
		"xv 235 yv 41 string \"%3d\" "
		"xv 35 yv 51 string \"%3d/%3d/%3d\" "
		"xv 151 yv 50 picn i_ctf1sm "
		"xv 190 yv 51 string \"%3d\" "
		"xv 235 yv 51 string \"%3d\" ",
		bestping[0], (team1plcount > 0 ? (totalping[0] / team1plcount) : 0), worstping[0], Team_TeamScore(0), Team_NumPlayers(0),
		bestping[1], (team2plcount > 0 ? (totalping[1] / team2plcount) : 0), worstping[1], Team_TeamScore(1), Team_NumPlayers(1));
	len = strlen(string);

	for (i=0 ; i<16 ; i++)
	{
		if (i >= total)
			break; // we're done

		*entry = 0;

		cl = &game.clients[sorted[i]];
		cl_ent = g_edicts + 1 + sorted[i];

		sprintf(entry+strlen(entry),
			"ctf 80 %d %d %d %d xv 136 yv %d picn i_ctf%dsm ",
			63 + i * 10,
			sorted[i],
			cl->ping > 999 ? 999 : cl->ping,
			cl->resp.score,
			62 + i * 10,
			cl->resp.ctf_team);
		
		// TODO
		//if (cl_ent->client->pers.inventory[ITEM_INDEX(flag2_item)])
		//	sprintf(entry + strlen(entry), "xv 56 yv %d picn sbfctf2 ",
		//		42 + i * 8);

		if (maxsize - len > strlen(entry)) {
			strcat(string, entry);
			len = strlen(string);
			last = i;
		}
		
	}

	// put in spectators if we have enough room
	j = (last + 2) * 10 + 62;

	k = n = 0;
	if (maxsize - len > 50) {
		for (i = 0; i < maxclients->value; i++) {
			cl_ent = g_edicts + 1 + i;
			cl = &game.clients[i];
			if (!cl_ent->inuse ||
				cl_ent->solid != SOLID_NOT ||
				cl_ent->client->resp.ctf_team != CTF_NOTEAM)
				continue;

			if (!k) {
				k = 1;
				sprintf(entry, "xv 0 yv %d string2 \"Spectators\" ", j);
				strcat(string, entry);
				len = strlen(string);
				j += 8;
			}

			sprintf(entry+strlen(entry),
				"ctf %d %d %d %d %d ",
				(n & 1) ? 160 : 0, // x
				j, // y
				i, // playernum
				cl->resp.score,
				cl->ping > 999 ? 999 : cl->ping);
			if (maxsize - len > strlen(entry)) {
				strcat(string, entry);
				len = strlen(string);
			}
			
			if (n & 1)
				j += 8;
			n++;
		}
	}

	if ((total - last) > 1) // couldn't fit everyone
		sprintf(string + strlen(string), "xv 8 yv %d string \"..and %d more\" ",
			62 + (last+1)*8, total - last - 1);
	
	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}
