#include "g_local.h"

static char *rnames[] = {
	"item_rune_strength", 
	"item_rune_haste", 
	"item_rune_regen", 
	"item_rune_resist",
	NULL
};

extern gitem_armor_t jacketarmor_info;
extern gitem_armor_t combatarmor_info;
extern gitem_armor_t bodyarmor_info;

edict_t *SelectRandomDeathmatchSpawnPoint (void);
void Rune_Respawn (edict_t *self);

qboolean	runes_spawned;

void Rune_StrengthSound(edict_t *ent)
{
	float volume = 1.0;

	if (ent->client && ent->client->silencer_shots)
		volume = 0.2;

	if (ent->client->rune_last_sound_time < level.time)
	{
		ent->client->rune_last_sound_time = level.time + 1;
		if (ent->client->quad_framenum > level.framenum)
			gi.sound(ent, CHAN_VOICE, gi.soundindex("rune/strquad.wav"), volume, ATTN_NORM, 0);
		else
			gi.sound(ent, CHAN_VOICE, gi.soundindex("rune/strength.wav"), volume, ATTN_NORM, 0);
	}
};

void Rune_ResistSound(edict_t *ent)
{
	float volume = 1.0;

	if (ent->client && ent->client->silencer_shots)
		volume = 0.2;

   	gi.sound(ent, CHAN_VOICE, gi.soundindex("rune/resist.wav"), volume, ATTN_NORM, 0);
};

void Rune_HasteSound (edict_t *ent)
{
	float volume = 1.0;

	if (ent->client && ent->client->silencer_shots)
		volume = 0.2;

	if (ent->client->rune_last_sound_time < level.time)
	{
		ent->client->rune_last_sound_time = level.time + 1;
		gi.sound(ent, CHAN_VOICE, gi.soundindex("rune/haste.wav"), volume, ATTN_NORM, 0);
	}
}

/*
void Rune_Respawn (edict_t *self)
{
	edict_t *rune_spawn_point;

	gi.unlinkentity(self);

	rune_spawn_point = SelectRandomDeathmatchSpawnPoint();
	Do_DropRune(self->item, rune_spawn_point);
	
	G_FreeEdict(self);
};
*/

void Rune_Regen(edict_t *ent)
{
	int				index;
	qboolean		noise = false;
	float			volume = 1.0;
	gclient_t		*client;

	client = ent->client;
	if (!client)
		return;

	if (ent->client->silencer_shots)
		volume = 0.2;

	if (ent->client->regen_time < level.time)
	{
		ent->client->regen_time = level.time;
		if (ent->health < 150)
		{
			ent->health += 5;
			if (ent->health > 150)
				ent->health = 150;
			ent->client->regen_time += 0.5;
			noise = true;
		};
		index = ArmorIndex (ent);
		if (index && client->pers.inventory[index] < 150) {
				client->pers.inventory[index] += 5;
				if (client->pers.inventory[index] > 150)
					client->pers.inventory[index] = 150;
				client->regen_time += 0.5;
				noise = true;
		}
		if (noise && ent->client->rune_last_sound_time < level.time) {
			ent->client->rune_last_sound_time = level.time + 1;
			gi.sound(ent, CHAN_VOICE, gi.soundindex("rune/regen.wav"), volume, ATTN_NORM, 0);
		}
	}
};

gitem_t *Rune_WhichCarried(edict_t *player)
{
	if (player->flags & FL_STRENGTH_RUNE)
		return FindItem(STRENGTH_RUNE_PICKUP_NAME);
	else if (player->flags & FL_HASTE_RUNE)
		return FindItem(HASTE_RUNE_PICKUP_NAME);
	else if (player->flags & FL_REGEN_RUNE)
		return FindItem(REGEN_RUNE_PICKUP_NAME);
	else if (player->flags & FL_RESIST_RUNE)
		return FindItem(RESIST_RUNE_PICKUP_NAME);

	return NULL;
};

qboolean Rune_Pickup (edict_t *self, edict_t *other)
{
	int		index;

	if (other->flags & FL_PLAYER_RUNE_MASK)
	{
		if (other->client->rune_notice_time < level.time)
		{
			gi.centerprintf(other, "You already have a rune\n");
			other->client->rune_notice_time = level.time + 5;
			gi.sound (other, CHAN_AUTO, gi.soundindex ("misc/talk1.wav"), 1, ATTN_NORM, 0);
		};
		return false;
	};

	index = ITEM_INDEX(self->item);
	if (!strcmp(self->classname, "item_rune_strength"))
	{
		other->flags |= FL_STRENGTH_RUNE;
	}
	else if (!strcmp(self->classname, "item_rune_regen"))
	{
		other->flags |= FL_REGEN_RUNE;
	}
	else if (!strcmp(self->classname, "item_rune_haste"))
	{
		other->flags |= FL_HASTE_RUNE;
	}
	else if (!strcmp(self->classname, "item_rune_resist"))
	{
		other->flags |= FL_RESIST_RUNE;
	};

	// flash the screen
	other->client->bonus_alpha = 0.25;	

	// play the pickup sound
	gi.sound(other, CHAN_ITEM, gi.soundindex(self->item->pickup_sound), 1, ATTN_NORM, 0);

	other->client->pers.inventory[index]++;

	// show icon and name on status bar
	//other->client->ps.stats[STAT_PICKUP_ICON] = gi.imageindex(self->item->icon);
	//other->client->ps.stats[STAT_PICKUP_STRING] = CS_ITEMS+ITEM_INDEX(self->item);
	//other->client->pickup_msg_time = level.time + 3.0;

	return true;
};

static edict_t *FindRuneSpawnPoint(void);
void Rune_SpawnRune(gitem_t *rune, edict_t *spawn_point);

static void RuneThink(edict_t *rune)
{
	edict_t *spot;

	if ((spot = FindRuneSpawnPoint()) != NULL) {
		Rune_SpawnRune(rune->item, spot);
		G_FreeEdict(rune);
	} else {
		rune->nextthink = level.time + 120;
		rune->think = RuneThink;
	}
}

void Rune_DeadDrop(edict_t *player)
{
	int		i;
	gitem_t *rune;
	edict_t	*dropped;

	rune = Rune_WhichCarried(player);

	if (rune == NULL)
		return;

	dropped = Drop_Item(player, rune);
	// hack the velocity to make it bounce random
	dropped->velocity[0] = (rand() % 600) - 300;
	dropped->velocity[1] = (rand() % 600) - 300;
	dropped->nextthink = level.time + 120;
	dropped->think = RuneThink;
	dropped->owner = NULL;

	player->flags &= ~FL_PLAYER_RUNE_MASK;
		
	// remove rune from player inventory
	i = ITEM_INDEX(FindItem(rune->pickup_name));
	player->client->pers.inventory[i] = 0;
	
};

void Rune_SpawnRune(gitem_t *rune, edict_t *spawn_point)
{
	edict_t *self;
	vec3_t	forward, right;
	vec3_t  angles;

	self = G_Spawn();

	self->classname = rune->classname;
	self->item = rune;
	self->spawnflags = DROPPED_ITEM;
	self->s.effects = rune->world_model_flags;
	self->s.renderfx = RF_GLOW;
	VectorSet(self->mins, -16, -16, 0);
	VectorSet(self->maxs, 16, 16, 56);
	gi.setmodel(self, rune->world_model);
	self->solid = SOLID_TRIGGER;
	self->movetype = MOVETYPE_TOSS;
	self->touch = Touch_Item;
	self->owner = self;
	self->flags = FL_RUNE;

	angles[0] = 0;
	angles[1] = rand() % 360;
	angles[2] = 0;

	AngleVectors (angles, forward, right, NULL);
	VectorCopy (spawn_point->s.origin, self->s.origin);
	self->s.origin[2] += 16;
	VectorScale (forward, 100, self->velocity);
	self->velocity[2] = 300;
	
	self->nextthink = level.time + 120; // if no one touches it in two minutes,
										// respawn it somewhere else, so inaccessible ones will come 'back'
	self->think = RuneThink;

	gi.linkentity(self);
};

static edict_t *FindRuneSpawnPoint(void)
{
	edict_t *spot = NULL;
	int i = rand() % 16;

	while (i--)
		spot = G_Find (spot, FOFS(classname), "info_player_deathmatch");
	if (!spot)
		spot = G_Find (spot, FOFS(classname), "info_player_deathmatch");
	return spot;
}

static void SpawnRunes(edict_t *self)
{
	gitem_t *rune;
	edict_t *spot;
	int i;

	i = 0;
	while (rnames[i]) {
		if ((rune = FindItemByClassname(rnames[i])) != NULL &&
			(spot = FindRuneSpawnPoint()) != NULL)
			Rune_SpawnRune(rune, spot);
		i++;
	}
};

void Rune_SetupSpawn()
{
	edict_t *rspawn;

	if (runes_spawned)
		return;

	rspawn = G_Spawn();
	rspawn->nextthink = level.time + 2;
	rspawn->think = SpawnRunes;
	runes_spawned = true;
};

// frees the passed edict!
void Rune_Respawn(edict_t *ent)
{
	edict_t *spot;

	if ((spot = FindRuneSpawnPoint()) != NULL)
		Rune_SpawnRune(ent->item, spot);
	G_FreeEdict(ent);
}
