#include "g_local.h"
#include "m_player.h"
#include "s_hook.h"

void P_ProjectSource (gclient_t *client, vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result);
void Weapon_Generic (edict_t *ent, int FRAME_ACTIVATE_LAST, int FRAME_FIRE_LAST, int FRAME_IDLE_LAST, int FRAME_DEACTIVATE_LAST, int *pause_frames, int *fire_frames, void (*fire)(edict_t *ent));
extern qboolean	is_quad;
qboolean CheckTeamDamage (edict_t *targ, edict_t *attacker);

/*
==========
BreakChain 
==========
*/

void BreakChain (edict_t *star)
{
	if (star->goalentity)
	{
		if (star->goalentity->goalentity)
		{
			if (star->goalentity->goalentity->goalentity)
				G_FreeEdict(star->goalentity->goalentity->goalentity);
			G_FreeEdict(star->goalentity->goalentity);
		}
		G_FreeEdict(star->goalentity);
	}
};

/*
=======
LinkPos
=======
*/

void LinkPos (edict_t *self)
{
	vec3_t	forward, right, up;

	AngleVectors (self->enemy->s.angles, forward, right, up);
	
	if (self->client->ps.pmove.pm_flags & PMF_DUCKED) {
		VectorMA(self->owner->s.origin, -16, up, self->owner->s.origin);
	};

	if (self->client->ps.pmove.pm_flags & PMF_JUMP_HELD) {
		VectorMA(self->owner->s.origin, 16, up, self->owner->s.origin);
	};

	VectorMA(self->owner->s.origin, 16, forward, self->owner->s.origin);

//	setorigin (self, self.owner.origin + (((self.enemy.origin + (v_up * 16 * (!self.enemy.button2)) + (v_forward * 16)) - self.owner.origin) * (self.weapon)));
    
	self->nextthink = level.time + 0.1;
};

edict_t *Build_Link (edict_t *hook)
{
	edict_t	*link;

	link = G_Spawn();
	link->owner = hook;
	link->goalentity = NULL;
    link->movetype = MOVETYPE_NOCLIP;
    link->solid = SOLID_NOT;
	VectorSet(link->avelocity, 200, 200, 200);
	link->s.modelindex = gi.modelindex ("models/items/grapple/chain/tris.md2");
	VectorClear(link->maxs);
	VectorClear(link->mins);
	VectorCopy(hook->s.origin, link->s.origin);
	gi.linkentity(link);

	return link;
}

void Update_Link (edict_t *link, edict_t *hook, edict_t *player, float scale)
{
};

void Update_Chain (edict_t *self)
{
	vec3_t	forward, right, offset, start, v;

	// self = first and only thinking chain link
	// self->owner = hook
	// self->owner->owner = player

	if (self->owner)
		if (self->owner->owner)
			if (self->owner->owner->inuse &&
				self->owner->owner->client)
				if (self->owner->owner->client->ctf_grapple)
				{
					// Break the view angle up into vectors
					AngleVectors (self->owner->owner->client->v_angle, forward, right, NULL);
					// Create an offset to accomodate the view height
					VectorSet(offset, 8, 8, self->owner->owner->viewheight-8);
					// Add to the global offset of the world ?
					VectorAdd (offset, vec3_origin, offset);
					// Project the source vector based on handedness
					P_ProjectSource (self->owner->owner->client, self->owner->owner->s.origin, offset, forward, right, start);
					//VectorCopy(self->owner->owner->s.origin, start);
					VectorSubtract(self->owner->s.origin, start, v);
					
					VectorMA(start, 0.25, v, self->s.origin);
					VectorMA(start, 0.50, v, self->goalentity->s.origin);
					VectorMA(start, 0.75, v, self->goalentity->goalentity->s.origin);

					gi.linkentity(self);
					gi.linkentity(self->goalentity);
					gi.linkentity(self->goalentity->goalentity);

					self->nextthink = level.time + 0.1;
					return;
				}

	self->think = BreakChain;
	self->nextthink = level.time + 0.1;

	return;
}

/*
=========
MakeChain
=========
*/

void Make_Chain (edict_t *self)
{
	self->goalentity = Build_Link(self);
	self->goalentity->think = Update_Chain;
	self->goalentity->nextthink = level.time + 0.1;

	self->goalentity->goalentity = Build_Link(self);
	self->goalentity->goalentity->goalentity = Build_Link(self);
};

//======================================================================

// self is grapple, not player
void Hook_Reset(edict_t *self)
{
	if (self->owner->client->ctf_grapple) {
		float volume = 1.0;
		gclient_t *cl;

		if (self->owner->client->silencer_shots)
			volume = 0.2;

		gi.sound (self->owner, CHAN_RELIABLE+CHAN_WEAPON, gi.soundindex("grapple/bounce2.wav"), volume, ATTN_NORM, 0);
		cl = self->owner->client;
		cl->ctf_grapple = NULL;
		cl->ctf_grapplereleasetime = level.time;
		cl->ctf_grapplestate = CTF_GRAPPLE_STATE_FLY; // we're firing, not on hook
		cl->ps.pmove.pm_flags &= ~PMF_NO_PREDICTION;
		BreakChain (self);
		G_FreeEdict(self);
	}
}

// pull the player toward the grapple
void Hook_GrapplePull(edict_t *self)
{
	vec3_t hookdir, v;
	float vlen;

	if (strcmp(self->owner->client->pers.weapon->classname, "weapon_grapple") == 0 &&
		!self->owner->client->newweapon &&
		self->owner->client->weaponstate != WEAPON_FIRING &&
		self->owner->client->weaponstate != WEAPON_ACTIVATING) {
		Hook_Reset(self);
		return;
	}

	if (self->enemy) {
		if (self->enemy->solid == SOLID_NOT) {
			Hook_Reset(self);
			return;
		}
		if (self->enemy->solid == SOLID_BBOX) {
			VectorScale(self->enemy->size, 0.5, v);
			VectorAdd(v, self->enemy->s.origin, v);
			VectorAdd(v, self->enemy->mins, self->s.origin);
			gi.linkentity (self);
		} else
			VectorCopy(self->enemy->velocity, self->velocity);
		if (self->enemy->takedamage &&
			!CheckTeamDamage (self->enemy, self->owner)) {
			float volume = 1.0;

			if (self->owner->client->silencer_shots)
				volume = 0.2;

			T_Damage (self->enemy, self, self->owner, self->velocity, self->s.origin, vec3_origin, 1, 1, 0, MOD_GRAPPLE);
//			gi.sound (self, CHAN_WEAPON, gi.soundindex("weapons/grapple/grhurt.wav"), volume, ATTN_NORM, 0);
		}
		if (self->enemy->deadflag) { // he died
			Hook_Reset(self);
			return;
		}
	}

	if (self->owner->client->ctf_grapplestate > CTF_GRAPPLE_STATE_FLY) {
		// pull player toward grapple
		// this causes icky stuff with prediction, we need to extend
		// the prediction layer to include two new fields in the player
		// move stuff: a point and a velocity.  The client should add
		// that velociy in the direction of the point
		vec3_t forward, up;

		AngleVectors (self->owner->client->v_angle, forward, NULL, up);
		VectorCopy(self->owner->s.origin, v);
		v[2] += self->owner->viewheight;
		VectorSubtract (self->s.origin, v, hookdir);

		vlen = VectorLength(hookdir);

		if (self->owner->client->ctf_grapplestate == CTF_GRAPPLE_STATE_PULL &&
			vlen < 64) {
			float volume = 1.0;

			if (self->owner->client->silencer_shots)
				volume = 0.2;

			self->owner->client->ps.pmove.pm_flags |= PMF_NO_PREDICTION;
			//gi.sound (self->owner, CHAN_RELIABLE+CHAN_WEAPON, gi.soundindex("grapple/chain3.wav"), volume, ATTN_NORM, 0);
			gi.sound (self->owner, CHAN_WEAPON, gi.soundindex("grapple/chain3.wav"), volume, ATTN_NORM, 0);
			self->owner->client->ctf_grapplestate = CTF_GRAPPLE_STATE_HANG;
			BreakChain(self);
		}

		VectorNormalize (hookdir);
		VectorScale(hookdir, 800, hookdir);
		VectorCopy(hookdir, self->owner->velocity);
	}
}


void Hook_Anchor (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (other == self->owner)
		return;

	if (self->owner->client->ctf_grapplestate != CTF_GRAPPLE_STATE_FLY)
		return;

	if (surf && (surf->flags & SURF_SKY))
	{
		Hook_Reset(self);
		return;
	}

	VectorCopy(vec3_origin, self->velocity);
	VectorCopy(vec3_origin, self->avelocity);

	PlayerNoise(self->owner, self->s.origin, PNOISE_IMPACT);

	if (other->takedamage) {
		T_Damage (other, self, self->owner, self->velocity, self->s.origin, plane->normal, self->dmg, 1, 0, MOD_GRAPPLE);
		//Hook_Reset(self);
		//return;
		self->s.modelindex = 0;
	}

	self->owner->client->ctf_grapplestate = CTF_GRAPPLE_STATE_PULL; // we're on hook
	self->enemy = other;

	self->solid = SOLID_NOT;

//	gi.sound (self, CHAN_WEAPON, gi.soundindex("weapons/grapple/grhit.wav"), volume, ATTN_NORM, 0);

	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_SPARKS);
	gi.WritePosition (self->s.origin);
	if (!plane)
		gi.WriteDir (vec3_origin);
	else
		gi.WriteDir (plane->normal);
	gi.multicast (self->s.origin, MULTICAST_PVS);
}

void Hook_SpawnStar (edict_t *owner, vec3_t start, vec3_t dir, int damage)
{
	edict_t *star;
	trace_t tr;

	VectorNormalize (dir);

    star = G_Spawn ();
	VectorCopy (start, star->s.origin);
	VectorCopy (start, star->s.old_origin);
	vectoangles (dir, star->s.angles);
	VectorScale (dir, 800, star->velocity);
    star->movetype = MOVETYPE_FLYMISSILE;
	star->clipmask = MASK_SHOT;
    star->solid = SOLID_BBOX;
	VectorClear(star->mins);
	VectorClear(star->maxs);
	star->s.modelindex = gi.modelindex ("models/items/grapple/star/tris.md2");
    star->owner = owner;
	star->classname = "hook";
	owner->client->ctf_grapple = star;
	// This gives the hook some spin as it's flying
	VectorSet(star->avelocity, 0, 0, -500);

	star->touch = Hook_Anchor;
    star->nextthink = level.time + 0.1;
    star->think = Make_Chain;
	gi.linkentity (star);

	tr = gi.trace(owner->s.origin, NULL, NULL, star->s.origin, star, MASK_SHOT);
	if (tr.fraction < 1.0) {
		VectorMA (star->s.origin, -10, dir, star->s.origin);
		star->touch(star, tr.ent, NULL, NULL);
	}
};

void Hook_GrappleFire (edict_t *ent, vec3_t g_offset, int damage, int effect)
{
	vec3_t	forward, right;
	vec3_t	start;
	vec3_t	offset;
	float volume = 1.0;

	if (ent->client->ctf_grapplestate > CTF_GRAPPLE_STATE_FLY)
		return; // it's already out

	AngleVectors (ent->client->v_angle, forward, right, NULL);
//	VectorSet(offset, 24, 16, ent->viewheight-8+2);
	VectorSet(offset, 24, 8, ent->viewheight-8+2);
	VectorAdd (offset, g_offset, offset);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -1;

	if (ent->client->silencer_shots)
		volume = 0.2;

	gi.sound (ent, CHAN_RELIABLE+CHAN_WEAPON, gi.soundindex("grapple/chain1.wav"), volume, ATTN_NORM, 0);
	Hook_SpawnStar (ent, start, forward, damage);

#if 0
	// send muzzle flash
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_BLASTER);
	gi.multicast (ent->s.origin, MULTICAST_PVS);
#endif

	PlayerNoise(ent, start, PNOISE_WEAPON);
}

void Weapon_Grapple_Fire (edict_t *ent)
{
	int damage = 10;
	Hook_GrappleFire (ent, vec3_origin, damage, 0);
	ent->client->ps.gunframe++;
}

void Weapon_Grapple (edict_t *ent)
{
	static int	pause_frames[]	= {19, 32, 0};
	static int	fire_frames[]	= {5, 0};
	int prevstate;

	// if the the attack button is still down, stay in the firing frame
	if ((ent->client->buttons & BUTTON_ATTACK) && 
		ent->client->weaponstate == WEAPON_FIRING &&
		ent->client->ctf_grapple)
		ent->client->ps.gunframe = 8;

	if (!(ent->client->buttons & BUTTON_ATTACK) && 
		ent->client->ctf_grapple) {
		Hook_Reset(ent->client->ctf_grapple);
		if (ent->client->weaponstate == WEAPON_FIRING)
			ent->client->weaponstate = WEAPON_READY;
	}


	if (ent->client->newweapon && 
		ent->client->ctf_grapplestate > CTF_GRAPPLE_STATE_FLY &&
		ent->client->weaponstate == WEAPON_FIRING) {
		// he wants to change weapons while grappled
		ent->client->weaponstate = WEAPON_DROPPING;
		ent->client->ps.gunframe = 53;
	}

	prevstate = ent->client->weaponstate;
	Weapon_Generic (ent, 4, 8, 52, 55, pause_frames, fire_frames, Weapon_Grapple_Fire);

	// if we just switched back to grapple, immediately go to fire frame
	if (prevstate == WEAPON_ACTIVATING &&
		ent->client->weaponstate == WEAPON_READY &&
		ent->client->ctf_grapplestate > CTF_GRAPPLE_STATE_FLY) {
		if (!(ent->client->buttons & BUTTON_ATTACK))
			ent->client->ps.gunframe = 8;
		else
			ent->client->ps.gunframe = 4;
		ent->client->weaponstate = WEAPON_FIRING;
	}
}

void Hook_DeadReset(edict_t *ent)
{
	if (ent->client && ent->client->ctf_grapple)
		Hook_Reset(ent->client->ctf_grapple);
}
