#include "g_local.h"

char *ReadEntityFile(char *filename)
{
	FILE *in;
	int c, size;
	char *additional_entities;

	if ((in = fopen(filename, "r")) == NULL)
	{
		gi.dprintf("No additional entities\n");
		return NULL;
	};
	
	size = 0;
	while ((c = fgetc(in)) != EOF) size++;
	fseek(in, 0, 0);

	additional_entities = gi.TagMalloc(size+1, TAG_LEVEL);
	if (!additional_entities) {
		gi.dprintf("Insufficient memory to read additional entities\n");
		return NULL;
	}

	size = 0;
	while ((c = fgetc(in)) != EOF) additional_entities[size++] = c;

	fclose (in);

	return (additional_entities);
};

void LoadAdditionalCTFEntities(char *mapname, char *entities)
{
	char	entfilename[MAX_QPATH] = "";
	char	*newentities;
	int		i, len;
	
	strcpy(entfilename, gamedir->string);
	strcat(entfilename, "\\maps\\");

	len = strlen(entfilename);
	for (i=0; mapname[i]; i++)
		entfilename[len + i] = tolower(mapname[i]);
	entfilename[len + i] = 0;
	strcat(entfilename, ".ent");

	newentities = ReadEntityFile(entfilename);

	if (newentities)
		 strcat(entities, newentities);

	return;
};
