#include "g_local.h"
#include "radio.h"

void RadioToggle_f(edict_t *self)
{
	if (self->client->resp.radio_power)
	{
		self->client->resp.radio_power = 0;
		gi.cprintf(self, PRINT_HIGH, "Radio OFF\n");
	}
	else
	{
		self->client->resp.radio_power = 1;
		gi.cprintf(self, PRINT_HIGH, "Radio ON\n");
	}
}

void stuffcmd(edict_t *ent, char *s);

void Radio_f(edict_t *self, char *channel, char *msg)
{
	edict_t	*player;
	int		i;
	char	*cmd, *pos;
	char	*prefix;
	char	*info;

	cmd = "\0";

	if (!self->client->resp.radio_power)
		return;

	self->client->ctf_lasttalkmsg = level.time + 5;

	// Well this is where we check the model to see what sound to send out.
	// Support Male, Female, Cyborg, Crackwhore and Zumlin. Crackwhore sounds 
	// aren't included in the .PAK file, But the prefix is crk_
	// Based this chec from the IsFemale() Subroutine

	info = Info_ValueForKey (self->client->pers.userinfo, "skin");
	if (info[0] == 'f' || info[0] == 'F')
		prefix = "fem_";
	else if (info[0] == 'c' || info[0] == 'C')
	{
		if (info[1] == 'y' || info[1] == 'Y')
			prefix = "cyb_";
		if (info[1] == 'r' || info[1] == 'R')
			prefix = "crk_";
	}
	else if (info[0] == 'z' || info[0] == 'Z')
		prefix = "zum_";
	else
		prefix = "male_";

	// Okay gotta make sure people can't stuff extra commands down to kill someone.
	// This is also why i send everything to the guy that sent it originally also
	if (pos = strstr(msg,";"))
		pos[0] = 0;
		
	
	if (Q_stricmp (channel, "ALL") == 0)
	{
		for_each_player(player, i)
		{
			if (player->client->resp.radio_power)
			{
				sprintf(cmd, "play world/%s\n", msg);
				stuffcmd(player, cmd);
			}
		}
		return;
	}
	else if (Q_stricmp (channel, "TEAM") == 0)
	{
		for_each_player(player, i)
		{
			if (player->client->resp.ctf_team == self->client->resp.ctf_team)
			{
				if (player->client->resp.radio_power)
				{
					sprintf(cmd, "play radio/%s%s\n", prefix, msg);
					stuffcmd(player, cmd);
				}
			}
		}
		return;
	}

	else if (Q_stricmp (channel, "ROOM") == 0)
	{
		sprintf(cmd, "radio/%s%s.wav", prefix, msg);
		gi.sound (self, CHAN_VOICE, gi.soundindex(cmd), 1, ATTN_NORM, 0);
		return;
	}
}
